/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.playlist;

import de.quippy.javamod.main.gui.playlist.EditPlaylistEntry;
import de.quippy.javamod.main.gui.playlist.PlaylistGUIChangeListener;
import de.quippy.javamod.main.gui.tools.FileChooserResult;
import de.quippy.javamod.main.gui.tools.PlaylistDropListener;
import de.quippy.javamod.main.gui.tools.PlaylistDropListenerCallBack;
import de.quippy.javamod.main.playlist.PlayList;
import de.quippy.javamod.main.playlist.PlayListEntry;
import de.quippy.javamod.main.playlist.PlaylistChangedListener;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;

public class PlayListGUI
extends JPanel
implements PlaylistChangedListener,
PlaylistDropListenerCallBack {
    private static final long serialVersionUID = -7914306014081401144L;
    private static final int PLUS_LINES_VISABLE = 2;
    private JFrame parentFrame = null;
    private PlayList playList;
    private PlayListEntry lastClickedEntry;
    private JCheckBox repeatCheckBox = null;
    private JScrollPane scrollPane = null;
    private JTextPane textArea = null;
    private JPopupMenu playListPopUp = null;
    private JMenuItem popUpEntryDeleteFromList = null;
    private JMenuItem popUpEntryCropFromList = null;
    private JMenuItem popUpEntryRefreshEntry = null;
    private JMenuItem popUpEntryEditEntry = null;
    private JMenuItem popUpEntrySaveList = null;
    private JMenuItem popUpEntryShuffleList = null;
    private EditPlaylistEntry editPlayListEntryDialog = null;
    private ArrayList<DropTarget> dropTargetList;
    private PlayListUpdateThread playlistUpdateThread;
    private String unmarkColorBackground;
    private String unmarkColorForeground;
    private String markColorBackground;
    private String markColorForeground;
    private ArrayList<PlaylistGUIChangeListener> listeners = new ArrayList();

    public PlayListGUI(JFrame jFrame) {
        this.parentFrame = jFrame;
        this.initialize();
    }

    private static String getHTMLColorString(Color color) {
        String string = Integer.toHexString(color.getRGB());
        if (string.length() > 6) {
            string = string.substring(string.length() - 6);
        }
        return string;
    }

    private void initialize() {
        this.setName("PlayList");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getScrollPane(), Helpers.getGridBagConstraint(0, 0, 1, 0, 1, 17, 1.0, 1.0));
        this.add((Component)this.getRepeatCheckBox(), Helpers.getGridBagConstraint(0, 1, 1, 0, 0, 13, 0.0, 0.0));
        this.dropTargetList = new ArrayList();
        PlaylistDropListener playlistDropListener = new PlaylistDropListener(this);
        Helpers.registerDropListener(this.dropTargetList, this.getPlaylistTextArea(), playlistDropListener);
        this.unmarkColorBackground = PlayListGUI.getHTMLColorString(this.getPlaylistTextArea().getBackground());
        this.unmarkColorForeground = PlayListGUI.getHTMLColorString(this.getPlaylistTextArea().getForeground());
        this.markColorBackground = PlayListGUI.getHTMLColorString(this.getPlaylistTextArea().getSelectionColor());
        this.markColorForeground = PlayListGUI.getHTMLColorString(this.getPlaylistTextArea().getSelectedTextColor());
        this.playlistUpdateThread = new PlayListUpdateThread(this);
        this.playlistUpdateThread.start();
    }

    private JCheckBox getRepeatCheckBox() {
        if (this.repeatCheckBox == null) {
            this.repeatCheckBox = new JCheckBox();
            this.repeatCheckBox.setName("repeatCombobox");
            this.repeatCheckBox.setText("repeat playlist");
            this.repeatCheckBox.setFont(Helpers.DIALOG_FONT);
            this.repeatCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1 || itemEvent.getStateChange() == 2) {
                        if (PlayListGUI.this.playList != null) {
                            PlayListGUI.this.playList.setRepeat(PlayListGUI.this.repeatCheckBox.isSelected());
                        } else {
                            PlayListGUI.this.repeatCheckBox.setSelected(false);
                        }
                        PlayListGUI.this.firePlaylistChanged();
                    }
                }
            });
        }
        return this.repeatCheckBox;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setName("scrollPane_TextField");
            this.scrollPane.setViewportView(this.getPlaylistTextArea());
        }
        return this.scrollPane;
    }

    private JTextPane getPlaylistTextArea() {
        if (this.textArea == null) {
            this.textArea = new JTextPane(new HTMLDocument());
            this.textArea.setContentType("text/html");
            this.textArea.setName("textArea");
            this.textArea.setEditable(false);
            this.textArea.setCaret(new InvisiableCaret());
            this.textArea.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.isConsumed() || PlayListGUI.this.playList == null) {
                        return;
                    }
                    if (keyEvent.isControlDown()) {
                        switch (keyEvent.getKeyCode()) {
                            case 83: {
                                PlayListGUI.this.doSavePlayList();
                                keyEvent.consume();
                                break;
                            }
                            case 69: {
                                PlayListGUI.this.doEditSelectedEntry();
                                keyEvent.consume();
                                break;
                            }
                            case 85: {
                                PlayListGUI.this.doUpdateSelectedEntryFromList();
                                keyEvent.consume();
                                break;
                            }
                            case 82: {
                                PlayListGUI.this.doShufflePlayList();
                                keyEvent.consume();
                                break;
                            }
                            case 65: {
                                PlayListGUI.this.doSelectAll();
                                keyEvent.consume();
                                break;
                            }
                            case 127: {
                                PlayListGUI.this.doCropSelectedEntryFromList();
                                keyEvent.consume();
                            }
                        }
                    } else if (keyEvent.isShiftDown()) {
                        switch (keyEvent.getKeyCode()) {
                            case 38: {
                                PlayListGUI.this.doChangeSelectionInList(-1);
                                keyEvent.consume();
                                break;
                            }
                            case 40: {
                                PlayListGUI.this.doChangeSelectionInList(1);
                                keyEvent.consume();
                            }
                        }
                    } else if (keyEvent.isAltDown()) {
                        switch (keyEvent.getKeyCode()) {
                            case 38: {
                                PlayListGUI.this.doMoveSelectedEntriesInList(-1);
                                keyEvent.consume();
                                break;
                            }
                            case 40: {
                                PlayListGUI.this.doMoveSelectedEntriesInList(1);
                                keyEvent.consume();
                            }
                        }
                    } else if (!keyEvent.isAltGraphDown() && !keyEvent.isMetaDown()) {
                        switch (keyEvent.getKeyCode()) {
                            case 127: {
                                PlayListGUI.this.doDeleteSelectedEntryFromList();
                                keyEvent.consume();
                                break;
                            }
                            case 27: {
                                PlayListGUI.this.playList.setSelectedElement(-1);
                                keyEvent.consume();
                                break;
                            }
                            case 36: {
                                PlayListGUI.this.playList.setSelectedElement(0);
                                PlayListGUI.this.doMakeIndexVisible(0);
                                keyEvent.consume();
                                break;
                            }
                            case 35: {
                                int n = PlayListGUI.this.playList.size() - 1;
                                PlayListGUI.this.playList.setSelectedElement(n);
                                PlayListGUI.this.doMakeIndexVisible(n);
                                keyEvent.consume();
                                break;
                            }
                            case 38: {
                                PlayListGUI.this.doMoveSelectionInList(-1);
                                keyEvent.consume();
                                break;
                            }
                            case 40: {
                                PlayListGUI.this.doMoveSelectionInList(1);
                                keyEvent.consume();
                                break;
                            }
                            case 33: {
                                PlayListGUI.this.doMoveSelectionInList(-(PlayListGUI.this.getMaxVisableRows() - 1));
                                keyEvent.consume();
                                break;
                            }
                            case 34: {
                                PlayListGUI.this.doMoveSelectionInList(PlayListGUI.this.getMaxVisableRows() - 1);
                                keyEvent.consume();
                                break;
                            }
                            case 10: {
                                PlayListGUI.this.doPlaySelectedPiece();
                                keyEvent.consume();
                            }
                        }
                    }
                }
            });
            this.textArea.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    if (mouseEvent.isConsumed() || PlayListGUI.this.playList == null) {
                        return;
                    }
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        int n = PlayListGUI.this.getSelectedIndexFromPoint(mouseEvent.getPoint(), false);
                        if (n == -1) {
                            return;
                        }
                        PlayListEntry playListEntry = PlayListGUI.this.playList.getEntry(n);
                        if (playListEntry.isSelected() && PlayListGUI.this.lastClickedEntry == null) {
                            PlayListGUI.this.lastClickedEntry = playListEntry;
                        } else if (PlayListGUI.this.lastClickedEntry != null) {
                            int n2 = n - PlayListGUI.this.lastClickedEntry.getIndexInPlaylist();
                            if (n2 == 0) {
                                return;
                            }
                            PlayListGUI.this.doMoveSelectedEntriesInList(n2);
                        }
                        mouseEvent.consume();
                    }
                }
            });
            this.textArea.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.isConsumed() || PlayListGUI.this.playList == null) {
                        return;
                    }
                    PlayListGUI.this.lastClickedEntry = null;
                    int n = PlayListGUI.this.getSelectedIndexFromPoint(mouseEvent.getPoint(), false);
                    if (n != -1) {
                        PlayListEntry playListEntry = PlayListGUI.this.playList.getEntry(n);
                        if (mouseEvent.isShiftDown()) {
                            PlayListEntry[] playListEntryArray = PlayListGUI.this.playList.getSelectedEntries();
                            if (playListEntryArray == null) {
                                PlayListGUI.this.playList.setSelectedElement(n);
                            } else {
                                int n2 = playListEntryArray[0].getIndexInPlaylist();
                                PlayListGUI.this.playList.setSelectedElements(n2, n);
                            }
                            PlayListGUI.this.lastClickedEntry = playListEntry;
                        } else if (mouseEvent.isControlDown()) {
                            PlayListGUI.this.playList.toggleSelectedElement(n);
                            PlayListGUI.this.lastClickedEntry = playListEntry;
                        } else if (!playListEntry.isSelected()) {
                            PlayListGUI.this.playList.setSelectedElement(n);
                            PlayListGUI.this.lastClickedEntry = playListEntry;
                        }
                    } else {
                        PlayListGUI.this.playList.setSelectedElement(n);
                    }
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        PlayListGUI.this.getPopup().show(PlayListGUI.this.textArea, mouseEvent.getX(), mouseEvent.getY());
                    }
                    mouseEvent.consume();
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.isConsumed() || PlayListGUI.this.playList == null) {
                        return;
                    }
                    int n = PlayListGUI.this.getSelectedIndexFromPoint(mouseEvent.getPoint(), false);
                    if (n != -1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        PlayListEntry playListEntry = PlayListGUI.this.playList.getEntry(n);
                        if (mouseEvent.getClickCount() > 1) {
                            PlayListGUI.this.doPlaySelectedPiece();
                        } else if (playListEntry != null && PlayListGUI.this.lastClickedEntry == null) {
                            PlayListGUI.this.playList.setSelectedElement(n);
                        }
                        mouseEvent.consume();
                    }
                }
            });
        }
        return this.textArea;
    }

    private JPopupMenu getPopup() {
        if (this.playListPopUp == null) {
            this.playListPopUp = new JPopupMenu();
            this.playListPopUp.setName("playListPopUp");
            this.playListPopUp.add(this.getPopUpEntryDeleteFromList());
            this.playListPopUp.add(this.getPopUpEntryCropFromList());
            this.playListPopUp.add(new JSeparator());
            this.playListPopUp.add(this.getPopUpEntryRefreshEntry());
            this.playListPopUp.add(this.getPopUpEntryEditEntry());
            this.playListPopUp.add(this.getPopUpEntryShuffleList());
            this.playListPopUp.add(new JSeparator());
            this.playListPopUp.add(this.getPopUpEntrySaveList());
        }
        boolean bl = this.playList != null && this.playList.size() > 0;
        PlayListEntry[] playListEntryArray = bl ? this.playList.getSelectedEntries() : null;
        boolean bl2 = bl && playListEntryArray != null;
        this.getPopUpEntryDeleteFromList().setEnabled(bl2);
        this.getPopUpEntryRefreshEntry().setEnabled(bl2);
        this.getPopUpEntryEditEntry().setEnabled(bl2 && playListEntryArray != null && playListEntryArray.length == 1);
        this.getPopUpEntrySaveList().setEnabled(bl);
        this.getPopUpEntryShuffleList().setEnabled(bl);
        return this.playListPopUp;
    }

    private JMenuItem getPopUpEntryDeleteFromList() {
        if (this.popUpEntryDeleteFromList == null) {
            this.popUpEntryDeleteFromList = new JMenuItem();
            this.popUpEntryDeleteFromList.setName("JPopUpMenu_DeleteFromList");
            this.popUpEntryDeleteFromList.setText("<del> delete entry from list");
            this.popUpEntryDeleteFromList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PlayListGUI.this.doDeleteSelectedEntryFromList();
                }
            });
        }
        return this.popUpEntryDeleteFromList;
    }

    private JMenuItem getPopUpEntryCropFromList() {
        if (this.popUpEntryCropFromList == null) {
            this.popUpEntryCropFromList = new JMenuItem();
            this.popUpEntryCropFromList.setName("JPopUpMenu_CropFromList");
            this.popUpEntryCropFromList.setText("<ctrl-del> crop entry from list");
            this.popUpEntryCropFromList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PlayListGUI.this.doCropSelectedEntryFromList();
                }
            });
        }
        return this.popUpEntryCropFromList;
    }

    private JMenuItem getPopUpEntryRefreshEntry() {
        if (this.popUpEntryRefreshEntry == null) {
            this.popUpEntryRefreshEntry = new JMenuItem();
            this.popUpEntryRefreshEntry.setName("JPopUpMenu_RefreshEntry");
            this.popUpEntryRefreshEntry.setText("<ctrl-u> Refresh entry");
            this.popUpEntryRefreshEntry.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PlayListGUI.this.doUpdateSelectedEntryFromList();
                }
            });
        }
        return this.popUpEntryRefreshEntry;
    }

    private JMenuItem getPopUpEntryEditEntry() {
        if (this.popUpEntryEditEntry == null) {
            this.popUpEntryEditEntry = new JMenuItem();
            this.popUpEntryEditEntry.setName("JPopUpMenu_EditEntry");
            this.popUpEntryEditEntry.setText("<ctrl-e> Edit entry");
            this.popUpEntryEditEntry.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PlayListGUI.this.doEditSelectedEntry();
                }
            });
        }
        return this.popUpEntryEditEntry;
    }

    private JMenuItem getPopUpEntrySaveList() {
        if (this.popUpEntrySaveList == null) {
            this.popUpEntrySaveList = new JMenuItem();
            this.popUpEntrySaveList.setName("JPopUpMenu_SaveList");
            this.popUpEntrySaveList.setText("<ctrl-s> save playlist to");
            this.popUpEntrySaveList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PlayListGUI.this.doSavePlayList();
                }
            });
        }
        return this.popUpEntrySaveList;
    }

    private JMenuItem getPopUpEntryShuffleList() {
        if (this.popUpEntryShuffleList == null) {
            this.popUpEntryShuffleList = new JMenuItem();
            this.popUpEntryShuffleList.setName("JPopUpMenu_ShuffleList");
            this.popUpEntryShuffleList.setText("<ctrl-r> shuffle list");
            this.popUpEntryShuffleList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PlayListGUI.this.doShufflePlayList();
                }
            });
        }
        return this.popUpEntryShuffleList;
    }

    private EditPlaylistEntry getEditDialog() {
        if (this.editPlayListEntryDialog == null) {
            this.editPlayListEntryDialog = new EditPlaylistEntry(this.parentFrame, true);
        } else {
            this.editPlayListEntryDialog.setLocation(Helpers.getFrameCenteredLocation(this.editPlayListEntryDialog, this.parentFrame));
        }
        return this.editPlayListEntryDialog;
    }

    private void doDeleteSelectedEntryFromList() {
        PlayListEntry[] playListEntryArray = this.playList.getSelectedEntries();
        if (playListEntryArray != null) {
            this.playlistUpdateThread.halt();
            try {
                int n = 0;
                while (n < playListEntryArray.length) {
                    this.playList.remove(playListEntryArray[n].getIndexInPlaylist());
                    ++n;
                }
                this.createList(this.getFirstVisableIndex());
                this.firePlaylistChanged();
            }
            finally {
                this.playlistUpdateThread.restart();
            }
        }
    }

    private void doCropSelectedEntryFromList() {
        PlayListEntry[] playListEntryArray = this.playList.getAllEntries();
        if (playListEntryArray != null) {
            this.playlistUpdateThread.halt();
            try {
                int n = 0;
                while (n < playListEntryArray.length) {
                    if (!playListEntryArray[n].isSelected()) {
                        this.playList.remove(playListEntryArray[n].getIndexInPlaylist());
                    }
                    ++n;
                }
                this.createList(this.getFirstVisableIndex());
                this.firePlaylistChanged();
            }
            finally {
                this.playlistUpdateThread.restart();
            }
        }
    }

    private void doUpdateSelectedEntryFromList() {
        PlayListEntry[] playListEntryArray = this.playList.getSelectedEntries();
        if (playListEntryArray != null) {
            this.playlistUpdateThread.halt();
            try {
                int n = 0;
                while (n < playListEntryArray.length) {
                    playListEntryArray[n].setSongName(null);
                    playListEntryArray[n].setDuration(null);
                    this.updateLine(playListEntryArray[n].getIndexInPlaylist());
                    ++n;
                }
            }
            finally {
                this.playlistUpdateThread.restart();
            }
        }
    }

    private void doEditSelectedEntry() {
        block7: {
            PlayListEntry[] playListEntryArray = this.playList.getSelectedEntries();
            if (playListEntryArray != null) {
                this.playlistUpdateThread.halt();
                try {
                    PlayListEntry playListEntry = playListEntryArray[0];
                    EditPlaylistEntry editPlaylistEntry = this.getEditDialog();
                    editPlaylistEntry.setValue(Helpers.createLocalFileStringFromURL(playListEntry.getFile(), false));
                    editPlaylistEntry.setVisible(true);
                    String string = editPlaylistEntry.getValue();
                    if (string == null) break block7;
                    try {
                        URL uRL = Helpers.createURLfromString(string);
                        if (uRL != null) {
                            playListEntry.setFile(uRL);
                            playListEntry.setSongName(null);
                            playListEntry.setDuration(null);
                            this.updateLine(playListEntry.getIndexInPlaylist());
                        }
                    }
                    catch (Throwable throwable) {
                        JOptionPane.showMessageDialog(this, "Changing entry failed", "Failed", 0);
                    }
                }
                finally {
                    this.playlistUpdateThread.restart();
                }
            }
        }
    }

    private void doSavePlayList() {
        if (this.playList != null) {
            File file;
            String string;
            FileChooserResult fileChooserResult;
            while ((fileChooserResult = Helpers.selectFileNameFor(this, string = Helpers.createLocalFileStringFromURL(this.playList.getLoadedFromURL(), true), "Save playlist to", new FileFilter[]{PlayList.PLAYLIST_FILE_FILTER}, 1, false)) != null && (file = fileChooserResult.getSelectedFile()) != null) {
                String string2 = file.getAbsolutePath();
                String string3 = string2.toLowerCase();
                if (!(string3.endsWith("pls") || string3.endsWith("m3u") || string3.endsWith("cue"))) {
                    file = new File(String.valueOf(string2) + ".M3U");
                }
                if (file.exists()) {
                    int n = JOptionPane.showConfirmDialog(this, "File already exists! Overwrite?", "Overwrite confirmation", 1, 3);
                    if (n == 2) {
                        return;
                    }
                    if (n == 1) continue;
                    boolean bl = file.delete();
                    if (!bl) {
                        JOptionPane.showMessageDialog(this, "Overwrite failed. Is file write protected or in use?", "Failed", 0);
                        return;
                    }
                }
                try {
                    this.playList.savePlayListTo(file);
                    break;
                }
                catch (Exception exception) {
                    Log.error("Save playlist", exception);
                    break;
                }
            }
            return;
        }
    }

    private void doShufflePlayList() {
        this.playlistUpdateThread.halt();
        try {
            this.playList.doShuffle();
            this.createList(this.getFirstVisableIndex());
        }
        finally {
            this.playlistUpdateThread.restart();
        }
    }

    private void doSelectAll() {
        this.playList.setSelectedElements(0, this.playList.size() - 1);
    }

    private void doChangeSelectionInList(int n) {
        PlayListEntry[] playListEntryArray = this.playList.getSelectedEntries();
        if (playListEntryArray == null || playListEntryArray.length == 0) {
            this.playList.setSelectedElement(0);
            this.doMakeIndexVisible(0);
        } else {
            int n2 = playListEntryArray[0].getIndexInPlaylist();
            int n3 = playListEntryArray[playListEntryArray.length - 1].getIndexInPlaylist();
            if (n < 0) {
                if ((n2 += n) < 0) {
                    n2 = 0;
                }
            } else if ((n3 += n) >= this.playList.size()) {
                n3 = this.playList.size() - 1;
            }
            this.playList.setSelectedElements(n2, n3);
            if (n < 0) {
                this.doMakeIndexVisible(n2);
            } else {
                this.doMakeIndexVisible(n3);
            }
        }
    }

    private void doMoveSelectionInList(int n) {
        PlayListEntry[] playListEntryArray = this.playList.getSelectedEntries();
        if (playListEntryArray == null || playListEntryArray.length == 0) {
            this.playList.setSelectedElement(0);
            this.doMakeIndexVisible(0);
        } else {
            int n2 = playListEntryArray[0].getIndexInPlaylist();
            if ((n2 += n) < 0) {
                n2 = 0;
            } else if (n2 >= this.playList.size()) {
                n2 = this.playList.size() - 1;
            }
            this.playList.setSelectedElement(n2);
            n2 = n < 0 ? (n2 -= 2) : (n2 += 2);
            this.doMakeIndexVisible(n2);
        }
    }

    private void doMoveSelectedEntriesInList(int n) {
        PlayListEntry[] playListEntryArray = this.playList.getSelectedEntries();
        if (playListEntryArray != null) {
            this.playlistUpdateThread.halt();
            try {
                int n2;
                if (n < 0) {
                    if (playListEntryArray[0].getIndexInPlaylist() + n < 0) {
                        n = playListEntryArray[0].getIndexInPlaylist();
                    }
                    if (n == 0) {
                        return;
                    }
                    n2 = 0;
                    while (n2 < playListEntryArray.length) {
                        int n3 = playListEntryArray[n2].getIndexInPlaylist();
                        this.playList.move(n3, n3 + n);
                        ++n2;
                    }
                } else {
                    n2 = playListEntryArray.length - 1;
                    if (playListEntryArray[n2].getIndexInPlaylist() + n >= this.playList.size()) {
                        n = this.playList.size() - 1 - playListEntryArray[n2].getIndexInPlaylist();
                    }
                    if (n == 0) {
                        return;
                    }
                    int n4 = n2;
                    while (n4 >= 0) {
                        int n5 = playListEntryArray[n4].getIndexInPlaylist();
                        this.playList.move(n5, n5 + n);
                        --n4;
                    }
                }
                n2 = n < 0 ? playListEntryArray[0].getIndexInPlaylist() - 2 : playListEntryArray[playListEntryArray.length - 1].getIndexInPlaylist() + 2;
                this.createList(n2);
                this.firePlaylistChanged();
            }
            finally {
                this.playlistUpdateThread.restart();
            }
        }
    }

    private void doPlaySelectedPiece() {
        PlayListEntry[] playListEntryArray = this.playList.getSelectedEntries();
        if (playListEntryArray != null) {
            int n = playListEntryArray[0].getIndexInPlaylist();
            this.playList.setSelectedElement(n);
            this.playList.setCurrentElement(n);
            this.fireActiveElementChanged();
        }
    }

    private Element getDocumentRootElement() {
        Element element;
        Element element2;
        Document document = this.getPlaylistTextArea().getDocument();
        if (document != null && (element2 = document.getDefaultRootElement()) != null && (element = element2.getElement(1)) != null) {
            return element.getElement(0);
        }
        return null;
    }

    private Element getDocumentElementForIndex(int n) {
        Element element;
        if (n > -1 && (element = this.getDocumentRootElement()) != null) {
            return element.getElement(n);
        }
        return null;
    }

    private int getMaxVisableRows() {
        Rectangle rectangle = this.getScrollPane().getVisibleRect();
        Point point = new Point(0, (int)rectangle.getHeight());
        return this.getSelectedIndexFromPoint(point, true) - 1;
    }

    private int getFirstVisableIndex() {
        Element element = this.getDocumentRootElement();
        if (element != null) {
            int n = 0;
            while (n < element.getElementCount()) {
                Element element2 = element.getElement(n);
                try {
                    Rectangle rectangle = this.getPlaylistTextArea().modelToView(element2.getStartOffset());
                    Rectangle rectangle2 = this.getPlaylistTextArea().modelToView(element2.getEndOffset() - 1);
                    Rectangle rectangle3 = new Rectangle((int)rectangle.getX(), (int)rectangle.getY(), (int)(rectangle2.getX() - rectangle.getX()), (int)rectangle.getHeight());
                    Rectangle rectangle4 = rectangle3.intersection(this.getPlaylistTextArea().getVisibleRect());
                    if (!rectangle4.isEmpty() && rectangle4.height == rectangle3.height) {
                        return n;
                    }
                }
                catch (BadLocationException badLocationException) {}
                ++n;
            }
        }
        return -1;
    }

    private int getSelectedIndexFromPoint(Point point, boolean bl) {
        int n = this.getPlaylistTextArea().viewToModel(point);
        Element element = this.getDocumentRootElement();
        if (element != null) {
            Rectangle rectangle;
            int n2;
            block8: {
                n2 = element.getElementIndex(n);
                Element element2 = element.getElement(n2);
                try {
                    rectangle = this.getPlaylistTextArea().modelToView(element2.getStartOffset());
                    Rectangle rectangle2 = this.getPlaylistTextArea().modelToView(element2.getEndOffset() - 1);
                    Rectangle rectangle3 = new Rectangle((int)rectangle.getX(), (int)rectangle.getY(), (int)(rectangle2.getX() - rectangle.getX()), (int)rectangle.getHeight());
                    if (bl || rectangle3.contains(point)) break block8;
                    return -1;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (bl) {
                if (point.getY() < rectangle.getY()) {
                    --n2;
                } else if (point.getY() > rectangle.getY() + rectangle.getHeight()) {
                    ++n2;
                }
            }
            return n2;
        }
        return -1;
    }

    private void doMakeIndexVisible(PlayListEntry playListEntry) {
        if (playListEntry != null) {
            try {
                Element element = this.getDocumentElementForIndex(playListEntry.getIndexInPlaylist());
                if (element != null) {
                    Rectangle rectangle = this.getPlaylistTextArea().modelToView(element.getStartOffset());
                    Rectangle rectangle2 = this.getPlaylistTextArea().modelToView(element.getEndOffset() - 1);
                    if (rectangle != null && rectangle2 != null) {
                        Rectangle rectangle3 = new Rectangle((int)rectangle.getX(), (int)rectangle.getY(), (int)(rectangle2.getX() - rectangle.getX()), (int)rectangle.getHeight());
                        this.getPlaylistTextArea().scrollRectToVisible(rectangle3);
                    }
                }
            }
            catch (Throwable throwable) {
                Log.error("PlayListGui::doMakeIndexVisible", throwable);
            }
        }
    }

    private void doMakeIndexVisible(int n) {
        if (this.playList != null) {
            if (n < 0) {
                n = 0;
            } else if (n >= this.playList.size()) {
                n = this.playList.size() - 1;
            }
            this.doMakeIndexVisible(this.playList.getEntry(n));
        }
    }

    @Override
    public void playlistRecieved(DropTargetDropEvent dropTargetDropEvent, PlayList playList, URL uRL) {
        if (this.playList == null) {
            this.setNewPlaylist(playList);
            this.firePlaylistChanged();
        } else {
            this.playlistUpdateThread.halt();
            try {
                int n = this.getSelectedIndexFromPoint(dropTargetDropEvent.getLocation(), true);
                if (n == -1) {
                    n = 0;
                }
                if (n > this.playList.size()) {
                    n = this.playList.size();
                }
                this.playList.addAllAt(n, playList);
                this.createList(this.getFirstVisableIndex());
                this.firePlaylistChanged();
            }
            finally {
                this.playlistUpdateThread.restart();
            }
        }
    }

    public void addPlaylistGUIChangeListener(PlaylistGUIChangeListener playlistGUIChangeListener) {
        this.listeners.add(playlistGUIChangeListener);
    }

    public void removePlaylistGUIChangeListener(PlaylistGUIChangeListener playlistGUIChangeListener) {
        this.listeners.remove(playlistGUIChangeListener);
    }

    private synchronized void fireActiveElementChanged() {
        int n = 0;
        while (n < this.listeners.size()) {
            this.listeners.get(n).userSelectedPlaylistEntry();
            ++n;
        }
    }

    private void firePlaylistChanged() {
        int n = 0;
        while (n < this.listeners.size()) {
            this.listeners.get(n).playListChanged(this.playList);
            ++n;
        }
    }

    private String getHTMLString(PlayListEntry playListEntry, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder("<TR style=\"").append("background:#").append(playListEntry.isSelected() ? this.markColorBackground : this.unmarkColorBackground).append("; ").append("color:#").append(playListEntry.isSelected() ? this.markColorForeground : this.unmarkColorForeground).append("; ").append("font-family:").append(Helpers.TEXTAREA_FONT.getFamily()).append("; ").append("font-size:").append(Helpers.TEXTAREA_FONT.getSize()).append(';').append("font-weight:").append(playListEntry.isActive() ? "bold" : "normal").append(';').append("\"><TD align=\"left\" nowrap>").append(string.replace(" ", "&nbsp;")).append("</TD><TD align=\"right\" nowrap>").append(string2.replace(" ", "&nbsp;")).append("</TD></TR>");
        return stringBuilder.toString();
    }

    private void createList(int n) {
        if (this.playList != null) {
            StringBuilder stringBuilder = new StringBuilder("<HTML><HEAD><TITLE>PlayList</TITLE></HEAD><BODY><TABLE WIDTH=\"100%\" BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\">");
            Iterator<PlayListEntry> iterator = this.playList.getIterator();
            int n2 = 0;
            int n3 = (int)(Math.log10(this.playList.size()) + 1.0);
            String string = String.format("%%%dd. ", n3);
            while (iterator.hasNext()) {
                PlayListEntry playListEntry = iterator.next();
                stringBuilder.append(this.getHTMLString(playListEntry, String.valueOf(String.format(string, n2 + 1)) + playListEntry.getQuickSongName(), playListEntry.getQuickDuration()));
                ++n2;
            }
            stringBuilder.append("</TABLE></FONT></BODY></HTML>");
            this.getPlaylistTextArea().setText(stringBuilder.toString());
            this.getPlaylistTextArea().select(0, 0);
            this.doMakeIndexVisible(n < 0 ? 0 : n);
            this.getRepeatCheckBox().setSelected(this.playList.isRepeat());
        } else {
            this.getRepeatCheckBox().setSelected(false);
        }
    }

    public void setNewPlaylist(final PlayList playList) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlayListGUI playListGUI = PlayListGUI.this;
                PlayListGUI.this.playlistUpdateThread.halt();
                try {
                    playListGUI.playList = playList;
                    PlayListGUI.this.createList(0);
                    playListGUI.playList.addPlaylistChangedListener(playListGUI);
                }
                finally {
                    PlayListGUI.this.playlistUpdateThread.restart();
                }
            }
        });
    }

    private void replaceLine(String string, String string2, int n) {
        try {
            Element element = this.getDocumentElementForIndex(n);
            if (element != null) {
                Element element2 = element.getElement(0).getElement(0).getElement(0);
                Element element3 = element.getElement(1).getElement(0).getElement(0);
                this.getPlaylistTextArea().getDocument().remove(element2.getStartOffset(), element2.getEndOffset() - element2.getStartOffset());
                this.getPlaylistTextArea().getDocument().insertString(element2.getStartOffset(), string, element2.getAttributes());
                this.getPlaylistTextArea().getDocument().remove(element3.getStartOffset(), element3.getEndOffset() - element3.getStartOffset());
                this.getPlaylistTextArea().getDocument().insertString(element3.getStartOffset(), string2, element3.getAttributes());
            }
        }
        catch (BadLocationException badLocationException) {
            Log.error("PlayListGUI::replaceLine", badLocationException);
        }
    }

    private void updateLine(int n) {
        int n2 = (int)(Math.log10(this.playList.size()) + 1.0);
        String string = String.format("%%%dd. %%s", n2);
        PlayListEntry playListEntry = this.playList.getEntry(n);
        String string2 = MultimediaContainerManager.getSongNameFromURL(playListEntry.getFile());
        String string3 = "0:00";
        try {
            string2 = playListEntry.getFormattedName();
            string3 = playListEntry.getDurationString();
        }
        catch (RuntimeException runtimeException) {
            string2 = String.valueOf(string2) + " [" + runtimeException.getMessage() + "]";
        }
        String string4 = String.format(string, n + 1, string2);
        this.replaceLine(string4, string3, n);
    }

    private static String getText(Element element) throws BadLocationException {
        String string = element.getDocument().getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
        if (string.endsWith("\n")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    private void setTextDecorationAndColorsFor(PlayListEntry playListEntry) {
        try {
            Element element = this.getDocumentElementForIndex(playListEntry.getIndexInPlaylist());
            if (element != null) {
                String string = PlayListGUI.getText(element.getElement(0).getElement(0).getElement(0));
                String string2 = PlayListGUI.getText(element.getElement(1).getElement(0).getElement(0));
                HTMLDocument hTMLDocument = (HTMLDocument)element.getDocument();
                hTMLDocument.setOuterHTML(element, this.getHTMLString(playListEntry, string, string2));
            }
        }
        catch (Throwable throwable) {
            Log.error("PlayListGui::setTextDecorationAndColorsFor", throwable);
        }
    }

    @Override
    public void activeElementChanged(final PlayListEntry playListEntry, final PlayListEntry playListEntry2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (playListEntry != null) {
                    PlayListGUI.this.setTextDecorationAndColorsFor(playListEntry);
                }
                if (playListEntry2 != null) {
                    PlayListGUI.this.setTextDecorationAndColorsFor(playListEntry2);
                    PlayListGUI.this.doMakeIndexVisible(playListEntry2);
                }
            }
        });
    }

    @Override
    public void selectedElementChanged(final PlayListEntry playListEntry, final PlayListEntry playListEntry2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (playListEntry != null) {
                    PlayListGUI.this.setTextDecorationAndColorsFor(playListEntry);
                }
                if (playListEntry2 != null) {
                    PlayListGUI.this.setTextDecorationAndColorsFor(playListEntry2);
                    PlayListGUI.this.doMakeIndexVisible(playListEntry2);
                }
            }
        });
    }

    static /* synthetic */ void access$1(PlayListGUI playListGUI, int n) {
        playListGUI.updateLine(n);
    }

    private static final class InvisiableCaret
    implements Caret {
        private Point magicCaretPosition;
        private int dot;
        private int rate;

        @Override
        public void setVisible(boolean bl) {
        }

        @Override
        public void setSelectionVisible(boolean bl) {
        }

        @Override
        public boolean isVisible() {
            return false;
        }

        @Override
        public boolean isSelectionVisible() {
            return false;
        }

        @Override
        public void setMagicCaretPosition(Point point) {
            this.magicCaretPosition = point;
        }

        @Override
        public Point getMagicCaretPosition() {
            return this.magicCaretPosition;
        }

        @Override
        public void setDot(int n) {
            this.dot = n;
        }

        @Override
        public int getDot() {
            return this.dot;
        }

        @Override
        public void setBlinkRate(int n) {
            this.rate = n;
        }

        @Override
        public int getBlinkRate() {
            return this.rate;
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
        }

        @Override
        public void paint(Graphics graphics) {
        }

        @Override
        public void moveDot(int n) {
        }

        @Override
        public void install(JTextComponent jTextComponent) {
        }

        @Override
        public void deinstall(JTextComponent jTextComponent) {
        }

        @Override
        public int getMark() {
            return this.dot;
        }
    }

    private static final class PlayListUpdateThread
    extends Thread
    implements Serializable {
        private static final long serialVersionUID = -8105723830268691249L;
        private PlayListGUI parent;
        private volatile boolean stopIt;
        private volatile boolean isStopped;
        private volatile boolean finished;

        public PlayListUpdateThread(PlayListGUI playListGUI) {
            this.setName("PlayListUpdateThread::" + this.getClass().getName());
            this.setDaemon(true);
            this.setPriority(1);
            this.parent = playListGUI;
            this.isStopped = true;
            this.stopIt = false;
            this.finished = false;
        }

        public boolean isStopped() {
            return this.isStopped;
        }

        public void halt() {
            if (!this.isStopped) {
                this.stopIt = true;
                this.interrupt();
                while (!this.isStopped()) {
                    try {
                        PlayListUpdateThread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.stopIt = false;
            }
        }

        public void restart() {
            this.stopIt = false;
            this.isStopped = false;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            ** GOTO lbl27
            {
                try {
                    PlayListUpdateThread.sleep(1000L);
                }
                catch (InterruptedException v0) {}
                block8: do {
                    if (this.isStopped() && !this.finished) continue block7;
                    try {
                        if (PlayListGUI.access$0(this.parent) == null) continue;
                        var1_1 = PlayListGUI.access$0(this.parent).size();
                        var2_2 = 0;
                        if (true) ** GOTO lbl20
                        do {
                            PlayListGUI.access$1(this.parent, var2_2);
                            try {
                                PlayListUpdateThread.sleep(250L);
                            }
                            catch (InterruptedException v1) {}
                            ++var2_2;
lbl20:
                            // 2 sources

                            if (var2_2 >= var1_1) continue block8;
                        } while (!this.stopIt);
                    }
                    finally {
                        this.stopIt = false;
                        this.isStopped = true;
                    }
lbl27:
                    // 4 sources

                } while (!this.finished);
            }
        }
    }
}

