/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.tools;

import java.io.File;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;

public class FileChooserFilter
extends FileFilter {
    private ArrayList<String> mExtensions = new ArrayList();
    private String mDescription;

    public FileChooserFilter() {
    }

    public FileChooserFilter(String string, String string2) {
        this();
        this.mExtensions.add(string.toLowerCase());
        this.mDescription = string2 == null ? String.valueOf(string) + " files" : string2;
    }

    public FileChooserFilter(String string) {
        this(string, null);
    }

    public FileChooserFilter(String[] stringArray, String string) {
        this();
        this.mDescription = string != null ? string : "";
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n].toLowerCase();
            if (string == null) {
                this.mDescription = String.valueOf(this.mDescription) + "*." + string2 + " ";
            }
            this.mExtensions.add(stringArray[n].toLowerCase());
            ++n;
        }
    }

    public FileChooserFilter(String[] stringArray) {
        this(stringArray, null);
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        int n = this.mExtensions.size();
        if (n == 0) {
            return true;
        }
        int n2 = 0;
        while (n2 < n) {
            String string = this.mExtensions.get(n2);
            if (file.getName().toLowerCase().endsWith(String.valueOf('.') + string)) {
                return true;
            }
            if (file.getName().toLowerCase().startsWith(String.valueOf(string) + '.')) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }
}

