/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer.dsp.iir.filter;

import de.quippy.javamod.mixer.dsp.iir.filter.IIRFilterBase;

public class IIRHighpassFilter
extends IIRFilterBase {
    @Override
    public void initialize(int n, int n2, int n3, float f) {
        super.initialize(n, n2, n3, f);
        float f2 = this.getThetaZero();
        float f3 = f / (2.0f * (float)Math.sin(f2));
        this.beta = 0.5f * ((1.0f - f3) / (1.0f + f3));
        this.gamma = (0.5f + this.beta) * (float)Math.cos(f2);
        this.alpha = (0.5f + this.beta + this.gamma) / 4.0f;
        this.alpha *= 2.0f;
        this.beta *= 2.0f;
        this.gamma *= 2.0f;
    }

    @Override
    protected float performFilterCalculation(float f, int n, int n2, int n3, int n4) {
        float[] fArray = this.inArray[n];
        float[] fArray2 = this.outArray[n];
        fArray[n2] = f;
        fArray2[n2] = this.alpha * (fArray[n2] - 2.0f * fArray[n4] + fArray[n3]) + this.gamma * fArray2[n4] - this.beta * fArray2[n3];
        return fArray2[n2];
    }
}

