/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader.instrument;

import de.quippy.javamod.multimedia.mod.mixer.interpolation.CubicSpline;
import de.quippy.javamod.multimedia.mod.mixer.interpolation.WindowedFIR;

public class Sample {
    public String name;
    public int length;
    public int fineTune;
    public int volume;
    public int repeatStart;
    public int repeatStop;
    public int repeatLength;
    public int loopType;
    public int transpose;
    public int baseFrequency;
    public int type;
    public String dosFileName;
    public int flags;
    public int panning;
    public int vibratoType;
    public int vibratoSweep;
    public int vibratoDepth;
    public int vibratoRate;
    public int sustainLoopStart;
    public int sustainLoopEnd;
    public int flag_CvT;
    public int globalVolume;
    public int[] sample;

    public void allocSampleData() {
        this.sample = new int[this.length + 5];
    }

    public void fixSampleLoops(int n) {
        if (this.sample == null || this.length == 0) {
            return;
        }
        if (this.repeatStop > this.length) {
            this.repeatStop = this.length;
            this.repeatLength = this.repeatStop - this.repeatStart;
        }
        if (this.repeatStart + 2 > this.repeatStop) {
            this.repeatStart = 0;
            this.repeatStop = 0;
            this.repeatLength = this.repeatStop - this.repeatStart;
            this.loopType = 0;
        }
        this.sample[this.length + 1] = this.sample[this.length] = this.sample[this.length - 1];
        this.sample[this.length + 2] = this.sample[this.length];
        this.sample[this.length + 3] = this.sample[this.length];
        this.sample[this.length + 4] = this.sample[this.length];
        if (this.loopType == 1 && (this.repeatStop + 4 > this.repeatLength || n == 1 || n == 4)) {
            this.sample[this.repeatStop] = this.sample[this.repeatStart];
            this.sample[this.repeatStop + 1] = this.sample[this.repeatStart + 1];
            this.sample[this.repeatStop + 2] = this.sample[this.repeatStart + 2];
            this.sample[this.repeatStop + 3] = this.sample[this.repeatStart + 3];
            this.sample[this.repeatStop + 4] = this.sample[this.repeatStart + 4];
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.name);
        stringBuilder.append('(').append("length:").append(this.length).append(',').append("fineTune:").append(this.fineTune).append(',').append("transpose:").append(this.transpose).append(',').append("baseFrequency:").append(this.baseFrequency).append(',').append("volume:").append(this.volume).append(',').append("panning:").append(this.panning).append(',').append("repeatStart:").append(this.repeatStart).append(',').append("repeatLength:").append(this.repeatLength).append(',').append("repeatStop:").append(this.repeatStop).append(')');
        return stringBuilder.toString();
    }

    public String toShortString() {
        return this.name;
    }

    private int getLinearInterpolated(int n, int n2) {
        long l = (long)this.sample[n] << 12;
        long l2 = (long)this.sample[n + 1] << 12;
        return (int)(l + ((l2 - l) * (long)n2 >> 16) >> 12);
    }

    private int getCubicInterpolated(int n, int n2) {
        int n3 = n2 >> 4 & 0xFFC;
        long l = (n - 1 < 0 ? 0L : (long)CubicSpline.lut[n3] * (long)this.sample[n - 1]) + (long)CubicSpline.lut[n3 + 1] * (long)this.sample[n] + (long)CubicSpline.lut[n3 + 2] * (long)this.sample[n + 1] + (long)CubicSpline.lut[n3 + 3] * (long)this.sample[n + 2];
        return (int)(l >> 14);
    }

    private int getFIRInterpolated(int n, int n2) {
        int n3 = n2 & 0xFFFF;
        int n4 = n3 + 16 >> 2 & 0x7FF8;
        long l = (n - 3 < 0 ? 0L : (long)WindowedFIR.lut[n4] * (long)this.sample[n - 3]) + (n - 2 < 0 ? 0L : (long)WindowedFIR.lut[n4 + 1] * (long)this.sample[n - 2]) + (n - 1 < 0 ? 0L : (long)WindowedFIR.lut[n4 + 2] * (long)this.sample[n - 1]) + (long)WindowedFIR.lut[n4 + 3] * (long)this.sample[n];
        long l2 = (long)WindowedFIR.lut[n4 + 4] * (long)this.sample[n + 1] + (long)WindowedFIR.lut[n4 + 5] * (long)this.sample[n + 2] + (long)WindowedFIR.lut[n4 + 6] * (long)this.sample[n + 3] + (long)WindowedFIR.lut[n4 + 7] * (long)this.sample[n + 4];
        return (int)((l >> 1) + (l2 >> 1) >> 14);
    }

    public int getInterpolatedSample(int n, int n2, int n3) {
        if (this.sample == null) {
            return 0;
        }
        if (n2 > this.length) {
            return 0;
        }
        switch (n) {
            case 0: {
                return this.sample[n2];
            }
            case 1: {
                return this.getLinearInterpolated(n2, n3);
            }
            case 2: {
                return this.getCubicInterpolated(n2, n3);
            }
            case 3: {
                return this.getFIRInterpolated(n2, n3);
            }
        }
        return 0;
    }

    public void setBaseFrequency(int n) {
        this.baseFrequency = n;
    }

    public void setDosFileName(String string) {
        this.dosFileName = string;
    }

    public void setFineTune(int n) {
        this.fineTune = n;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public void setLoopType(int n) {
        this.loopType = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setRepeatLength(int n) {
        this.repeatLength = n;
    }

    public void setRepeatStart(int n) {
        this.repeatStart = n;
    }

    public void setRepeatStop(int n) {
        this.repeatStop = n;
    }

    public void setSample(int[] nArray) {
        this.sample = nArray;
    }

    public void setTranspose(int n) {
        this.transpose = n;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setVolume(int n) {
        this.volume = n;
    }

    public void setPanning(int n) {
        this.panning = n;
    }

    public void setCvT(int n) {
        this.flag_CvT = n;
    }

    public void setSustainLoopStart(int n) {
        this.sustainLoopStart = n;
    }

    public void setSustainLoopEnd(int n) {
        this.sustainLoopEnd = n;
    }

    public void setVibratoDepth(int n) {
        this.vibratoDepth = n;
    }

    public void setVibratoRate(int n) {
        this.vibratoRate = n;
    }

    public void setVibratoSweep(int n) {
        this.vibratoSweep = n;
    }

    public void setVibratoType(int n) {
        this.vibratoType = n;
    }

    public void setGlobalVolume(int n) {
        this.globalVolume = n;
    }
}

