/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jflac.metadata;

import de.quippy.jflac.io.BitInputStream;
import de.quippy.jflac.metadata.Metadata;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class Picture
extends Metadata {
    private int pictureType;
    private int mimeTypeByteCount;
    private String mimeString;
    private int descStringByteCount;
    private String descString;
    private int picPixelWidth;
    private int picPixelHeight;
    private int picBitsPerPixel;
    private int picColorCount;
    private int picByteCount;
    protected byte[] image;

    public Picture(BitInputStream bitInputStream, int n, boolean bl) throws IOException {
        super(bl);
        int n2 = 0;
        this.pictureType = bitInputStream.readRawUInt(32);
        n2 += 32;
        this.mimeTypeByteCount = bitInputStream.readRawUInt(32);
        n2 += 32;
        byte[] byArray = new byte[this.mimeTypeByteCount];
        bitInputStream.readByteBlockAlignedNoCRC(byArray, this.mimeTypeByteCount);
        n2 += this.mimeTypeByteCount * 8;
        this.mimeString = new String(byArray);
        this.descStringByteCount = bitInputStream.readRawUInt(32);
        n2 += 32;
        if (this.descStringByteCount != 0) {
            byArray = new byte[this.descStringByteCount];
            bitInputStream.readByteBlockAlignedNoCRC(byArray, this.descStringByteCount);
            try {
                this.descString = new String(byArray, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.descString = new String(byArray);
            }
            n2 += 32;
        } else {
            this.descString = "";
        }
        this.picPixelWidth = bitInputStream.readRawUInt(32);
        n2 += 32;
        this.picPixelHeight = bitInputStream.readRawUInt(32);
        n2 += 32;
        this.picBitsPerPixel = bitInputStream.readRawUInt(32);
        n2 += 32;
        this.picColorCount = bitInputStream.readRawUInt(32);
        n2 += 32;
        this.picByteCount = bitInputStream.readRawUInt(32);
        n2 += 32;
        this.image = new byte[this.picByteCount];
        bitInputStream.readByteBlockAlignedNoCRC(this.image, this.picByteCount);
        bitInputStream.readByteBlockAlignedNoCRC(null, n -= (n2 += this.picByteCount * 8) / 8);
    }

    public String toString() {
        return "Picture:  Type=" + this.pictureType + " MIME type=" + this.mimeString + " Description=\"" + this.descString + "\"" + " Pixels (WxH)=" + this.picPixelWidth + "x" + this.picPixelHeight + " Color Depth=" + this.picBitsPerPixel + " Color Count=" + this.picColorCount + " Picture Size (bytes)=" + this.picByteCount;
    }
}

