/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jflac.metadata;

import de.quippy.jflac.io.BitInputStream;
import de.quippy.jflac.io.BitOutputStream;
import de.quippy.jflac.metadata.Metadata;
import de.quippy.jflac.metadata.SeekPoint;
import java.io.IOException;

public class SeekTable
extends Metadata {
    private static final int SEEKPOINT_LENGTH_BYTES = 18;
    protected SeekPoint[] points;

    public SeekTable(BitInputStream bitInputStream, int n, boolean bl) throws IOException {
        super(bl);
        int n2 = n / 18;
        this.points = new SeekPoint[n2];
        int n3 = 0;
        while (n3 < this.points.length) {
            this.points[n3] = new SeekPoint(bitInputStream);
            ++n3;
        }
        if ((n -= n * 18) > 0) {
            bitInputStream.readByteBlockAlignedNoCRC(null, n);
        }
    }

    public SeekTable(SeekPoint[] seekPointArray, boolean bl) {
        super(bl);
        this.points = seekPointArray;
    }

    public void write(BitOutputStream bitOutputStream, boolean bl) throws IOException {
        bitOutputStream.writeRawUInt(bl, 1);
        bitOutputStream.writeRawUInt(3, 7);
        bitOutputStream.writeRawUInt(this.calcLength(), 24);
        int n = 0;
        while (n < this.points.length) {
            this.points[n].write(bitOutputStream);
            ++n;
        }
        bitOutputStream.flushByteAligned();
    }

    public int calcLength() {
        return this.points.length * 18;
    }

    public SeekPoint getSeekPoint(int n) {
        if (n < 0 || n >= this.points.length) {
            return null;
        }
        return this.points[n];
    }

    public int numberOfPoints() {
        return this.points.length;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SeekTable: points=" + this.points.length + "\n");
        int n = 0;
        while (n < this.points.length) {
            stringBuffer.append("\tPoint " + this.points[n].toString() + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

