/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.info;

import de.quippy.jmac.info.APEDescriptor;
import de.quippy.jmac.info.APEFileInfo;
import de.quippy.jmac.info.APEHeaderNew;
import de.quippy.jmac.info.APEHeaderOld;
import de.quippy.jmac.tools.ByteArrayReader;
import de.quippy.jmac.tools.File;
import de.quippy.jmac.tools.JMACException;
import java.io.EOFException;
import java.io.IOException;

public class APEHeader {
    public static final int MAC_FORMAT_FLAG_8_BIT = 1;
    public static final int MAC_FORMAT_FLAG_CRC = 2;
    public static final int MAC_FORMAT_FLAG_HAS_PEAK_LEVEL = 4;
    public static final int MAC_FORMAT_FLAG_24_BIT = 8;
    public static final int MAC_FORMAT_FLAG_HAS_SEEK_ELEMENTS = 16;
    public static final int MAC_FORMAT_FLAG_CREATE_WAV_HEADER = 32;
    protected File m_pIO;

    public APEHeader(File file) {
        this.m_pIO = file;
    }

    public void Analyze(APEFileInfo aPEFileInfo) throws IOException {
        aPEFileInfo.nJunkHeaderBytes = this.FindDescriptor(true);
        if (aPEFileInfo.nJunkHeaderBytes < 0) {
            throw new JMACException("Unsupported Format");
        }
        this.m_pIO.mark(10);
        ByteArrayReader byteArrayReader = new ByteArrayReader(this.m_pIO, 8);
        if (!byteArrayReader.readString(4, "US-ASCII").equals("MAC ")) {
            throw new JMACException("Unsupported Format");
        }
        int n = byteArrayReader.readUnsignedShort();
        this.m_pIO.reset();
        if (n >= 3980) {
            this.AnalyzeCurrent(aPEFileInfo);
        } else {
            this.AnalyzeOld(aPEFileInfo);
        }
    }

    protected void AnalyzeCurrent(APEFileInfo aPEFileInfo) throws IOException {
        aPEFileInfo.spAPEDescriptor = APEDescriptor.read(this.m_pIO);
        if (aPEFileInfo.spAPEDescriptor.nDescriptorBytes - 52L > 0L) {
            this.m_pIO.skipBytes((int)(aPEFileInfo.spAPEDescriptor.nDescriptorBytes - 52L));
        }
        APEHeaderNew aPEHeaderNew = APEHeaderNew.read(this.m_pIO);
        if (aPEFileInfo.spAPEDescriptor.nHeaderBytes - 24L > 0L) {
            this.m_pIO.skipBytes((int)(aPEFileInfo.spAPEDescriptor.nHeaderBytes - 24L));
        }
        aPEFileInfo.nVersion = aPEFileInfo.spAPEDescriptor.nVersion;
        aPEFileInfo.nCompressionLevel = aPEHeaderNew.nCompressionLevel;
        aPEFileInfo.nFormatFlags = aPEHeaderNew.nFormatFlags;
        aPEFileInfo.nTotalFrames = (int)aPEHeaderNew.nTotalFrames;
        aPEFileInfo.nFinalFrameBlocks = (int)aPEHeaderNew.nFinalFrameBlocks;
        aPEFileInfo.nBlocksPerFrame = (int)aPEHeaderNew.nBlocksPerFrame;
        aPEFileInfo.nChannels = aPEHeaderNew.nChannels;
        aPEFileInfo.nSampleRate = (int)aPEHeaderNew.nSampleRate;
        aPEFileInfo.nBitsPerSample = aPEHeaderNew.nBitsPerSample;
        aPEFileInfo.nBytesPerSample = aPEFileInfo.nBitsPerSample / 8;
        aPEFileInfo.nBlockAlign = aPEFileInfo.nBytesPerSample * aPEFileInfo.nChannels;
        aPEFileInfo.nTotalBlocks = (int)(aPEHeaderNew.nTotalFrames == 0L ? 0L : (aPEHeaderNew.nTotalFrames - 1L) * (long)aPEFileInfo.nBlocksPerFrame + aPEHeaderNew.nFinalFrameBlocks);
        aPEFileInfo.nWAVHeaderBytes = (int)((aPEHeaderNew.nFormatFlags & 0x20) > 0 ? 44L : aPEFileInfo.spAPEDescriptor.nHeaderDataBytes);
        aPEFileInfo.nWAVTerminatingBytes = (int)aPEFileInfo.spAPEDescriptor.nTerminatingDataBytes;
        aPEFileInfo.nWAVDataBytes = aPEFileInfo.nTotalBlocks * aPEFileInfo.nBlockAlign;
        aPEFileInfo.nWAVTotalBytes = aPEFileInfo.nWAVDataBytes + aPEFileInfo.nWAVHeaderBytes + aPEFileInfo.nWAVTerminatingBytes;
        aPEFileInfo.nAPETotalBytes = this.m_pIO.isLocal() ? (int)this.m_pIO.length() : -1;
        aPEFileInfo.nLengthMS = (int)((long)aPEFileInfo.nTotalBlocks * 1000L / (long)aPEFileInfo.nSampleRate);
        aPEFileInfo.nAverageBitrate = aPEFileInfo.nLengthMS <= 0 ? 0 : (int)((long)aPEFileInfo.nAPETotalBytes * 8L / (long)aPEFileInfo.nLengthMS);
        aPEFileInfo.nDecompressedBitrate = aPEFileInfo.nBlockAlign * aPEFileInfo.nSampleRate * 8 / 1000;
        aPEFileInfo.nSeekTableElements = (int)(aPEFileInfo.spAPEDescriptor.nSeekTableBytes / 4L);
        aPEFileInfo.nPeakLevel = -1;
        aPEFileInfo.spSeekByteTable = new int[aPEFileInfo.nSeekTableElements];
        int n = 0;
        while (n < aPEFileInfo.nSeekTableElements) {
            aPEFileInfo.spSeekByteTable[n] = this.m_pIO.readIntBack();
            ++n;
        }
        if ((aPEHeaderNew.nFormatFlags & 0x20) <= 0) {
            aPEFileInfo.spWaveHeaderData = new byte[aPEFileInfo.nWAVHeaderBytes];
            try {
                this.m_pIO.readFully(aPEFileInfo.spWaveHeaderData);
            }
            catch (EOFException eOFException) {
                throw new JMACException("Can't Read Wave Header Data");
            }
        }
    }

    protected void AnalyzeOld(APEFileInfo aPEFileInfo) throws IOException {
        APEHeaderOld aPEHeaderOld = APEHeaderOld.read(this.m_pIO);
        if (aPEHeaderOld.nTotalFrames == 0L) {
            throw new JMACException("Unsupported Format");
        }
        int n = -1;
        if ((aPEHeaderOld.nFormatFlags & 4) > 0) {
            n = this.m_pIO.readIntBack();
        }
        aPEFileInfo.nSeekTableElements = (aPEHeaderOld.nFormatFlags & 0x10) > 0 ? this.m_pIO.readIntBack() : (int)aPEHeaderOld.nTotalFrames;
        aPEFileInfo.nVersion = aPEHeaderOld.nVersion;
        aPEFileInfo.nCompressionLevel = aPEHeaderOld.nCompressionLevel;
        aPEFileInfo.nFormatFlags = aPEHeaderOld.nFormatFlags;
        aPEFileInfo.nTotalFrames = (int)aPEHeaderOld.nTotalFrames;
        aPEFileInfo.nFinalFrameBlocks = (int)aPEHeaderOld.nFinalFrameBlocks;
        int n2 = aPEFileInfo.nBlocksPerFrame = aPEHeaderOld.nVersion >= 3900 || aPEHeaderOld.nVersion >= 3800 && aPEHeaderOld.nCompressionLevel == 4000 ? 73728 : 9216;
        if (aPEHeaderOld.nVersion >= 3950) {
            aPEFileInfo.nBlocksPerFrame = 294912;
        }
        aPEFileInfo.nChannels = aPEHeaderOld.nChannels;
        aPEFileInfo.nSampleRate = (int)aPEHeaderOld.nSampleRate;
        aPEFileInfo.nBitsPerSample = (aPEFileInfo.nFormatFlags & 1) > 0 ? 8 : ((aPEFileInfo.nFormatFlags & 8) > 0 ? 24 : 16);
        aPEFileInfo.nBytesPerSample = aPEFileInfo.nBitsPerSample / 8;
        aPEFileInfo.nBlockAlign = aPEFileInfo.nBytesPerSample * aPEFileInfo.nChannels;
        aPEFileInfo.nTotalBlocks = (int)(aPEHeaderOld.nTotalFrames == 0L ? 0L : (aPEHeaderOld.nTotalFrames - 1L) * (long)aPEFileInfo.nBlocksPerFrame + aPEHeaderOld.nFinalFrameBlocks);
        aPEFileInfo.nWAVHeaderBytes = (int)((aPEHeaderOld.nFormatFlags & 0x20) > 0 ? 44L : aPEHeaderOld.nHeaderBytes);
        aPEFileInfo.nWAVTerminatingBytes = (int)aPEHeaderOld.nTerminatingBytes;
        aPEFileInfo.nWAVDataBytes = aPEFileInfo.nTotalBlocks * aPEFileInfo.nBlockAlign;
        aPEFileInfo.nWAVTotalBytes = aPEFileInfo.nWAVDataBytes + aPEFileInfo.nWAVHeaderBytes + aPEFileInfo.nWAVTerminatingBytes;
        aPEFileInfo.nAPETotalBytes = this.m_pIO.isLocal() ? (int)this.m_pIO.length() : -1;
        aPEFileInfo.nLengthMS = (int)((long)aPEFileInfo.nTotalBlocks * 1000L / (long)aPEFileInfo.nSampleRate);
        aPEFileInfo.nAverageBitrate = (int)(aPEFileInfo.nLengthMS <= 0 ? 0L : (long)aPEFileInfo.nAPETotalBytes * 8L / (long)aPEFileInfo.nLengthMS);
        aPEFileInfo.nDecompressedBitrate = aPEFileInfo.nBlockAlign * aPEFileInfo.nSampleRate * 8 / 1000;
        aPEFileInfo.nPeakLevel = n;
        if ((aPEHeaderOld.nFormatFlags & 0x20) <= 0) {
            if (aPEHeaderOld.nHeaderBytes > Integer.MAX_VALUE) {
                throw new JMACException("The HeaderBytes Parameter Is Too Big");
            }
            aPEFileInfo.spWaveHeaderData = new byte[(int)aPEHeaderOld.nHeaderBytes];
            try {
                this.m_pIO.readFully(aPEFileInfo.spWaveHeaderData);
            }
            catch (EOFException eOFException) {
                throw new JMACException("Can't Read Wave Header Data");
            }
        }
        aPEFileInfo.spSeekByteTable = new int[aPEFileInfo.nSeekTableElements];
        int n3 = 0;
        while (n3 < aPEFileInfo.nSeekTableElements) {
            aPEFileInfo.spSeekByteTable[n3] = this.m_pIO.readIntBack();
            ++n3;
        }
        if (aPEHeaderOld.nVersion <= 3800) {
            aPEFileInfo.spSeekBitTable = new byte[aPEFileInfo.nSeekTableElements];
            try {
                this.m_pIO.readFully(aPEFileInfo.spSeekBitTable);
            }
            catch (EOFException eOFException) {
                throw new JMACException("Can't Read Seek Bit Table");
            }
        }
    }

    protected int FindDescriptor(boolean bl) throws IOException {
        int n;
        int n2 = 0;
        if (this.m_pIO.isLocal()) {
            this.m_pIO.mark(1000);
            ByteArrayReader byteArrayReader = new ByteArrayReader(10);
            byteArrayReader.reset(this.m_pIO, 10);
            String string = byteArrayReader.readString(3, "US-ASCII");
            if (string.equals("ID3")) {
                byteArrayReader.readByte();
                byteArrayReader.readByte();
                n = byteArrayReader.readUnsignedByte();
                int n3 = (byteArrayReader.readUnsignedByte() & 0x7F) << 21;
                n3 += (byteArrayReader.readUnsignedByte() & 0x7F) << 14;
                n3 += (byteArrayReader.readUnsignedByte() & 0x7F) << 7;
                n3 += byteArrayReader.readUnsignedByte() & 0x7F;
                boolean bl2 = false;
                if ((n & 0x10) > 0) {
                    bl2 = true;
                    n2 = n3 + 20;
                } else {
                    n2 = n3 + 10;
                }
                this.m_pIO.skipBytes(n2 - 10);
                if (!bl2) {
                    while (this.m_pIO.read() == 0) {
                        ++n2;
                    }
                }
            }
            this.m_pIO.reset();
            this.m_pIO.skipBytes(n2);
        }
        this.m_pIO.mark(1000);
        int n4 = 1296122656;
        int n5 = this.m_pIO.readInt();
        if (this.m_pIO.isLocal()) {
            n = 0;
            while (n4 != n5 && n < 0x100000) {
                n5 = n5 << 8 | this.m_pIO.readByte();
                ++n2;
                ++n;
            }
        }
        if (n4 != n5) {
            n2 = -1;
        }
        if (bl && n2 != -1) {
            this.m_pIO.reset();
            this.m_pIO.skipBytes(n2);
            this.m_pIO.mark(1000);
        } else {
            this.m_pIO.reset();
        }
        return n2;
    }
}

