/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.prediction;

import de.quippy.jmac.tools.JMACException;
import de.quippy.jmac.tools.RollBufferShort;
import java.util.Arrays;

public abstract class NNFilter {
    protected int m_nOrder;
    protected int m_nShift;
    protected int m_nVersion;
    protected int orderPlusWindow;
    private int m_nRunningAverage;
    private RollBufferShort m_rbInput = new RollBufferShort();
    private RollBufferShort m_rbDeltaM = new RollBufferShort();
    private short[] m_paryM;
    public static final int NN_WINDOW_ELEMENTS = 512;

    public NNFilter(int n, int n2, int n3) {
        if (n <= 0 || n % 16 != 0) {
            throw new JMACException("Wrong Order");
        }
        this.m_nOrder = n;
        this.m_nShift = n2;
        this.m_nVersion = n3;
        this.m_rbInput.Create(512, n);
        this.m_rbDeltaM.Create(512, n);
        this.m_paryM = new short[n];
    }

    public int Compress(int n) {
        short[] sArray = this.m_rbInput.m_pData;
        int n2 = this.m_rbInput.index;
        sArray[n2] = (short)(n >= Short.MIN_VALUE && n <= Short.MAX_VALUE ? n : n >> 31 ^ Short.MAX_VALUE);
        int n3 = this.CalculateDotProductNoMMX(sArray, n2 - this.m_nOrder, this.m_paryM, 0);
        int n4 = n - (n3 + (1 << this.m_nShift - 1) >> this.m_nShift);
        short[] sArray2 = this.m_rbDeltaM.m_pData;
        int n5 = this.m_rbDeltaM.index;
        this.AdaptNoMMX(this.m_paryM, 0, sArray2, n5 - this.m_nOrder, n4);
        int n6 = Math.abs(n);
        sArray2[n5] = n6 > this.m_nRunningAverage * 3 ? (short)((n >> 25 & 0x40) - 32) : (n6 > (this.m_nRunningAverage << 2) / 3 ? (short)((n >> 26 & 0x20) - 16) : (n6 > 0 ? (short)((n >> 27 & 0x10) - 8) : (short)0));
        this.m_nRunningAverage += (n6 - this.m_nRunningAverage) / 16;
        int n7 = n5 - 1;
        sArray2[n7] = (short)(sArray2[n7] >> 1);
        int n8 = n5 - 2;
        sArray2[n8] = (short)(sArray2[n8] >> 1);
        int n9 = n5 - 8;
        sArray2[n9] = (short)(sArray2[n9] >> 1);
        if (++this.m_rbInput.index == this.orderPlusWindow) {
            System.arraycopy(sArray, this.m_rbInput.index - this.m_nOrder, sArray, 0, this.m_nOrder);
            this.m_rbInput.index = this.m_nOrder;
        }
        if (++this.m_rbDeltaM.index == this.orderPlusWindow) {
            System.arraycopy(sArray2, this.m_rbDeltaM.index - this.m_nOrder, sArray2, 0, this.m_nOrder);
            this.m_rbDeltaM.index = this.m_nOrder;
        }
        return n4;
    }

    public int Decompress(int n) {
        short[] sArray = this.m_rbInput.m_pData;
        int n2 = this.m_rbInput.index;
        int n3 = this.CalculateDotProductNoMMX(sArray, n2 - this.m_nOrder, this.m_paryM, 0);
        short[] sArray2 = this.m_rbDeltaM.m_pData;
        int n4 = this.m_rbDeltaM.index;
        this.AdaptNoMMX(this.m_paryM, 0, sArray2, n4 - this.m_nOrder, n);
        int n5 = n + (n3 + (1 << this.m_nShift - 1) >> this.m_nShift);
        sArray[n2] = (short)(n5 >= Short.MIN_VALUE && n5 <= Short.MAX_VALUE ? n5 : n5 >> 31 ^ Short.MAX_VALUE);
        if (this.m_nVersion >= 3980) {
            int n6 = Math.abs(n5);
            sArray2[n4] = n6 > this.m_nRunningAverage * 3 ? (short)((n5 >> 25 & 0x40) - 32) : (n6 > (this.m_nRunningAverage << 2) / 3 ? (short)((n5 >> 26 & 0x20) - 16) : (n6 > 0 ? (short)((n5 >> 27 & 0x10) - 8) : (short)0));
            this.m_nRunningAverage += (n6 - this.m_nRunningAverage) / 16;
            int n7 = n4 - 1;
            sArray2[n7] = (short)(sArray2[n7] >> 1);
            int n8 = n4 - 2;
            sArray2[n8] = (short)(sArray2[n8] >> 1);
            int n9 = n4 - 8;
            sArray2[n9] = (short)(sArray2[n9] >> 1);
        } else {
            sArray2[n4] = (short)(n5 == 0 ? 0 : (n5 >> 28 & 8) - 4);
            int n10 = n4 - 4;
            sArray2[n10] = (short)(sArray2[n10] >> 1);
            int n11 = n4 - 8;
            sArray2[n11] = (short)(sArray2[n11] >> 1);
        }
        if (++this.m_rbInput.index == this.orderPlusWindow) {
            System.arraycopy(sArray, this.m_rbInput.index - this.m_nOrder, sArray, 0, this.m_nOrder);
            this.m_rbInput.index = this.m_nOrder;
        }
        if (++this.m_rbDeltaM.index == this.orderPlusWindow) {
            System.arraycopy(sArray2, this.m_rbDeltaM.index - this.m_nOrder, sArray2, 0, this.m_nOrder);
            this.m_rbDeltaM.index = this.m_nOrder;
        }
        return n5;
    }

    public void Flush() {
        Arrays.fill(this.m_paryM, (short)0);
        this.m_rbInput.Flush();
        this.m_rbDeltaM.Flush();
        this.m_nRunningAverage = 0;
    }

    protected abstract int CalculateDotProductNoMMX(short[] var1, int var2, short[] var3, int var4);

    protected abstract void AdaptNoMMX(short[] var1, int var2, short[] var3, int var4, int var5);
}

