/*
 * Decompiled with CFR 0.152.
 */
package org.kc7bfi.jflac.sound.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.lang.constant.Constable;
import java.net.URL;
import java.util.HashMap;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.kc7bfi.jflac.Constants;
import org.kc7bfi.jflac.FLACDecoder;
import org.kc7bfi.jflac.io.BitInputStream;
import org.kc7bfi.jflac.io.BitOutputStream;
import org.kc7bfi.jflac.metadata.StreamInfo;
import org.kc7bfi.jflac.sound.spi.FlacAudioFileFormat;
import org.kc7bfi.jflac.sound.spi.FlacAudioFormat;
import org.kc7bfi.jflac.sound.spi.FlacEncoding;
import org.kc7bfi.jflac.sound.spi.FlacFileFormatType;
import org.tritonus.share.sampled.file.TAudioFileReader;

public class FlacAudioFileReader
extends TAudioFileReader {
    private static final boolean DEBUG = false;
    private FLACDecoder decoder;
    private StreamInfo streamInfo;
    private static final int INITAL_READ_LENGTH = 64000;
    private static final int MARK_LIMIT = 64001;

    public FlacAudioFileReader() {
        super(64001, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream, (int)file.length());
            return audioFileFormat;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = url.openStream();
        try {
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream);
            return audioFileFormat;
        }
        finally {
            inputStream.close();
        }
    }

    public AudioFileFormat getAudioFileFormat(InputStream stream) throws UnsupportedAudioFileException, IOException {
        return this.getAudioFileFormat(stream, -1L);
    }

    public AudioFileFormat getAudioFileFormat(InputStream stream, long lFileLengthInBytes) throws UnsupportedAudioFileException, IOException {
        HashMap<String, Number> aff_properties = new HashMap<String, Number>();
        HashMap<String, Constable> af_properties = new HashMap<String, Constable>();
        int channels = -1;
        int bitsPerSample = -1;
        int sampleRate = -1;
        long totalSamples = -1L;
        int duration = -1;
        int frameSizeMin = -1;
        int frameSizeMax = -1;
        int blockSizeMin = -1;
        int blockSizeMax = -1;
        try {
            this.decoder = new FLACDecoder(stream);
            this.streamInfo = this.decoder.readStreamInfo();
            if (this.streamInfo == null) {
                throw new UnsupportedAudioFileException("No StreamInfo found");
            }
            bitsPerSample = this.streamInfo.getBitsPerSample();
            channels = this.streamInfo.getChannels();
            sampleRate = this.streamInfo.getSampleRate();
            totalSamples = this.streamInfo.getTotalSamples();
            duration = Math.round(totalSamples / (long)sampleRate);
            frameSizeMin = this.streamInfo.getMinFrameSize();
            frameSizeMax = this.streamInfo.getMaxFrameSize();
            blockSizeMin = this.streamInfo.getMinBlockSize();
            blockSizeMax = this.streamInfo.getMaxBlockSize();
            aff_properties.put("flac.bitpersample", new Integer(bitsPerSample));
            aff_properties.put("flac.channels", new Integer(channels));
            aff_properties.put("flac.sampleRate", new Integer(sampleRate));
            aff_properties.put("flac.totalSamples", new Long(totalSamples));
            aff_properties.put("duration", new Long((long)duration * 1000000L));
            aff_properties.put("flac.framesize.min", new Integer(frameSizeMin));
            aff_properties.put("flac.framesize.max", new Integer(frameSizeMax));
            aff_properties.put("flac.blocksize.min", new Integer(blockSizeMin));
            aff_properties.put("flac.blocksize.max", new Integer(blockSizeMax));
            af_properties.put("bitrate", new Integer(-1));
            af_properties.put("vbr", Boolean.FALSE);
            af_properties.put("quality", new Integer(100));
        }
        catch (IOException ioe) {
            throw new UnsupportedAudioFileException(ioe.getMessage());
        }
        FlacAudioFormat format = new FlacAudioFormat((AudioFormat.Encoding)FlacEncoding.FLAC, (float)sampleRate, bitsPerSample, channels, -1, -1.0f, false, af_properties);
        return new FlacAudioFileFormat(FlacFileFormatType.FLAC, format, -1, (int)lFileLengthInBytes, aff_properties);
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream inputStream = new FileInputStream(file);
        try {
            return this.getAudioInputStream((InputStream)inputStream, (int)file.length());
        }
        catch (UnsupportedAudioFileException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
        catch (IOException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
    }

    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = url.openStream();
        try {
            return this.getAudioInputStream(inputStream);
        }
        catch (UnsupportedAudioFileException e) {
            inputStream.close();
            throw e;
        }
        catch (IOException ex) {
            inputStream.close();
            throw ex;
        }
    }

    public AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        return this.getAudioInputStream(stream, -1);
    }

    protected AudioInputStream getAudioInputStream(InputStream inputStream, int medialength) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream, medialength);
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        BitOutputStream bitOutStream = new BitOutputStream(byteOutStream);
        bitOutStream.writeByteBlock(Constants.STREAM_SYNC_STRING, Constants.STREAM_SYNC_STRING.length);
        this.streamInfo.write(bitOutStream, false);
        BitInputStream bis = this.decoder.getBitInputStream();
        int bytesLeft = bis.getInputBytesUnconsumed();
        byte[] b = new byte[bytesLeft];
        bis.readByteBlockAlignedNoCRC(b, bytesLeft);
        byteOutStream.write(b);
        ByteArrayInputStream byteInStream = new ByteArrayInputStream(byteOutStream.toByteArray());
        SequenceInputStream sequenceInputStream = new SequenceInputStream(byteInStream, inputStream);
        return new AudioInputStream(sequenceInputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }
}

