/*
 * Decompiled with CFR 0.152.
 */
package xtrememp;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.Document;
import org.apache.commons.io.FilenameUtils;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtrememp.ControlListener;
import xtrememp.MediaInfoDialog;
import xtrememp.Settings;
import xtrememp.XtremeMP;
import xtrememp.player.audio.AudioPlayer;
import xtrememp.playlist.Playlist;
import xtrememp.playlist.PlaylistException;
import xtrememp.playlist.PlaylistIO;
import xtrememp.playlist.PlaylistItem;
import xtrememp.playlist.filter.Predicate;
import xtrememp.playlist.filter.TruePredicate;
import xtrememp.tag.TagInfo;
import xtrememp.ui.table.PlaylistColumn;
import xtrememp.ui.table.PlaylistTableColumn;
import xtrememp.ui.table.PlaylistTableColumnModel;
import xtrememp.ui.table.PlaylistTableModel;
import xtrememp.ui.text.SearchTextField;
import xtrememp.util.AbstractSwingWorker;
import xtrememp.util.Utilities;
import xtrememp.util.file.AudioFileFilter;
import xtrememp.util.file.M3uPlaylistFileFilter;
import xtrememp.util.file.PlaylistFileFilter;
import xtrememp.util.file.XspfPlaylistFileFilter;

public class PlaylistManager
extends JPanel
implements ActionListener,
DropTargetListener,
ListSelectionListener {
    private final Logger logger = LoggerFactory.getLogger(PlaylistManager.class);
    private final AudioFileFilter audioFileFilter = AudioFileFilter.INSTANCE;
    private final PlaylistFileFilter playlistFileFilter = PlaylistFileFilter.INSTANCE;
    private JButton openPlaylistButton;
    private JButton savePlaylistButton;
    private JButton addToPlaylistButton;
    private JButton remFromPlaylistButton;
    private JButton clearPlaylistButton;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JButton mediaInfoButton;
    private ControlListener controlListener;
    private Playlist playlist;
    private JTable playlistTable;
    private PlaylistTableModel playlistTableModel;
    private PlaylistTableColumnModel playlistTableColumnModel;
    private SearchTextField searchTextField;
    private Predicate<PlaylistItem> searchFilter;
    private String searchString;
    private int doubleSelectedRow = -1;
    private volatile boolean firstLoad = false;

    public PlaylistManager(ControlListener controlListener) {
        super(new BorderLayout());
        this.controlListener = controlListener;
        this.playlist = new Playlist();
        this.initModel();
        this.initComponents();
        this.initFiltering();
    }

    private void initModel() {
        this.playlistTableColumnModel = new PlaylistTableColumnModel();
        PlaylistColumn[] playlistColumns = Settings.getPlaylistColumns();
        for (int i = 0; i < playlistColumns.length; ++i) {
            this.playlistTableColumnModel.addColumn(new PlaylistTableColumn(playlistColumns[i], i));
        }
        this.playlistTableModel = new PlaylistTableModel(this.playlist, this.playlistTableColumnModel);
    }

    private void initComponents() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        this.openPlaylistButton = new JButton(Utilities.DOCUMENT_OPEN_ICON);
        this.openPlaylistButton.setToolTipText(Utilities.tr("MainFrame.PlaylistManager.OpenPlaylist"));
        this.openPlaylistButton.addActionListener(this);
        toolBar.add(this.openPlaylistButton);
        this.savePlaylistButton = new JButton(Utilities.DOCUMENT_SAVE_ICON);
        this.savePlaylistButton.setToolTipText(Utilities.tr("MainFrame.PlaylistManager.SavePlaylist"));
        this.savePlaylistButton.addActionListener(this);
        toolBar.add(this.savePlaylistButton);
        toolBar.addSeparator();
        this.addToPlaylistButton = new JButton(Utilities.LIST_ADD_ICON);
        this.addToPlaylistButton.setToolTipText(Utilities.tr("MainFrame.PlaylistManager.AddToPlaylist"));
        this.addToPlaylistButton.addActionListener(this);
        toolBar.add(this.addToPlaylistButton);
        this.remFromPlaylistButton = new JButton(Utilities.LIST_REMOVE_ICON);
        this.remFromPlaylistButton.setToolTipText(Utilities.tr("MainFrame.PlaylistManager.RemoveFromPlaylist"));
        this.remFromPlaylistButton.addActionListener(this);
        this.remFromPlaylistButton.setEnabled(false);
        toolBar.add(this.remFromPlaylistButton);
        this.clearPlaylistButton = new JButton(Utilities.EDIT_CLEAR_ICON);
        this.clearPlaylistButton.setToolTipText(Utilities.tr("MainFrame.PlaylistManager.ClearPlaylist"));
        this.clearPlaylistButton.addActionListener(this);
        this.clearPlaylistButton.setEnabled(false);
        toolBar.add(this.clearPlaylistButton);
        toolBar.addSeparator();
        this.moveUpButton = new JButton(Utilities.GO_UP_ICON);
        this.moveUpButton.setToolTipText(Utilities.tr("MainFrame.PlaylistManager.MoveUp"));
        this.moveUpButton.addActionListener(this);
        this.moveUpButton.setEnabled(false);
        toolBar.add(this.moveUpButton);
        this.moveDownButton = new JButton(Utilities.GO_DOWN_ICON);
        this.moveDownButton.setToolTipText(Utilities.tr("MainFrame.PlaylistManager.MoveDown"));
        this.moveDownButton.addActionListener(this);
        this.moveDownButton.setEnabled(false);
        toolBar.add(this.moveDownButton);
        toolBar.addSeparator();
        this.mediaInfoButton = new JButton(Utilities.MEDIA_INFO_ICON);
        this.mediaInfoButton.setToolTipText(Utilities.tr("MainFrame.PlaylistManager.MediaInfo"));
        this.mediaInfoButton.addActionListener(this);
        this.mediaInfoButton.setEnabled(false);
        toolBar.add(this.mediaInfoButton);
        toolBar.add(Box.createHorizontalGlue());
        this.searchTextField = new SearchTextField(15);
        this.searchTextField.setMaximumSize(new Dimension(120, this.searchTextField.getPreferredSize().height));
        this.searchTextField.getTextField().getDocument().addDocumentListener(new SearchFilterListener());
        toolBar.add(this.searchTextField);
        toolBar.add(Box.createHorizontalStrut(6));
        this.add((Component)toolBar, "North");
        this.playlistTable = new JTable(this.playlistTableModel, this.playlistTableColumnModel);
        this.playlistTable.setDefaultRenderer(String.class, (TableCellRenderer)((Object)new PlaylistCellRenderer()));
        this.playlistTable.setActionMap(null);
        this.playlistTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent ev) {
                if (SwingUtilities.isRightMouseButton(ev) || MouseInfo.getNumberOfButtons() == 1 && ev.isControlDown()) {
                    PlaylistManager.this.playlistTableColumnModel.getPopupMenu().show(PlaylistManager.this.playlistTable.getTableHeader(), ev.getX(), ev.getY());
                    return;
                }
                int clickedColumn = PlaylistManager.this.playlistTableColumnModel.getColumnIndexAtX(ev.getX());
                PlaylistTableColumn playlistColumn = PlaylistManager.this.playlistTableColumnModel.getColumn(clickedColumn);
                PlaylistManager.this.playlistTableColumnModel.resetAll(playlistColumn.getModelIndex());
                playlistColumn.setSortOrderUp(!playlistColumn.isSortOrderUp());
                PlaylistManager.this.playlistTableModel.sort(playlistColumn.getComparator());
                PlaylistManager.this.colorizeRow();
            }
        });
        this.playlistTable.setFillsViewportHeight(true);
        this.playlistTable.setShowGrid(false);
        this.playlistTable.setRowSelectionAllowed(true);
        this.playlistTable.setColumnSelectionAllowed(false);
        this.playlistTable.setDragEnabled(false);
        this.playlistTable.setFont(this.playlistTable.getFont().deriveFont(1));
        this.playlistTable.setIntercellSpacing(new Dimension(0, 0));
        this.playlistTable.setSelectionMode(2);
        this.playlistTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent ev) {
                int selectedRow = PlaylistManager.this.playlistTable.rowAtPoint(ev.getPoint());
                if (SwingUtilities.isLeftMouseButton(ev) && ev.getClickCount() == 2 && selectedRow != -1) {
                    PlaylistManager.this.playlist.setCursorPosition(selectedRow);
                    PlaylistManager.this.controlListener.acOpenAndPlay();
                }
            }
        });
        this.playlistTable.getSelectionModel().addListSelectionListener(this);
        this.playlistTable.getColumnModel().getSelectionModel().addListSelectionListener(this);
        this.playlistTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 73 && e.getModifiers() == 2) {
                    PlaylistManager.this.viewMediaInfo();
                } else if (e.getKeyCode() == 65 && e.getModifiers() == 2) {
                    PlaylistManager.this.playlistTable.selectAll();
                } else if (e.getKeyCode() == 38) {
                    if (e.getModifiers() == 8) {
                        PlaylistManager.this.moveUp();
                    } else if (PlaylistManager.this.playlistTable.getSelectedRow() > 0) {
                        int previousRowIndex = PlaylistManager.this.playlistTable.getSelectedRow() - 1;
                        PlaylistManager.this.playlistTable.clearSelection();
                        PlaylistManager.this.playlistTable.addRowSelectionInterval(previousRowIndex, previousRowIndex);
                        PlaylistManager.this.makeRowVisible(previousRowIndex);
                    }
                } else if (e.getKeyCode() == 40) {
                    if (e.getModifiers() == 8) {
                        PlaylistManager.this.moveDown();
                    } else if (PlaylistManager.this.playlistTable.getSelectedRow() < PlaylistManager.this.playlistTable.getRowCount() - 1) {
                        int nextRowIndex = PlaylistManager.this.playlistTable.getSelectedRow() + 1;
                        PlaylistManager.this.playlistTable.clearSelection();
                        PlaylistManager.this.playlistTable.addRowSelectionInterval(nextRowIndex, nextRowIndex);
                        PlaylistManager.this.makeRowVisible(nextRowIndex);
                    }
                } else if (e.getKeyCode() == 10) {
                    int selectedRow = PlaylistManager.this.playlistTable.getSelectedRow();
                    if (selectedRow != -1) {
                        PlaylistManager.this.playlist.setCursorPosition(selectedRow);
                        PlaylistManager.this.controlListener.acOpenAndPlay();
                    }
                } else if (e.getKeyCode() == 155) {
                    PlaylistManager.this.addFilesDialog();
                } else if (e.getKeyCode() == 127) {
                    PlaylistManager.this.remove();
                }
            }
        });
        XtremeMP.getInstance().getMainFrame().setDropTarget(new DropTarget(this.playlistTable, this));
        JScrollPane ptScrollPane = new JScrollPane(this.playlistTable);
        ptScrollPane.setActionMap(null);
        this.add((Component)ptScrollPane, "Center");
    }

    private void initFiltering() {
        this.searchFilter = new Predicate<PlaylistItem>(){

            @Override
            public boolean evaluate(PlaylistItem pli) {
                StringBuilder sb = new StringBuilder();
                TagInfo tagInfo = pli.getTagInfo();
                sb.append(tagInfo.getTrack()).append(tagInfo.getTitle()).append(tagInfo.getArtist()).append(tagInfo.getAlbum()).append(tagInfo.getGenre());
                return sb.toString().toLowerCase().contains(PlaylistManager.this.searchString.toLowerCase());
            }
        };
    }

    protected void addFiles(List<File> newFiles) {
        AddFilesWorker addFilesWorker = new AddFilesWorker(newFiles);
        addFilesWorker.execute();
    }

    public void add(PlaylistItem newPli) {
        this.playlistTableModel.add(newPli);
    }

    public void add(List<PlaylistItem> newItems) {
        this.playlistTableModel.add(newItems);
    }

    public Playlist getPlaylist() {
        return this.playlist;
    }

    public void randomizePlaylist() {
        if (!this.playlist.isEmpty()) {
            this.playlistTableModel.randomize();
            this.colorizeRow();
        }
    }

    public void loadPlaylist(String location) {
        PlaylistLoaderWorker playlistLoader = new PlaylistLoaderWorker(location);
        playlistLoader.execute();
    }

    public PlaylistColumn[] getPlaylistColums() {
        return this.playlistTableColumnModel.getPlaylistColumns();
    }

    public void setFirstLoad(boolean flag) {
        this.firstLoad = flag;
    }

    public void refreshRow(int index) {
        this.playlistTableModel.fireTableRowsUpdated(index, index);
    }

    public void openPlaylist() {
        JFileChooser fileChooser = new JFileChooser(Settings.getLastDir());
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(this.playlistFileFilter);
        fileChooser.setMultiSelectionEnabled(false);
        if (fileChooser.showOpenDialog(this) == 0) {
            File file = fileChooser.getSelectedFile();
            Settings.setLastDir(file.getPath());
            this.clearPlaylist();
            this.loadPlaylist(file.getPath());
        }
    }

    public boolean savePlaylistDialog() {
        JFileChooser fileChooser = new JFileChooser(Settings.getLastDir());
        M3uPlaylistFileFilter m3uFileFilter = new M3uPlaylistFileFilter();
        XspfPlaylistFileFilter xspfFileFilter = new XspfPlaylistFileFilter();
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(m3uFileFilter);
        fileChooser.addChoosableFileFilter(xspfFileFilter);
        fileChooser.setMultiSelectionEnabled(false);
        if (fileChooser.showSaveDialog(this) == 0) {
            File file = fileChooser.getSelectedFile();
            FileFilter fileFilter = fileChooser.getFileFilter();
            String fileName = file.getName().toLowerCase();
            if (fileFilter == m3uFileFilter) {
                if (!fileName.endsWith(".m3u")) {
                    fileName = fileName.concat(".m3u");
                }
                try {
                    return PlaylistIO.saveM3U(this.playlist, file.getParent() + File.separator + fileName);
                }
                catch (PlaylistException ex) {
                    this.logger.error("Can't save playlist in M3U format", (Throwable)ex);
                }
            }
            if (fileFilter == xspfFileFilter) {
                if (!fileName.endsWith(".xspf")) {
                    fileName = fileName.concat(".xspf");
                }
                try {
                    return PlaylistIO.saveXSPF(this.playlist, file.getParent() + File.separator + fileName);
                }
                catch (PlaylistException ex) {
                    this.logger.error("Can't save playlist in XSPF format", (Throwable)ex);
                }
            }
            Settings.setLastDir(file.getParent());
        }
        return false;
    }

    public void addFilesDialog() {
        JFileChooser fileChooser = new JFileChooser(Settings.getLastDir());
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(this.audioFileFilter);
        fileChooser.setFileSelectionMode(2);
        fileChooser.setMultiSelectionEnabled(true);
        if (fileChooser.showOpenDialog(this) == 0) {
            File[] selectedFiles = fileChooser.getSelectedFiles();
            Settings.setLastDir(selectedFiles[0].getParent());
            this.addFiles(Arrays.asList(selectedFiles));
        }
    }

    public void moveUp() {
        if (this.playlistTable.getSelectedRowCount() > 0) {
            int[] selectedRows = this.playlistTable.getSelectedRows();
            int minSelectedIndex = selectedRows[0];
            if (minSelectedIndex > 0) {
                this.playlistTable.clearSelection();
                for (int selectedRow : selectedRows) {
                    int prevRow = selectedRow - 1;
                    this.playlistTableModel.moveItem(selectedRow, prevRow);
                    this.playlistTable.addRowSelectionInterval(prevRow, prevRow);
                }
                this.makeRowVisible(minSelectedIndex - 1);
            }
            this.colorizeRow();
        }
    }

    public void moveDown() {
        if (this.playlistTable.getSelectedRowCount() > 0) {
            int maxLength;
            int[] selectedRows = this.playlistTable.getSelectedRows();
            int maxSelectedIndex = selectedRows[maxLength = selectedRows.length - 1];
            if (maxSelectedIndex < this.playlist.size() - 1) {
                this.playlistTable.clearSelection();
                for (int i = maxLength; i >= 0; --i) {
                    int selectedRow = selectedRows[i];
                    int nextRow = selectedRow + 1;
                    this.playlistTableModel.moveItem(selectedRow, nextRow);
                    this.playlistTable.addRowSelectionInterval(nextRow, nextRow);
                }
                this.makeRowVisible(maxSelectedIndex + 1);
            }
            this.colorizeRow();
        }
    }

    public void remove() {
        int selectedRowCount = this.playlistTable.getSelectedRowCount();
        if (selectedRowCount > 0) {
            if (selectedRowCount == this.playlist.size() && !this.playlist.isFiltered()) {
                this.clearPlaylist();
                return;
            }
            ArrayList<PlaylistItem> items = new ArrayList<PlaylistItem>();
            int[] selectedRows = this.playlistTable.getSelectedRows();
            int len = selectedRows.length;
            for (int i = 0; i < len; ++i) {
                items.add(this.playlist.getItemAt(selectedRows[i]));
            }
            this.playlistTableModel.removeAll(items);
            this.clearSelection();
            this.colorizeRow();
        }
    }

    protected void clearSelection() {
        this.playlistTable.clearSelection();
        this.remFromPlaylistButton.setEnabled(false);
        this.mediaInfoButton.setEnabled(false);
        this.moveUpButton.setEnabled(false);
        this.moveDownButton.setEnabled(false);
    }

    public void clearPlaylist() {
        if (!this.playlist.isEmpty()) {
            this.playlistTableModel.clear();
            this.doubleSelectedRow = -1;
            this.remFromPlaylistButton.setEnabled(false);
            this.mediaInfoButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
            this.clearPlaylistButton.setEnabled(false);
            Settings.setPlaylistPosition(-1);
            this.playlistTable.requestFocusInWindow();
        }
    }

    public void colorizeRow() {
        if (!this.playlist.isEmpty()) {
            int cursorPos;
            this.doubleSelectedRow = cursorPos = this.playlist.getCursorPosition();
            this.playlistTable.repaint();
            this.makeRowVisible(cursorPos);
        }
    }

    public void makeRowVisible(int rowIndex) {
        if (!(this.playlistTable.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)this.playlistTable.getParent();
        Rectangle contentRect = (Rectangle)this.playlistTable.getCellRect(rowIndex, this.playlistTable.getSelectedColumn(), true).clone();
        Point pt = viewport.getViewPosition();
        contentRect.setLocation(contentRect.x - pt.x, contentRect.y - pt.y);
        viewport.scrollRectToVisible(contentRect);
    }

    private void viewMediaInfo() {
        int selectedRow = this.playlistTable.getSelectedRow();
        if (selectedRow != -1) {
            PlaylistItem pli = this.playlist.getItemAt(selectedRow);
            MediaInfoWorker mediaInfoWorker = new MediaInfoWorker(pli);
            mediaInfoWorker.execute();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.openPlaylistButton)) {
            this.openPlaylist();
        } else if (source.equals(this.savePlaylistButton)) {
            this.savePlaylistDialog();
        } else if (source.equals(this.addToPlaylistButton)) {
            this.addFilesDialog();
        } else if (source.equals(this.remFromPlaylistButton)) {
            this.remove();
        } else if (source.equals(this.clearPlaylistButton)) {
            this.clearPlaylist();
        } else if (source.equals(this.moveUpButton)) {
            this.moveUp();
        } else if (source.equals(this.moveDownButton)) {
            this.moveDown();
        } else if (source.equals(this.mediaInfoButton)) {
            this.viewMediaInfo();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.playlistTable.getSelectionModel()) {
            ListSelectionModel lsm;
            if (this.playlistTable.getSelectedRowCount() > 0) {
                this.remFromPlaylistButton.setEnabled(true);
                this.mediaInfoButton.setEnabled(true);
            }
            if ((lsm = this.playlistTable.getSelectionModel()).getMinSelectionIndex() == 0) {
                this.moveUpButton.setEnabled(false);
            } else {
                this.moveUpButton.setEnabled(true);
            }
            if (lsm.getMaxSelectionIndex() == this.playlistTable.getRowCount() - 1) {
                this.moveDownButton.setEnabled(false);
            } else {
                this.moveDownButton.setEnabled(true);
            }
        }
    }

    @Override
    public void drop(DropTargetDropEvent ev) {
        DropTargetContext targetContext = ev.getDropTargetContext();
        Transferable t = ev.getTransferable();
        try {
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                ev.acceptDrop(3);
                this.addFiles((List)t.getTransferData(DataFlavor.javaFileListFlavor));
                targetContext.dropComplete(true);
            } else if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                ev.acceptDrop(3);
                String urls = (String)t.getTransferData(DataFlavor.stringFlavor);
                ArrayList<File> fileList = new ArrayList<File>();
                StringTokenizer st = new StringTokenizer(urls);
                while (st.hasMoreTokens()) {
                    URI uri = new URI(st.nextToken());
                    fileList.add(new File(uri));
                }
                this.addFiles(fileList);
                targetContext.dropComplete(true);
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent ev) {
    }

    @Override
    public void dragOver(DropTargetDragEvent ev) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent ev) {
    }

    @Override
    public void dragExit(DropTargetEvent ev) {
    }

    protected class MediaInfoWorker
    extends AbstractSwingWorker<Void, PlaylistItem> {
        private final PlaylistItem pli;

        public MediaInfoWorker(PlaylistItem pli) {
            this.pli = pli;
        }

        @Override
        protected Void doInBackground() throws Exception {
            if (this.pli != null) {
                this.pli.getTagInfo();
            }
            return null;
        }

        @Override
        protected void process(List<PlaylistItem> moreItems) {
            PlaylistManager.this.playlistTableModel.add(moreItems);
        }

        @Override
        protected void done() {
            this.setProgress(100);
            if (this.pli != null) {
                MediaInfoDialog mediaInfoDialog = new MediaInfoDialog(this.pli);
                mediaInfoDialog.setVisible(true);
            }
        }
    }

    protected class AddFilesWorker
    extends AbstractSwingWorker<Void, PlaylistItem> {
        private final List<File> fileList;

        public AddFilesWorker(List<File> fileList) {
            this.fileList = fileList;
        }

        @Override
        protected Void doInBackground() {
            ArrayList<File> tempFileList = new ArrayList<File>();
            for (File file : this.fileList) {
                if (file.isDirectory()) {
                    this.scanDir(file, tempFileList);
                    continue;
                }
                if (!PlaylistManager.this.audioFileFilter.accept(file)) continue;
                tempFileList.add(file);
            }
            int count = 0;
            int size = tempFileList.size();
            for (File file : tempFileList) {
                String baseName = FilenameUtils.getBaseName(file.getName());
                PlaylistItem pli = new PlaylistItem(baseName, file.getAbsolutePath(), -1L, true);
                pli.getTagInfo();
                this.publish(pli);
                this.setProgress(100 * ++count / size);
            }
            return null;
        }

        @Override
        protected void process(List<PlaylistItem> moreItems) {
            PlaylistManager.this.playlistTableModel.add(moreItems);
        }

        @Override
        protected void done() {
            this.setProgress(100);
            if (!PlaylistManager.this.playlist.isEmpty()) {
                PlaylistManager.this.clearPlaylistButton.setEnabled(true);
                if (PlaylistManager.this.firstLoad) {
                    PlaylistManager.this.firstLoad = false;
                    PlaylistManager.this.playlist.begin();
                    PlaylistManager.this.controlListener.acOpenAndPlay();
                }
            }
        }

        protected void scanDir(File dir, List<File> fileList) {
            for (File file : dir.listFiles(PlaylistManager.this.audioFileFilter)) {
                if (file.isFile()) {
                    fileList.add(file);
                    continue;
                }
                this.scanDir(file, fileList);
            }
        }
    }

    protected class PlaylistLoaderWorker
    extends AbstractSwingWorker<Void, PlaylistItem> {
        private final String location;

        public PlaylistLoaderWorker(String location) {
            this.location = location;
        }

        @Override
        protected Void doInBackground() throws Exception {
            List<PlaylistItem> pliList = PlaylistIO.load(this.location);
            int count = 0;
            int size = pliList.size();
            for (PlaylistItem pli : pliList) {
                if (pli.isFile()) {
                    pli.getTagInfo();
                }
                this.publish(pli);
                this.setProgress(100 * ++count / size);
            }
            return null;
        }

        @Override
        protected void process(List<PlaylistItem> moreItems) {
            PlaylistManager.this.playlistTableModel.add(moreItems);
        }

        @Override
        protected void done() {
            this.setProgress(100);
            if (!PlaylistManager.this.playlist.isEmpty()) {
                PlaylistManager.this.clearPlaylistButton.setEnabled(true);
                AudioPlayer audioPlayer = XtremeMP.getInstance().getAudioPlayer();
                if (audioPlayer.getState() == -1 || audioPlayer.getState() == 4) {
                    int index = Settings.getPlaylistPosition();
                    if (!PlaylistManager.this.firstLoad && index >= 0 && index <= PlaylistManager.this.playlist.size() - 1) {
                        PlaylistManager.this.playlist.setCursorPosition(index);
                    } else {
                        PlaylistManager.this.playlist.begin();
                    }
                    if (PlaylistManager.this.firstLoad) {
                        PlaylistManager.this.firstLoad = false;
                        PlaylistManager.this.controlListener.acOpenAndPlay();
                    } else {
                        PlaylistManager.this.controlListener.acOpen();
                    }
                }
            }
        }
    }

    protected class SearchFilterListener
    implements DocumentListener {
        protected SearchFilterListener() {
        }

        public void changeFilter(DocumentEvent event) {
            Document document = event.getDocument();
            try {
                PlaylistManager.this.clearSelection();
                PlaylistManager.this.searchString = document.getText(0, document.getLength());
                if (PlaylistManager.this.searchString != null && !PlaylistManager.this.searchString.isEmpty()) {
                    PlaylistManager.this.playlistTableModel.filter(PlaylistManager.this.searchFilter);
                    PlaylistManager.this.moveUpButton.setEnabled(false);
                    PlaylistManager.this.moveDownButton.setEnabled(false);
                } else {
                    PlaylistManager.this.playlistTableModel.filter(TruePredicate.<PlaylistItem>getInstance());
                }
                PlaylistManager.this.colorizeRow();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.changeFilter(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changeFilter(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changeFilter(e);
        }
    }

    protected class PlaylistCellRenderer
    extends SubstanceDefaultTableCellRenderer {
        private Border emptyBorder = BorderFactory.createEmptyBorder();
        private Color selectedColor = Color.red;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBorder(this.emptyBorder);
            if (PlaylistManager.this.playlistTableColumnModel.getColumn(column).getPlaylistColumn() == PlaylistColumn.DURATION) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
            if (row == PlaylistManager.this.doubleSelectedRow) {
                this.setForeground(this.selectedColor);
            }
            return this;
        }
    }
}

