/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.playlist;

import java.util.concurrent.TimeUnit;
import xtrememp.tag.TagInfo;
import xtrememp.tag.TagInfoFactory;
import xtrememp.util.Utilities;

public class PlaylistItem {
    private String name;
    private String location;
    private long duration = 0L;
    private boolean isFile = false;
    private TagInfo tagInfo;
    private String formattedName;
    private String formatedLength;

    public PlaylistItem(String name, String location, long duration, boolean isFile) {
        this.name = name;
        this.location = location;
        this.duration = duration;
        this.isFile = isFile;
        this.formatedLength = this.getFormattedLength(this.duration);
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public TagInfo getTagInfo() {
        if (this.tagInfo == null && !Utilities.isNullOrEmpty(this.location)) {
            this.tagInfo = TagInfoFactory.getInstance().getTagInfo(this.location);
            if (this.isFile) {
                this.duration = this.tagInfo.getTrackLength();
                this.formatedLength = this.getFormattedLength(this.duration);
            }
        }
        return this.tagInfo;
    }

    public void setFormattedName(String formattedName) {
        this.name = formattedName;
        this.formattedName = formattedName;
    }

    public String getFormattedName() {
        if (this.tagInfo == null) {
            this.formattedName = this.name;
        } else if (this.formattedName == null) {
            String title = this.tagInfo.getTitle();
            if (!Utilities.isNullOrEmpty(title)) {
                StringBuilder sb = new StringBuilder(title);
                String artist = this.tagInfo.getArtist();
                if (!Utilities.isNullOrEmpty(artist)) {
                    sb.append(" - ");
                    sb.append(artist);
                }
                this.formattedName = sb.toString();
            } else {
                this.formattedName = this.name;
            }
        }
        return this.formattedName;
    }

    public String getFormattedLength() {
        return this.formatedLength;
    }

    public final String getFormattedLength(long duration) {
        String result = "";
        if (duration > -1L) {
            long hours = TimeUnit.SECONDS.toHours(duration);
            long min = TimeUnit.SECONDS.toMinutes(duration) - TimeUnit.HOURS.toMinutes(hours);
            long sec = duration - TimeUnit.MINUTES.toSeconds(min) - TimeUnit.HOURS.toSeconds(hours);
            result = hours > 0L ? String.format("%d:%02d:%02d", hours, min, sec) : String.format("%02d:%02d", min, sec);
        }
        return result;
    }

    public String getM3UExtInf() {
        StringBuilder sb = new StringBuilder(String.valueOf(this.duration));
        if (this.tagInfo == null) {
            sb.append(',');
            sb.append(this.formattedName);
        } else {
            String title = this.tagInfo.getTitle();
            if (!Utilities.isNullOrEmpty(title)) {
                sb.append(',');
                sb.append(title);
                String artist = this.tagInfo.getArtist();
                if (!Utilities.isNullOrEmpty(artist)) {
                    sb.append(" - ");
                    sb.append(artist);
                }
            } else {
                sb.append(',');
                sb.append(this.formattedName);
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.location;
    }
}

