/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.ui.table;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import xtrememp.playlist.Playlist;
import xtrememp.playlist.PlaylistItem;
import xtrememp.playlist.filter.Predicate;
import xtrememp.ui.table.PlaylistColumn;
import xtrememp.ui.table.PlaylistTableColumn;
import xtrememp.ui.table.PlaylistTableColumnModel;
import xtrememp.util.Utilities;

public class PlaylistTableModel
extends AbstractTableModel {
    private final Playlist playlist;
    private final PlaylistTableColumnModel playlistTableColumnModel;

    public PlaylistTableModel(Playlist playlist, PlaylistTableColumnModel playlistTableColumnModel) {
        this.playlist = playlist;
        this.playlistTableColumnModel = playlistTableColumnModel;
    }

    public void add(List<PlaylistItem> newItems) {
        int first = this.playlist.size();
        int last = first + newItems.size() - 1;
        this.playlist.addAll(newItems);
        this.fireTableRowsInserted(first, last);
    }

    public void add(PlaylistItem item) {
        int index = this.playlist.size();
        this.playlist.addItem(item);
        this.fireTableRowsInserted(index, index);
    }

    public void removeItemAt(int index) {
        this.playlist.removeItemAt(index);
        this.fireTableRowsDeleted(index, index);
    }

    public void removeAll(Collection<? extends PlaylistItem> c) {
        this.playlist.removeAll(c);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.playlist.clear();
        this.fireTableDataChanged();
    }

    public void filter(Predicate<PlaylistItem> filterPredicate) {
        this.playlist.filter(filterPredicate);
        this.fireTableDataChanged();
    }

    public void sort(Comparator<PlaylistItem> comparator) {
        this.playlist.sort(comparator);
        this.fireTableDataChanged();
    }

    public void randomize() {
        this.playlist.randomize();
        this.fireTableDataChanged();
    }

    public void moveItem(int fromIndex, int toIndex) {
        this.playlist.moveItem(fromIndex, toIndex);
        if (fromIndex < toIndex) {
            this.fireTableRowsUpdated(fromIndex, toIndex);
        } else {
            this.fireTableRowsUpdated(toIndex, fromIndex);
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.playlistTableColumnModel.getColumn(columnIndex).getName();
    }

    @Override
    public int getRowCount() {
        return this.playlist.size();
    }

    @Override
    public int getColumnCount() {
        return this.playlistTableColumnModel.getColumnCount();
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (!this.playlist.isEmpty()) {
            PlaylistTableColumn playlistTableColumn = this.playlistTableColumnModel.getColumn(columnIndex);
            PlaylistColumn playlistColumn = playlistTableColumn.getPlaylistColumn();
            PlaylistItem item = this.playlist.getItemAt(rowIndex);
            StringBuilder sb = new StringBuilder();
            if (item.isFile()) {
                switch (playlistColumn) {
                    case TRACK: {
                        String trackStr = item.getTagInfo().getTrack();
                        int trackNum = -1;
                        if (!Utilities.isNullOrEmpty(trackStr)) {
                            try {
                                trackNum = Integer.parseInt(trackStr);
                            }
                            catch (NumberFormatException ex) {
                                // empty catch block
                            }
                        }
                        sb.append(trackNum < 0 ? "" : Integer.valueOf(trackNum));
                        break;
                    }
                    case TITLE: {
                        sb.append(" ");
                        String title = item.getTagInfo().getTitle();
                        sb.append(Utilities.isNullOrEmpty(title) ? item.getFormattedName() : title);
                        break;
                    }
                    case DURATION: {
                        sb.append(item.getFormattedLength()).append(" ");
                        break;
                    }
                    case ARTIST: {
                        sb.append(" ").append(item.getTagInfo().getArtist());
                        break;
                    }
                    case ALBUM: {
                        sb.append(" ").append(item.getTagInfo().getAlbum());
                        break;
                    }
                    case GENRE: {
                        sb.append(" ").append(item.getTagInfo().getGenre());
                    }
                }
            } else {
                switch (playlistColumn) {
                    case TITLE: {
                        sb.append(" ");
                        sb.append(item.getFormattedName());
                        break;
                    }
                    default: {
                        sb.append(" ");
                    }
                }
            }
            return sb.toString();
        }
        return null;
    }
}

