/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.ui.text;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import xtrememp.util.Utilities;

public class SearchTextField
extends JPanel {
    private final char faChar = (char)83;
    private final String searchText = Utilities.tr("MainFrame.PlaylistManager.Filter") + "  (Alt+" + 'S' + ")";
    private JTextField textField;

    public SearchTextField(int columns) {
        super(new BorderLayout());
        this.textField = new PromptTextField(this.searchText, columns);
        this.textField.setBackground(new Color(0, 0, 0, 64));
        this.textField.setFont(this.getFont().deriveFont(1));
        this.textField.setFocusAccelerator('S');
        this.add((Component)this.textField, "Center");
    }

    public JTextField getTextField() {
        return this.textField;
    }

    private class PromptTextField
    extends JTextField {
        private String promptText;
        private Font promptFont;
        private Insets insets;
        private Map desktopHints;

        public PromptTextField(String promptText) {
            this(promptText, 0);
        }

        public PromptTextField(int columns) {
            this(null, columns);
        }

        public PromptTextField(String promptText, int columns) {
            super(columns);
            this.promptText = promptText;
            this.promptFont = this.getFont().deriveFont(3);
            this.insets = new Insets(3, 5, 3, 5);
            Toolkit tk = Toolkit.getDefaultToolkit();
            this.desktopHints = (Map)tk.getDesktopProperty("awt.font.desktophints");
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    if (evt.getKeyCode() == 27) {
                        PromptTextField.this.setText("");
                    }
                }
            });
        }

        @Override
        public Insets getInsets() {
            return this.insets;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.promptText != null && !this.isFocusOwner() && this.getText().isEmpty()) {
                Graphics2D g2d = (Graphics2D)g.create();
                if (this.desktopHints != null) {
                    g2d.addRenderingHints(this.desktopHints);
                }
                if (SubstanceLookAndFeel.isCurrentLookAndFeel()) {
                    g2d.setColor(SubstanceLookAndFeel.getCurrentSkin().getColorScheme((Component)this, ComponentState.ENABLED).getForegroundColor());
                } else {
                    g2d.setColor(this.getDisabledTextColor());
                }
                g2d.setFont(this.promptFont);
                g2d.drawString(this.promptText, this.insets.left, this.getHeight() - (this.insets.top + this.insets.bottom));
                g2d.dispose();
            }
        }
    }
}

