/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.IzPanel;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PathSelectionPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 3618700794577105718L;
    private JTextField textField;
    private JButton browseButton;
    private IzPanel parent;
    private InstallData idata;

    public PathSelectionPanel(IzPanel parent, InstallData idata) {
        this.parent = parent;
        this.idata = idata;
        this.createLayout();
    }

    protected void createLayout() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.textField = new JTextField(this.idata.getInstallPath(), 40);
        this.textField.addActionListener(this);
        this.parent.setInitialFocus(this.textField);
        GridBagConstraints gbConstraints = new GridBagConstraints();
        this.parent.getInstallerFrame().buildConstraints(gbConstraints, 0, 1, -1, 1, 1.0, 0.0);
        gbConstraints.fill = 2;
        gbConstraints.anchor = 17;
        gbConstraints.insets = new Insets(0, 0, 0, 10);
        layout.addLayoutComponent(this.textField, gbConstraints);
        this.add(this.textField);
        this.browseButton = ButtonFactory.createButton(this.parent.getInstallerFrame().langpack.getString("TargetPanel.browse"), this.parent.getInstallerFrame().icons.getImageIcon("open"), this.idata.buttonsHColor);
        this.browseButton.addActionListener(this);
        this.parent.getInstallerFrame().buildConstraints(gbConstraints, 1, 1, 0, 1, 0.0, 0.0);
        gbConstraints.fill = 2;
        gbConstraints.anchor = 13;
        gbConstraints.insets = new Insets(0, 0, 0, 5);
        layout.addLayoutComponent(this.browseButton, gbConstraints);
        this.add(this.browseButton);
    }

    public Dimension getMinimumSize() {
        Dimension ss = super.getPreferredSize();
        Dimension retval = this.parent.getSize();
        retval.height = ss.height;
        return retval;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.browseButton) {
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(new File(this.textField.getText()));
            fc.setMultiSelectionEnabled(false);
            fc.setFileSelectionMode(1);
            fc.addChoosableFileFilter(fc.getAcceptAllFileFilter());
            if (fc.showOpenDialog(this) == 0) {
                String path = fc.getSelectedFile().getAbsolutePath();
                this.textField.setText(path);
            }
        } else if (this.parent instanceof ActionListener) {
            ((ActionListener)((Object)this.parent)).actionPerformed(e);
        }
    }

    public String getPath() {
        return this.textField.getText();
    }

    public void setPath(String path) {
        this.textField.setText(path);
    }

    public JTextField getPathInputField() {
        return this.textField;
    }
}

