/*
 * Decompiled with CFR 0.152.
 */
package davaguine.jmac.prediction;

import davaguine.jmac.prediction.IPredictorDecompress;
import davaguine.jmac.prediction.NNFilter;
import davaguine.jmac.prediction.NNFilter1280;
import davaguine.jmac.prediction.NNFilter16;
import davaguine.jmac.prediction.NNFilter256;
import davaguine.jmac.prediction.NNFilter32;
import davaguine.jmac.prediction.NNFilter64;
import davaguine.jmac.tools.JMACException;
import davaguine.jmac.tools.RollBufferFastInt;
import java.util.Arrays;

public class PredictorDecompress3950toCurrent
extends IPredictorDecompress {
    public static final int M_COUNT = 8;
    private static final int WINDOW_BLOCKS = 512;
    protected int[] m_aryMA = new int[8];
    protected int[] m_aryMB = new int[8];
    protected RollBufferFastInt m_rbPredictionA = new RollBufferFastInt(512, 8);
    protected RollBufferFastInt m_rbPredictionB = new RollBufferFastInt(512, 8);
    protected RollBufferFastInt m_rbAdaptA = new RollBufferFastInt(512, 8);
    protected RollBufferFastInt m_rbAdaptB = new RollBufferFastInt(512, 8);
    protected int scaledFilterALV;
    protected int scaledFilterBLV;
    protected int m_nCurrentIndex;
    protected int m_nLastValueA;
    protected int m_nVersion;
    protected NNFilter m_pNNFilter;
    protected NNFilter m_pNNFilter1;
    protected NNFilter m_pNNFilter2;

    public PredictorDecompress3950toCurrent(int nCompressionLevel, int nVersion) {
        super(nCompressionLevel, nVersion);
        this.m_nVersion = nVersion;
        if (nCompressionLevel == 1000) {
            this.m_pNNFilter = null;
            this.m_pNNFilter1 = null;
            this.m_pNNFilter2 = null;
        } else if (nCompressionLevel == 2000) {
            this.m_pNNFilter = new NNFilter16(11, nVersion);
            this.m_pNNFilter1 = null;
            this.m_pNNFilter2 = null;
        } else if (nCompressionLevel == 3000) {
            this.m_pNNFilter = new NNFilter64(11, nVersion);
            this.m_pNNFilter1 = null;
            this.m_pNNFilter2 = null;
        } else if (nCompressionLevel == 4000) {
            this.m_pNNFilter = new NNFilter256(13, nVersion);
            this.m_pNNFilter1 = new NNFilter32(10, nVersion);
            this.m_pNNFilter2 = null;
        } else if (nCompressionLevel == 5000) {
            this.m_pNNFilter = new NNFilter1280(15, nVersion);
            this.m_pNNFilter1 = new NNFilter256(13, nVersion);
            this.m_pNNFilter2 = new NNFilter16(11, nVersion);
        } else {
            throw new JMACException("Unknown Compression Type");
        }
    }

    public int DecompressValue(int nA) {
        return this.DecompressValue(nA, 0);
    }

    public int DecompressValue(int nA, int nB) {
        int l;
        Object obj;
        if (this.m_nCurrentIndex == 512) {
            this.m_rbPredictionA.Roll();
            this.m_rbPredictionB.Roll();
            this.m_rbAdaptA.Roll();
            this.m_rbAdaptB.Roll();
            this.m_nCurrentIndex = 0;
        }
        if ((obj = this.m_pNNFilter2) != null) {
            nA = ((NNFilter)obj).Decompress(nA);
        }
        if ((obj = this.m_pNNFilter1) != null) {
            nA = ((NNFilter)obj).Decompress(nA);
        }
        if ((obj = this.m_pNNFilter) != null) {
            nA = ((NNFilter)obj).Decompress(nA);
        }
        obj = this.m_rbPredictionA;
        int indexA = ((RollBufferFastInt)obj).index;
        RollBufferFastInt predictB = this.m_rbPredictionB;
        int indexB = predictB.index;
        int[] ai = ((RollBufferFastInt)obj).m_pData;
        ((RollBufferFastInt)obj).m_pData[indexA] = l = this.m_nLastValueA;
        int l1 = indexA - 1;
        ai[l1] = l - ai[l1];
        int[] ai3 = predictB.m_pData;
        ai3[indexB] = nB - (this.scaledFilterBLV * 31 >> 5);
        this.scaledFilterBLV = nB;
        int k2 = indexB - 1;
        ai3[k2] = ai3[indexB] - ai3[k2];
        int[] ai2 = this.m_aryMA;
        int nPredictionA = l * this.m_aryMA[0] + ai[l1] * ai2[1] + ai[indexA - 2] * ai2[2] + ai[indexA - 3] * ai2[3];
        int[] ai4 = this.m_aryMB;
        int nPredictionB = ai3[indexB] * this.m_aryMB[0] + ai3[k2] * ai4[1] + ai3[indexB - 2] * ai4[2] + ai3[indexB - 3] * ai4[3] + ai3[indexB - 4] * ai4[4];
        int nCurrentA = nA + (nPredictionA + (nPredictionB >> 1) >> 10);
        RollBufferFastInt adaptA = this.m_rbAdaptA;
        int indexAA = adaptA.index;
        RollBufferFastInt adaptB = this.m_rbAdaptB;
        int indexAB = adaptB.index;
        int[] ai1 = this.m_rbAdaptA.m_pData;
        this.m_rbAdaptA.m_pData[indexAA] = l != 0 ? (l >> 30 & 2) - 1 : 0;
        ai1[indexAA - 1] = ai[l1] != 0 ? (ai[l1] >> 30 & 2) - 1 : 0;
        int[] ai5 = this.m_rbAdaptB.m_pData;
        this.m_rbAdaptB.m_pData[indexAB] = ai3[indexB] != 0 ? (ai3[indexB] >> 30 & 2) - 1 : 0;
        int n = ai5[indexAB - 1] = ai3[k2] != 0 ? (ai3[k2] >> 30 & 2) - 1 : 0;
        if (nA > 0) {
            ai2[0] = ai2[0] - ai1[indexAA];
            ai2[1] = ai2[1] - ai1[indexAA - 1];
            ai2[2] = ai2[2] - ai1[indexAA - 2];
            ai2[3] = ai2[3] - ai1[indexAA - 3];
            ai4[0] = ai4[0] - ai5[indexAB];
            ai4[1] = ai4[1] - ai5[indexAB - 1];
            ai4[2] = ai4[2] - ai5[indexAB - 2];
            ai4[3] = ai4[3] - ai5[indexAB - 3];
            ai4[4] = ai4[4] - ai5[indexAB - 4];
        } else if (nA < 0) {
            ai2[0] = ai2[0] + ai1[indexAA];
            ai2[1] = ai2[1] + ai1[indexAA - 1];
            ai2[2] = ai2[2] + ai1[indexAA - 2];
            ai2[3] = ai2[3] + ai1[indexAA - 3];
            ai4[0] = ai4[0] + ai5[indexAB];
            ai4[1] = ai4[1] + ai5[indexAB - 1];
            ai4[2] = ai4[2] + ai5[indexAB - 2];
            ai4[3] = ai4[3] + ai5[indexAB - 3];
            ai4[4] = ai4[4] + ai5[indexAB - 4];
        }
        this.scaledFilterALV = nCurrentA + (this.scaledFilterALV * 31 >> 5);
        this.m_nLastValueA = nCurrentA;
        ++((RollBufferFastInt)obj).index;
        ++predictB.index;
        ++adaptA.index;
        ++adaptB.index;
        ++this.m_nCurrentIndex;
        return this.scaledFilterALV;
    }

    public void Flush() {
        NNFilter nnfilter = this.m_pNNFilter;
        if (nnfilter != null) {
            nnfilter.Flush();
        }
        if ((nnfilter = this.m_pNNFilter1) != null) {
            nnfilter.Flush();
        }
        if ((nnfilter = this.m_pNNFilter2) != null) {
            nnfilter.Flush();
        }
        Arrays.fill(this.m_aryMA, 0);
        Arrays.fill(this.m_aryMB, 0);
        this.m_rbPredictionA.Flush();
        this.m_rbPredictionB.Flush();
        this.m_rbAdaptA.Flush();
        this.m_rbAdaptB.Flush();
        int[] ai = this.m_aryMA;
        this.m_aryMA[0] = 360;
        ai[1] = 317;
        ai[2] = -109;
        ai[3] = 98;
        this.scaledFilterALV = 0;
        this.scaledFilterBLV = 0;
        this.m_nLastValueA = 0;
        this.m_nCurrentIndex = 0;
    }
}

