/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp.equalizer.ui;

import java.awt.Polygon;

public abstract class ControlCurve {
    static final int EPSILON = 36;
    protected Polygon pts = new Polygon();
    protected int selection = -1;
    int maxHeight = -1;
    int minHeight = -1;

    public int boundY(int n) {
        int n2 = n;
        if (this.minHeight >= 0 && n < this.minHeight) {
            n2 = 0;
        }
        if (this.maxHeight >= 0 && n >= this.maxHeight) {
            n2 = this.maxHeight - 1;
        }
        return n2;
    }

    public void setMaxHeight(int n) {
        this.maxHeight = n;
    }

    public void setMinHeight(int n) {
        this.minHeight = n;
    }

    public int selectPoint(int n, int n2) {
        int n3 = Integer.MAX_VALUE;
        this.selection = -1;
        for (int i = 0; i < this.pts.npoints; ++i) {
            int n4 = ControlCurve.sqr(this.pts.xpoints[i] - n) + ControlCurve.sqr(this.pts.ypoints[i] - n2);
            if (n4 >= n3 || n4 >= 36) continue;
            n3 = n4;
            this.selection = i;
        }
        return this.selection;
    }

    static int sqr(int n) {
        return n * n;
    }

    public int addPoint(int n, int n2) {
        this.pts.addPoint(n, n2);
        this.selection = this.pts.npoints - 1;
        return this.selection;
    }

    public void setPoint(int n, int n2) {
        if (this.selection >= 0) {
            this.pts.xpoints[this.selection] = n;
            this.pts.ypoints[this.selection] = n2;
        }
    }

    public void removePoint() {
        if (this.selection >= 0) {
            --this.pts.npoints;
            for (int i = this.selection; i < this.pts.npoints; ++i) {
                this.pts.xpoints[i] = this.pts.xpoints[i + 1];
                this.pts.ypoints[i] = this.pts.ypoints[i + 1];
            }
        }
    }

    public abstract Polygon getPolyline();
}

