/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp.skin;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import javazoom.jlgui.player.amp.playlist.PlaylistItem;
import javazoom.jlgui.player.amp.playlist.ui.PlaylistUI;
import javazoom.jlgui.player.amp.skin.AbsoluteConstraints;

public class PlaylistUIDelegate {
    private AbsoluteConstraints constraints = null;
    private Image titleLeftImage = null;
    private Image titleRightImage = null;
    private Image titleCenterImage = null;
    private Image titleStretchImage = null;
    private Image leftImage = null;
    private Image rightImage = null;
    private Image bottomLeftImage = null;
    private Image bottomRightImage = null;
    private Image bottomStretchImage = null;
    private Color backgroundColor = null;
    private Color selectedBackgroundColor = null;
    private Color normalColor = null;
    private Color currentColor = null;
    private Font font = null;
    private int[] listarea = new int[]{12, 20, 256, 78};
    private PlaylistUI parent = null;

    public PlaylistUIDelegate() {
        this.currentColor = new Color(102, 204, 255);
        this.normalColor = new Color(178, 228, 246);
        this.selectedBackgroundColor = Color.black;
        this.backgroundColor = Color.black;
        this.font = new Font("Dialog", 0, 10);
    }

    public void setParent(PlaylistUI playlistUI) {
        this.parent = playlistUI;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getSelectedBackgroundColor() {
        return this.selectedBackgroundColor;
    }

    public Color getCurrentColor() {
        return this.currentColor;
    }

    public void setCurrentColor(Color color) {
        this.currentColor = color;
    }

    public Color getNormalColor() {
        return this.normalColor;
    }

    public void setNormalColor(Color color) {
        this.normalColor = color;
    }

    public void setSelectedBackgroundColor(Color color) {
        this.selectedBackgroundColor = color;
    }

    public Image getBottomLeftImage() {
        return this.bottomLeftImage;
    }

    public void setBottomLeftImage(Image image) {
        this.bottomLeftImage = image;
    }

    public Image getBottomRightImage() {
        return this.bottomRightImage;
    }

    public void setBottomRightImage(Image image) {
        this.bottomRightImage = image;
    }

    public Image getBottomStretchImage() {
        return this.bottomStretchImage;
    }

    public void setBottomStretchImage(Image image) {
        this.bottomStretchImage = image;
    }

    public Image getLeftImage() {
        return this.leftImage;
    }

    public void setLeftImage(Image image) {
        this.leftImage = image;
    }

    public Image getRightImage() {
        return this.rightImage;
    }

    public void setRightImage(Image image) {
        this.rightImage = image;
    }

    public Image getTitleCenterImage() {
        return this.titleCenterImage;
    }

    public void setTitleCenterImage(Image image) {
        this.titleCenterImage = image;
    }

    public Image getTitleLeftImage() {
        return this.titleLeftImage;
    }

    public void setTitleLeftImage(Image image) {
        this.titleLeftImage = image;
    }

    public Image getTitleRightImage() {
        return this.titleRightImage;
    }

    public void setTitleRightImage(Image image) {
        this.titleRightImage = image;
    }

    public Image getTitleStretchImage() {
        return this.titleStretchImage;
    }

    public void setTitleStretchImage(Image image) {
        this.titleStretchImage = image;
    }

    public void setConstraints(AbsoluteConstraints absoluteConstraints) {
        this.constraints = absoluteConstraints;
    }

    public AbsoluteConstraints getConstraints() {
        return this.constraints;
    }

    public int getLines() {
        return (this.listarea[3] - this.listarea[1]) / 12;
    }

    public boolean isInSelectArea(int n, int n2) {
        return n >= this.listarea[0] && n <= this.listarea[2] && n2 >= this.listarea[1] && n2 <= this.listarea[3];
    }

    public boolean isIndexArea(int n, int n2) {
        return n >= this.listarea[1] + 12 - 10 + n2 * 12 && n < this.listarea[1] + 12 - 10 + n2 * 12 + 14;
    }

    public void paintBackground(Graphics graphics) {
        graphics.drawImage(this.titleLeftImage, 0, 0, null);
        graphics.drawImage(this.titleStretchImage, 25, 0, null);
        graphics.drawImage(this.titleStretchImage, 50, 0, null);
        graphics.drawImage(this.titleStretchImage, 62, 0, null);
        graphics.drawImage(this.titleCenterImage, 87, 0, null);
        graphics.drawImage(this.titleStretchImage, 187, 0, null);
        graphics.drawImage(this.titleStretchImage, 200, 0, null);
        graphics.drawImage(this.titleStretchImage, 225, 0, null);
        graphics.drawImage(this.titleRightImage, 250, 0, null);
        graphics.drawImage(this.leftImage, 0, 20, null);
        graphics.drawImage(this.leftImage, 0, 48, null);
        graphics.drawImage(this.leftImage, 0, 50, null);
        graphics.drawImage(this.bottomLeftImage, 0, this.parent.getHeight() - 38, null);
        graphics.drawImage(this.bottomRightImage, 125, this.parent.getHeight() - 38, null);
    }

    public void paintList(Graphics graphics) {
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(this.listarea[0], this.listarea[1], this.listarea[2] - this.listarea[0], this.listarea[3] - this.listarea[1]);
        if (this.font != null) {
            graphics.setFont(this.font);
        }
        if (this.parent.getPlaylist() != null) {
            int n = this.parent.getPlaylist().getSelectedIndex();
            graphics.setColor(this.normalColor);
            int n2 = this.parent.getPlaylist().getPlaylistSize();
            for (int i = 0; i < n2; ++i) {
                if (i < this.parent.getTopIndex()) continue;
                int n3 = i - this.parent.getTopIndex();
                if (this.listarea[1] + 12 + n3 * 12 > this.listarea[3]) break;
                PlaylistItem playlistItem = this.parent.getPlaylist().getItemAt(i);
                String string = playlistItem.getFormattedName();
                if (playlistItem.isSelected()) {
                    graphics.setColor(this.selectedBackgroundColor);
                    graphics.fillRect(this.listarea[0] + 4, this.listarea[1] + 12 - 10 + n3 * 12, this.listarea[2] - this.listarea[0] - 4, 14);
                }
                if (i == n) {
                    graphics.setColor(this.currentColor);
                } else {
                    graphics.setColor(this.normalColor);
                }
                if (i + 1 >= 10) {
                    graphics.drawString(i + 1 + ".  " + string, this.listarea[0] + 12, this.listarea[1] + 12 + n3 * 12);
                } else {
                    graphics.drawString("0" + (i + 1) + ".  " + string, this.listarea[0] + 12, this.listarea[1] + 12 + n3 * 12);
                }
                if (i != n) continue;
                graphics.setColor(this.normalColor);
            }
        }
    }
}

