/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp.tag;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.jlgui.player.amp.tag.APEInfo;
import javazoom.jlgui.player.amp.tag.FlacInfo;
import javazoom.jlgui.player.amp.tag.MpegInfo;
import javazoom.jlgui.player.amp.tag.OggVorbisInfo;
import javazoom.jlgui.player.amp.tag.TagInfo;
import javazoom.jlgui.player.amp.tag.ui.APEDialog;
import javazoom.jlgui.player.amp.tag.ui.EmptyDialog;
import javazoom.jlgui.player.amp.tag.ui.FlacDialog;
import javazoom.jlgui.player.amp.tag.ui.MpegDialog;
import javazoom.jlgui.player.amp.tag.ui.OggVorbisDialog;
import javazoom.jlgui.player.amp.tag.ui.TagInfoDialog;
import javazoom.jlgui.player.amp.util.Config;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TagInfoFactory {
    private static Log log = LogFactory.getLog((Class)TagInfoFactory.class);
    private static TagInfoFactory instance = null;
    private Class MpegTagInfoClass = null;
    private Class VorbisTagInfoClass = null;
    private Class APETagInfoClass = null;
    private Class FlacTagInfoClass = null;
    private Config conf = Config.getInstance();

    private TagInfoFactory() {
        String string = this.conf.getMpegTagInfoClassName();
        this.MpegTagInfoClass = this.getTagInfoImpl(string);
        if (this.MpegTagInfoClass == null) {
            log.error((Object)("Error : TagInfo implementation not found in " + string + " hierarchy"));
            this.MpegTagInfoClass = this.getTagInfoImpl("javazoom.jlgui.player.amp.tag.MpegInfo");
        }
        string = this.conf.getOggVorbisTagInfoClassName();
        this.VorbisTagInfoClass = this.getTagInfoImpl(string);
        if (this.VorbisTagInfoClass == null) {
            log.error((Object)("Error : TagInfo implementation not found in " + string + " hierarchy"));
            this.VorbisTagInfoClass = this.getTagInfoImpl("javazoom.jlgui.player.amp.tag.OggVorbisInfo");
        }
        string = this.conf.getAPETagInfoClassName();
        this.APETagInfoClass = this.getTagInfoImpl(string);
        if (this.APETagInfoClass == null) {
            log.error((Object)("Error : TagInfo implementation not found in " + string + " hierarchy"));
            this.APETagInfoClass = this.getTagInfoImpl("javazoom.jlgui.player.amp.tag.APEInfo");
        }
        string = this.conf.getFlacTagInfoClassName();
        this.FlacTagInfoClass = this.getTagInfoImpl(string);
        if (this.FlacTagInfoClass == null) {
            log.error((Object)("Error : TagInfo implementation not found in " + string + " hierarchy"));
            this.FlacTagInfoClass = this.getTagInfoImpl("javazoom.jlgui.player.amp.tag.FlacInfo");
        }
    }

    public static synchronized TagInfoFactory getInstance() {
        if (instance == null) {
            instance = new TagInfoFactory();
        }
        return instance;
    }

    public TagInfo getTagInfo(URL uRL) {
        TagInfo tagInfo;
        try {
            tagInfo = this.getTagInfoImplInstance(this.MpegTagInfoClass);
            tagInfo.load(uRL);
        }
        catch (IOException iOException) {
            log.debug((Object)iOException);
            tagInfo = null;
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            tagInfo = null;
        }
        if (tagInfo == null) {
            try {
                tagInfo = this.getTagInfoImplInstance(this.VorbisTagInfoClass);
                tagInfo.load(uRL);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                tagInfo = null;
            }
            catch (IOException iOException) {
                log.debug((Object)iOException);
                tagInfo = null;
            }
        }
        if (tagInfo == null) {
            try {
                tagInfo = this.getTagInfoImplInstance(this.APETagInfoClass);
                tagInfo.load(uRL);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                tagInfo = null;
            }
            catch (IOException iOException) {
                log.debug((Object)iOException);
                tagInfo = null;
            }
        }
        if (tagInfo == null) {
            try {
                tagInfo = this.getTagInfoImplInstance(this.FlacTagInfoClass);
                tagInfo.load(uRL);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                tagInfo = null;
            }
            catch (IOException iOException) {
                log.debug((Object)iOException);
                tagInfo = null;
            }
        }
        return tagInfo;
    }

    public TagInfo getTagInfo(String string) {
        if (Config.startWithProtocol(string)) {
            try {
                return this.getTagInfo(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return this.getTagInfo(new File(string));
    }

    public TagInfo getTagInfo(File file) {
        TagInfo tagInfo;
        try {
            tagInfo = this.getTagInfoImplInstance(this.MpegTagInfoClass);
            tagInfo.load(file);
        }
        catch (IOException iOException) {
            log.debug((Object)iOException);
            tagInfo = null;
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            tagInfo = null;
        }
        if (tagInfo == null) {
            try {
                tagInfo = this.getTagInfoImplInstance(this.VorbisTagInfoClass);
                tagInfo.load(file);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                tagInfo = null;
            }
            catch (IOException iOException) {
                log.debug((Object)iOException);
                tagInfo = null;
            }
        }
        if (tagInfo == null) {
            try {
                tagInfo = this.getTagInfoImplInstance(this.APETagInfoClass);
                tagInfo.load(file);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                tagInfo = null;
            }
            catch (IOException iOException) {
                log.debug((Object)iOException);
                tagInfo = null;
            }
        }
        if (tagInfo == null) {
            try {
                tagInfo = this.getTagInfoImplInstance(this.FlacTagInfoClass);
                tagInfo.load(file);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                tagInfo = null;
            }
            catch (IOException iOException) {
                log.debug((Object)iOException);
                tagInfo = null;
            }
        }
        return tagInfo;
    }

    public TagInfoDialog getTagInfoDialog(TagInfo tagInfo) {
        TagInfoDialog tagInfoDialog = tagInfo != null ? (tagInfo instanceof OggVorbisInfo ? new OggVorbisDialog(this.conf.getTopParent(), "OggVorbis info", (OggVorbisInfo)tagInfo) : (tagInfo instanceof MpegInfo ? new MpegDialog(this.conf.getTopParent(), "Mpeg info", (MpegInfo)tagInfo) : (tagInfo instanceof APEInfo ? new APEDialog(this.conf.getTopParent(), "Ape info", (APEInfo)tagInfo) : (tagInfo instanceof FlacInfo ? new FlacDialog(this.conf.getTopParent(), "Flac info", (FlacInfo)tagInfo) : new EmptyDialog(this.conf.getTopParent(), "No info", tagInfo))))) : new EmptyDialog(this.conf.getTopParent(), "No info", null);
        return tagInfoDialog;
    }

    public Class getTagInfoImpl(String string) {
        Class<?> clazz = null;
        boolean bl = false;
        if (string != null) {
            try {
                for (Class<?> clazz2 = clazz = Class.forName(string); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                    Class<?>[] classArray = clazz2.getInterfaces();
                    for (int i = 0; i < classArray.length; ++i) {
                        if (!classArray[i].getName().equals("javazoom.jlgui.player.amp.tag.TagInfo")) continue;
                        bl = true;
                        break;
                    }
                    if (bl) break;
                }
                if (bl) {
                    log.info((Object)(string + " loaded"));
                } else {
                    log.info((Object)(string + " not loaded"));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.error((Object)("Error : " + string + " : " + classNotFoundException.getMessage()));
            }
        }
        return clazz;
    }

    public TagInfo getTagInfoImplInstance(Class clazz) {
        TagInfo tagInfo = null;
        if (clazz != null) {
            try {
                Class[] classArray = new Class[]{};
                Constructor constructor = clazz.getConstructor(classArray);
                tagInfo = (TagInfo)constructor.newInstance(null);
            }
            catch (Exception exception) {
                log.error((Object)("Cannot Instanciate : " + clazz.getName() + " : " + exception.getMessage()));
            }
        }
        return tagInfo;
    }
}

