/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp.tag.ui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javazoom.jlgui.player.amp.tag.MpegInfo;
import javazoom.jlgui.player.amp.tag.ui.TagInfoDialog;

public class MpegDialog
extends TagInfoDialog {
    private MpegInfo _mpeginfo = null;
    private JLabel bitrateLabel;
    private JPanel buttonsPanel;
    private JLabel copyrightLabel;
    private JLabel crcLabel;
    private JLabel emphasisLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JLabel lengthLabel;
    private JLabel locationLabel;
    private JLabel originalLabel;
    private JLabel samplerateLabel;
    private JLabel sizeLabel;
    private JTextArea textField;
    private JLabel vbrLabel;
    private JLabel versionLabel;

    public MpegDialog(JFrame jFrame, String string, MpegInfo mpegInfo) {
        super(jFrame, string);
        int n;
        Vector vector;
        this.initComponents();
        this._mpeginfo = mpegInfo;
        int n2 = this._mpeginfo.getLocation().length();
        this.locationLabel.setText(n2 > 50 ? "..." + this._mpeginfo.getLocation().substring(n2 - 50) : this._mpeginfo.getLocation());
        if (this._mpeginfo.getTitle() != null && !this._mpeginfo.getTitle().equals("")) {
            this.textField.append("Title=" + this._mpeginfo.getTitle() + "\n");
        }
        if (this._mpeginfo.getArtist() != null && !this._mpeginfo.getArtist().equals("")) {
            this.textField.append("Artist=" + this._mpeginfo.getArtist() + "\n");
        }
        if (this._mpeginfo.getAlbum() != null && !this._mpeginfo.getAlbum().equals("")) {
            this.textField.append("Album=" + this._mpeginfo.getAlbum() + "\n");
        }
        if (this._mpeginfo.getTrack() > 0) {
            this.textField.append("Track=" + this._mpeginfo.getTrack() + "\n");
        }
        if (this._mpeginfo.getYear() != null && !this._mpeginfo.getYear().equals("")) {
            this.textField.append("Year=" + this._mpeginfo.getYear() + "\n");
        }
        if (this._mpeginfo.getGenre() != null && !this._mpeginfo.getGenre().equals("")) {
            this.textField.append("Genre=" + this._mpeginfo.getGenre() + "\n");
        }
        if ((vector = this._mpeginfo.getComment()) != null) {
            for (n = 0; n < vector.size(); ++n) {
                this.textField.append(vector.get(n) + "\n");
            }
        }
        if ((n = Math.round(this._mpeginfo.getPlayTime())) < 0) {
            n = 0;
        }
        int n3 = n / 60;
        int n4 = n - n3 * 60;
        this.lengthLabel.setText("Length : " + n3 + ":" + n4);
        DecimalFormat decimalFormat = new DecimalFormat("#,###,###");
        this.sizeLabel.setText("Size : " + decimalFormat.format(this._mpeginfo.getSize()) + " bytes");
        this.versionLabel.setText(this._mpeginfo.getVersion() + " " + this._mpeginfo.getLayer());
        this.bitrateLabel.setText(this._mpeginfo.getBitRate() / 1000 + " kbps");
        this.samplerateLabel.setText(this._mpeginfo.getSamplingRate() + " Hz " + this._mpeginfo.getChannelsMode());
        this.vbrLabel.setText("VBR : " + this._mpeginfo.getVBR());
        this.crcLabel.setText("CRCs : " + this._mpeginfo.getCRC());
        this.copyrightLabel.setText("Copyrighted : " + this._mpeginfo.getCopyright());
        this.originalLabel.setText("Original : " + this._mpeginfo.getOriginal());
        this.emphasisLabel.setText("Emphasis : " + this._mpeginfo.getEmphasis());
        this.buttonsPanel.add(this._close);
        this.pack();
    }

    public MpegInfo getOggVorbisInfo() {
        return this._mpeginfo;
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.locationLabel = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.textField = new JTextArea();
        this.jPanel2 = new JPanel();
        this.lengthLabel = new JLabel();
        this.sizeLabel = new JLabel();
        this.versionLabel = new JLabel();
        this.bitrateLabel = new JLabel();
        this.samplerateLabel = new JLabel();
        this.vbrLabel = new JLabel();
        this.crcLabel = new JLabel();
        this.copyrightLabel = new JLabel();
        this.originalLabel = new JLabel();
        this.emphasisLabel = new JLabel();
        this.buttonsPanel = new JPanel();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new FlowLayout(0));
        this.jLabel1.setText("File/URL :");
        this.jPanel1.add(this.jLabel1);
        this.jPanel1.add(this.locationLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel2.setText("Standard Tags");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("File/Stream info");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.jLabel3, gridBagConstraints);
        this.textField.setColumns(20);
        this.textField.setRows(10);
        this.jScrollPane1.setViewportView(this.textField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        this.jPanel2.add(this.lengthLabel);
        this.jPanel2.add(this.sizeLabel);
        this.jPanel2.add(this.versionLabel);
        this.jPanel2.add(this.bitrateLabel);
        this.jPanel2.add(this.samplerateLabel);
        this.jPanel2.add(this.vbrLabel);
        this.jPanel2.add(this.crcLabel);
        this.jPanel2.add(this.copyrightLabel);
        this.jPanel2.add(this.originalLabel);
        this.jPanel2.add(this.emphasisLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.jPanel2, gridBagConstraints);
        this.getContentPane().add(this.jPanel3);
        this.getContentPane().add(this.buttonsPanel);
    }
}

