/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.audio;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import net.sourceforge.dvb.projectx.audio.AudioFormat;
import net.sourceforge.dvb.projectx.audio.MpaConverter;
import net.sourceforge.dvb.projectx.audio.MpaDecoder;
import net.sourceforge.dvb.projectx.common.Common;

public class AudioFormatMPA
extends AudioFormat {
    private String instanced_time = "";
    private MpaConverter MPAConverter;
    private int CRC16_POLY = 98309;
    private int[] crc_table = new int[256];
    private int[][][] bitrate_index;
    private int[][] frequency_index;
    private double[] time_index;
    private String[] dID;
    private String[] dLayer;
    private String[] dCRC;
    private String[] dMode;
    private int Bound;
    private int Sblimit;
    private final int[] rpadding;
    private final int[] rlayer;
    private final int[][] rsample;
    private final int[] rmode;
    private final int[] rchnl;
    private final int[] rmext;
    private final int[] remph;
    private final int[][][] rbitrate;
    ArrayList _list;
    ByteArrayOutputStream bo;
    private boolean DecodeRDS;
    private boolean Debug;
    private boolean hasRawData;
    private final byte RDS_identifier = -3;
    private final int RDS_startcode = 254;
    private final int RDS_endcode = 255;
    private String[] rds_values;
    private final String[] pty_list;
    private final short[] chars;
    private WaveHeader WaveHeader_Ch1;
    private WaveHeader WaveHeader_Ch2;

    public AudioFormatMPA() {
        int[][][] nArrayArray = new int[3][][];
        int[][] nArrayArray2 = new int[3][];
        int[] nArray = new int[16];
        nArray[0] = -1;
        nArray[1] = 8000;
        nArray[2] = 16000;
        nArray[3] = 24000;
        nArray[4] = 32000;
        nArray[5] = 40000;
        nArray[6] = 48000;
        nArray[7] = 56000;
        nArray[8] = 64000;
        nArray[9] = 80000;
        nArray[10] = 96000;
        nArray[11] = 112000;
        nArray[12] = 128000;
        nArray[13] = 144000;
        nArray[14] = 160000;
        nArrayArray2[0] = nArray;
        int[] nArray2 = new int[16];
        nArray2[0] = -1;
        nArray2[1] = 8000;
        nArray2[2] = 16000;
        nArray2[3] = 24000;
        nArray2[4] = 32000;
        nArray2[5] = 40000;
        nArray2[6] = 48000;
        nArray2[7] = 56000;
        nArray2[8] = 64000;
        nArray2[9] = 80000;
        nArray2[10] = 96000;
        nArray2[11] = 112000;
        nArray2[12] = 128000;
        nArray2[13] = 144000;
        nArray2[14] = 160000;
        nArrayArray2[1] = nArray2;
        int[] nArray3 = new int[16];
        nArray3[0] = -1;
        nArray3[1] = 32000;
        nArray3[2] = 48000;
        nArray3[3] = 56000;
        nArray3[4] = 64000;
        nArray3[5] = 80000;
        nArray3[6] = 96000;
        nArray3[7] = 112000;
        nArray3[8] = 128000;
        nArray3[9] = 144000;
        nArray3[10] = 160000;
        nArray3[11] = 176000;
        nArray3[12] = 192000;
        nArray3[13] = 224000;
        nArray3[14] = 256000;
        nArrayArray2[2] = nArray3;
        nArrayArray[0] = nArrayArray2;
        int[][] nArrayArray3 = new int[3][];
        int[] nArray4 = new int[16];
        nArray4[0] = -1;
        nArray4[1] = 32000;
        nArray4[2] = 40000;
        nArray4[3] = 48000;
        nArray4[4] = 56000;
        nArray4[5] = 64000;
        nArray4[6] = 80000;
        nArray4[7] = 96000;
        nArray4[8] = 112000;
        nArray4[9] = 128000;
        nArray4[10] = 160000;
        nArray4[11] = 192000;
        nArray4[12] = 224000;
        nArray4[13] = 256000;
        nArray4[14] = 320000;
        nArrayArray3[0] = nArray4;
        int[] nArray5 = new int[16];
        nArray5[0] = -1;
        nArray5[1] = 32000;
        nArray5[2] = 48000;
        nArray5[3] = 56000;
        nArray5[4] = 64000;
        nArray5[5] = 80000;
        nArray5[6] = 96000;
        nArray5[7] = 112000;
        nArray5[8] = 128000;
        nArray5[9] = 160000;
        nArray5[10] = 192000;
        nArray5[11] = 224000;
        nArray5[12] = 256000;
        nArray5[13] = 320000;
        nArray5[14] = 384000;
        nArrayArray3[1] = nArray5;
        int[] nArray6 = new int[16];
        nArray6[0] = -1;
        nArray6[1] = 32000;
        nArray6[2] = 64000;
        nArray6[3] = 96000;
        nArray6[4] = 128000;
        nArray6[5] = 160000;
        nArray6[6] = 192000;
        nArray6[7] = 224000;
        nArray6[8] = 256000;
        nArray6[9] = 288000;
        nArray6[10] = 320000;
        nArray6[11] = 352000;
        nArray6[12] = 384000;
        nArray6[13] = 416000;
        nArray6[14] = 448000;
        nArrayArray3[2] = nArray6;
        nArrayArray[1] = nArrayArray3;
        int[][] nArrayArray4 = new int[3][];
        int[] nArray7 = new int[16];
        nArray7[0] = -1;
        nArray7[1] = 6000;
        nArray7[2] = 8000;
        nArray7[3] = 10000;
        nArray7[4] = 12000;
        nArray7[5] = 16000;
        nArray7[6] = 20000;
        nArray7[7] = 24000;
        nArray7[8] = 28000;
        nArray7[9] = 320000;
        nArray7[10] = 40000;
        nArray7[11] = 48000;
        nArray7[12] = 56000;
        nArray7[13] = 64000;
        nArray7[14] = 80000;
        nArrayArray4[0] = nArray7;
        int[] nArray8 = new int[16];
        nArray8[0] = -1;
        nArray8[1] = 6000;
        nArray8[2] = 8000;
        nArray8[3] = 10000;
        nArray8[4] = 12000;
        nArray8[5] = 16000;
        nArray8[6] = 20000;
        nArray8[7] = 24000;
        nArray8[8] = 28000;
        nArray8[9] = 320000;
        nArray8[10] = 40000;
        nArray8[11] = 48000;
        nArray8[12] = 56000;
        nArray8[13] = 64000;
        nArray8[14] = 80000;
        nArrayArray4[1] = nArray8;
        int[] nArray9 = new int[16];
        nArray9[0] = -1;
        nArray9[1] = 8000;
        nArray9[2] = 12000;
        nArray9[3] = 16000;
        nArray9[4] = 20000;
        nArray9[5] = 24000;
        nArray9[6] = 32000;
        nArray9[7] = 40000;
        nArray9[8] = 48000;
        nArray9[9] = 560000;
        nArray9[10] = 64000;
        nArray9[11] = 80000;
        nArray9[12] = 96000;
        nArray9[13] = 112000;
        nArray9[14] = 128000;
        nArrayArray4[2] = nArray9;
        nArrayArray[2] = nArrayArray4;
        this.bitrate_index = nArrayArray;
        int[][] nArrayArray5 = new int[3][];
        int[] nArray10 = new int[4];
        nArray10[0] = 22050;
        nArray10[1] = 24000;
        nArray10[2] = 16000;
        nArrayArray5[0] = nArray10;
        int[] nArray11 = new int[4];
        nArray11[0] = 44100;
        nArray11[1] = 48000;
        nArray11[2] = 32000;
        nArrayArray5[1] = nArray11;
        int[] nArray12 = new int[4];
        nArray12[0] = 11025;
        nArray12[1] = 12000;
        nArray12[2] = 8000;
        nArrayArray5[2] = nArray12;
        this.frequency_index = nArrayArray5;
        double[] dArray = new double[4];
        dArray[1] = 1.0368E8;
        dArray[2] = 1.0368E8;
        dArray[3] = 3.456E7;
        this.time_index = dArray;
        this.dID = new String[]{"MPEG-2", "MPEG-1", "MPEG-2.5"};
        this.dLayer = new String[]{"n.a.", "Layer3", "Layer2", "Layer1"};
        this.dCRC = new String[]{"noCRC", "CRC"};
        this.dMode = new String[]{"stereo", "jstereo", "dual", "mono"};
        this.Bound = 0;
        this.Sblimit = 32;
        int[] nArray13 = new int[4];
        nArray13[1] = 1;
        nArray13[2] = 1;
        nArray13[3] = 4;
        this.rpadding = nArray13;
        int[] nArray14 = new int[4];
        nArray14[1] = 4;
        nArray14[2] = 2;
        nArray14[3] = 1;
        this.rlayer = nArray14;
        int[][] nArrayArray6 = new int[2][];
        int[] nArray15 = new int[4];
        nArray15[0] = 22050;
        nArray15[1] = 24000;
        nArray15[2] = 16000;
        nArrayArray6[0] = nArray15;
        int[] nArray16 = new int[4];
        nArray16[0] = 44100;
        nArray16[1] = 48000;
        nArray16[2] = 32000;
        nArrayArray6[1] = nArray16;
        this.rsample = nArrayArray6;
        this.rmode = new int[]{1, 2, 4, 8};
        this.rchnl = new int[]{2, 2, 2, 1};
        this.rmext = new int[]{1, 2, 4, 8};
        this.remph = new int[]{1, 2, 3, 4};
        int[][][] nArrayArray7 = new int[2][][];
        int[][] nArrayArray8 = new int[4][];
        nArrayArray8[0] = new int[16];
        int[] nArray17 = new int[16];
        nArray17[1] = 8000;
        nArray17[2] = 16000;
        nArray17[3] = 24000;
        nArray17[4] = 32000;
        nArray17[5] = 40000;
        nArray17[6] = 48000;
        nArray17[7] = 56000;
        nArray17[8] = 64000;
        nArray17[9] = 80000;
        nArray17[10] = 96000;
        nArray17[11] = 112000;
        nArray17[12] = 128000;
        nArray17[13] = 144000;
        nArray17[14] = 160000;
        nArrayArray8[1] = nArray17;
        int[] nArray18 = new int[16];
        nArray18[1] = 8000;
        nArray18[2] = 16000;
        nArray18[3] = 24000;
        nArray18[4] = 32000;
        nArray18[5] = 40000;
        nArray18[6] = 48000;
        nArray18[7] = 56000;
        nArray18[8] = 64000;
        nArray18[9] = 80000;
        nArray18[10] = 96000;
        nArray18[11] = 112000;
        nArray18[12] = 128000;
        nArray18[13] = 144000;
        nArray18[14] = 160000;
        nArrayArray8[2] = nArray18;
        int[] nArray19 = new int[16];
        nArray19[1] = 32000;
        nArray19[2] = 48000;
        nArray19[3] = 56000;
        nArray19[4] = 64000;
        nArray19[5] = 80000;
        nArray19[6] = 96000;
        nArray19[7] = 112000;
        nArray19[8] = 128000;
        nArray19[9] = 144000;
        nArray19[10] = 160000;
        nArray19[11] = 176000;
        nArray19[12] = 192000;
        nArray19[13] = 224000;
        nArray19[14] = 256000;
        nArrayArray8[3] = nArray19;
        nArrayArray7[0] = nArrayArray8;
        int[][] nArrayArray9 = new int[4][];
        nArrayArray9[0] = new int[16];
        int[] nArray20 = new int[16];
        nArray20[1] = 32000;
        nArray20[2] = 40000;
        nArray20[3] = 48000;
        nArray20[4] = 56000;
        nArray20[5] = 64000;
        nArray20[6] = 80000;
        nArray20[7] = 96000;
        nArray20[8] = 112000;
        nArray20[9] = 128000;
        nArray20[10] = 160000;
        nArray20[11] = 192000;
        nArray20[12] = 224000;
        nArray20[13] = 256000;
        nArray20[14] = 320000;
        nArrayArray9[1] = nArray20;
        int[] nArray21 = new int[16];
        nArray21[1] = 32000;
        nArray21[2] = 48000;
        nArray21[3] = 56000;
        nArray21[4] = 64000;
        nArray21[5] = 80000;
        nArray21[6] = 96000;
        nArray21[7] = 112000;
        nArray21[8] = 128000;
        nArray21[9] = 160000;
        nArray21[10] = 192000;
        nArray21[11] = 224000;
        nArray21[12] = 256000;
        nArray21[13] = 320000;
        nArray21[14] = 384000;
        nArrayArray9[2] = nArray21;
        int[] nArray22 = new int[16];
        nArray22[1] = 32000;
        nArray22[2] = 64000;
        nArray22[3] = 96000;
        nArray22[4] = 128000;
        nArray22[5] = 160000;
        nArray22[6] = 192000;
        nArray22[7] = 224000;
        nArray22[8] = 256000;
        nArray22[9] = 288000;
        nArray22[10] = 320000;
        nArray22[11] = 352000;
        nArray22[12] = 384000;
        nArray22[13] = 416000;
        nArray22[14] = 448000;
        nArrayArray9[3] = nArray22;
        nArrayArray7[1] = nArrayArray9;
        this.rbitrate = nArrayArray7;
        this._list = new ArrayList();
        this.bo = new ByteArrayOutputStream();
        this.DecodeRDS = false;
        this.Debug = false;
        this.hasRawData = false;
        this.RDS_identifier = (byte)-3;
        this.RDS_startcode = 254;
        this.RDS_endcode = 255;
        this.rds_values = new String[9];
        this.pty_list = new String[]{"undefined", "News", "Current Affairs", "Information", "Sport", "Education", "Drama", "Culture", "Science", "Varied", "Pop Music", "Rock Music", "Easy Listening", "Light Classical", "Seriuos Classical", "Other Music", "Weather", "Finance", "Children", "Social Affairs", "Religion", "Phone In", "Travel", "Leisure", "Jazz Music", "Country Music", "National Music", "Oldies Music", "Folk Music", "Documentary", "Alarm Test", "Alarm"};
        this.chars = new short[]{32, 33, 34, 35, 164, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 32, 225, 224, 233, 232, 237, 236, 243, 242, 250, 249, 209, 199, 350, 223, 304, 306, 226, 228, 234, 235, 238, 239, 244, 246, 251, 252, 241, 231, 351, 287, 305, 307};
        this.instanced_time = String.valueOf(System.currentTimeMillis());
        this.initCRCTable();
    }

    public int compareHeader() {
        if (this.getLastID() != this.getID()) {
            return 1;
        }
        if (this.getLastLayer() != this.getLayer()) {
            return 2;
        }
        if (this.getLastSamplingFrequency() != this.getSamplingFrequency()) {
            return 4;
        }
        if (this.getLastBitrate() != this.getBitrate()) {
            return 8;
        }
        if (this.getLastProtectionBit() != this.getProtectionBit()) {
            return 16;
        }
        if (this.getLastMode() != this.getMode()) {
            if (this.getMode() + this.getLastMode() < 2) {
                return 32;
            }
            return 64;
        }
        return 0;
    }

    private String compareMsg(String string, int n, double d) {
        if (string == null || string.equals(this.rds_values[n])) {
            return null;
        }
        this.rds_values[n] = string;
        return "-> RDS @ " + Common.formatTime_1((long)(d / 90.0)) + ": " + string;
    }

    public byte[][] convertFrame(byte[] byArray, int n) {
        if (this.MPAConverter == null) {
            this.MPAConverter = new MpaConverter();
        }
        byte[][] byArray2 = this.MPAConverter.modifyframe(byArray, n);
        this.parseRiffData(byArray2[0], 1);
        if (n >= 4) {
            this.parseRiffData(byArray2[1], 2);
        }
        return byArray2;
    }

    public String decodeAncillaryData(byte[] byArray, double d) {
        if (!this.DecodeRDS) {
            return null;
        }
        int n = this.getSize() - 1;
        if (byArray[n] != -3) {
            return null;
        }
        int n2 = 0xFF & byArray[n - 1];
        int n3 = n - 2;
        while (n3 > 3 && n3 > n - 2 - n2) {
            int n4 = 0xFF & byArray[n3];
            this._list.add(String.valueOf(n4));
            --n3;
        }
        return this.decodeChunk(this._list, d);
    }

    /*
     * Unable to fully structure code
     */
    private String decodeChunk(ArrayList var1_1, double var2_2) {
        var4_3 = var1_1.indexOf(String.valueOf(254));
        if (var4_3 >= 0) ** GOTO lbl8
        var1_1.clear();
        return null;
lbl-1000:
        // 1 sources

        {
            var1_1.remove(0);
            --var4_3;
lbl8:
            // 2 sources

            ** while (var4_3 > 0)
        }
lbl9:
        // 1 sources

        var5_4 = var1_1.indexOf(String.valueOf(255));
        if (var5_4 < 0) {
            return null;
        }
        if (var5_4 < 5) {
            var1_1.remove(0);
            return null;
        }
        if (this.Debug) {
            var6_5 = "";
            var7_7 = "";
            var8_9 = 0;
            while (var8_9 <= var5_4) {
                var7_7 = Integer.toHexString(Integer.parseInt(var1_1.get(var8_9).toString())).toUpperCase();
                var6_5 = String.valueOf(var6_5) + " " + (var7_7.length() < 2 ? "0" + var7_7 : var7_7);
                ++var8_9;
            }
            System.out.println("RDS:" + var6_5);
        }
        var6_6 = Integer.parseInt(var1_1.get(4).toString());
        var7_8 = -1;
        var8_9 = -1;
        var9_10 = 0;
        var10_11 = false;
        var11_12 = 0;
        var13_13 = 253;
        while (var9_10 <= var5_4) {
            var12_14 = Integer.parseInt(var1_1.get(0).toString());
            if (var9_10 >= 5 && var12_14 <= var13_13) {
                if (var9_10 == 5) {
                    var8_9 = var12_14;
                } else if (var12_14 == var13_13) {
                    var10_11 = true;
                } else {
                    if (var10_11) {
                        var12_14 += var13_13;
                        var10_11 = false;
                    }
                    if (var11_12 < var6_6 - 1) {
                        this.bo.write(var12_14);
                    }
                    var7_8 = var11_12++;
                }
            }
            ++var9_10;
            var1_1.remove(0);
        }
        if (var7_8 != var6_6) {
            var8_9 = -1;
        }
        var14_15 = null;
        switch (var8_9) {
            case 218: {
                this.getRawData(this.bo.toByteArray());
                break;
            }
            case 10: {
                var14_15 = this.compareMsg(this.getRT(this.bo.toByteArray()), 0, var2_2);
                break;
            }
            case 1: {
                var14_15 = this.compareMsg(this.getPI(this.bo.toByteArray()), 1, var2_2);
                break;
            }
            case 2: {
                var14_15 = this.compareMsg(this.getPS(this.bo.toByteArray()), 2, var2_2);
                break;
            }
            case 3: {
                var14_15 = this.compareMsg(this.getTP(this.bo.toByteArray()), 3, var2_2);
                break;
            }
            case 5: {
                var14_15 = this.compareMsg(this.getMS(this.bo.toByteArray()), 4, var2_2);
                break;
            }
            case 7: {
                var14_15 = this.compareMsg(this.getPTY(this.bo.toByteArray()), 5, var2_2);
                break;
            }
            case 13: {
                var14_15 = this.compareMsg(this.getRTC(this.bo.toByteArray()), 6, var2_2);
                break;
            }
            case 48: {
                var14_15 = this.compareMsg("transmits TMC messages", 7, var2_2);
                break;
            }
            case 70: {
                var14_15 = this.compareMsg("transmits ODA messages", 8, var2_2);
                break;
            }
        }
        this.bo.reset();
        return var14_15;
    }

    private int determineCRC(byte[] byArray, int n, int n2, int n3) {
        int n4 = n + (n2 >>> 3);
        int n5 = n;
        while (n5 < n4) {
            n3 = (this.crc_table[0xFF & byArray[n5] ^ n3 >> 8] ^ n3 << 8) & 0xFFFF;
            ++n5;
        }
        int n6 = n2 & 7;
        if (n6 > 0) {
            n3 = (this.crc_table[255 >> 8 - n6 & byArray[n4] >> 8 - n6 ^ n3 >> 16 - n6] ^ n3 << n6) & 0xFFFF;
        }
        return n3;
    }

    public String displayHeader() {
        return this.dID[this.getLastID()] + ", " + this.dLayer[this.getLastLayer()] + ", " + this.getLastSamplingFrequency() + "Hz, " + this.dMode[this.getLastMode()] + ", " + this.getLastBitrate() / 1000 + "kbps, " + this.dCRC[this.getLastProtectionBit()];
    }

    public byte[] getExtraWaveHeader(int n, boolean bl) {
        switch (n) {
            case 1: {
                return bl ? this.WaveHeader_Ch1.getPlaceHolder() : this.WaveHeader_Ch1.getHeader();
            }
            case 2: {
                return bl ? this.WaveHeader_Ch2.getPlaceHolder() : this.WaveHeader_Ch2.getHeader();
            }
        }
        return new byte[0];
    }

    private String getMS(byte[] byArray) {
        try {
            int n = 0;
            int n2 = 0xFF & byArray[n];
            int n3 = 0xFF & byArray[n + 1];
            boolean bl = (1 & byArray[n += 2]) != 0;
            return "-> MS (" + n3 + "): " + (bl ? "Speech" : "Music");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private String getPI(byte[] byArray) {
        try {
            int n = 0;
            int n2 = 0xFF & byArray[n];
            int n3 = 0xFF & byArray[n + 1];
            int n4 = (0xFF & byArray[n += 2]) << 8 | 0xFF & byArray[n + 1];
            return "-> PI (" + n3 + "): 0x" + Integer.toHexString(n4).toUpperCase();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private String getPS(byte[] byArray) {
        try {
            int n = 0;
            int n2 = 0xFF & byArray[n];
            int n3 = 0xFF & byArray[n + 1];
            int n4 = byArray.length >= (n += 2) + 8 ? 8 : byArray.length - n;
            String string = this.getString(byArray, n, n4);
            return "-> PS (" + n3 + "): '" + string.trim() + "'";
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private String getPTY(byte[] byArray) {
        try {
            int n = 0;
            int n2 = 0xFF & byArray[n];
            int n3 = 0xFF & byArray[n + 1];
            int n4 = 0x1F & byArray[n += 2];
            return "-> PTY (" + n3 + "): " + this.pty_list[n4];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private String getRT(byte[] byArray) {
        try {
            int n = 0;
            int n2 = 0xFF & byArray[n];
            int n3 = 0xFF & byArray[n + 1];
            int n4 = 0xFF & byArray[n += 2];
            int n5 = 0xFF & byArray[++n];
            String string = this.getString(byArray, ++n, n4 - 1);
            return "-> RT (" + Integer.toHexString(n5).toUpperCase() + "): '" + string.trim() + "'";
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private String getRTC(byte[] byArray) {
        try {
            int n = 0;
            String string = "20" + Common.adaptString(Integer.toHexString(0x7F & byArray[n]), 2);
            String string2 = Common.adaptString(String.valueOf(0xF & byArray[n + 1]), 2);
            String string3 = Common.adaptString(String.valueOf(0x1F & byArray[n + 2]), 2);
            String string4 = Common.adaptString(String.valueOf(0x1F & byArray[n + 3]), 2);
            String string5 = Common.adaptString(String.valueOf(0x3F & byArray[n + 4]), 2);
            String string6 = Common.adaptString(String.valueOf(0x3F & byArray[n + 5]), 2);
            String string7 = Common.adaptString(String.valueOf(0x7F & byArray[n + 6]), 2);
            int n2 = 0xFF & byArray[n + 7];
            String string8 = n2 != 255 ? ((0x20 & n2) != 0 ? "-" + (0x1F & n2) / 2 : "+" + (0x1F & n2) / 2) : "\u00b10";
            return "-> RTC (" + string8 + "h): " + string + "." + string2 + "." + string3 + "  " + string4 + ":" + string5 + ":" + string6 + "." + string7;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private void getRawData(byte[] byArray) {
        try {
            int n = 0;
            int n2 = 0xFF & byArray[n];
            int n3 = byArray.length;
            int n4 = 0xFF & byArray[n += 5];
            int n5 = 0xFF & byArray[n += 3];
            ++n;
            try {
                if (!this.hasRawData) {
                    this.hasRawData = true;
                    Common.setMessage("-> exporting RDS data (RASS) to '" + this.instanced_time + "_RASS@RDS'");
                }
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(Common.getCollection().getOutputNameParent(String.valueOf(this.instanced_time) + "_RASS@RDS"), true));
                int n6 = n;
                while (n6 < n3) {
                    int n7 = 0xFF & byArray[n6];
                    bufferedOutputStream.write(n7);
                    ++n6;
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            catch (IOException iOException) {
                Common.setMessage("!> error rds1");
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Common.setMessage("!> error rds2");
        }
    }

    private String getString(byte[] byArray, int n, int n2) {
        String string = "";
        try {
            int n3 = n;
            int n4 = n + n2;
            while (n3 < n4) {
                int n5 = 0xFF & byArray[n3];
                string = String.valueOf(string) + (n5 > 159 || n5 < 32 ? (char)this.chars[0] : (char)this.chars[n5 - 32]);
                ++n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return string;
    }

    private String getTP(byte[] byArray) {
        try {
            int n = 0;
            int n2 = 0xFF & byArray[n];
            int n3 = 0xFF & byArray[n + 1];
            boolean bl = (2 & byArray[n += 2]) != 0;
            boolean bl2 = (1 & byArray[n]) != 0;
            return "-> TP/TA (" + n3 + "): " + (bl ? "TP" : "no TP") + " / " + (bl2 ? "TA on air" : "no TA");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private void initCRCTable() {
        int n = 0;
        while (n < 256) {
            int n2 = n << 8;
            int n3 = 0;
            while (n3 < 8) {
                n2 = (n2 & 0x8000) != 0 ? n2 << 1 & 0xFFFF ^ this.CRC16_POLY & 0xFFFF : (n2 <<= 1);
                ++n3;
            }
            this.crc_table[n] = n2;
            ++n;
        }
    }

    public void initExtraWaveHeader(boolean bl, boolean bl2, boolean bl3) {
        this.WaveHeader_Ch1 = new WaveHeader(bl, bl2);
        this.WaveHeader_Ch2 = new WaveHeader(bl, bl2);
    }

    public int parseHeader(byte[] byArray, int n) {
        int n2 = 32;
        if ((0xFF & byArray[n]) != 255 || (0xF0 & byArray[n + 1]) != 240) {
            return -1;
        }
        this.setID(1 & byArray[n + 1] >>> 3);
        this.setEmphasis(3 & byArray[n + 3]);
        if (this.getID() == 1 && this.getEmphasis() == 2) {
            this.setID(2);
        }
        this.setLayer(3 & byArray[n + 1] >>> 1);
        if (this.getLayer() < 1) {
            return -2;
        }
        this.setProtectionBit(1 & byArray[n + 1] ^ 1);
        this.setBitrate(this.bitrate_index[this.getID()][this.getLayer() - 1][0xF & byArray[n + 2] >>> 4]);
        if (this.getBitrate() < 1) {
            return -3;
        }
        this.setSamplingFrequency(this.frequency_index[this.getID()][3 & byArray[n + 2] >>> 2]);
        if (this.getSamplingFrequency() == 0) {
            return -4;
        }
        this.setPaddingBit(1 & byArray[n + 2] >>> 1);
        this.setPrivateBit(1 & byArray[n + 2]);
        this.setMode(3 & byArray[n + 3] >>> 6);
        this.setModeExtension(3 & byArray[n + 3] >>> 4);
        if (this.getMode() == 0) {
            this.setModeExtension(0);
        }
        this.Bound = this.getMode() == 1 ? this.getModeExtension() + 1 << 2 : n2;
        this.setChannel(this.getMode() == 3 ? 1 : 2);
        this.setCopyright(1 & byArray[n + 3] >>> 3);
        this.setOriginal(1 & byArray[n + 3] >>> 2);
        this.setFrameTimeLength(this.time_index[this.getLayer()] / (double)this.getSamplingFrequency());
        if (this.getID() == 1 && this.getLayer() == 2) {
            if (this.getBitrate() / this.getChannel() < 32000) {
                return -5;
            }
            if (this.getBitrate() / this.getChannel() > 192000) {
                return -6;
            }
            this.Sblimit = this.getBitrate() / this.getChannel() < 56000 ? (this.getSamplingFrequency() == 32000 ? 12 : 8) : (this.getBitrate() / this.getChannel() < 96000 ? 27 : (this.getSamplingFrequency() == 48000 ? 27 : 30));
            if (this.Bound > this.Sblimit) {
                this.Bound = this.Sblimit;
            }
        } else if (this.getLayer() == 2) {
            this.Sblimit = 30;
        }
        if (this.getLayer() < 3) {
            if (this.Bound > this.Sblimit) {
                this.Bound = this.Sblimit;
            }
            this.setSizeBase((this.getID() == 0 && this.getLayer() == 1 ? 72 : 144) * this.getBitrate() / this.getSamplingFrequency());
            this.setSize(this.getSizeBase() + this.getPaddingBit());
            return 1;
        }
        this.Sblimit = 32;
        this.setSizeBase(12 * this.getBitrate() / this.getSamplingFrequency() << 2);
        this.setSize(this.getSizeBase() + (this.getPaddingBit() << 2));
        return 2;
    }

    public int parseNextHeader(byte[] byArray, int n) {
        if ((0xFF & byArray[n]) != 255 || (0xF0 & byArray[n + 1]) != 240) {
            return -1;
        }
        this.setNextID(1 & byArray[n + 1] >>> 3);
        this.setNextEmphasis(3 & byArray[n + 3]);
        if (this.getNextID() == 1 && this.getNextEmphasis() == 2) {
            this.setNextID(2);
        }
        this.setNextLayer(3 & byArray[n + 1] >>> 1);
        if (this.getNextLayer() < 1) {
            return -2;
        }
        this.setNextProtectionBit(1 & byArray[n + 1] ^ 1);
        this.setNextBitrate(this.bitrate_index[this.getNextID()][this.getNextLayer() - 1][0xF & byArray[n + 2] >>> 4]);
        if (this.getNextBitrate() < 1) {
            return -3;
        }
        this.setNextSamplingFrequency(this.frequency_index[this.getNextID()][3 & byArray[n + 2] >>> 2]);
        if (this.getNextSamplingFrequency() == 0) {
            return -4;
        }
        this.setNextPaddingBit(1 & byArray[n + 2] >>> 1);
        this.setNextPrivateBit(1 & byArray[n + 2]);
        this.setNextMode(3 & byArray[n + 3] >>> 6);
        this.setNextModeExtension(3 & byArray[n + 3] >>> 4);
        if (this.getNextMode() == 0) {
            this.setNextModeExtension(0);
        }
        this.setNextChannel(this.getNextMode() == 3 ? 1 : 2);
        this.setNextCopyright(1 & byArray[n + 3] >>> 3);
        this.setNextOriginal(1 & byArray[n + 3] >>> 2);
        this.setNextFrameTimeLength(this.time_index[this.getNextLayer()] / (double)this.getNextSamplingFrequency());
        if (this.getNextID() == 1 && this.getNextLayer() == 2) {
            if (this.getNextBitrate() / this.getNextChannel() < 32000) {
                return -5;
            }
            if (this.getNextBitrate() / this.getNextChannel() > 192000) {
                return -6;
            }
        }
        if (this.getNextLayer() < 3) {
            this.setNextSizeBase((this.getNextID() == 0 && this.getNextLayer() == 1 ? 72 : 144) * this.getNextBitrate() / this.getNextSamplingFrequency());
            this.setNextSize(this.getNextSizeBase() + this.getNextPaddingBit());
            return 1;
        }
        this.setNextSizeBase(12 * this.getNextBitrate() / this.getNextSamplingFrequency() << 2);
        this.setNextSize(this.getNextSizeBase() + (this.getNextPaddingBit() << 2));
        return 2;
    }

    public void parseRiffData(byte[] byArray, int n) {
        int[] nArray = new int[10];
        nArray[0] = (8 & byArray[1]) << 1 | (1 & byArray[1]) << 3 | 4 & byArray[3] | (8 & byArray[3]) >>> 2 | 1 & byArray[2];
        nArray[1] = this.rlayer[(6 & byArray[1]) >>> 1];
        nArray[2] = this.rsample[(8 & byArray[1]) >>> 3][(0xC & byArray[2]) >>> 2];
        nArray[3] = this.rmode[(0xC0 & byArray[3]) >>> 6];
        nArray[4] = this.rchnl[(0xC0 & byArray[3]) >>> 6];
        nArray[5] = this.rmext[(0x30 & byArray[3]) >>> 4];
        nArray[6] = this.rbitrate[(8 & byArray[1]) >>> 3][(6 & byArray[1]) >>> 1][(0xF0 & byArray[2]) >>> 4];
        nArray[7] = this.remph[3 & byArray[3]];
        nArray[8] = nArray[1] == 1 ? 4 * (12 * nArray[6] / nArray[2]) : 144 * nArray[6] / nArray[2];
        nArray[8] = nArray[8] / ((8 & byArray[1]) == 0 && (6 & byArray[1]) == 1 ? 2 : 1);
        if ((2 & byArray[2]) != 0) {
            nArray[8] = nArray[8] + this.rpadding[(6 & byArray[1]) >>> 1];
        }
        this.setExtraWaveData(nArray, n);
    }

    public void removeCRC(byte[] byArray, boolean bl) {
        if (this.getLayer() < 2 || !bl) {
            return;
        }
        this.removePrivateBit(byArray);
        if ((byArray[1] & 1) == 1) {
            return;
        }
        System.arraycopy(byArray, 6, byArray, 4, byArray.length - 6);
        Arrays.fill(byArray, byArray.length - 2, byArray.length, (byte)0);
        byArray[1] = (byte)(byArray[1] | 1);
        this.setProtectionBit(1);
    }

    private void removePrivateBit(byte[] byArray) {
        if ((byArray[2] & 1) == 0) {
            return;
        }
        byArray[2] = (byte)(byArray[2] & 0xFFFFFFFE);
        this.setPrivateBit(0);
    }

    public void setAncillaryDataDecoder(boolean bl, boolean bl2) {
        this.DecodeRDS = bl;
        this.Debug = bl2;
        Arrays.fill(this.rds_values, null);
    }

    public void setExtraWaveData(int[] nArray, int n) {
        switch (n) {
            case 1: {
                this.WaveHeader_Ch1.setWaveData(nArray);
                break;
            }
            case 2: {
                this.WaveHeader_Ch2.setWaveData(nArray);
                break;
            }
        }
    }

    public void setExtraWaveLength(long l, long l2, int n) {
        switch (n) {
            case 1: {
                this.WaveHeader_Ch1.setWaveLength(l, l2);
                break;
            }
            case 2: {
                this.WaveHeader_Ch2.setWaveLength(l, l2);
                break;
            }
        }
    }

    public int validateCRC(byte[] byArray, int n, int n2) {
        if (this.getLayer() < 2 || this.getProtectionBit() == 0) {
            return 0;
        }
        int n3 = (0xFF & byArray[4]) << 8 | 0xFF & byArray[5];
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, 4);
        System.arraycopy(byArray, 6, byArray2, 4, byArray.length - 6);
        int n4 = 2;
        int n5 = 16;
        int[] nArray = new int[]{32};
        if (this.getLayer() == 3) {
            int n6 = 0;
            while (n6 < this.Bound) {
                int n7 = 0;
                while (n7 < this.getChannel()) {
                    n5 += 4;
                    ++n7;
                }
                ++n6;
            }
            n6 = this.Bound;
            while (n6 < this.Sblimit) {
                n5 += 4;
                ++n6;
            }
        } else {
            int n8;
            int[][] nArray2;
            int[] nArray3;
            int[][] nArray4 = new int[32][2];
            if (this.getID() == 1) {
                if (this.Sblimit > 20) {
                    nArray3 = MpaDecoder.table_b2ab_nbal;
                    nArray2 = MpaDecoder.table_b2ab;
                } else {
                    nArray3 = MpaDecoder.table_b2cd_nbal;
                    nArray2 = MpaDecoder.table_b2cd;
                }
            } else {
                nArray3 = MpaDecoder.table_MPG2_nbal;
                nArray2 = MpaDecoder.table_MPG2;
            }
            int n9 = 0;
            while (n9 < this.Bound) {
                n8 = 0;
                while (n8 < this.getChannel()) {
                    nArray4[n9][n8] = nArray2[n9][this.getBits(byArray2, nArray, nArray3[n9])];
                    n5 += nArray3[n9];
                    ++n8;
                }
                ++n9;
            }
            n9 = this.Bound;
            while (n9 < this.Sblimit) {
                int n10 = nArray2[n9][this.getBits(byArray2, nArray, nArray3[n9])];
                nArray4[n9][1] = n10;
                nArray4[n9][0] = n10;
                n5 += nArray3[n9];
                ++n9;
            }
            n9 = 0;
            while (n9 < this.Sblimit) {
                n8 = 0;
                while (n8 < this.getChannel()) {
                    if (nArray4[n9][n8] > 0) {
                        n5 += 2;
                    }
                    ++n8;
                }
                ++n9;
            }
        }
        int n11 = 65535;
        n11 = this.determineCRC(byArray2, n4, n5, n11);
        return n11 != n3 ? 1 : 0;
    }

    private class WaveHeader {
        private byte[] riffacm;
        private byte[] riffbwf;
        private long Samples;
        private long SampleCount;
        private final int HeaderLength_ACM = 70;
        private final int HeaderLength_BWF = 80;
        private final int ACM_WaveFormat = 1;
        private final int BWF_WaveFormat = 2;
        private int WaveFormat;

        public WaveHeader(boolean bl, boolean bl2) {
            byte[] byArray = new byte[70];
            byArray[0] = 82;
            byArray[1] = 73;
            byArray[2] = 70;
            byArray[3] = 70;
            byArray[8] = 87;
            byArray[9] = 65;
            byArray[10] = 86;
            byArray[11] = 69;
            byArray[12] = 102;
            byArray[13] = 109;
            byArray[14] = 116;
            byArray[15] = 32;
            byArray[16] = 30;
            byArray[20] = 85;
            byArray[22] = 1;
            byArray[24] = 1;
            byArray[32] = 1;
            byArray[36] = 12;
            byArray[38] = 1;
            byArray[40] = 2;
            byArray[46] = 1;
            byArray[48] = 113;
            byArray[49] = 5;
            byArray[50] = 102;
            byArray[51] = 97;
            byArray[52] = 99;
            byArray[53] = 116;
            byArray[54] = 4;
            byArray[62] = 100;
            byArray[63] = 97;
            byArray[64] = 116;
            byArray[65] = 97;
            this.riffacm = byArray;
            byte[] byArray2 = new byte[80];
            byArray2[0] = 82;
            byArray2[1] = 73;
            byArray2[2] = 70;
            byArray2[3] = 70;
            byArray2[8] = 87;
            byArray2[9] = 65;
            byArray2[10] = 86;
            byArray2[11] = 69;
            byArray2[12] = 102;
            byArray2[13] = 109;
            byArray2[14] = 116;
            byArray2[15] = 32;
            byArray2[16] = 40;
            byArray2[20] = 80;
            byArray2[22] = 1;
            byArray2[24] = 1;
            byArray2[36] = 22;
            byArray2[40] = 1;
            byArray2[60] = 102;
            byArray2[61] = 97;
            byArray2[62] = 99;
            byArray2[63] = 116;
            byArray2[64] = 4;
            byArray2[72] = 100;
            byArray2[73] = 97;
            byArray2[74] = 116;
            byArray2[75] = 97;
            this.riffbwf = byArray2;
            this.Samples = 0L;
            this.SampleCount = 0L;
            this.HeaderLength_ACM = 70;
            this.HeaderLength_BWF = 80;
            this.ACM_WaveFormat = 1;
            this.BWF_WaveFormat = 2;
            this.WaveFormat = bl ? 1 : (bl2 ? 2 : 0);
        }

        public byte[] getHeader() {
            switch (this.WaveFormat) {
                case 1: {
                    return this.riffacm;
                }
                case 2: {
                    return this.riffbwf;
                }
            }
            return new byte[0];
        }

        public byte[] getPlaceHolder() {
            switch (this.WaveFormat) {
                case 1: {
                    return new byte[70];
                }
                case 2: {
                    return new byte[80];
                }
            }
            return new byte[0];
        }

        public void setWaveData(int[] nArray) {
            this.Samples += (long)nArray[2];
            ++this.SampleCount;
            int n = AudioFormatMPA.this.getValue(this.riffbwf, 24, 4, true);
            int n2 = AudioFormatMPA.this.getValue(this.riffbwf, 40, 4, true);
            int n3 = AudioFormatMPA.this.getValue(this.riffbwf, 32, 2, true);
            if (n3 == 0) {
                AudioFormatMPA.this.setValue(this.riffacm, 44, 2, true, nArray[8]);
                AudioFormatMPA.this.setValue(this.riffbwf, 32, 2, true, nArray[8]);
            } else if (n3 != 1 && n3 != nArray[8]) {
                AudioFormatMPA.this.setValue(this.riffbwf, 32, 2, true, 1);
            }
            if (n == 1) {
                AudioFormatMPA.this.setValue(this.riffacm, 24, 4, true, nArray[2]);
                AudioFormatMPA.this.setValue(this.riffbwf, 24, 4, true, nArray[2]);
            } else if (n != 0 && n != nArray[2]) {
                AudioFormatMPA.this.setValue(this.riffacm, 24, 4, true, 0);
                AudioFormatMPA.this.setValue(this.riffbwf, 24, 4, true, 0);
            }
            if (n2 == 1) {
                AudioFormatMPA.this.setValue(this.riffbwf, 40, 4, true, nArray[6]);
            } else if (n2 != 0 && n2 != nArray[6]) {
                AudioFormatMPA.this.setValue(this.riffbwf, 40, 4, true, 0);
            }
            if (nArray[3] == 2) {
                this.riffbwf[46] = (byte)(this.riffbwf[46] | (byte)nArray[5]);
            }
            if (this.riffbwf[22] == 1) {
                this.riffacm[22] = this.riffbwf[22] = (byte)nArray[4];
            }
            this.riffbwf[38] = (byte)(this.riffbwf[38] | (byte)nArray[1]);
            this.riffbwf[44] = (byte)(this.riffbwf[44] | (byte)nArray[3]);
            this.riffbwf[48] = (byte)(this.riffbwf[48] | (byte)nArray[7]);
            this.riffbwf[50] = (byte)(this.riffbwf[50] | (byte)nArray[0]);
        }

        public void setWaveLength(long l, long l2) {
            int n = (int)l - 70;
            int n2 = (int)l - 80;
            int n3 = 0;
            while (n3 < 4) {
                this.riffacm[4 + n3] = (byte)(0xFF & n + 62 >>> n3 * 8);
                this.riffbwf[4 + n3] = (byte)(0xFF & n2 + 72 >>> n3 * 8);
                this.riffacm[66 + n3] = (byte)(0xFF & n >>> n3 * 8);
                this.riffbwf[76 + n3] = (byte)(0xFF & n2 >>> n3 * 8);
                ++n3;
            }
            if (l <= 100L) {
                return;
            }
            int n4 = (int)l2;
            int n5 = (int)(1000L * (long)n / (long)n4);
            int n6 = (int)(1000L * (long)n2 / (long)n4);
            int n7 = 0;
            while (n7 < 4) {
                this.riffacm[28 + n7] = (byte)(0xFF & n5 >>> n7 * 8);
                this.riffbwf[28 + n7] = (byte)(0xFF & n6 >>> n7 * 8);
                ++n7;
            }
            int n8 = (int)(this.Samples / this.SampleCount * (long)n4 / 1000L);
            int n9 = 0;
            while (n9 < 4) {
                byte by = (byte)(0xFF & n8 >>> n9 * 8);
                this.riffbwf[68 + n9] = by;
                this.riffacm[58 + n9] = by;
                ++n9;
            }
        }
    }
}

