/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Image;
import java.awt.Menu;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.ImageObserver;

public final class DAXKamera
extends ImageFrame
implements ImageObserver {
    public static final int INDEX_DJI = 0;
    public static final int INDEX_NASDAQ = 1;
    public static final int INDEX_SP500 = 2;
    private static final int KAMERABREITE = 404;
    private static final int KAMERAHOEHE = 308;
    private static final String EXT = "jpg";
    private static final String FTYPE = "JPEG";
    public static final int S_LOADING = 0;
    public static final int S_ERROR = 1;
    public static final int S_OFFLINE = 2;
    private int status = 0;
    private DAXKameraLeser kameraLeser = null;
    private ThomsonKameraLeser djiLeser = null;
    private ThomsonKameraLeser nasdaqLeser = null;
    private ThomsonKameraLeser sp500Leser = null;
    private boolean showDJI = AktienMan.properties.getBoolean("Kamera.showDJI", true);
    private boolean showSP500 = AktienMan.properties.getBoolean("Kamera.showSP500", true);
    private boolean showNASDAQ = AktienMan.properties.getBoolean("Kamera.showNASDAQ", true);
    private byte[] kameraDaten = null;
    private Image daxImage = null;
    private Image[] usImages = new Image[3];

    public DAXKamera() {
        super("AktienMan - DAX-Kamera", "DAX-Kamera", EXT, FTYPE);
        Menu menu = this.getEditMenu();
        if (menu != null) {
            CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem("\"Dow Jones\" anzeigen");
            checkboxMenuItem.addItemListener(new 1());
            CheckboxMenuItem checkboxMenuItem2 = new CheckboxMenuItem("\"S&P 500\" anzeigen");
            checkboxMenuItem2.addItemListener(new 2());
            CheckboxMenuItem checkboxMenuItem3 = new CheckboxMenuItem("\"NASDAQ\" anzeigen");
            checkboxMenuItem3.addItemListener(new 3());
            menu.add(checkboxMenuItem);
            menu.add(checkboxMenuItem2);
            menu.add(checkboxMenuItem3);
            checkboxMenuItem.setState(this.showDJI);
            checkboxMenuItem2.setState(this.showSP500);
            checkboxMenuItem3.setState(this.showNASDAQ);
        }
    }

    public void setupElements() {
        this.setLayout(new BorderLayout());
        this.add("Center", new DAXCanvas(this));
    }

    public void setupSize() {
        int n = AktienMan.screenSize.width - 404 - 50;
        int n2 = 40;
        int n3 = AktienMan.properties.getInt("Kamera.X");
        int n4 = AktienMan.properties.getInt("Kamera.Y");
        int n5 = AktienMan.properties.getInt("Kamera.Breite");
        int n6 = AktienMan.properties.getInt("Kamera.Hoehe");
        if (n3 < 0 || n4 < 0 || n5 <= 0 || n6 <= 0) {
            ((Component)this).setBounds(n, n2, 404, 308);
        } else {
            ((Component)this).setBounds(n3, n4, n5, n6);
        }
    }

    public boolean canOK() {
        return false;
    }

    public synchronized void showKamera() {
        if (this.kameraLeser == null) {
            this.kameraLeser = new DAXKameraLeser(this);
            if (this.kameraLeser != null) {
                this.kameraLeser.start();
            }
        } else {
            this.kameraLeser.interrupt();
        }
        if (this.showDJI) {
            if (this.djiLeser == null) {
                this.djiLeser = new ThomsonKameraLeser(this, 11, 0);
                if (this.djiLeser != null) {
                    this.djiLeser.start();
                }
            } else {
                this.djiLeser.interrupt();
            }
        }
        if (this.showNASDAQ) {
            if (this.nasdaqLeser == null) {
                this.nasdaqLeser = new ThomsonKameraLeser(this, 12, 1);
                if (this.nasdaqLeser != null) {
                    this.nasdaqLeser.start();
                }
            } else {
                this.nasdaqLeser.interrupt();
            }
        }
        if (this.showSP500) {
            if (this.sp500Leser == null) {
                this.sp500Leser = new ThomsonKameraLeser(this, 13, 2);
                if (this.sp500Leser != null) {
                    this.sp500Leser.start();
                }
            } else {
                this.sp500Leser.interrupt();
            }
        }
        this.toFront();
    }

    public void closed() {
        this.savePos();
        if (this.kameraLeser != null) {
            this.kameraLeser.stopLoading();
            this.kameraLeser = null;
        }
        if (this.djiLeser != null) {
            this.djiLeser.stopLoading();
            this.djiLeser = null;
        }
        if (this.nasdaqLeser != null) {
            this.nasdaqLeser.stopLoading();
            this.nasdaqLeser = null;
        }
        if (this.sp500Leser != null) {
            this.sp500Leser.stopLoading();
            this.sp500Leser = null;
        }
        AktienMan.daxKamera = null;
    }

    public void savePos() {
        Rectangle rectangle = this.getBounds();
        AktienMan.properties.setInt("Kamera.X", rectangle.x);
        AktienMan.properties.setInt("Kamera.Y", rectangle.y);
        AktienMan.properties.setInt("Kamera.Breite", rectangle.width);
        AktienMan.properties.setInt("Kamera.Hoehe", rectangle.height);
        AktienMan.properties.setBoolean("Kamera.showDJI", this.showDJI);
        AktienMan.properties.setBoolean("Kamera.showSP500", this.showSP500);
        AktienMan.properties.setBoolean("Kamera.showNASDAQ", this.showNASDAQ);
    }

    public synchronized void setStatus(int n) {
        this.status = n;
        this.neuZeichnen();
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public void neuZeichnen() {
        this.paintAll(this.getGraphics());
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 1) != 0 && (n & 2) != 0) {
            this.neuZeichnen();
        }
        return true;
    }

    public synchronized void setKameraDaten(byte[] byArray) {
        this.kameraDaten = byArray;
        System.gc();
    }

    public synchronized void setImage(Image image) {
        this.daxImage = image;
        System.gc();
    }

    public synchronized void setImage(int n, Image image) {
        this.usImages[n] = image;
        System.gc();
    }

    public synchronized byte[] getImageData() {
        return this.kameraDaten;
    }

    public synchronized Image getImage() {
        return this.daxImage;
    }

    public synchronized Image getIndexImage(int n) {
        return this.usImages != null ? this.usImages[n] : null;
    }

    public String getDefaultFilename() {
        return "DAX-" + new ADate().toTimestamp(true) + "." + EXT;
    }

    private final class 1
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            DAXKamera.this.showDJI = itemEvent.getStateChange() == 1;
            if (DAXKamera.this.showDJI) {
                DAXKamera.this.showKamera();
            } else {
                if (DAXKamera.this.djiLeser != null) {
                    DAXKamera.this.djiLeser.stopLoading();
                    DAXKamera.this.djiLeser = null;
                }
                DAXKamera.this.setImage(0, null);
                DAXKamera.this.neuZeichnen();
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            DAXKamera.this.showSP500 = itemEvent.getStateChange() == 1;
            if (DAXKamera.this.showSP500) {
                DAXKamera.this.showKamera();
            } else {
                if (DAXKamera.this.sp500Leser != null) {
                    DAXKamera.this.sp500Leser.stopLoading();
                    DAXKamera.this.sp500Leser = null;
                }
                DAXKamera.this.setImage(2, null);
                DAXKamera.this.neuZeichnen();
            }
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            DAXKamera.this.showNASDAQ = itemEvent.getStateChange() == 1;
            if (DAXKamera.this.showNASDAQ) {
                DAXKamera.this.showKamera();
            } else {
                if (DAXKamera.this.nasdaqLeser != null) {
                    DAXKamera.this.nasdaqLeser.stopLoading();
                    DAXKamera.this.nasdaqLeser = null;
                }
                DAXKamera.this.setImage(1, null);
                DAXKamera.this.neuZeichnen();
            }
        }

        /* synthetic */ 3() {
        }
    }
}

