/*
 * Decompiled with CFR 0.152.
 */
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Menu;
import java.io.File;

public final class Portfolios {
    public static final int INDEX_NONE = -1;
    private static final String NAME_DEFAULT = "Standard";
    private static final int NAME_MAXLEN = 27;
    private static final int INDEX_DEFAULT = 0;
    private static final int INDEX_OFFSET = 2;
    private static Menu menu = new Menu("\u00d6ffnen");
    private static Menu menuCopy = new Menu("Kopieren nach");
    private static Menu menuMove = new Menu("Verschieben nach");
    private static Menu popupCopy = new Menu("Kopieren nach");
    private static Menu popupMove = new Menu("Verschieben nach");
    private static boolean menuEnabled = false;
    private static int index = 0;
    private static boolean indexValid = false;
    private static String[] dateien = null;
    private static Hauptdialog hauptdialog = null;

    public static synchronized Menu getMenu(Hauptdialog hauptdialog) {
        menu.setEnabled(false);
        Portfolios.hauptdialog = hauptdialog;
        return menu;
    }

    public static synchronized Menu getMenuCopy(Hauptdialog hauptdialog) {
        menuCopy.setEnabled(false);
        Portfolios.hauptdialog = hauptdialog;
        return menuCopy;
    }

    public static synchronized Menu getMenuMove(Hauptdialog hauptdialog) {
        menuMove.setEnabled(false);
        Portfolios.hauptdialog = hauptdialog;
        return menuMove;
    }

    public static synchronized Menu getPopupCopy(Hauptdialog hauptdialog) {
        popupCopy.setEnabled(false);
        Portfolios.hauptdialog = hauptdialog;
        return popupCopy;
    }

    public static synchronized Menu getPopupMove(Hauptdialog hauptdialog) {
        popupMove.setEnabled(false);
        Portfolios.hauptdialog = hauptdialog;
        return popupMove;
    }

    public static void enableMoveCopyMenus() {
        menuEnabled = true;
        Portfolios.checkMoveCopyMenus();
    }

    public static void disableMoveCopyMenus() {
        menuEnabled = false;
        Portfolios.checkMoveCopyMenus();
    }

    private static void checkMoveCopyMenus() {
        if (menuEnabled) {
            menuCopy.setEnabled(true);
            menuMove.setEnabled(true);
        } else {
            menuCopy.setEnabled(false);
            menuMove.setEnabled(false);
        }
    }

    public static synchronized void updateMenu(boolean bl) {
        menu.setEnabled(false);
        menu.removeAll();
        CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(NAME_DEFAULT);
        checkboxMenuItem.addItemListener(new PortfolioListener(0));
        menu.add(checkboxMenuItem);
        Portfolios.leseDateien();
        if (!indexValid) {
            Portfolios.initIndex();
            indexValid = true;
        }
        if (Portfolios.getAnzahlDateien() > 0) {
            menu.addSeparator();
            int n = 0;
            while (n < Portfolios.getAnzahlDateien()) {
                checkboxMenuItem = new CheckboxMenuItem(dateien[n]);
                checkboxMenuItem.addItemListener(new PortfolioListener(2 + n));
                menu.add(checkboxMenuItem);
                ++n;
            }
        }
        if (bl) {
            Portfolios.setIndex(Portfolios.getIndex(), false, true);
        }
        menu.setEnabled(true);
    }

    public static synchronized void updateMenu() {
        Portfolios.updateMenu(true);
    }

    private static synchronized void updateCopyMove() {
        menuCopy.setEnabled(false);
        menuMove.setEnabled(false);
        popupCopy.setEnabled(false);
        popupMove.setEnabled(false);
        menuCopy.removeAll();
        menuMove.removeAll();
        popupCopy.removeAll();
        popupMove.removeAll();
        if (Portfolios.getAnzahlDateien() > 0) {
            boolean bl = false;
            int n = 0;
            while (n < Portfolios.getAnzahlDateien()) {
                int n2 = 2 + n;
                if (Portfolios.getIndex() != n2) {
                    CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(dateien[n]);
                    checkboxMenuItem.addItemListener(new PortfolioCopyMoveListener(n2, hauptdialog, false));
                    menuCopy.add(checkboxMenuItem);
                    checkboxMenuItem = new CheckboxMenuItem(dateien[n]);
                    checkboxMenuItem.addItemListener(new PortfolioCopyMoveListener(n2, hauptdialog, false));
                    popupCopy.add(checkboxMenuItem);
                    checkboxMenuItem = new CheckboxMenuItem(dateien[n]);
                    checkboxMenuItem.addItemListener(new PortfolioCopyMoveListener(n2, hauptdialog, true));
                    menuMove.add(checkboxMenuItem);
                    checkboxMenuItem = new CheckboxMenuItem(dateien[n]);
                    checkboxMenuItem.addItemListener(new PortfolioCopyMoveListener(n2, hauptdialog, true));
                    popupMove.add(checkboxMenuItem);
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                popupCopy.setEnabled(true);
                popupMove.setEnabled(true);
                Portfolios.checkMoveCopyMenus();
            }
        }
    }

    public static synchronized Choice getChoiceMove() {
        Choice choice = new Choice();
        int n = 0;
        while (n < Portfolios.getAnzahlDateien()) {
            if (Portfolios.getIndex() != 2 + n) {
                choice.add(dateien[n]);
            }
            ++n;
        }
        return choice;
    }

    private static synchronized int getAnzahlDateien() {
        return dateien == null ? 0 : dateien.length;
    }

    private static synchronized void leseDateien() {
        File file = new File(FileUtil.getAMDirectory(false));
        dateien = file.list(new PortfolioFilter(".lst"));
        if (Portfolios.getAnzahlDateien() > 0) {
            int n = 0;
            while (n < Portfolios.getAnzahlDateien()) {
                Portfolios.dateien[n] = dateien[n].substring(0, dateien[n].length() - ".lst".length());
                ++n;
            }
            Portfolios.sortiereDateien();
        }
    }

    private static synchronized void sortiereDateien() {
        int n = Portfolios.getAnzahlDateien();
        int n2 = 0;
        while (n2 < n - 1) {
            int n3 = n2;
            String string = dateien[n3].trim().toUpperCase();
            int n4 = n2 + 1;
            while (n4 < n) {
                if (string.compareTo(dateien[n4].trim().toUpperCase()) > 0) {
                    n3 = n4;
                    string = dateien[n3].trim().toUpperCase();
                }
                ++n4;
            }
            if (n3 != n2) {
                String string2 = dateien[n2];
                Portfolios.dateien[n2] = dateien[n3];
                Portfolios.dateien[n3] = string2;
            }
            ++n2;
        }
    }

    private static synchronized void initIndex() {
        String string = AktienMan.properties.getString("Portfolio.StartName").trim();
        index = 0;
        if (string.length() > 0) {
            int n = 0;
            while (n < Portfolios.getAnzahlDateien()) {
                if (string.equalsIgnoreCase(dateien[n])) {
                    index = 2 + n;
                    break;
                }
                ++n;
            }
        }
    }

    private static synchronized void setIndex(int n, boolean bl, boolean bl2) {
        if (n < 2 || n >= 2 + Portfolios.getAnzahlDateien()) {
            n = 0;
        }
        ((CheckboxMenuItem)menu.getItem(n)).setState(false);
        if (!hauptdialog.main() && n != 0) {
            n = 0;
            new TextWarnalert(hauptdialog, "Mit der Demoversion k\u00f6nnen Sie nur das Standard-Portfolio verwalten.");
        }
        boolean bl3 = false;
        if (!hauptdialog.isLocked(true)) {
            if (Portfolios.getIndex() != n) {
                ((CheckboxMenuItem)menu.getItem(Portfolios.getIndex())).setState(false);
                index = n;
                if (bl2) {
                    hauptdialog.waitProgress();
                    hauptdialog.loadPortfolio(bl);
                    bl3 = true;
                }
            }
            Portfolios.updateCopyMove();
        }
        ((CheckboxMenuItem)menu.getItem(Portfolios.getIndex())).setState(true);
        hauptdialog.checkPortfolioMenu();
        hauptdialog.setPortfolioTitle(Portfolios.getCurrentWindowTitle());
        AktienMan.properties.setString("Portfolio.StartName", Portfolios.getName(Portfolios.getIndex()));
        if (bl3) {
            hauptdialog.resetProgress();
        }
    }

    public static synchronized void setIndex(int n) {
        Portfolios.setIndex(n, true, true);
    }

    public static synchronized void setDefaultIndexDontSave() {
        Portfolios.setIndex(0, false, true);
    }

    public static synchronized void setIndexByName(String string) {
        int n = Portfolios.getIndexByName(string);
        if (n == -1) {
            Portfolios.setIndex(0);
        } else {
            Portfolios.setIndex(n);
        }
    }

    public static synchronized void changeIndexByName(String string) {
        int n = Portfolios.getIndexByName(string);
        if (n == -1) {
            Portfolios.setIndex(0, false, false);
        } else {
            Portfolios.setIndex(n, false, false);
        }
    }

    public static synchronized int getIndexByName(String string) {
        if (string.length() > 0) {
            int n = 0;
            while (n < Portfolios.getAnzahlDateien()) {
                if (string.equalsIgnoreCase(dateien[n])) {
                    return 2 + n;
                }
                ++n;
            }
        }
        return -1;
    }

    private static synchronized int getIndex() {
        return index;
    }

    public static synchronized boolean isDefault() {
        return Portfolios.getIndex() == 0;
    }

    private static synchronized String getName(int n) {
        if (n >= 2 && n < 2 + Portfolios.getAnzahlDateien()) {
            return dateien[n - 2].trim();
        }
        return "";
    }

    public static String fixFilename(String string) {
        if ((string = string.trim()).length() > 27) {
            string = string.substring(0, 27);
        }
        string = string.replace(';', '_');
        string = string.replace(':', '_');
        string = string.replace(',', '_');
        string = string.replace('/', '_');
        string = string.replace('\\', '_');
        string = string.replace('|', '_');
        string = string.replace('\"', '_');
        string = string.replace('*', '_');
        if ((string = string.replace('?', '_')).length() > 0 && string.charAt(0) == '-') {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.setCharAt(0, '_');
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String getNewFile(String string) {
        return String.valueOf(FileUtil.getAMDirectory(true)) + string + ".lst";
    }

    public static synchronized String getFileByIndex(int n) {
        if (n == 0) {
            return FileUtil.getDefaultPortfolioFile();
        }
        return String.valueOf(FileUtil.getAMDirectory(true)) + Portfolios.getName(n) + ".lst";
    }

    public static synchronized String getCurrentFile() {
        return Portfolios.getFileByIndex(Portfolios.getIndex());
    }

    public static synchronized String getCurrentName() {
        if (Portfolios.getIndex() == 0) {
            return NAME_DEFAULT;
        }
        return Portfolios.getName(Portfolios.getIndex());
    }

    public static synchronized String getCurrentWindowTitle() {
        if (Portfolios.getIndex() == 0) {
            return "";
        }
        return " - Portfolio \"" + Portfolios.getName(Portfolios.getIndex()) + "\"";
    }
}

