/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.MatchType;
import org.yccheok.jstock.engine.SearchEngine;
import org.yccheok.jstock.gui.Utils;

public class AjaxGoogleSearchEngine
implements SearchEngine<MatchType> {
    private final Gson gson = new Gson();
    private static final Log log = LogFactory.getLog(AjaxGoogleSearchEngine.class);

    @Override
    public List<MatchType> searchAll(String prefix) {
        StringBuilder builder = new StringBuilder("https://www.google.com/finance/match?matchtype=matchall&q=");
        try {
            builder.append(URLEncoder.encode(prefix, "UTF-8"));
            String location = builder.toString();
            String respond = Utils.getResponseBodyAsStringBasedOnProxyAuthOption(location);
            Holder value = (Holder)this.gson.fromJson(respond, Holder.class);
            if (value != null) {
                return Collections.unmodifiableList(value.matches);
            }
        }
        catch (UnsupportedEncodingException ex) {
            log.error(null, (Throwable)ex);
        }
        catch (Exception ex) {
            log.error(null, (Throwable)ex);
        }
        return Collections.emptyList();
    }

    @Override
    public MatchType search(String prefix) {
        List<MatchType> list = this.searchAll(prefix);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private static final class Holder {
        List<MatchType> matches;

        private Holder() {
        }
    }
}

