/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.yccheok.jstock.engine.BrazilYahooStockServerFactory;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.GoogleStockServerFactory;
import org.yccheok.jstock.engine.KLSEInfoStockServerFactory;
import org.yccheok.jstock.engine.StockServerFactory;
import org.yccheok.jstock.engine.YahooStockServerFactory;

public enum Factories {
    INSTANCE;

    private static final Map<Country, List<StockServerFactory>> map;
    private static final StockServerFactory klseInfoStockServerFactory;
    private static final Object klseInfoStockServerFactoryMonitor;

    public List<StockServerFactory> getStockServerFactories(Country country) {
        List<StockServerFactory> list = map.get((Object)country);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePrimaryStockServerFactory(Country country, Class<?> c) {
        Object object = klseInfoStockServerFactoryMonitor;
        synchronized (object) {
            List<StockServerFactory> stockServerFactories = map.get((Object)country);
            int index = 0;
            for (StockServerFactory stockServerFactory : stockServerFactories) {
                if (stockServerFactory.getClass().equals(c)) {
                    StockServerFactory tmp = stockServerFactories.get(0);
                    stockServerFactories.set(0, stockServerFactory);
                    stockServerFactories.set(index, tmp);
                    break;
                }
                ++index;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKLSEInfoStockServerFactory() {
        Object object = klseInfoStockServerFactoryMonitor;
        synchronized (object) {
            map.get((Object)Country.Malaysia).remove(klseInfoStockServerFactory);
        }
    }

    static {
        map = new EnumMap<Country, List<StockServerFactory>>(Country.class);
        klseInfoStockServerFactory = KLSEInfoStockServerFactory.newInstance();
        klseInfoStockServerFactoryMonitor = new Object();
        CopyOnWriteArrayList<StockServerFactory> australiaList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> austriaList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> belgiumList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> brazilList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> canadaList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> chinaList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> denmarkList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> franceList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> germanyList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> hongkongList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> indiaList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> indonesiaList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> israelList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> italyList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> koreaList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> malaysiaList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> netherlandsList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> newZealandList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> norwayList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> portugalList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> singaporeList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> spainList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> swedenList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> switzerlandList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> taiwanList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> unitedKingdomList = new CopyOnWriteArrayList<StockServerFactory>();
        CopyOnWriteArrayList<StockServerFactory> unitedStateList = new CopyOnWriteArrayList<StockServerFactory>();
        australiaList.add(YahooStockServerFactory.newInstance());
        austriaList.add(YahooStockServerFactory.newInstance());
        belgiumList.add(YahooStockServerFactory.newInstance());
        brazilList.add(BrazilYahooStockServerFactory.newInstance());
        canadaList.add(YahooStockServerFactory.newInstance());
        chinaList.add(GoogleStockServerFactory.newInstance(true));
        chinaList.add(YahooStockServerFactory.newInstance());
        denmarkList.add(YahooStockServerFactory.newInstance());
        franceList.add(YahooStockServerFactory.newInstance());
        germanyList.add(YahooStockServerFactory.newInstance());
        hongkongList.add(YahooStockServerFactory.newInstance());
        indiaList.add(GoogleStockServerFactory.newInstance(true));
        indonesiaList.add(YahooStockServerFactory.newInstance());
        israelList.add(YahooStockServerFactory.newInstance());
        italyList.add(YahooStockServerFactory.newInstance());
        koreaList.add(YahooStockServerFactory.newInstance());
        malaysiaList.add(klseInfoStockServerFactory);
        malaysiaList.add(YahooStockServerFactory.newInstance());
        netherlandsList.add(YahooStockServerFactory.newInstance());
        newZealandList.add(YahooStockServerFactory.newInstance());
        norwayList.add(YahooStockServerFactory.newInstance());
        portugalList.add(YahooStockServerFactory.newInstance());
        singaporeList.add(YahooStockServerFactory.newInstance());
        spainList.add(YahooStockServerFactory.newInstance());
        swedenList.add(YahooStockServerFactory.newInstance());
        switzerlandList.add(YahooStockServerFactory.newInstance());
        taiwanList.add(YahooStockServerFactory.newInstance());
        unitedKingdomList.add(YahooStockServerFactory.newInstance());
        unitedStateList.add(GoogleStockServerFactory.newInstance(false));
        unitedStateList.add(YahooStockServerFactory.newInstance());
        map.put(Country.Australia, australiaList);
        map.put(Country.Austria, austriaList);
        map.put(Country.Belgium, belgiumList);
        map.put(Country.Brazil, brazilList);
        map.put(Country.Canada, canadaList);
        map.put(Country.China, chinaList);
        map.put(Country.Denmark, denmarkList);
        map.put(Country.France, franceList);
        map.put(Country.Germany, germanyList);
        map.put(Country.HongKong, hongkongList);
        map.put(Country.India, indiaList);
        map.put(Country.Indonesia, indonesiaList);
        map.put(Country.Israel, israelList);
        map.put(Country.Italy, italyList);
        map.put(Country.Korea, koreaList);
        map.put(Country.Malaysia, malaysiaList);
        map.put(Country.Netherlands, netherlandsList);
        map.put(Country.NewZealand, newZealandList);
        map.put(Country.Norway, norwayList);
        map.put(Country.Portugal, portugalList);
        map.put(Country.Singapore, singaporeList);
        map.put(Country.Spain, spainList);
        map.put(Country.Sweden, swedenList);
        map.put(Country.Switzerland, switzerlandList);
        map.put(Country.Taiwan, taiwanList);
        map.put(Country.UnitedKingdom, unitedKingdomList);
        map.put(Country.UnitedState, unitedStateList);
    }
}

