/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.blobsallad.Controller;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.internationalization.GUIBundle;

public class AboutJDialog
extends JDialog {
    private final Thread checkForUpdateThread = new Thread(new Runnable(){

        @Override
        public void run() {
            Utils.ApplicationInfo applicationInfo = Utils.getLatestApplicationInfo();
            if (applicationInfo == null) {
                AboutJDialog.this.updateCheckForUpdateStatus(ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("AboutJDialog_UnknownUpdateStatus"));
            } else if (applicationInfo.applicationVersionID <= Utils.getApplicationVersionID()) {
                AboutJDialog.this.updateCheckForUpdateStatus(ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("AboutJDialog_JStockIsUpToDate"));
            } else {
                String url = applicationInfo.windowsDownloadLink;
                String name = System.getProperty("os.name").toLowerCase();
                if (name.startsWith("linux")) {
                    url = applicationInfo.linuxDownloadLink;
                } else if (name.startsWith("mac")) {
                    url = applicationInfo.macDownloadLink;
                } else if (name.startsWith("solaris") || name.startsWith("sun")) {
                    url = applicationInfo.solarisDownloadLink;
                }
                String template = GUIBundle.getString("AboutJDialog_JStockIsNotUpToDate_template");
                String message = MessageFormat.format(template, url);
                AboutJDialog.this.updateCheckForUpdateStatus(message);
            }
        }
    });
    private Controller controller = new Controller();
    private static final Log log = LogFactory.getLog(AboutJDialog.class);
    private JButton jButton1;
    private JEditorPane jEditorPane1;
    private JEditorPane jEditorPane2;
    private JEditorPane jEditorPane3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JTextArea jTextArea1;

    private void updateCheckForUpdateStatus(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.jEditorPane2.setText("<html><head></head><body>" + string + "</body></html>");
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AboutJDialog.this.jEditorPane2.setText("<html><head></head><body>" + string + "</body></html>");
                }
            });
        }
    }

    public AboutJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        String template = GUIBundle.getString("AboutJDialog_CheckingForUpdates..._template");
        String message = MessageFormat.format(template, Utils.toHTMLFileSrcFormat(Utils.getExtraDataDirectory() + "spinner.gif"));
        this.updateCheckForUpdateStatus(message);
        this.checkForUpdateThread.start();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel9 = new JPanel();
        this.jPanel10 = new JPanel();
        this.jEditorPane3 = new JEditorPane();
        this.jPanel2 = new JPanel();
        this.jEditorPane2 = new JEditorPane();
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPane1 = new JEditorPane();
        this.jPanel5 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jPanel6 = new JPanel();
        this.jPanel7 = this.controller.getView();
        this.jPanel8 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle(this.getVersionString());
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                AboutJDialog.this.formWindowClosed(evt);
            }
        });
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.jButton1.setText(bundle.getString("AboutJDialog_OK"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutJDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton1);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                AboutJDialog.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jPanel3.setLayout(new BorderLayout(2, 2));
        this.jLabel1.setForeground(new Color(0, 0, 255));
        this.jLabel1.setHorizontalAlignment(2);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/images/splash/jstock2-wording.png")));
        this.jLabel1.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.jPanel3.add((Component)this.jLabel1, "Center");
        this.jPanel9.setLayout(new GridLayout(2, 0));
        this.jEditorPane3.setEditable(false);
        this.jEditorPane3.setBackground(new Color(240, 240, 240));
        this.jEditorPane3.setContentType("text/html");
        this.jEditorPane3.setText(bundle.getString("AboutJDialog_Homepage"));
        this.jEditorPane3.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                AboutJDialog.this.jEditorPane1HyperlinkUpdate(evt);
            }
        });
        this.jPanel10.add(this.jEditorPane3);
        this.jPanel9.add(this.jPanel10);
        this.jEditorPane2.setBackground(new Color(240, 240, 240));
        this.jEditorPane2.setContentType("text/html");
        this.jEditorPane2.setEditable(false);
        this.jEditorPane2.setText(bundle.getString("AboutJDialog_CheckingForUpdates..."));
        this.jEditorPane2.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                AboutJDialog.this.jEditorPane1HyperlinkUpdate(evt);
            }
        });
        this.jPanel2.add(this.jEditorPane2);
        this.jPanel9.add(this.jPanel2);
        this.jPanel3.add((Component)this.jPanel9, "South");
        this.jTabbedPane1.addTab(bundle.getString("AboutJDialog_General"), this.jPanel3);
        this.jPanel4.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(null);
        this.jEditorPane1.setEditable(false);
        this.jEditorPane1.setContentType("text/html");
        this.jEditorPane1.setText("<html>\n<head>\n</head>\n    <body>\n        <p style=\"margin-top: 10; font-size: 9px; font-family: Tahoma;\"><u>Team Members of JStock Open Source Project :</u></p>\n        <p style=\"margin-top: 10; font-size: 9px; font-family: Tahoma;\"><b>Yan Cheng CHEOK</b>, <a href=\"mailto:yccheok@yahoo.com\">yccheok@yahoo.com</a>, Programmer and Project Admin.</p>\n        <p style=\"margin-top: 10; font-size: 9px; font-family: Tahoma;\"><b><a href=\"http://www.iconblock.com/\">The IconBlock Ltd</a></b>, Graphic Designer.</p>\n        <p style=\"margin-top: 10; font-size: 9px; font-family: Tahoma;\"><b>Shuwn Yuan Tee</b>, Programmer and Web Designer.</p>\n        <p style=\"margin-top: 10; font-size: 9px; font-family: Tahoma;\"><b>Stefan Angrick</b>, German Translator and English Translator.</p>\n        <p style=\"margin-top: 10; font-size: 9px; font-family: Tahoma;\"><b>Maurizio Da Lio</b>, Italian Translator.</p>\n        <p style=\"margin-top: 10; font-size: 9px; font-family: Tahoma;\"><b><a href=\"http://www.klse.info/?utm_source=jstock&utm_medium=about_box_link\">http://www.klse.info/</a></b>, Malaysia History Data Feed Sponsor.</p>\n        <p style=\"margin-top: 10; font-size: 9px; font-family: Tahoma;\"><b>Peter Gransdorfer</b>, Code Contributor.</p>\n        <p style=\"margin-top: 10; font-size: 9px; font-family: Tahoma;\"><b> Nanne Baars</b>, Code Contributor.</p>\n        <p style=\"margin-top: 10; font-size: 9px; font-family: Tahoma;\"><b>Mark DeSpain</b>, Code Contributor.</p>\n        <p style=\"margin-top: 10; font-size: 9px; font-family: Tahoma;\"><b>Carlo de Wolf</b>, Code Contributor.</p>\n        <p style=\"margin-top: 10; font-size: 9px; font-family: Tahoma;\"><b>bbuelte</b>, Code Contributor.</p>\n        <p style=\"margin-top: 10; font-size: 9px; font-family: Tahoma;\"><b>Vetsper Felix</b>, Code Contributor.</p>\n        <p style=\"margin-top: 10; font-size: 9px; font-family: Tahoma;\"><b>Peter Kane</b>, Code Contributor.</p>\n        <p style=\"margin-top: 10; font-size: 9px; font-family: Tahoma;\"><b>Karl Heinz Putz</b>, Mac Packager.</p>\n        <br>\n        <br>\n        <p style=\"margin-top: 10; font-size: 9px; font-family: Tahoma;\"><u>Used Libraries :</u></p>\n        <p style=\"margin-top: 10; font-size: 9px; font-family: Tahoma;\">\n        <a href=\"http://commons.apache.org/logging/\">Apache Common Logging</a> - Logging.<br>\n        <a href=\"http://hc.apache.org/httpclient-3.x/\">Apache HttpClient</a> - Http communication.<br>\n        <a href=\"http://poi.apache.org/\">Apache POI</a> - Excel file format.<br>\n        <a href=\"http://jstock.org/blobsallad/index.html\">blobsallad</a> - Java ported blob sallad by Yan Cheng Cheok. Original JavaScript version written by Bj\u00f6rn Lindberg.<br>\n        <a href=\"http://www.toedter.com/en/jcalendar/index.html\">JCalendar</a> - Calendar GUI component.<br>\n        <a href=\"http://www.jfree.org/jfreechart/\">JFreeChart</a> - Charting.<br>\n        <a href=\"https://jxlayer.dev.java.net/\">JXLayer</a> - Yellow information box and blue ball tracing.<br>\n        <a href=\"https://sourceforge.net/projects/jhotdraw/\">JHotDraw</a> - Indicator editor drawing.<br>\n        <a href=\"http://www.l2fprod.com/\">L2fProd</a> - Flashy looking GUI.<br>\n        <a href=\"http://www.jasypt.org/\">Jasypt</a> - Encryption.<br>\n        <a href=\"http://nachocalendar.sourceforge.net/\">NachoCalendar</a> - Calendar GUI component.<br>\n        <a href=\"http://opencsv.sourceforge.net/\">opencsv</a> - CSV file format.<br>\n        <a href=\"http://www.igniterealtime.org/projects/smack/index.jsp\">Smack</a> - XMPP messaging.<br>\n        <a href=\"https://swingx.dev.java.net/\">SwingX</a> - Flashy looking GUI.<br>\n        <a href=\"http://xstream.codehaus.org/\">XStream</a> - Serialization.<br>\n        </p>\n        <br>\n        <br>\n        <hr>\n        <p style=\"margin-top: 10; font-size: 8px; font-family: Tahoma;\">Wish to see your name being mentioned here? Feel free to visit <a href=\"http://sourceforge.net/projects/jstock\">http://sourceforge.net/projects/jstock</a> to see how you can contribute to JStock Open Source Project.</p>\n    </body>\n</html>");
        this.jEditorPane1.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                AboutJDialog.this.jEditorPane1HyperlinkUpdate(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jEditorPane1);
        this.jEditorPane1.setCaretPosition(0);
        this.jPanel4.add((Component)this.jScrollPane1, "Center");
        this.jTabbedPane1.addTab(bundle.getString("AboutJDialog_Credits"), this.jPanel4);
        this.jPanel5.setLayout(new BorderLayout());
        this.jScrollPane2.setBorder(null);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setFont(new Font("Monospaced", 0, 12));
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("\t\t    GNU GENERAL PUBLIC LICENSE\n\t\t       Version 2, June 1991\n\n Copyright (C) 1989, 1991 Free Software Foundation, Inc.,\n 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n Everyone is permitted to copy and distribute verbatim copies\n of this license document, but changing it is not allowed.\n\n\t\t\t    Preamble\n\n  The licenses for most software are designed to take away your\nfreedom to share and change it.  By contrast, the GNU General Public\nLicense is intended to guarantee your freedom to share and change free\nsoftware--to make sure the software is free for all its users.  This\nGeneral Public License applies to most of the Free Software\nFoundation's software and to any other program whose authors commit to\nusing it.  (Some other Free Software Foundation software is covered by\nthe GNU Lesser General Public License instead.)  You can apply it to\nyour programs, too.\n\n  When we speak of free software, we are referring to freedom, not\nprice.  Our General Public Licenses are designed to make sure that you\nhave the freedom to distribute copies of free software (and charge for\nthis service if you wish), that you receive source code or can get it\nif you want it, that you can change the software or use pieces of it\nin new free programs; and that you know you can do these things.\n\n  To protect your rights, we need to make restrictions that forbid\nanyone to deny you these rights or to ask you to surrender the rights.\nThese restrictions translate to certain responsibilities for you if you\ndistribute copies of the software, or if you modify it.\n\n  For example, if you distribute copies of such a program, whether\ngratis or for a fee, you must give the recipients all the rights that\nyou have.  You must make sure that they, too, receive or can get the\nsource code.  And you must show them these terms so they know their\nrights.\n\n  We protect your rights with two steps: (1) copyright the software, and\n(2) offer you this license which gives you legal permission to copy,\ndistribute and/or modify the software.\n\n  Also, for each author's protection and ours, we want to make certain\nthat everyone understands that there is no warranty for this free\nsoftware.  If the software is modified by someone else and passed on, we\nwant its recipients to know that what they have is not the original, so\nthat any problems introduced by others will not reflect on the original\nauthors' reputations.\n\n  Finally, any free program is threatened constantly by software\npatents.  We wish to avoid the danger that redistributors of a free\nprogram will individually obtain patent licenses, in effect making the\nprogram proprietary.  To prevent this, we have made it clear that any\npatent must be licensed for everyone's free use or not licensed at all.\n\n  The precise terms and conditions for copying, distribution and\nmodification follow.\n\n\t\t    GNU GENERAL PUBLIC LICENSE\n   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION\n\n  0. This License applies to any program or other work which contains\na notice placed by the copyright holder saying it may be distributed\nunder the terms of this General Public License.  The \"Program\", below,\nrefers to any such program or work, and a \"work based on the Program\"\nmeans either the Program or any derivative work under copyright law:\nthat is to say, a work containing the Program or a portion of it,\neither verbatim or with modifications and/or translated into another\nlanguage.  (Hereinafter, translation is included without limitation in\nthe term \"modification\".)  Each licensee is addressed as \"you\".\n\nActivities other than copying, distribution and modification are not\ncovered by this License; they are outside its scope.  The act of\nrunning the Program is not restricted, and the output from the Program\nis covered only if its contents constitute a work based on the\nProgram (independent of having been made by running the Program).\nWhether that is true depends on what the Program does.\n\n  1. You may copy and distribute verbatim copies of the Program's\nsource code as you receive it, in any medium, provided that you\nconspicuously and appropriately publish on each copy an appropriate\ncopyright notice and disclaimer of warranty; keep intact all the\nnotices that refer to this License and to the absence of any warranty;\nand give any other recipients of the Program a copy of this License\nalong with the Program.\n\nYou may charge a fee for the physical act of transferring a copy, and\nyou may at your option offer warranty protection in exchange for a fee.\n\n  2. You may modify your copy or copies of the Program or any portion\nof it, thus forming a work based on the Program, and copy and\ndistribute such modifications or work under the terms of Section 1\nabove, provided that you also meet all of these conditions:\n\n    a) You must cause the modified files to carry prominent notices\n    stating that you changed the files and the date of any change.\n\n    b) You must cause any work that you distribute or publish, that in\n    whole or in part contains or is derived from the Program or any\n    part thereof, to be licensed as a whole at no charge to all third\n    parties under the terms of this License.\n\n    c) If the modified program normally reads commands interactively\n    when run, you must cause it, when started running for such\n    interactive use in the most ordinary way, to print or display an\n    announcement including an appropriate copyright notice and a\n    notice that there is no warranty (or else, saying that you provide\n    a warranty) and that users may redistribute the program under\n    these conditions, and telling the user how to view a copy of this\n    License.  (Exception: if the Program itself is interactive but\n    does not normally print such an announcement, your work based on\n    the Program is not required to print an announcement.)\n\nThese requirements apply to the modified work as a whole.  If\nidentifiable sections of that work are not derived from the Program,\nand can be reasonably considered independent and separate works in\nthemselves, then this License, and its terms, do not apply to those\nsections when you distribute them as separate works.  But when you\ndistribute the same sections as part of a whole which is a work based\non the Program, the distribution of the whole must be on the terms of\nthis License, whose permissions for other licensees extend to the\nentire whole, and thus to each and every part regardless of who wrote it.\n\nThus, it is not the intent of this section to claim rights or contest\nyour rights to work written entirely by you; rather, the intent is to\nexercise the right to control the distribution of derivative or\ncollective works based on the Program.\n\nIn addition, mere aggregation of another work not based on the Program\nwith the Program (or with a work based on the Program) on a volume of\na storage or distribution medium does not bring the other work under\nthe scope of this License.\n\n  3. You may copy and distribute the Program (or a work based on it,\nunder Section 2) in object code or executable form under the terms of\nSections 1 and 2 above provided that you also do one of the following:\n\n    a) Accompany it with the complete corresponding machine-readable\n    source code, which must be distributed under the terms of Sections\n    1 and 2 above on a medium customarily used for software interchange; or,\n\n    b) Accompany it with a written offer, valid for at least three\n    years, to give any third party, for a charge no more than your\n    cost of physically performing source distribution, a complete\n    machine-readable copy of the corresponding source code, to be\n    distributed under the terms of Sections 1 and 2 above on a medium\n    customarily used for software interchange; or,\n\n    c) Accompany it with the information you received as to the offer\n    to distribute corresponding source code.  (This alternative is\n    allowed only for noncommercial distribution and only if you\n    received the program in object code or executable form with such\n    an offer, in accord with Subsection b above.)\n\nThe source code for a work means the preferred form of the work for\nmaking modifications to it.  For an executable work, complete source\ncode means all the source code for all modules it contains, plus any\nassociated interface definition files, plus the scripts used to\ncontrol compilation and installation of the executable.  However, as a\nspecial exception, the source code distributed need not include\nanything that is normally distributed (in either source or binary\nform) with the major components (compiler, kernel, and so on) of the\noperating system on which the executable runs, unless that component\nitself accompanies the executable.\n\nIf distribution of executable or object code is made by offering\naccess to copy from a designated place, then offering equivalent\naccess to copy the source code from the same place counts as\ndistribution of the source code, even though third parties are not\ncompelled to copy the source along with the object code.\n\n  4. You may not copy, modify, sublicense, or distribute the Program\nexcept as expressly provided under this License.  Any attempt\notherwise to copy, modify, sublicense or distribute the Program is\nvoid, and will automatically terminate your rights under this License.\nHowever, parties who have received copies, or rights, from you under\nthis License will not have their licenses terminated so long as such\nparties remain in full compliance.\n\n  5. You are not required to accept this License, since you have not\nsigned it.  However, nothing else grants you permission to modify or\ndistribute the Program or its derivative works.  These actions are\nprohibited by law if you do not accept this License.  Therefore, by\nmodifying or distributing the Program (or any work based on the\nProgram), you indicate your acceptance of this License to do so, and\nall its terms and conditions for copying, distributing or modifying\nthe Program or works based on it.\n\n  6. Each time you redistribute the Program (or any work based on the\nProgram), the recipient automatically receives a license from the\noriginal licensor to copy, distribute or modify the Program subject to\nthese terms and conditions.  You may not impose any further\nrestrictions on the recipients' exercise of the rights granted herein.\nYou are not responsible for enforcing compliance by third parties to\nthis License.\n\n  7. If, as a consequence of a court judgment or allegation of patent\ninfringement or for any other reason (not limited to patent issues),\nconditions are imposed on you (whether by court order, agreement or\notherwise) that contradict the conditions of this License, they do not\nexcuse you from the conditions of this License.  If you cannot\ndistribute so as to satisfy simultaneously your obligations under this\nLicense and any other pertinent obligations, then as a consequence you\nmay not distribute the Program at all.  For example, if a patent\nlicense would not permit royalty-free redistribution of the Program by\nall those who receive copies directly or indirectly through you, then\nthe only way you could satisfy both it and this License would be to\nrefrain entirely from distribution of the Program.\n\nIf any portion of this section is held invalid or unenforceable under\nany particular circumstance, the balance of the section is intended to\napply and the section as a whole is intended to apply in other\ncircumstances.\n\nIt is not the purpose of this section to induce you to infringe any\npatents or other property right claims or to contest validity of any\nsuch claims; this section has the sole purpose of protecting the\nintegrity of the free software distribution system, which is\nimplemented by public license practices.  Many people have made\ngenerous contributions to the wide range of software distributed\nthrough that system in reliance on consistent application of that\nsystem; it is up to the author/donor to decide if he or she is willing\nto distribute software through any other system and a licensee cannot\nimpose that choice.\n\nThis section is intended to make thoroughly clear what is believed to\nbe a consequence of the rest of this License.\n\n  8. If the distribution and/or use of the Program is restricted in\ncertain countries either by patents or by copyrighted interfaces, the\noriginal copyright holder who places the Program under this License\nmay add an explicit geographical distribution limitation excluding\nthose countries, so that distribution is permitted only in or among\ncountries not thus excluded.  In such case, this License incorporates\nthe limitation as if written in the body of this License.\n\n  9. The Free Software Foundation may publish revised and/or new versions\nof the General Public License from time to time.  Such new versions will\nbe similar in spirit to the present version, but may differ in detail to\naddress new problems or concerns.\n\nEach version is given a distinguishing version number.  If the Program\nspecifies a version number of this License which applies to it and \"any\nlater version\", you have the option of following the terms and conditions\neither of that version or of any later version published by the Free\nSoftware Foundation.  If the Program does not specify a version number of\nthis License, you may choose any version ever published by the Free Software\nFoundation.\n\n  10. If you wish to incorporate parts of the Program into other free\nprograms whose distribution conditions are different, write to the author\nto ask for permission.  For software which is copyrighted by the Free\nSoftware Foundation, write to the Free Software Foundation; we sometimes\nmake exceptions for this.  Our decision will be guided by the two goals\nof preserving the free status of all derivatives of our free software and\nof promoting the sharing and reuse of software generally.\n\n\t\t\t    NO WARRANTY\n\n  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY\nFOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN\nOTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES\nPROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED\nOR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF\nMERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS\nTO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE\nPROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,\nREPAIR OR CORRECTION.\n\n  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING\nWILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR\nREDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,\nINCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING\nOUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED\nTO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY\nYOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER\nPROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE\nPOSSIBILITY OF SUCH DAMAGES.\n\n\t\t     END OF TERMS AND CONDITIONS\n\n\t    How to Apply These Terms to Your New Programs\n\n  If you develop a new program, and you want it to be of the greatest\npossible use to the public, the best way to achieve this is to make it\nfree software which everyone can redistribute and change under these terms.\n\n  To do so, attach the following notices to the program.  It is safest\nto attach them to the start of each source file to most effectively\nconvey the exclusion of warranty; and each file should have at least\nthe \"copyright\" line and a pointer to where the full notice is found.\n\n    <one line to give the program's name and a brief idea of what it does.>\n    Copyright (C) <year>  <name of author>\n\n    This program is free software; you can redistribute it and/or modify\n    it under the terms of the GNU General Public License as published by\n    the Free Software Foundation; either version 2 of the License, or\n    (at your option) any later version.\n\n    This program is distributed in the hope that it will be useful,\n    but WITHOUT ANY WARRANTY; without even the implied warranty of\n    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n    GNU General Public License for more details.\n\n    You should have received a copy of the GNU General Public License along\n    with this program; if not, write to the Free Software Foundation, Inc.,\n    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.\n\nAlso add information on how to contact you by electronic and paper mail.\n\nIf the program is interactive, make it output a short notice like this\nwhen it starts in an interactive mode:\n\n    Gnomovision version 69, Copyright (C) year name of author\n    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.\n    This is free software, and you are welcome to redistribute it\n    under certain conditions; type `show c' for details.\n\nThe hypothetical commands `show w' and `show c' should show the appropriate\nparts of the General Public License.  Of course, the commands you use may\nbe called something other than `show w' and `show c'; they could even be\nmouse-clicks or menu items--whatever suits your program.\n\nYou should also get your employer (if you work as a programmer) or your\nschool, if any, to sign a \"copyright disclaimer\" for the program, if\nnecessary.  Here is a sample; alter the names:\n\n  Yoyodyne, Inc., hereby disclaims all copyright interest in the program\n  `Gnomovision' (which makes passes at compilers) written by James Hacker.\n\n  <signature of Ty Coon>, 1 April 1989\n  Ty Coon, President of Vice\n\nThis General Public License does not permit incorporating your program into\nproprietary programs.  If your program is a subroutine library, you may\nconsider it more useful to permit linking proprietary applications with the\nlibrary.  If this is what you want to do, use the GNU Lesser General\nPublic License instead of this License.\n");
        this.jScrollPane2.setViewportView(this.jTextArea1);
        this.jTextArea1.setCaretPosition(0);
        this.jPanel5.add((Component)this.jScrollPane2, "Center");
        this.jTabbedPane1.addTab(bundle.getString("AboutJDialog_License"), this.jPanel5);
        this.jPanel6.setLayout(new BorderLayout(2, 2));
        this.jPanel6.add((Component)this.jPanel7, "Center");
        this.jPanel8.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.jPanel8.setLayout(new GridLayout(2, 0));
        this.jLabel2.setText(bundle.getString("AboutJDialog_MoveAroundBlobWithArrowKeysOrMouse"));
        this.jPanel8.add(this.jLabel2);
        this.jLabel2.getAccessibleContext().setAccessibleName(bundle.getString("AboutJDialog_MoveAroundBlobWithArrowKeysOrMouse"));
        this.jLabel3.setText(bundle.getString("AboutJDialog_SplitBlobWithHJoinBlobsWithJTurnGravityOnOffWithG"));
        this.jPanel8.add(this.jLabel3);
        this.jLabel3.getAccessibleContext().setAccessibleName(bundle.getString("AboutJDialog_SplitBlobWithHJoinBlobsWithJTurnGravityOnOffWithG"));
        this.jPanel6.add((Component)this.jPanel8, "South");
        this.jTabbedPane1.addTab(bundle.getString("AboutJDialog_Blobsallad"), this.jPanel6);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.setSize(new Dimension(525, 534));
        this.setLocationRelativeTo(null);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jEditorPane1HyperlinkUpdate(HyperlinkEvent evt) {
        Utils.launchWebBrowser(evt);
    }

    private void formWindowClosed(WindowEvent evt) {
        this.controller.stop();
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        JTabbedPane pane = (JTabbedPane)evt.getSource();
        if (pane.getSelectedComponent() == this.jPanel6) {
            this.controller.requestFocus();
        }
    }

    private String getVersionString() {
        return MessageFormat.format(GUIBundle.getString("AboutJDialog_AboutJStock_template"), Utils.getAboutBoxVersionString());
    }
}

