/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXHeader;
import org.yccheok.jstock.gui.Icons;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.gui.analysis.MemoryLogJDialog;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.internationalization.MessagesBundle;

public class LoadFromCloudJDialog
extends JDialog {
    private volatile SwingWorker<Boolean, Status> loadFromCloudTask = null;
    private final List<String> memoryLog = new ArrayList<String>();
    private static final Log log = LogFactory.getLog(LoadFromCloudJDialog.class);
    private JButton jButton1;
    private JButton jButton2;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPasswordField jPasswordField1;
    private JTextField jTextField1;
    private JXHeader jXHeader1;

    public LoadFromCloudJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jLabel3.setVisible(false);
        this.jLabel4.setVisible(false);
        this.jLabel5.setVisible(false);
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        if (jStockOptions.isRememberGoogleAccountEnabled()) {
            this.jCheckBox1.setSelected(true);
            this.jTextField1.setText(Utils.decrypt(jStockOptions.getGoogleUsername()));
            this.jPasswordField1.setText(Utils.decrypt(jStockOptions.getGooglePassword()));
        }
    }

    private void initComponents() {
        this.jPanel6 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jXHeader1 = new JXHeader();
        this.jPanel3 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jPasswordField1 = new JPasswordField();
        this.jLabel6 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.setTitle(bundle.getString("LoadFromCloudJDialog_Title"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                LoadFromCloudJDialog.this.formWindowClosed(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add((Component)this.jPanel6, "West");
        this.getContentPane().add((Component)this.jPanel5, "East");
        this.jXHeader1.setDescription(bundle.getString("LoadFromCloudJDialog_Description"));
        this.jXHeader1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/32x32/download_from_cloud.png")));
        this.jXHeader1.setTitle(bundle.getString("LoadFromCloudJDialog_Title"));
        this.getContentPane().add((Component)this.jXHeader1, "North");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/apply.png")));
        this.jButton1.setText(bundle.getString("LoadFromCloudJDialog_OK"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadFromCloudJDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton1);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/button_cancel.png")));
        this.jButton2.setText(bundle.getString("LoadFromCloudJDialog_Cancel"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadFromCloudJDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton2);
        this.getContentPane().add((Component)this.jPanel3, "Last");
        this.jPanel1.setLayout(new BorderLayout(5, 5));
        this.jPanel4.setLayout(new FlowLayout(0));
        this.jLabel3.setForeground(new Color(0, 0, 255));
        this.jLabel3.setText(bundle.getString("LoadFromCloudJDialog_LoadingFromCloud..."));
        this.jPanel4.add(this.jLabel3);
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/spinner.gif")));
        this.jPanel4.add(this.jLabel4);
        this.jLabel5.setText(bundle.getString("WizardDownloadlIndicatorJPanel_ViewLog"));
        this.jLabel3.setVisible(false);
        this.jLabel5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LoadFromCloudJDialog.this.jLabel5MouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                LoadFromCloudJDialog.this.jLabel5MouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                LoadFromCloudJDialog.this.jLabel5MouseExited(evt);
            }
        });
        this.jPanel4.add(this.jLabel5);
        this.jPanel1.add((Component)this.jPanel4, "South");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("LoadFromCloudJDialog_GoogleAccount")));
        this.jLabel1.setText(bundle.getString("LoadFromCloudJDialog_Username"));
        this.jTextField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadFromCloudJDialog.this.jTextField1ActionPerformed(evt);
            }
        });
        this.jLabel2.setText(bundle.getString("SaveToCloudJDialog_Password"));
        this.jPasswordField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadFromCloudJDialog.this.jPasswordField1ActionPerformed(evt);
            }
        });
        this.jLabel6.setFont(this.jLabel6.getFont().deriveFont((float)this.jLabel6.getFont().getSize() - 1.0f));
        this.jLabel6.setText(bundle.getString("LoadFromCloudJDialog_EmailExample"));
        this.jCheckBox1.setText(bundle.getString("LoadFromCloudJDialog_KeepMeSignedIn"));
        this.jLabel7.setForeground(new Color(255, 0, 0));
        this.jLabel7.setText(bundle.getString("LoadFromCloudJDialog_WarningAllYourDataWillBeOverwriteByCloudData"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox1).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGap(10, 10, 10).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPasswordField1, -1, 177, Short.MAX_VALUE).addComponent(this.jTextField1, -1, 177, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6)).addComponent(this.jLabel7)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jPasswordField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox1).addContainerGap(12, Short.MAX_VALUE)));
        this.jPanel1.add((Component)this.jPanel2, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 420) / 2, (screenSize.height - 334) / 2, 420, 334);
    }

    private void formWindowClosed(WindowEvent evt) {
        this.cancel();
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        if (!this.jCheckBox1.isSelected()) {
            jStockOptions.setRememberGoogleAccountEnabled(false);
            jStockOptions.setGoogleUsername("");
            jStockOptions.setGooglePassword("");
        }
    }

    private void cancel() {
        if (this.loadFromCloudTask != null) {
            this.loadFromCloudTask.cancel(true);
            this.loadFromCloudTask = null;
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jLabel5MouseClicked(MouseEvent evt) {
        MemoryLogJDialog memoryLogJDialog = new MemoryLogJDialog((Frame)MainFrame.getInstance(), true);
        memoryLogJDialog.setLocationRelativeTo(this);
        memoryLogJDialog.setLog(this.memoryLog);
        memoryLogJDialog.setVisible(true);
    }

    private void jLabel5MouseEntered(MouseEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void jLabel5MouseExited(MouseEvent evt) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        String username = this.jTextField1.getText().trim();
        if (username.length() == 0) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_username_cannot_be_empty"), MessagesBundle.getString("warning_title_username_cannot_be_empty"), 2);
            this.jTextField1.requestFocus();
            return;
        }
        if ((username = Utils.toEmailIfPossible(username)) == null) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_invalid_email_address"), MessagesBundle.getString("warning_title_invalid_email_address"), 2);
            this.jTextField1.requestFocus();
            return;
        }
        if (this.jPasswordField1.getPassword().length == 0) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_password_cannot_be_empty"), MessagesBundle.getString("warning_title_password_cannot_be_empty"), 2);
            this.jPasswordField1.requestFocus();
            return;
        }
        if (new String(this.jPasswordField1.getPassword()).trim().length() == 0) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_password_cannot_be_empty"), MessagesBundle.getString("warning_title_password_cannot_be_empty"), 2);
            this.jPasswordField1.requestFocus();
            return;
        }
        this.jButton1.setEnabled(false);
        this.jTextField1.setEnabled(false);
        this.jPasswordField1.setEnabled(false);
        this.jCheckBox1.setEnabled(false);
        this.jLabel3.setText(GUIBundle.getString("LoadFromCloudJDialog_LoadingFromCloud..."));
        this.jLabel4.setIcon(Icons.BUSY);
        this.jLabel3.setVisible(true);
        this.jLabel4.setVisible(true);
        this.loadFromCloudTask = this.getLoadFromCloudTask(username);
        this.loadFromCloudTask.execute();
    }

    private void jPasswordField1ActionPerformed(ActionEvent evt) {
        this.jButton1ActionPerformed(evt);
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
        this.jButton1ActionPerformed(evt);
    }

    private SwingWorker<Boolean, Status> getLoadFromCloudTask(final String username) {
        SwingWorker<Boolean, Status> worker = new SwingWorker<Boolean, Status>(){

            @Override
            protected void done() {
                boolean result = false;
                if (!this.isCancelled()) {
                    try {
                        result = (Boolean)this.get();
                    }
                    catch (InterruptedException ex) {
                        log.error(null, (Throwable)ex);
                    }
                    catch (ExecutionException ex) {
                        log.error(null, (Throwable)ex);
                    }
                    catch (CancellationException ex) {
                        log.error(null, (Throwable)ex);
                    }
                }
                LoadFromCloudJDialog.this.jButton1.setEnabled(true);
                LoadFromCloudJDialog.this.jTextField1.setEnabled(true);
                LoadFromCloudJDialog.this.jPasswordField1.setEnabled(true);
                LoadFromCloudJDialog.this.jCheckBox1.setEnabled(true);
                if (result) {
                    JOptionPane.showMessageDialog(LoadFromCloudJDialog.this, GUIBundle.getString("LoadFromCloudJDialog_Success"));
                    JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
                    if (LoadFromCloudJDialog.this.jCheckBox1.isSelected()) {
                        jStockOptions.setRememberGoogleAccountEnabled(true);
                        jStockOptions.setGoogleUsername(Utils.encrypt(username));
                        jStockOptions.setGooglePassword(Utils.encrypt(new String(LoadFromCloudJDialog.this.jPasswordField1.getPassword())).trim());
                    }
                    LoadFromCloudJDialog.this.setVisible(false);
                    LoadFromCloudJDialog.this.dispose();
                }
            }

            @Override
            protected void process(List<Status> statuses) {
                for (Status status : statuses) {
                    LoadFromCloudJDialog.this.writeToMemoryLog(status.message);
                    LoadFromCloudJDialog.this.jLabel3.setText(status.message);
                    LoadFromCloudJDialog.this.jLabel4.setIcon(status.icon);
                    LoadFromCloudJDialog.this.jLabel3.setVisible(true);
                    LoadFromCloudJDialog.this.jLabel4.setVisible(true);
                    if (status.icon == Icons.ERROR || status.icon == Icons.WARNING) {
                        LoadFromCloudJDialog.this.jLabel3.setForeground(Color.RED);
                        LoadFromCloudJDialog.this.jLabel5.setVisible(true);
                        continue;
                    }
                    LoadFromCloudJDialog.this.jLabel3.setForeground(Color.BLUE);
                    LoadFromCloudJDialog.this.jLabel5.setVisible(false);
                }
            }

            @Override
            protected Boolean doInBackground() {
                File f;
                JStockOptions jStockOptions;
                if (this.isCancelled()) {
                    return false;
                }
                LoadFromCloudJDialog.this.memoryLog.clear();
                this.publish(Status.newInstance(GUIBundle.getString("LoadFromCloudJDialog_LoadingFromCloud..."), Icons.BUSY));
                String password = new String(LoadFromCloudJDialog.this.jPasswordField1.getPassword()).trim();
                Utils.CloudFile cloudFile = Utils.loadFromGoogleDoc(username, password);
                if (cloudFile == null) {
                    cloudFile = Utils.loadFromCloud(username, password);
                    if (cloudFile == null) {
                        this.publish(Status.newInstance(GUIBundle.getString("LoadFromCloudJDialog_LoadingFromCloudFail"), Icons.ERROR));
                        return false;
                    }
                    if (!Utils.saveToGoogleDoc(username, password, cloudFile.file)) {
                        LoadFromCloudJDialog.this.showMessageBoxWithGoogleDocLink();
                    } else {
                        JOptionPane.showMessageDialog(LoadFromCloudJDialog.this, MessagesBundle.getString("info_message_migration_to_google_doc_server_success"), MessagesBundle.getString("info_title_migration_to_google_doc_server_success"), 1);
                    }
                }
                if (cloudFile.checksum != org.yccheok.jstock.analysis.Utils.getChecksum(cloudFile.file)) {
                    this.publish(Status.newInstance(GUIBundle.getString("LoadFromCloudJDialog_CheckingCheckSumFail"), Icons.ERROR));
                    return false;
                }
                long today = new Date().getTime();
                long milli_seconds_in_a_day = 86400000L;
                if (today / 86400000L != cloudFile.date / 86400000L) {
                    DateFormat dateFormat = DateFormat.getDateInstance();
                    String message = MessageFormat.format(MessagesBundle.getString("question_message_overwrite_your_data_by_cloud_data_at_template"), dateFormat.format(cloudFile.date));
                    int result = JOptionPane.showConfirmDialog(LoadFromCloudJDialog.this, message, MessagesBundle.getString("question_title_overwrite_your_data_by_cloud_data_at"), 0);
                    if (result != 0) {
                        this.publish(Status.newInstance(GUIBundle.getString("LoadFromCloudJDialog_UserRefuseToOverwriteWithOldData"), Icons.ERROR));
                        return false;
                    }
                }
                if (!Utils.isCloudFileCompatible(cloudFile.version)) {
                    String message = MessageFormat.format(GUIBundle.getString("LoadFromCloudJDialog_VersionNotCompatible_template"), cloudFile.version);
                    this.publish(Status.newInstance(message, Icons.ERROR));
                    return false;
                }
                if (this.isCancelled()) {
                    return false;
                }
                this.publish(Status.newInstance(GUIBundle.getString("LoadFromCloudJDialog_ExtractingData..."), Icons.BUSY));
                boolean status = Utils.extractZipFile(cloudFile.file, true);
                if (this.isCancelled()) {
                    return false;
                }
                if (!status) {
                    this.publish(Status.newInstance(GUIBundle.getString("LoadFromCloudJDialog_ExtractingDataFail"), Icons.ERROR));
                }
                if ((jStockOptions = Utils.fromXML(JStockOptions.class, f = new File(Utils.getUserDataDirectory() + "config" + File.separator + "options.xml"))) != null) {
                    MainFrame.getInstance().getJStockOptions().insensitiveCopy(jStockOptions);
                }
                MainFrame.getInstance().reloadAfterDownloadFromCloud();
                this.publish(Status.newInstance(GUIBundle.getString("LoadFromCloudJDialog_Success"), Icons.OK));
                return status;
            }
        };
        return worker;
    }

    private void writeToMemoryLog(String message) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss a");
        String s = dateFormat.format(new Date()) + "\n" + message;
        this.memoryLog.add(s);
    }

    private void showMessageBoxWithGoogleDocLink() {
        JLabel label = new JLabel();
        Font font = label.getFont();
        StringBuilder style = new StringBuilder("font-family:" + font.getFamily() + ";");
        style.append("font-weight:").append(font.isBold() ? "bold" : "normal").append(";");
        style.append("font-size:").append(font.getSize()).append("pt;");
        String html = MessageFormat.format(MessagesBundle.getString("info_message_register_google_doc"), style);
        JEditorPane ep = new JEditorPane("text/html", html);
        ep.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                Utils.launchWebBrowser(e);
            }
        });
        ep.setEditable(false);
        ep.setBackground(label.getBackground());
        JOptionPane.showMessageDialog(null, ep, MessagesBundle.getString("info_title_register_google_doc"), 1);
    }

    private static class Status {
        public final String message;
        public final Icon icon;

        private Status(String message, Icon icon) {
            if (message == null || icon == null) {
                throw new IllegalArgumentException("Method arguments cannot be null");
            }
            this.message = message;
            this.icon = icon;
        }

        public static Status newInstance(String message, Icon icon) {
            return new Status(message, icon);
        }
    }
}

