/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.border.DropShadowBorder;
import org.yccheok.jstock.alert.GoogleCalendar;
import org.yccheok.jstock.alert.GoogleMail;
import org.yccheok.jstock.alert.SMSLimiter;
import org.yccheok.jstock.analysis.Indicator;
import org.yccheok.jstock.analysis.OperatorIndicator;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.Duration;
import org.yccheok.jstock.engine.Factories;
import org.yccheok.jstock.engine.Index;
import org.yccheok.jstock.engine.Market;
import org.yccheok.jstock.engine.MarketServer;
import org.yccheok.jstock.engine.MatchType;
import org.yccheok.jstock.engine.Observer;
import org.yccheok.jstock.engine.RealTimeStockMonitor;
import org.yccheok.jstock.engine.ResultType;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockHistoryMonitor;
import org.yccheok.jstock.engine.StockHistorySerializer;
import org.yccheok.jstock.engine.StockHistoryServer;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.StockInfoDatabase;
import org.yccheok.jstock.engine.StockNameDatabase;
import org.yccheok.jstock.engine.StockServerFactory;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.file.Atom;
import org.yccheok.jstock.file.GUIBundleWrapper;
import org.yccheok.jstock.file.Statement;
import org.yccheok.jstock.file.Statements;
import org.yccheok.jstock.gui.AboutJDialog;
import org.yccheok.jstock.gui.AjaxServiceProvider;
import org.yccheok.jstock.gui.AlertStateManager;
import org.yccheok.jstock.gui.AppLock;
import org.yccheok.jstock.gui.AutoCompleteJComboBox;
import org.yccheok.jstock.gui.AutoUpdateNewsJDialog;
import org.yccheok.jstock.gui.CountryJDialog;
import org.yccheok.jstock.gui.GUIOptions;
import org.yccheok.jstock.gui.IndicatorPanel;
import org.yccheok.jstock.gui.IndicatorProjectManager;
import org.yccheok.jstock.gui.IndicatorScannerJPanel;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.JTableUtilities;
import org.yccheok.jstock.gui.LoadFromCloudJDialog;
import org.yccheok.jstock.gui.MarketJPanel;
import org.yccheok.jstock.gui.MyJXStatusBar;
import org.yccheok.jstock.gui.OptionsJDialog;
import org.yccheok.jstock.gui.Pair;
import org.yccheok.jstock.gui.PortfolioManagementJPanel;
import org.yccheok.jstock.gui.SaveToCloudJDialog;
import org.yccheok.jstock.gui.StockAlert;
import org.yccheok.jstock.gui.StockDatabaseJDialog;
import org.yccheok.jstock.gui.StockJDialog;
import org.yccheok.jstock.gui.StockTableCellRenderer;
import org.yccheok.jstock.gui.StockTableModel;
import org.yccheok.jstock.gui.TableColumnSelectionPopupListener;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.gui.charting.ChartJDialog;
import org.yccheok.jstock.gui.charting.ChartJDialogOptions;
import org.yccheok.jstock.gui.charting.DynamicChart;
import org.yccheok.jstock.gui.portfolio.Calc;
import org.yccheok.jstock.gui.portfolio.PortfolioJDialog;
import org.yccheok.jstock.gui.table.NonNegativeDoubleEditor;
import org.yccheok.jstock.gui.watchlist.WatchlistJDialog;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.internationalization.MessagesBundle;
import org.yccheok.jstock.network.ProxyDetector;
import org.yccheok.jstock.network.Utils;
import org.yccheok.jstock.portfolio.PortfolioInfo;
import org.yccheok.jstock.watchlist.WatchlistInfo;

public class MainFrame
extends JFrame {
    private TrayIcon trayIcon;
    private static final Log log;
    private MyJXStatusBar statusBar = new MyJXStatusBar();
    private boolean isStatusBarBusy = false;
    private Set<Code> stockCodeHistoryGUI = new HashSet<Code>();
    private volatile StockInfoDatabase stockInfoDatabase = null;
    private volatile StockNameDatabase stockNameDatabase = null;
    private RealTimeStockMonitor realTimeStockMonitor = null;
    private StockHistoryMonitor stockHistoryMonitor = null;
    private DatabaseTask databaseTask = null;
    private final Object databaseTaskMonitor = new Object();
    private LatestNewsTask latestNewsTask = null;
    private volatile Thread marketThread = null;
    private Thread klseInfoStockServerFactoryThread = null;
    private JStockOptions jStockOptions;
    private ChartJDialogOptions chartJDialogOptions;
    private IndicatorPanel indicatorPanel;
    private IndicatorScannerJPanel indicatorScannerJPanel;
    private PortfolioManagementJPanel portfolioManagementJPanel;
    private final AlertStateManager alertStateManager = new AlertStateManager();
    private ExecutorService emailAlertPool = Executors.newFixedThreadPool(1);
    private ExecutorService smsAlertPool = Executors.newFixedThreadPool(1);
    private ExecutorService systemTrayAlertPool = Executors.newFixedThreadPool(1);
    private volatile ExecutorService stockInfoDatabaseMetaPool = Executors.newFixedThreadPool(1);
    private final Observer<RealTimeStockMonitor, List<Stock>> realTimeStockMonitorObserver = this.getRealTimeStockMonitorObserver();
    private final Observer<StockHistoryMonitor, StockHistoryMonitor.StockHistoryRunnable> stockHistoryMonitorObserver = this.getStockHistoryMonitorObserver();
    private final Observer<Indicator, Boolean> alertStateManagerObserver = this.getAlertStateManagerObserver();
    private final ImageIcon smileIcon = this.getImageIcon("/images/16x16/smile.png");
    private final ImageIcon smileGrayIcon = this.getImageIcon("/images/16x16/smile-gray.png");
    private Executor zombiePool = Utils.getZoombiePool();
    private MarketJPanel marketJPanel;
    private Map<Code, DynamicChart> dynamicCharts = new ConcurrentHashMap<Code, DynamicChart>();
    private static final int MAX_DYNAMIC_CHART_SIZE = 10;
    private static final DynamicChart EMPTY_DYNAMIC_CHART;
    private final MouseAdapter dynamicChartMouseAdapter = this.getDynamicChartMouseAdapter();
    private static final int HISTORY_MONITOR_MAX_THREAD = 4;
    private static final Indicator FALL_BELOW_INDICATOR;
    private static final Indicator RISE_ABOVE_INDICATOR;
    private volatile boolean needToSaveUserDefinedDatabase = false;
    private volatile boolean isFormWindowClosedCalled = false;
    private long timestamp = 0L;
    private boolean refreshPriceInProgress = false;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JMenu jMenu1;
    private JMenu jMenu10;
    private JMenu jMenu11;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenu jMenu5;
    private JMenu jMenu6;
    private JMenu jMenu7;
    private JMenu jMenu8;
    private JMenu jMenu9;
    private JMenuBar jMenuBar2;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem10;
    private JMenuItem jMenuItem11;
    private JMenuItem jMenuItem12;
    private JMenuItem jMenuItem13;
    private JMenuItem jMenuItem14;
    private JMenuItem jMenuItem15;
    private JMenuItem jMenuItem16;
    private JMenuItem jMenuItem17;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem8;
    private JMenuItem jMenuItem9;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel6;
    private JPanel jPanel8;
    private JRadioButtonMenuItem jRadioButtonMenuItem1;
    private JRadioButtonMenuItem jRadioButtonMenuItem2;
    private JRadioButtonMenuItem jRadioButtonMenuItem3;
    private JRadioButtonMenuItem jRadioButtonMenuItem4;
    private JRadioButtonMenuItem jRadioButtonMenuItem5;
    private JRadioButtonMenuItem jRadioButtonMenuItem6;
    private JScrollPane jScrollPane1;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JPopupMenu.Separator jSeparator8;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;

    private MainFrame() {
    }

    private void init() {
        try {
            UIManager.setLookAndFeel(this.getJStockOptions().getLooknFeel());
        }
        catch (ClassNotFoundException exp) {
            log.error(null, (Throwable)exp);
        }
        catch (InstantiationException exp) {
            log.error(null, (Throwable)exp);
        }
        catch (IllegalAccessException exp) {
            log.error(null, (Throwable)exp);
        }
        catch (UnsupportedLookAndFeelException exp) {
            log.error(null, (Throwable)exp);
        }
        this.initComponents();
        this.createLookAndFeelMenuItem();
        this.createCountryMenuItem();
        this.createStockIndicatorEditor();
        this.createIndicatorScannerJPanel();
        this.createPortfolioManagementJPanel();
        this.createIconsAndToolTipTextForJTabbedPane();
        this.createSystemTrayIcon();
        this.initPreloadDatabase(false);
        this.initExtraDatas();
        this.initStatusBar();
        this.initMarketJPanel();
        this.initTableHeaderToolTips();
        this.initMyJXStatusBarExchangeRateLabelMouseAdapter();
        this.initMyJXStatusBarCountryLabelMouseAdapter();
        this.initMyJXStatusBarImageLabelMouseAdapter();
        this.initStockInfoDatabaseMeta();
        this.initDatabase(true);
        this.initAjaxProvider();
        this.initMarketThread();
        this.initLatestNewsTask();
        this.initKLSEInfoStockServerFactoryThread();
        this.initCurrencyExchangeMonitor();
        this.initRealTimeStockMonitor();
        this.initWatchlist();
        this.initAlertStateManager();
        this.initDynamicCharts();
        this.initDynamicChartVisibility();
        this.initStockHistoryMonitor();
        this.initOthersStockHistoryMonitor();
        this.initBrokingFirmLogos();
        this.initGUIOptions();
        this.initChartJDialogOptions();
        this.initLanguageMenuItemsSelection();
        this.initJXLayerOnJComboBox();
        this.initKeyBindings();
        int lastSelectedPageIndex = this.getJStockOptions().getLastSelectedPageIndex();
        if (this.jTabbedPane1.getTabCount() > lastSelectedPageIndex) {
            this.jTabbedPane1.setSelectedIndex(lastSelectedPageIndex);
        }
        this.handleJTabbedPaneStateChanged(this.jTabbedPane1);
        JStockOptions.BoundsEx boundsEx = this.jStockOptions.getBoundsEx();
        if (boundsEx == null) {
            this.setExtendedState(6);
        } else if ((boundsEx.extendedState & 6) == 6) {
            this.setExtendedState(6);
        } else {
            this.setBounds(boundsEx.bounds);
        }
        this.installShutdownHook();
        if (this.jStockOptions.getCountry() == Country.Spain) {
            JOptionPane.showMessageDialog(null, MessagesBundle.getString("info_message_spain_not_supported"), MessagesBundle.getString("info_title_spain_not_supported"), 1);
        }
    }

    private void requestFocusOnJComboBox() {
        this.jComboBox1.getEditor().getEditorComponent().requestFocus();
    }

    private void initKeyBindings() {
        KeyStroke watchlistNavigationKeyStroke = KeyStroke.getKeyStroke(87, 2);
        KeyStroke portfolioNavigationKeyStroke = KeyStroke.getKeyStroke(80, 2);
        this.getRootPane().getInputMap(2).put(watchlistNavigationKeyStroke, "watchlistNavigation");
        this.getRootPane().getInputMap(2).put(portfolioNavigationKeyStroke, "portfolioNavigation");
        this.getRootPane().getActionMap().put("watchlistNavigation", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.watchlistNavigation();
            }
        });
        this.getRootPane().getActionMap().put("portfolioNavigation", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.portfolioNavigation();
            }
        });
    }

    private void watchlistNavigation() {
        int index;
        if (this.getSelectedComponent() != this.jPanel8) {
            this.jTabbedPane1.setSelectedIndex(0);
            return;
        }
        List<String> watchlistNames = org.yccheok.jstock.watchlist.Utils.getWatchlistNames();
        int size = watchlistNames.size();
        if (size <= 1) {
            return;
        }
        String currentWatchlistName = this.getJStockOptions().getWatchlistName();
        for (index = 0; index < size; ++index) {
            if (!watchlistNames.get(index).equals(currentWatchlistName)) continue;
            if (++index < size) break;
            index = 0;
            break;
        }
        this.selectActiveWatchlist(watchlistNames.get(index));
    }

    private void portfolioNavigation() {
        int index;
        if (this.getSelectedComponent() != this.portfolioManagementJPanel) {
            this.jTabbedPane1.setSelectedIndex(3);
            return;
        }
        List<String> portfolioNames = org.yccheok.jstock.portfolio.Utils.getPortfolioNames();
        int size = portfolioNames.size();
        if (size <= 1) {
            return;
        }
        String currentPortfolioName = this.getJStockOptions().getPortfolioName();
        for (index = 0; index < size; ++index) {
            if (!portfolioNames.get(index).equals(currentPortfolioName)) continue;
            if (++index < size) break;
            index = 0;
            break;
        }
        this.selectActivePortfolio(portfolioNames.get(index));
    }

    private void installShutdownHook() {
        if (Utils.isMacOSX()) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    if (MainFrame.this.isFormWindowClosedCalled) {
                        AppLock.unlock();
                        return;
                    }
                    MainFrame.this.formWindowClosed(null);
                    AppLock.unlock();
                }
            };
            Runtime.getRuntime().addShutdownHook(new Thread(runner, "Window Prefs Hook"));
        } else {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    AppLock.unlock();
                }
            };
            Runtime.getRuntime().addShutdownHook(new Thread(runner, "Window Prefs Hook"));
        }
    }

    private void initLanguageMenuItemsSelection() {
        Locale defaultLocale = Locale.getDefault();
        if (Utils.isTraditionalChinese(defaultLocale)) {
            this.jRadioButtonMenuItem4.setSelected(true);
        } else if (Utils.isSimplifiedChinese(defaultLocale)) {
            this.jRadioButtonMenuItem2.setSelected(true);
        } else if (defaultLocale.getLanguage().equals(Locale.GERMAN.getLanguage())) {
            this.jRadioButtonMenuItem3.setSelected(true);
        } else if (defaultLocale.getLanguage().equals(Locale.ITALIAN.getLanguage())) {
            this.jRadioButtonMenuItem5.setSelected(true);
        } else {
            this.jRadioButtonMenuItem1.setSelected(true);
        }
    }

    public static MainFrame getInstance() {
        return MainFrameHolder.INSTANCE;
    }

    private void initJXLayerOnJComboBox() {
        this.jPanel1.add((Component)Utils.getBusyJXLayer((AutoCompleteJComboBox)this.jComboBox1));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.jComboBox1 = new AutoCompleteJComboBox();
        this.jPanel6 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel8 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel10 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jMenuBar2 = new JMenuBar();
        this.jMenu3 = new JMenu();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem9 = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.jMenuItem11 = new JMenuItem();
        this.jMenuItem10 = new JMenuItem();
        this.jSeparator8 = new JPopupMenu.Separator();
        this.jMenuItem1 = new JMenuItem();
        this.jMenu5 = new JMenu();
        this.jMenuItem4 = new JMenuItem();
        this.jMenuItem7 = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.jMenuItem15 = new JMenuItem();
        this.jMenu6 = new JMenu();
        this.jMenu10 = new JMenu();
        this.jRadioButtonMenuItem1 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItem2 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItem4 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItem6 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItem3 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItem5 = new JRadioButtonMenuItem();
        this.jMenu7 = new JMenu();
        this.jMenuItem8 = new JMenuItem();
        this.jMenu9 = new JMenu();
        this.jMenu8 = new JMenu();
        this.jMenu1 = new JMenu();
        this.jMenuItem6 = new JMenuItem();
        this.jMenu4 = new JMenu();
        this.jMenu2 = new JMenu();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem16 = new JMenuItem();
        this.jMenuItem12 = new JMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.jMenuItem13 = new JMenuItem();
        this.jMenuItem14 = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.jMenuItem5 = new JMenuItem();
        this.jMenu11 = new JMenu();
        this.jMenuItem17 = new JMenuItem();
        this.jComboBox1.setEditable(true);
        this.jComboBox1.setPreferredSize(new Dimension(150, 24));
        ((AutoCompleteJComboBox)this.jComboBox1).attachStockInfoObserver(this.getStockInfoObserver());
        ((AutoCompleteJComboBox)this.jComboBox1).attachResultObserver(this.getResultObserver());
        ((AutoCompleteJComboBox)this.jComboBox1).attachMatchObserver(this.getMatchObserver());
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.setTitle(bundle.getString("MainFrame_Application_Title"));
        this.setIconImage(this.getMyIconImage());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainFrame.this.formMouseClicked(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                MainFrame.this.formWindowClosed(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                MainFrame.this.formWindowClosing(evt);
            }

            @Override
            public void windowDeiconified(WindowEvent evt) {
                MainFrame.this.formWindowDeiconified(evt);
            }

            @Override
            public void windowIconified(WindowEvent evt) {
                MainFrame.this.formWindowIconified(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.jPanel6.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel6.setLayout(new BorderLayout(5, 5));
        this.jPanel6.add((Component)((Object)this.statusBar), "South");
        this.getContentPane().add((Component)this.jPanel6, "South");
        this.jTabbedPane1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MainFrame.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jPanel8.setLayout(new BorderLayout(5, 5));
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setFont(this.jTable1.getFont().deriveFont(this.jTable1.getFont().getStyle() | 1, this.jTable1.getFont().getSize() + 1));
        this.jTable1.setModel(new StockTableModel());
        this.jTable1.setAutoResizeMode(0);
        this.jTable1.setDefaultRenderer(Number.class, new StockTableCellRenderer(4));
        this.jTable1.setDefaultRenderer(Double.class, new StockTableCellRenderer(4));
        this.jTable1.setDefaultRenderer(Object.class, new StockTableCellRenderer(2));
        this.jTable1.setDefaultEditor(Double.class, new NonNegativeDoubleEditor());
        this.jTable1.getModel().addTableModelListener(this.getTableModelListener());
        this.jTable1.getTableHeader().addMouseListener(new TableColumnSelectionPopupListener(1));
        this.jTable1.addMouseListener(new TableRowPopupListener());
        this.jTable1.addKeyListener(new TableKeyEventListener());
        this.jTable1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MainFrame.this.jTable1KeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jPanel8.add((Component)this.jScrollPane1, "Center");
        this.jLabel1.setText(bundle.getString("MainFrame_Stock"));
        this.jPanel1.add(this.jLabel1);
        this.jPanel8.add((Component)this.jPanel1, "North");
        this.jPanel10.setPreferredSize(new Dimension(328, 170));
        this.jPanel10.setLayout(new FlowLayout(0, 10, 5));
        this.jPanel3.setBackground(new Color(255, 255, 255));
        this.jPanel3.setPreferredSize(new Dimension(170, 160));
        this.jPanel3.setBorder((Border)new DropShadowBorder(true));
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel10.add(this.jPanel3);
        EMPTY_DYNAMIC_CHART.getChartPanel().addMouseListener((MouseListener)this.dynamicChartMouseAdapter);
        this.jPanel3.add((Component)EMPTY_DYNAMIC_CHART.getChartPanel(), "Center");
        this.jPanel8.add((Component)this.jPanel10, "South");
        this.jTabbedPane1.addTab(bundle.getString("MainFrame_Title"), this.jPanel8);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.jPanel2.setLayout(new GridLayout(2, 1));
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.jMenu3.setText(bundle.getString("MainFrame_File"));
        this.jMenuItem2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/project_open.png")));
        this.jMenuItem2.setText(bundle.getString("MainFrame_Open..."));
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem2);
        this.jMenuItem9.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/filesave.png")));
        this.jMenuItem9.setText(bundle.getString("MainFrame_SaveAs..."));
        this.jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem9ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem9);
        this.jMenu3.add(this.jSeparator7);
        this.jMenuItem11.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/download_from_cloud.png")));
        this.jMenuItem11.setText(bundle.getString("MainFrame_OpenFromCloud..."));
        this.jMenuItem11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem11ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem11);
        this.jMenuItem10.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/upload_to_cloud.png")));
        this.jMenuItem10.setText(bundle.getString("MainFrame_SaveToCloud..."));
        this.jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem10ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem10);
        this.jMenu3.add(this.jSeparator8);
        this.jMenuItem1.setText(bundle.getString("MainFrame_Exit"));
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem1);
        this.jMenuBar2.add(this.jMenu3);
        this.jMenu5.setText(bundle.getString("MainFrame_Edit"));
        this.jMenuItem4.setText(bundle.getString("MainFrame_AddStocks..."));
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem4ActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jMenuItem4);
        this.jMenuItem7.setText(bundle.getString("MainFrame_ClearAllStocks"));
        this.jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem7ActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jMenuItem7);
        this.jMenu5.add(this.jSeparator4);
        this.jMenuItem15.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.jMenuItem15.setText(bundle.getString("MainFrame_RefreshStockPrices"));
        this.jMenuItem15.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem15ActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jMenuItem15);
        this.jMenuBar2.add(this.jMenu5);
        this.jMenu6.setText(bundle.getString("MainFrame_Country"));
        this.jMenuBar2.add(this.jMenu6);
        this.jMenu10.setText(bundle.getString("MainFrame_Language"));
        this.buttonGroup3.add(this.jRadioButtonMenuItem1);
        this.jRadioButtonMenuItem1.setSelected(true);
        this.jRadioButtonMenuItem1.setText(Locale.ENGLISH.getDisplayLanguage(Locale.getDefault()));
        this.jRadioButtonMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jRadioButtonMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu10.add(this.jRadioButtonMenuItem1);
        this.buttonGroup3.add(this.jRadioButtonMenuItem2);
        this.jRadioButtonMenuItem2.setText(Locale.SIMPLIFIED_CHINESE.getDisplayName(Locale.getDefault()));
        this.jRadioButtonMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jRadioButtonMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu10.add(this.jRadioButtonMenuItem2);
        this.buttonGroup3.add(this.jRadioButtonMenuItem4);
        this.jRadioButtonMenuItem4.setText(Locale.TRADITIONAL_CHINESE.getDisplayName(Locale.getDefault()));
        this.jRadioButtonMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jRadioButtonMenuItem4ActionPerformed(evt);
            }
        });
        this.jMenu10.add(this.jRadioButtonMenuItem4);
        this.buttonGroup3.add(this.jRadioButtonMenuItem6);
        this.jRadioButtonMenuItem6.setText(Locale.FRENCH.getDisplayLanguage(Locale.getDefault()));
        this.jRadioButtonMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jRadioButtonMenuItem6ActionPerformed(evt);
            }
        });
        this.jMenu10.add(this.jRadioButtonMenuItem6);
        this.buttonGroup3.add(this.jRadioButtonMenuItem3);
        this.jRadioButtonMenuItem3.setText(Locale.GERMAN.getDisplayLanguage(Locale.getDefault()));
        this.jRadioButtonMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jRadioButtonMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu10.add(this.jRadioButtonMenuItem3);
        this.buttonGroup3.add(this.jRadioButtonMenuItem5);
        this.jRadioButtonMenuItem5.setText(Locale.ITALIAN.getDisplayLanguage(Locale.getDefault()));
        this.jRadioButtonMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jRadioButtonMenuItem5ActionPerformed(evt);
            }
        });
        this.jMenu10.add(this.jRadioButtonMenuItem5);
        this.jMenuBar2.add(this.jMenu10);
        this.jMenu7.setText(bundle.getString("MainFrame_Database"));
        this.jMenuItem8.setText(bundle.getString("MainFrame_StockDatabase..."));
        this.jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem8ActionPerformed(evt);
            }
        });
        this.jMenu7.add(this.jMenuItem8);
        this.jMenuBar2.add(this.jMenu7);
        this.jMenu9.setText(bundle.getString("MainFrame_Watchlist"));
        this.jMenu9.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                MainFrame.this.jMenu9MenuSelected(evt);
            }
        });
        this.jMenuBar2.add(this.jMenu9);
        this.jMenu8.setText(bundle.getString("MainFrame_Portfolio"));
        this.jMenu8.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                MainFrame.this.jMenu8MenuSelected(evt);
            }
        });
        this.jMenuBar2.add(this.jMenu8);
        this.jMenu1.setText(bundle.getString("MainFrame_Options"));
        this.jMenuItem6.setText(bundle.getString("MainFrame_Options..."));
        this.jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem6ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem6);
        this.jMenuBar2.add(this.jMenu1);
        this.jMenu4.setText(bundle.getString("MainFrame_LooknFeel"));
        this.jMenuBar2.add(this.jMenu4);
        this.jMenu2.setText(bundle.getString("MainFrame_Help"));
        this.jMenuItem3.setText(bundle.getString("MainFrame_OnlineHelp"));
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem3);
        this.jMenuItem16.setText(bundle.getString("MainFrame_KeyboardShortcuts"));
        this.jMenuItem16.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem16ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem16);
        this.jMenuItem12.setText(bundle.getString("MainFrame_Calculator"));
        this.jMenuItem12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem12ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem12);
        this.jMenu2.add(this.jSeparator6);
        this.jMenuItem13.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/smile2.png")));
        this.jMenuItem13.setText(bundle.getString("MainFrame_DonateToJStock"));
        this.jMenuItem13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem13ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem13);
        this.jMenuItem14.setText(bundle.getString("MainFrame_ContributeToJStock"));
        this.jMenuItem14.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem14ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem14);
        this.jMenu2.add(this.jSeparator5);
        this.jMenuItem5.setText(bundle.getString("MainFrame_About..."));
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem5ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem5);
        this.jMenuBar2.add(this.jMenu2);
        this.jMenu11.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/android-small.png")));
        this.jMenu11.setText(bundle.getString("MainFrame_Android"));
        this.jMenu11.setFont(this.jMenu11.getFont().deriveFont(this.jMenu11.getFont().getStyle() | 1));
        this.jMenuItem17.setText(bundle.getString("MainFrame_DownloadJStockAndroid"));
        this.jMenuItem17.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem17ActionPerformed(evt);
            }
        });
        this.jMenu11.add(this.jMenuItem17);
        this.jMenuBar2.add(this.jMenu11);
        this.setJMenuBar(this.jMenuBar2);
        this.setSize(new Dimension(952, 478));
        this.setLocationRelativeTo(null);
    }

    private void jMenuItem4ActionPerformed(ActionEvent evt) {
        if (this.getStockInfoDatabase() == null) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("org/yccheok/jstock/data/messages").getString("info_message_we_havent_connected_to_stock_server"), ResourceBundle.getBundle("org/yccheok/jstock/data/messages").getString("info_title_we_havent_connected_to_stock_server"), 1);
            return;
        }
        StockJDialog stockJDialog = new StockJDialog((Frame)this, true);
        stockJDialog.setLocationRelativeTo(this);
        stockJDialog.setVisible(true);
    }

    private void jMenuItem7ActionPerformed(ActionEvent evt) {
        this.clearAllStocks();
    }

    private boolean openAsCSVFile(File file) {
        Statements statements = Statements.newInstanceFromCSVFile(file);
        return this.openAsStatements(statements, file);
    }

    public boolean openAsStatements(Statements statements, File file) {
        assert (statements != null);
        GUIBundleWrapper guiBundleWrapper = statements.getGUIBundleWrapper();
        if (statements.getType() == Statement.Type.RealtimeInfo) {
            int size = statements.size();
            for (int i = 0; i < size; ++i) {
                Statement statement = statements.get(i);
                String codeStr = statement.getValueAsString(guiBundleWrapper.getString("MainFrame_Code"));
                String symbolStr = statement.getValueAsString(guiBundleWrapper.getString("MainFrame_Symbol"));
                Double fallBelowDouble = statement.getValueAsDouble(guiBundleWrapper.getString("MainFrame_FallBelow"));
                Double riseAboveDouble = statement.getValueAsDouble(guiBundleWrapper.getString("MainFrame_RiseAbove"));
                if (codeStr.length() <= 0 || symbolStr.length() <= 0) continue;
                Stock stock = Utils.getEmptyStock(Code.newInstance(codeStr), Symbol.newInstance(symbolStr));
                StockAlert stockAlert = new StockAlert().setFallBelow(fallBelowDouble).setRiseAbove(riseAboveDouble);
                this.addStockToTable(stock, stockAlert);
                this.realTimeStockMonitor.addStockCode(Code.newInstance(codeStr));
            }
            this.realTimeStockMonitor.startNewThreadsIfNecessary();
            this.realTimeStockMonitor.refresh();
        } else if (statements.getType() == Statement.Type.StockIndicatorScanner) {
            int size = statements.size();
            for (int i = 0; i < size; ++i) {
                Statement statement = statements.get(i);
                String codeStr = statement.getValueAsString(guiBundleWrapper.getString("MainFrame_Code"));
                String symbolStr = statement.getValueAsString(guiBundleWrapper.getString("MainFrame_Symbol"));
                if (codeStr.length() <= 0 || symbolStr.length() <= 0) continue;
                Stock stock = Utils.getEmptyStock(Code.newInstance(codeStr), Symbol.newInstance(symbolStr));
                this.addStockToTable(stock);
                this.realTimeStockMonitor.addStockCode(Code.newInstance(codeStr));
            }
            this.realTimeStockMonitor.startNewThreadsIfNecessary();
            this.realTimeStockMonitor.refresh();
        } else {
            if (statements.getType() == Statement.Type.PortfolioManagementBuy || statements.getType() == Statement.Type.PortfolioManagementSell || statements.getType() == Statement.Type.PortfolioManagementDeposit || statements.getType() == Statement.Type.PortfolioManagementDividend) {
                return this.portfolioManagementJPanel.openAsStatements(statements, file);
            }
            return false;
        }
        return true;
    }

    private boolean openAsExcelFile(File file) {
        List<Statements> statementsList = Statements.newInstanceFromExcelFile(file);
        boolean status = statementsList.size() > 0;
        for (Statements statements : statementsList) {
            status &= this.openAsStatements(statements, file);
        }
        return status;
    }

    public RealTimeStockMonitor getRealTimeStockMonitor() {
        return this.realTimeStockMonitor;
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        File file = Utils.promptOpenCSVAndExcelJFileChooser();
        if (file == null) {
            return;
        }
        boolean status = true;
        if (Utils.getFileExtension(file).equals("xls")) {
            if (this.getSelectedComponent() == this.jPanel8) {
                status = this.openAsExcelFile(file);
            } else if (this.getSelectedComponent() == this.portfolioManagementJPanel) {
                status = this.portfolioManagementJPanel.openAsExcelFile(file);
            } else assert (false);
        } else if (Utils.getFileExtension(file).equals("csv")) {
            if (this.getSelectedComponent() == this.jPanel8) {
                status = this.openAsCSVFile(file);
            } else if (this.getSelectedComponent() == this.portfolioManagementJPanel) {
                status = this.portfolioManagementJPanel.openAsCSVFile(file);
            } else assert (false);
        } else assert (false);
        if (!status) {
            String output = MessageFormat.format(MessagesBundle.getString("error_message_bad_file_format_template"), file.getName());
            JOptionPane.showMessageDialog(this, output, MessagesBundle.getString("error_title_bad_file_format"), 0);
        }
    }

    private void handleJTabbedPaneStateChanged(JTabbedPane pane) {
        if (pane.getSelectedComponent() == this.jPanel8) {
            this.jMenuItem2.setEnabled(true);
            this.jMenuItem9.setEnabled(true);
            this.jMenuItem4.setEnabled(true);
            this.jMenuItem7.setEnabled(true);
            this.jMenuItem15.setEnabled(true);
            this.requestFocusOnJComboBox();
        } else if (pane.getSelectedComponent() == this.indicatorPanel) {
            this.jMenuItem2.setEnabled(false);
            this.jMenuItem9.setEnabled(false);
            this.jMenuItem4.setEnabled(false);
            this.jMenuItem7.setEnabled(false);
            this.jMenuItem15.setEnabled(false);
        } else if (pane.getSelectedComponent() == this.indicatorScannerJPanel) {
            this.jMenuItem2.setEnabled(false);
            this.jMenuItem9.setEnabled(true);
            this.jMenuItem4.setEnabled(false);
            this.jMenuItem7.setEnabled(false);
            this.jMenuItem15.setEnabled(true);
        } else if (pane.getSelectedComponent() == this.portfolioManagementJPanel) {
            this.jMenuItem2.setEnabled(true);
            this.jMenuItem9.setEnabled(true);
            this.jMenuItem4.setEnabled(false);
            this.jMenuItem7.setEnabled(false);
            this.jMenuItem15.setEnabled(true);
        }
        if (!this.isStatusBarBusy) {
            this.setStatusBar(false, this.getBestStatusBarMessage());
        }
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        JTabbedPane pane = (JTabbedPane)evt.getSource();
        this.handleJTabbedPaneStateChanged(pane);
    }

    private void jMenuItem6ActionPerformed(ActionEvent evt) {
        OptionsJDialog optionsJDialog = new OptionsJDialog((Frame)this, true);
        optionsJDialog.setLocationRelativeTo(this);
        optionsJDialog.set(this.jStockOptions);
        optionsJDialog.setVisible(true);
    }

    public JStockOptions getJStockOptions() {
        return this.jStockOptions;
    }

    public ChartJDialogOptions getChartJDialogOptions() {
        return this.chartJDialogOptions;
    }

    public void save() {
        this.getJStockOptions().setLastSelectedPageIndex(this.jTabbedPane1.getSelectedIndex());
        JStockOptions.BoundsEx boundsEx = new JStockOptions.BoundsEx(this.getBounds(), this.getExtendedState());
        this.getJStockOptions().setBoundsEx(boundsEx);
        this.jStockOptions.setApplicationVersionID(Utils.getApplicationVersionID());
        this.saveJStockOptions();
        this.saveGUIOptions();
        this.saveChartJDialogOptions();
        this.saveBrokingFirmLogos();
        this.saveWatchlist();
        this.indicatorPanel.saveAlertIndicatorProjectManager();
        this.indicatorPanel.saveModuleIndicatorProjectManager();
        this.portfolioManagementJPanel.savePortfolio();
    }

    private void dettachAllAndStopAutoCompleteJComboBox() {
        ((AutoCompleteJComboBox)this.jComboBox1).dettachAll();
        ((AutoCompleteJComboBox)this.jComboBox1).stop();
    }

    private void formWindowClosed(WindowEvent evt) {
        this.isFormWindowClosedCalled = true;
        try {
            TrayIcon _trayIcon;
            ExecutorService _stockInfoDatabaseMetaPool = this.stockInfoDatabaseMetaPool;
            this.stockInfoDatabaseMetaPool = null;
            _stockInfoDatabaseMetaPool.shutdownNow();
            this.save();
            if (this.needToSaveUserDefinedDatabase) {
                this.saveUserDefinedDatabaseAsCSV(this.jStockOptions.getCountry(), this.stockInfoDatabase);
            }
            if ((_trayIcon = this.trayIcon) != null) {
                SystemTray.getSystemTray().remove(_trayIcon);
                this.trayIcon = null;
            }
            this.dettachAllAndStopAutoCompleteJComboBox();
            this.indicatorPanel.dettachAllAndStopAutoCompleteJComboBox();
            log.info((Object)"latestNewsTask stop...");
            if (this.latestNewsTask != null) {
                this.latestNewsTask.cancel(true);
            }
            _stockInfoDatabaseMetaPool.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            log.info((Object)"Widnow is closed.");
        }
        catch (Exception exp) {
            log.error((Object)"Unexpected error while trying to quit application", (Throwable)exp);
        }
        System.exit(0);
    }

    private void jMenuItem5ActionPerformed(ActionEvent evt) {
        new AboutJDialog((Frame)this, true).setVisible(true);
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void formWindowIconified(WindowEvent evt) {
        if (Utils.isWindows()) {
            this.setVisible(false);
        }
    }

    private void formWindowDeiconified(WindowEvent evt) {
    }

    private void formMouseClicked(MouseEvent evt) {
        this.jTable1.getSelectionModel().clearSelection();
        this.indicatorScannerJPanel.clearTableSelection();
        this.portfolioManagementJPanel.clearTableSelection();
        this.updateDynamicChart(null);
    }

    private void updateDynamicChart(Stock stock) {
        DynamicChart dynamicChart;
        assert (EventQueue.isDispatchThread());
        DynamicChart dynamicChart2 = dynamicChart = stock != null ? this.dynamicCharts.get(stock.code) : EMPTY_DYNAMIC_CHART;
        if (dynamicChart == null) {
            dynamicChart = EMPTY_DYNAMIC_CHART;
        }
        if (Arrays.asList(this.jPanel3.getComponents()).contains(dynamicChart.getChartPanel())) {
            return;
        }
        this.jPanel3.removeAll();
        this.jPanel3.add((Component)dynamicChart.getChartPanel(), "Center");
        this.jPanel3.validate();
        dynamicChart.getChartPanel().repaint();
        dynamicChart.getChartPanel().removeMouseListener((MouseListener)this.dynamicChartMouseAdapter);
        dynamicChart.getChartPanel().addMouseListener((MouseListener)this.dynamicChartMouseAdapter);
    }

    private void jTable1KeyPressed(KeyEvent evt) {
        if (127 == evt.getKeyCode()) {
            this.deteleSelectedTableRow();
            return;
        }
        if (evt.isActionKey()) {
            int[] rows = this.jTable1.getSelectedRows();
            if (rows.length == 1) {
                int row = rows[0];
                StockTableModel tableModel = (StockTableModel)this.jTable1.getModel();
                int modelIndex = this.jTable1.convertRowIndexToModel(row);
                Stock stock = tableModel.getStock(modelIndex);
                this.updateDynamicChart(stock);
            } else {
                this.updateDynamicChart(null);
            }
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.indicatorPanel.promptToSaveSignificantEdits()) {
            this.dispose();
        }
    }

    private void jMenuItem8ActionPerformed(ActionEvent evt) {
        StockInfoDatabase stock_info_database = this.stockInfoDatabase;
        if (stock_info_database == null) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("org/yccheok/jstock/data/messages").getString("info_message_there_are_no_database_ready_yet"), ResourceBundle.getBundle("org/yccheok/jstock/data/messages").getString("info_title_there_are_no_database_ready_yet"), 1);
            return;
        }
        StockDatabaseJDialog stockDatabaseJDialog = new StockDatabaseJDialog((Frame)this, stock_info_database, true);
        stockDatabaseJDialog.setSize(540, 540);
        stockDatabaseJDialog.setLocationRelativeTo(this);
        stockDatabaseJDialog.setVisible(true);
        if (stockDatabaseJDialog.getResult() != null) {
            assert (stockDatabaseJDialog.getResult() == this.stockInfoDatabase);
            this.stockInfoDatabase = stockDatabaseJDialog.getResult();
            ((AutoCompleteJComboBox)this.jComboBox1).setStockInfoDatabase(this.stockInfoDatabase);
            this.indicatorPanel.setStockInfoDatabase(this.stockInfoDatabase);
            log.info((Object)"saveStockCodeAndSymbolDatabase...");
            this.saveDatabase();
        }
    }

    private void jMenuItem9ActionPerformed(ActionEvent evt) {
        String suggestedFileName = "";
        if (this.getSelectedComponent() == this.jPanel8) {
            suggestedFileName = GUIBundle.getString("MainFrame_Title");
        } else if (this.getSelectedComponent() == this.indicatorScannerJPanel) {
            suggestedFileName = GUIBundle.getString("IndicatorScannerJPanel_Title");
        } else if (this.getSelectedComponent() == this.portfolioManagementJPanel) {
            suggestedFileName = GUIBundle.getString("PortfolioManagementJPanel_Title");
        } else assert (false);
        boolean status = true;
        File file = null;
        if (this.getSelectedComponent() == this.jPanel8 || this.getSelectedComponent() == this.indicatorScannerJPanel) {
            file = Utils.promptSaveCSVAndExcelJFileChooser(suggestedFileName);
            if (file != null) {
                if (Utils.getFileExtension(file).equals("csv")) {
                    if (this.getSelectedComponent() == this.jPanel8) {
                        status = this.saveAsCSVFile(file, false);
                    } else if (this.getSelectedComponent() == this.indicatorScannerJPanel) {
                        status = this.indicatorScannerJPanel.saveAsCSVFile(file);
                    } else assert (false);
                } else if (Utils.getFileExtension(file).equals("xls")) {
                    if (this.getSelectedComponent() == this.jPanel8) {
                        status = this.saveAsExcelFile(file);
                    } else if (this.getSelectedComponent() == this.indicatorScannerJPanel) {
                        status = this.indicatorScannerJPanel.saveAsExcelFile(file);
                    } else assert (false);
                }
            }
        } else if (this.getSelectedComponent() == this.portfolioManagementJPanel) {
            Utils.FileEx fileEx = Utils.promptSavePortfolioCSVAndExcelJFileChooser(suggestedFileName);
            if (fileEx != null) {
                file = fileEx.file;
                if (Utils.getFileExtension(fileEx.file).equals("csv")) {
                    status = this.portfolioManagementJPanel.saveAsCSVFile(fileEx, false);
                } else if (Utils.getFileExtension(fileEx.file).equals("xls")) {
                    status = this.portfolioManagementJPanel.saveAsExcelFile(fileEx.file, false);
                }
            }
        } else assert (false);
        if (!status) {
            assert (file != null);
            String output = MessageFormat.format(MessagesBundle.getString("error_message_nothing_to_be_saved_template"), file.getName());
            JOptionPane.showMessageDialog(this, output, MessagesBundle.getString("error_title_nothing_to_be_saved"), 0);
        }
    }

    private void jMenu8MenuSelected(MenuEvent evt) {
        this.jMenu8.removeAll();
        List<String> portfolioNames = org.yccheok.jstock.portfolio.Utils.getPortfolioNames();
        final String currentPortfolioName = this.getJStockOptions().getPortfolioName();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (String portfolioName : portfolioNames) {
            JRadioButtonMenuItem mi = (JRadioButtonMenuItem)this.jMenu8.add(new JRadioButtonMenuItem(portfolioName));
            buttonGroup.add(mi);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = ((JRadioButtonMenuItem)e.getSource()).getText();
                    if (!s.equals(currentPortfolioName)) {
                        MainFrame.this.selectActivePortfolio(s);
                    }
                }
            });
            mi.setSelected(portfolioName.equals(currentPortfolioName));
        }
        this.jMenu8.addSeparator();
        JMenuItem mi = new JMenuItem(GUIBundle.getString("MainFrame_MultiplePortolio..."), this.getImageIcon("/images/16x16/calc.png"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.multiplePortfolios();
            }
        });
        this.jMenu8.add(mi);
    }

    private void jMenuItem11ActionPerformed(ActionEvent evt) {
        LoadFromCloudJDialog dialog = new LoadFromCloudJDialog((Frame)this, true);
        dialog.setVisible(true);
    }

    private void jMenuItem10ActionPerformed(ActionEvent evt) {
        SaveToCloudJDialog dialog = new SaveToCloudJDialog((Frame)this, true);
        dialog.setVisible(true);
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        Utils.launchWebBrowser(org.yccheok.jstock.network.Utils.getURL(Utils.Type.HELP_HTML));
    }

    private void jMenu9MenuSelected(MenuEvent evt) {
        this.jMenu9.removeAll();
        List<String> watchlistNames = org.yccheok.jstock.watchlist.Utils.getWatchlistNames();
        final String currentWatchlistName = this.getJStockOptions().getWatchlistName();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (String watchlistName : watchlistNames) {
            JRadioButtonMenuItem mi = (JRadioButtonMenuItem)this.jMenu9.add(new JRadioButtonMenuItem(watchlistName));
            buttonGroup.add(mi);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = ((JRadioButtonMenuItem)e.getSource()).getText();
                    if (!s.equals(currentWatchlistName)) {
                        MainFrame.this.selectActiveWatchlist(s);
                    }
                }
            });
            mi.setSelected(watchlistName.equals(currentWatchlistName));
        }
        this.jMenu9.addSeparator();
        JMenuItem mi = new JMenuItem(GUIBundle.getString("MainFrame_MultipleWatchlist..."), this.getImageIcon("/images/16x16/stock_timezone.png"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.multipleWatchlists();
            }
        });
        this.jMenu9.add(mi);
    }

    private void jMenuItem12ActionPerformed(ActionEvent evt) {
        try {
            Runtime.getRuntime().exec("calc");
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
            Calc calc = new Calc((Frame)this, false);
            calc.setVisible(true);
        }
    }

    private void jRadioButtonMenuItem1ActionPerformed(ActionEvent evt) {
        if (!Utils.hasSpecifiedLanguageFile(this.jStockOptions.getLocale())) {
            return;
        }
        if (!this.jStockOptions.getLocale().getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            int result = JOptionPane.showConfirmDialog(this, MessagesBundle.getString("question_message_restart_now"), MessagesBundle.getString("question_title_restart_now"), 0);
            if (result == 0) {
                Locale locale = new Locale(Locale.ENGLISH.getLanguage(), Locale.getDefault().getCountry(), Locale.getDefault().getVariant());
                this.jStockOptions.setLocale(locale);
                Utils.restartApplication(this);
            } else if (Utils.isTraditionalChinese(this.jStockOptions.getLocale())) {
                this.jRadioButtonMenuItem4.setSelected(true);
            } else if (Utils.isSimplifiedChinese(this.jStockOptions.getLocale())) {
                this.jRadioButtonMenuItem2.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.GERMAN.getLanguage()) == 0) {
                this.jRadioButtonMenuItem3.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.ITALIAN.getLanguage()) == 0) {
                this.jRadioButtonMenuItem5.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.FRENCH.getLanguage()) == 0) {
                this.jRadioButtonMenuItem6.setSelected(true);
            }
        }
    }

    private void jRadioButtonMenuItem2ActionPerformed(ActionEvent evt) {
        if (!Utils.isSimplifiedChinese(this.jStockOptions.getLocale())) {
            int result = JOptionPane.showConfirmDialog(this, MessagesBundle.getString("question_message_restart_now"), MessagesBundle.getString("question_title_restart_now"), 0);
            if (result == 0) {
                String country = Locale.TRADITIONAL_CHINESE.getCountry().equals(Locale.getDefault().getCountry()) ? Locale.SIMPLIFIED_CHINESE.getCountry() : Locale.getDefault().getCountry();
                Locale locale = new Locale(Locale.SIMPLIFIED_CHINESE.getLanguage(), country, Locale.getDefault().getVariant());
                this.jStockOptions.setLocale(locale);
                Utils.restartApplication(this);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.ENGLISH.getLanguage()) == 0) {
                this.jRadioButtonMenuItem1.setSelected(true);
            } else if (Utils.isTraditionalChinese(this.jStockOptions.getLocale())) {
                this.jRadioButtonMenuItem4.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.GERMAN.getLanguage()) == 0) {
                this.jRadioButtonMenuItem3.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.ITALIAN.getLanguage()) == 0) {
                this.jRadioButtonMenuItem5.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.FRENCH.getLanguage()) == 0) {
                this.jRadioButtonMenuItem6.setSelected(true);
            }
        }
    }

    private void jRadioButtonMenuItem3ActionPerformed(ActionEvent evt) {
        if (!this.jStockOptions.getLocale().getLanguage().equals(Locale.GERMAN.getLanguage())) {
            int result = JOptionPane.showConfirmDialog(this, MessagesBundle.getString("question_message_restart_now"), MessagesBundle.getString("question_title_restart_now"), 0);
            if (result == 0) {
                Locale locale = new Locale(Locale.GERMAN.getLanguage(), Locale.getDefault().getCountry(), Locale.getDefault().getVariant());
                this.jStockOptions.setLocale(locale);
                Utils.restartApplication(this);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.ENGLISH.getLanguage()) == 0) {
                this.jRadioButtonMenuItem1.setSelected(true);
            } else if (Utils.isTraditionalChinese(this.jStockOptions.getLocale())) {
                this.jRadioButtonMenuItem4.setSelected(true);
            } else if (Utils.isSimplifiedChinese(this.jStockOptions.getLocale())) {
                this.jRadioButtonMenuItem2.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.ITALIAN.getLanguage()) == 0) {
                this.jRadioButtonMenuItem5.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.FRENCH.getLanguage()) == 0) {
                this.jRadioButtonMenuItem6.setSelected(true);
            }
        }
    }

    private void jRadioButtonMenuItem4ActionPerformed(ActionEvent evt) {
        if (!Utils.isTraditionalChinese(this.jStockOptions.getLocale())) {
            int result = JOptionPane.showConfirmDialog(this, MessagesBundle.getString("question_message_restart_now"), MessagesBundle.getString("question_title_restart_now"), 0);
            if (result == 0) {
                Locale locale = new Locale(Locale.TRADITIONAL_CHINESE.getLanguage(), Locale.TRADITIONAL_CHINESE.getCountry(), Locale.getDefault().getVariant());
                this.jStockOptions.setLocale(locale);
                Utils.restartApplication(this);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.ENGLISH.getLanguage()) == 0) {
                this.jRadioButtonMenuItem1.setSelected(true);
            } else if (Utils.isSimplifiedChinese(this.jStockOptions.getLocale())) {
                this.jRadioButtonMenuItem2.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.GERMAN.getLanguage()) == 0) {
                this.jRadioButtonMenuItem3.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.ITALIAN.getLanguage()) == 0) {
                this.jRadioButtonMenuItem5.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.FRENCH.getLanguage()) == 0) {
                this.jRadioButtonMenuItem6.setSelected(true);
            }
        }
    }

    private void jMenuItem13ActionPerformed(ActionEvent evt) {
        Utils.launchWebBrowser(org.yccheok.jstock.network.Utils.getURL(Utils.Type.DONATE_HTML));
    }

    private void jMenuItem14ActionPerformed(ActionEvent evt) {
        Utils.launchWebBrowser(org.yccheok.jstock.network.Utils.getURL(Utils.Type.CONTRIBUTE_HTML));
    }

    private void jRadioButtonMenuItem5ActionPerformed(ActionEvent evt) {
        if (!this.jStockOptions.getLocale().getLanguage().equals(Locale.ITALIAN.getLanguage())) {
            int result = JOptionPane.showConfirmDialog(this, MessagesBundle.getString("question_message_restart_now"), MessagesBundle.getString("question_title_restart_now"), 0);
            if (result == 0) {
                Locale locale = new Locale(Locale.ITALIAN.getLanguage(), Locale.getDefault().getCountry(), Locale.getDefault().getVariant());
                this.jStockOptions.setLocale(locale);
                Utils.restartApplication(this);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.ENGLISH.getLanguage()) == 0) {
                this.jRadioButtonMenuItem1.setSelected(true);
            } else if (Utils.isTraditionalChinese(this.jStockOptions.getLocale())) {
                this.jRadioButtonMenuItem4.setSelected(true);
            } else if (Utils.isSimplifiedChinese(this.jStockOptions.getLocale())) {
                this.jRadioButtonMenuItem2.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.GERMAN.getLanguage()) == 0) {
                this.jRadioButtonMenuItem3.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.FRENCH.getLanguage()) == 0) {
                this.jRadioButtonMenuItem6.setSelected(true);
            }
        }
    }

    private void jMenuItem15ActionPerformed(ActionEvent evt) {
        this.refreshAllRealTimeStockMonitors();
        this.refreshCurrencyExchangeMonitor();
        this.initMarketThread();
        if (!this.getStocks().isEmpty()) {
            this.setStatusBar(true, GUIBundle.getString("MainFrame_RefreshStockPrices..."));
            this.refreshPriceInProgress = true;
        }
    }

    private void jMenuItem16ActionPerformed(ActionEvent evt) {
        Utils.launchWebBrowser(org.yccheok.jstock.network.Utils.getURL(Utils.Type.HELP_KEYBOARD_SHORTCUTS_HTML));
    }

    private void jMenuItem17ActionPerformed(ActionEvent evt) {
        Utils.launchWebBrowser(org.yccheok.jstock.network.Utils.getURL(Utils.Type.ANDROID_HTML));
    }

    private void jRadioButtonMenuItem6ActionPerformed(ActionEvent evt) {
        if (!this.jStockOptions.getLocale().getLanguage().equals(Locale.FRENCH.getLanguage())) {
            int result = JOptionPane.showConfirmDialog(this, MessagesBundle.getString("question_message_restart_now"), MessagesBundle.getString("question_title_restart_now"), 0);
            if (result == 0) {
                Locale locale = new Locale(Locale.FRENCH.getLanguage(), Locale.getDefault().getCountry(), Locale.getDefault().getVariant());
                this.jStockOptions.setLocale(locale);
                Utils.restartApplication(this);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.ENGLISH.getLanguage()) == 0) {
                this.jRadioButtonMenuItem1.setSelected(true);
            } else if (Utils.isTraditionalChinese(this.jStockOptions.getLocale())) {
                this.jRadioButtonMenuItem4.setSelected(true);
            } else if (Utils.isSimplifiedChinese(this.jStockOptions.getLocale())) {
                this.jRadioButtonMenuItem2.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.ITALIAN.getLanguage()) == 0) {
                this.jRadioButtonMenuItem5.setSelected(true);
            } else if (this.jStockOptions.getLocale().getLanguage().compareTo(Locale.GERMAN.getLanguage()) == 0) {
                this.jRadioButtonMenuItem3.setSelected(true);
            }
        }
    }

    public void selectActiveWatchlist(String watchlist) {
        assert (SwingUtilities.isEventDispatchThread());
        this.saveWatchlist();
        this._saveGUIOptions();
        this.getJStockOptions().setWatchlistName(watchlist);
        this.initWatchlist();
        this.jTabbedPane1.setSelectedIndex(0);
        this.setStatusBar(false, this.getBestStatusBarMessage());
    }

    public void selectActivePortfolio(String portfolio) {
        assert (SwingUtilities.isEventDispatchThread());
        this.portfolioManagementJPanel.savePortfolio();
        this.portfolioManagementJPanel.saveGUIOptions();
        this.getJStockOptions().setPortfolioName(portfolio);
        this.portfolioManagementJPanel.initPortfolio();
        this.jTabbedPane1.setSelectedIndex(3);
        this.portfolioManagementJPanel.updateTitledBorder();
        this.setStatusBar(false, this.getBestStatusBarMessage());
    }

    private void multipleWatchlists() {
        WatchlistJDialog watchlistJDialog = new WatchlistJDialog((Frame)this, true);
        watchlistJDialog.setLocationRelativeTo(this);
        watchlistJDialog.setVisible(true);
    }

    private void multiplePortfolios() {
        PortfolioJDialog portfolioJDialog = new PortfolioJDialog((Frame)this, true);
        portfolioJDialog.setLocationRelativeTo(this);
        portfolioJDialog.setVisible(true);
    }

    private static boolean saveAsCSVFile(CSVWatchlist csvWatchlist, File file, boolean languageIndependent) {
        Statements statements = Statements.newInstanceFromTableModel(csvWatchlist.tableModel, languageIndependent);
        assert (statements != null);
        return statements.saveAsCSVFile(file);
    }

    private boolean saveAsCSVFile(File file, boolean languageIndependent) {
        TableModel tableModel = this.jTable1.getModel();
        CSVWatchlist csvWatchlist = CSVWatchlist.newInstance(tableModel);
        return MainFrame.saveAsCSVFile(csvWatchlist, file, languageIndependent);
    }

    private boolean saveAsExcelFile(File file) {
        TableModel tableModel = this.jTable1.getModel();
        Statements statements = Statements.newInstanceFromTableModel(tableModel, false);
        assert (statements != null);
        return statements.saveAsExcelFile(file, GUIBundle.getString("MainFrame_Title"));
    }

    private static JStockOptions getJStockOptions(String[] args) {
        File f = new File(Utils.getUserDataDirectory() + "config" + File.separator + "options.xml");
        JStockOptions jStockOptions = Utils.fromXML(JStockOptions.class, f);
        if (jStockOptions == null) {
            jStockOptions = new JStockOptions();
        }
        for (String arg : args) {
            String compare;
            String[] tokens = arg.split("=");
            if (tokens.length != 2 || !(compare = tokens[0].trim()).equalsIgnoreCase("-country")) continue;
            String countryStr = tokens[1].trim();
            try {
                Country country = Country.valueOf(countryStr);
                if (country != Country.China || Utils.isFileOrDirectoryExist(Utils.getUserDataDirectory() + (Object)((Object)country))) continue;
                jStockOptions.setCountry(country);
                Locale locale = new Locale(Locale.SIMPLIFIED_CHINESE.getLanguage(), Locale.getDefault().getCountry(), Locale.getDefault().getVariant());
                jStockOptions.setLocale(locale);
            }
            catch (IllegalArgumentException ex) {
                log.error(null, (Throwable)ex);
            }
        }
        return jStockOptions;
    }

    public static void main(String[] args) {
        int choice;
        if (!AppLock.lock() && (choice = JOptionPane.showOptionDialog(null, MessagesBundle.getString("warning_message_running_2_jstock"), MessagesBundle.getString("warning_title_running_2_jstock"), 0, 2, null, new String[]{MessagesBundle.getString("yes_button_running_2_jstock"), MessagesBundle.getString("no_button_running_2_jstock")}, MessagesBundle.getString("no_button_running_2_jstock"))) != 0) {
            System.exit(0);
            return;
        }
        ProxyDetector.getInstance();
        Utils.setDefaultLookAndFeel();
        final String[] _args = args;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame mainFrame = MainFrame.getInstance();
                JStockOptions jStockOptions = MainFrame.getJStockOptions(_args);
                Locale.setDefault(jStockOptions.getLocale());
                mainFrame.initJStockOptions(jStockOptions);
                mainFrame.init();
                mainFrame.setVisible(true);
                mainFrame.updateDividerLocation();
                mainFrame.requestFocusOnJComboBox();
            }
        });
    }

    private void updateDividerLocation() {
        this.portfolioManagementJPanel.updateDividerLocation();
    }

    private void clearAllStocks() {
        if (this.stockCodeHistoryGUI != null) {
            this.stockCodeHistoryGUI.clear();
        }
        if (this.realTimeStockMonitor != null) {
            this.realTimeStockMonitor.clearStockCodes();
        }
        if (this.stockHistoryMonitor != null) {
            this.stockHistoryMonitor.clearStockCodes();
        }
        final StockTableModel tableModel = (StockTableModel)this.jTable1.getModel();
        this.initAlertStateManager();
        if (EventQueue.isDispatchThread()) {
            tableModel.clearAllStocks();
            this.updateDynamicChart(null);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    tableModel.clearAllStocks();
                    MainFrame.this.updateDynamicChart(null);
                }
            });
        }
        if (this.stockCodeHistoryGUI != null && this.stockCodeHistoryGUI.isEmpty() && this.stockInfoDatabase != null) {
            this.setStatusBar(false, this.getBestStatusBarMessage());
        }
    }

    private void deteleSelectedTableRow() {
        assert (EventQueue.isDispatchThread());
        StockTableModel tableModel = (StockTableModel)this.jTable1.getModel();
        int[] rows = this.jTable1.getSelectedRows();
        Arrays.sort(rows);
        for (int i = rows.length - 1; i >= 0; --i) {
            int row = rows[i];
            if (row < 0) continue;
            int modelIndex = this.jTable1.getRowSorter().convertRowIndexToModel(row);
            Stock stock = tableModel.getStock(modelIndex);
            this.stockCodeHistoryGUI.remove(stock.code);
            this.realTimeStockMonitor.removeStockCode(stock.code);
            this.stockHistoryMonitor.removeStockCode(stock.code);
            tableModel.removeRow(modelIndex);
            this.alertStateManager.clearState(stock);
        }
        this.updateDynamicChart(null);
        if (this.stockCodeHistoryGUI.isEmpty() && this.stockInfoDatabase != null) {
            this.setStatusBar(false, this.getBestStatusBarMessage());
        }
    }

    public void setStatusBarExchangeRate(final Double exchangeRate) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.statusBar.setExchangeRate(exchangeRate);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.statusBar.setExchangeRate(exchangeRate);
                }
            });
        }
    }

    public void setStatusBarExchangeRateVisible(final boolean visible) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.statusBar.setExchangeRateVisible(visible);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.statusBar.setExchangeRateVisible(visible);
                }
            });
        }
    }

    public void setStatusBarExchangeRateToolTipText(final String text) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.statusBar.setExchangeRateToolTipText(text);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.statusBar.setExchangeRateToolTipText(text);
                }
            });
        }
    }

    public void setStatusBar(final boolean progressBar, final String mainMessage) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.isStatusBarBusy = progressBar;
            this.statusBar.setProgressBar(progressBar);
            this.statusBar.setMainMessage(mainMessage);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.isStatusBarBusy = progressBar;
                    MainFrame.this.statusBar.setProgressBar(progressBar);
                    MainFrame.this.statusBar.setMainMessage(mainMessage);
                }
            });
        }
    }

    public void setLookAndFeel(String lafClassName) {
        if (lafClassName == null) {
            return;
        }
        try {
            UIManager.setLookAndFeel(lafClassName);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (ClassNotFoundException exp) {
            log.error(null, (Throwable)exp);
        }
        catch (InstantiationException exp) {
            log.error(null, (Throwable)exp);
        }
        catch (IllegalAccessException exp) {
            log.error(null, (Throwable)exp);
        }
        catch (UnsupportedLookAndFeelException exp) {
            log.error(null, (Throwable)exp);
        }
        this.jStockOptions.setLookNFeel(lafClassName);
        Enumeration<AbstractButton> e = this.buttonGroup1.getElements();
        while (e.hasMoreElements()) {
            AbstractButton button = e.nextElement();
            JRadioButtonMenuItem m = (JRadioButtonMenuItem)button;
            ChangeLookAndFeelAction a = (ChangeLookAndFeelAction)m.getActionListeners()[0];
            if (!a.getLafClassName().equals(lafClassName)) continue;
            m.setSelected(true);
            break;
        }
        ((AutoCompleteJComboBox)this.jComboBox1).setStockInfoDatabase(this.stockInfoDatabase);
        this.indicatorPanel.setStockInfoDatabase(this.stockInfoDatabase);
    }

    public PortfolioManagementJPanel getPortfolioManagementJPanel() {
        return this.portfolioManagementJPanel;
    }

    private void createPortfolioManagementJPanel() {
        this.portfolioManagementJPanel = new PortfolioManagementJPanel();
        this.jTabbedPane1.addTab(GUIBundle.getString("PortfolioManagementJPanel_Title"), this.portfolioManagementJPanel);
    }

    private void createStockIndicatorEditor() {
        this.indicatorPanel = new IndicatorPanel();
        this.jTabbedPane1.addTab(GUIBundle.getString("IndicatorPanel_Title"), this.indicatorPanel);
    }

    private void createIndicatorScannerJPanel() {
        this.indicatorScannerJPanel = new IndicatorScannerJPanel();
        this.jTabbedPane1.addTab(GUIBundle.getString("IndicatorScannerJPanel_Title"), this.indicatorScannerJPanel);
        this.jTabbedPane1.addChangeListener(this.indicatorScannerJPanel);
    }

    private void createIconsAndToolTipTextForJTabbedPane() {
        this.jTabbedPane1.setIconAt(0, this.getImageIcon("/images/16x16/stock_timezone.png"));
        this.jTabbedPane1.setIconAt(1, this.getImageIcon("/images/16x16/color_line.png"));
        this.jTabbedPane1.setIconAt(2, this.getImageIcon("/images/16x16/find.png"));
        this.jTabbedPane1.setIconAt(3, this.getImageIcon("/images/16x16/calc.png"));
        this.jTabbedPane1.setToolTipTextAt(0, ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_WatchYourFavoriteStockMovement"));
        this.jTabbedPane1.setToolTipTextAt(1, ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_CustomizeYourOwnStockIndicatorForAlertPurpose"));
        this.jTabbedPane1.setToolTipTextAt(2, ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_ScanThroughTheEntireStockMarketSoThatYouWillBeInformedWhatToSellOrBuy"));
        this.jTabbedPane1.setToolTipTextAt(3, ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_ManageYourRealTimePortfolioWhichEnableYouToTrackBuyAndSellRecords"));
    }

    public void createCountryMenuItem() {
        ArrayList<Country> countries = new ArrayList<Country>(Arrays.asList(Country.values()));
        countries.remove((Object)Country.Czech);
        for (final Country country : countries) {
            JRadioButtonMenuItem mi = (JRadioButtonMenuItem)this.jMenu6.add(new JRadioButtonMenuItem(country.toHumanReadableString(), country.getIcon()));
            this.buttonGroup2.add(mi);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.changeCountry(country);
                }
            });
            if (this.jStockOptions.getCountry() != country) continue;
            mi.setSelected(true);
        }
    }

    public void createLookAndFeelMenuItem() {
        LookAndFeel currentlaf = UIManager.getLookAndFeel();
        UIManager.LookAndFeelInfo[] lafInfo = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lafInfo.length; ++i) {
            JRadioButtonMenuItem mi = (JRadioButtonMenuItem)this.jMenu4.add(new JRadioButtonMenuItem(lafInfo[i].getName()));
            this.buttonGroup1.add(mi);
            mi.addActionListener(new ChangeLookAndFeelAction(this, lafInfo[i].getClassName()));
            if (currentlaf == null || !lafInfo[i].getClassName().equals(currentlaf.getClass().getName())) continue;
            mi.setSelected(true);
        }
    }

    private TableModelListener getTableModelListener() {
        return new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int firstRow = e.getFirstRow();
                int lastRow = e.getLastRow();
                int mColIndex = e.getColumn();
                switch (e.getType()) {
                    case 1: {
                        break;
                    }
                    case 0: {
                        break;
                    }
                }
            }
        };
    }

    private Image getMyIconImage() {
        if (Utils.isWindows7() || Utils.isWindows8()) {
            return new ImageIcon(this.getClass().getResource("/images/128x128/chart.png")).getImage();
        }
        return new ImageIcon(this.getClass().getResource("/images/16x16/chart.png")).getImage();
    }

    private void createSystemTrayIcon() {
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            Image image = Utils.isWindows7() || Utils.isWindows8() ? new ImageIcon(this.getClass().getResource("/images/128x128/chart.png")).getImage() : new ImageIcon(this.getClass().getResource("/images/16x16/chart.png")).getImage();
            MouseListener mouseListener = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1) {
                        MainFrame.this.setVisible(true);
                        MainFrame.this.setState(0);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            };
            ActionListener exitListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.setVisible(false);
                    MainFrame.this.dispose();
                }
            };
            PopupMenu popup = new PopupMenu();
            MenuItem defaultItem = new MenuItem(ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_Exit"));
            defaultItem.addActionListener(exitListener);
            popup.add(defaultItem);
            this.trayIcon = new TrayIcon(image, GUIBundle.getString("MainFrame_Application_Title"), popup);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            };
            this.trayIcon.setImageAutoSize(true);
            this.trayIcon.addActionListener(actionListener);
            this.trayIcon.addMouseListener(mouseListener);
            try {
                tray.add(this.trayIcon);
            }
            catch (AWTException e) {
                this.trayIcon = null;
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("org/yccheok/jstock/data/messages").getString("warning_message_trayicon_could_not_be_added"), ResourceBundle.getBundle("org/yccheok/jstock/data/messages").getString("warning_title_trayicon_could_not_be_added"), 2);
            }
        } else {
            this.trayIcon = null;
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("org/yccheok/jstock/data/messages").getString("warning_message_system_tray_is_not_supported"), ResourceBundle.getBundle("org/yccheok/jstock/data/messages").getString("warning_title_system_tray_is_not_supported"), 2);
        }
    }

    private void initTableHeaderToolTips() {
        JTableHeader header = this.jTable1.getTableHeader();
        ColumnHeaderToolTips tips = new ColumnHeaderToolTips();
        tips.setToolTip(this.jTable1.getColumn(GUIBundle.getString("MainFrame_FallBelow")), ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_AlertUserWhenLastPriceFallBelowOrEqualToSpecifiedValue"));
        tips.setToolTip(this.jTable1.getColumn(GUIBundle.getString("MainFrame_RiseAbove")), ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_AlertUserWhenLastPriceFallAboveOrEqualToSpecifiedValue"));
        header.addMouseMotionListener(tips);
    }

    public void commitBeforeSaveToCloud() {
        StockInfoDatabase stock_info_database;
        Country country = this.jStockOptions.getCountry();
        if (!Utils.isFileOrDirectoryExist(Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "database" + File.separator + "user-defined-database.xml") && (stock_info_database = this.stockInfoDatabase) != null) {
            this.saveUserDefinedDatabaseAsCSV(country, stock_info_database);
        }
        this.jStockOptions.setApplicationVersionID(Utils.getApplicationVersionID());
        this.saveJStockOptions();
        this.saveGUIOptions();
        this.saveChartJDialogOptions();
        this.saveBrokingFirmLogos();
        this.saveWatchlist();
        this.indicatorPanel.saveAlertIndicatorProjectManager();
        this.indicatorPanel.saveModuleIndicatorProjectManager();
        this.portfolioManagementJPanel.savePortfolio();
        this.solveCaseSensitiveFoldersIssue();
        this.saveWatchlistAndPortfolioInfos();
    }

    private void solveCaseSensitiveFoldersIssue() {
        String newDirectory;
        String originalDirectory;
        String newName;
        String originalName;
        int i;
        int ei;
        HashSet<String> lowerCaseNames;
        ArrayList<ArrayList<String>> duplicatedNames;
        Country currentCountry = this.jStockOptions.getCountry();
        String currentWatchlist = this.jStockOptions.getWatchlistName();
        String currentPortfolio = this.jStockOptions.getPortfolioName();
        for (Country country : Country.values()) {
            List<String> watchlistNames = org.yccheok.jstock.watchlist.Utils.getWatchlistNames(country);
            HashMap<String, ArrayList<String>> watchlistNamesMap = new HashMap<String, ArrayList<String>>();
            duplicatedNames = new ArrayList<ArrayList<String>>();
            lowerCaseNames = new HashSet<String>();
            for (String string : watchlistNames) {
                String lowerCaseWatchlistName = string.toLowerCase();
                lowerCaseNames.add(lowerCaseWatchlistName);
                ArrayList<String> names = (ArrayList<String>)watchlistNamesMap.get(lowerCaseWatchlistName);
                if (names == null) {
                    names = new ArrayList<String>();
                    watchlistNamesMap.put(lowerCaseWatchlistName, names);
                }
                names.add(string);
                if (names.size() <= 1) continue;
                duplicatedNames.add(names);
            }
            for (List list : duplicatedNames) {
                int counter = 0;
                boolean originalNameUsed = false;
                ei = list.size();
                for (i = 0; i < ei; ++i) {
                    originalName = (String)list.get(i);
                    if (currentCountry == country && currentWatchlist.equals(originalName)) {
                        originalNameUsed = true;
                        continue;
                    }
                    newName = originalName;
                    if (originalNameUsed || i < ei - 1) {
                        newName = originalName + counter++;
                        while (lowerCaseNames.contains(newName.toLowerCase())) {
                            newName = originalName + counter++;
                        }
                        lowerCaseNames.add(newName.toLowerCase());
                    } else {
                        originalNameUsed = true;
                    }
                    originalDirectory = org.yccheok.jstock.watchlist.Utils.getWatchlistDirectory(country, originalName);
                    newDirectory = org.yccheok.jstock.watchlist.Utils.getWatchlistDirectory(country, newName);
                    if (originalDirectory.equalsIgnoreCase(newDirectory)) continue;
                    new File(originalDirectory).renameTo(new File(newDirectory));
                }
            }
        }
        for (Country country : Country.values()) {
            List<String> portfolioNames = org.yccheok.jstock.portfolio.Utils.getPortfolioNames(country);
            HashMap<String, ArrayList<String>> portfolioNamesMap = new HashMap<String, ArrayList<String>>();
            duplicatedNames = new ArrayList();
            lowerCaseNames = new HashSet();
            for (String string : portfolioNames) {
                String lowerCasePortfolioName = string.toLowerCase();
                lowerCaseNames.add(lowerCasePortfolioName);
                ArrayList<String> names = (ArrayList<String>)portfolioNamesMap.get(lowerCasePortfolioName);
                if (names == null) {
                    names = new ArrayList<String>();
                    portfolioNamesMap.put(lowerCasePortfolioName, names);
                }
                names.add(string);
                if (names.size() <= 1) continue;
                duplicatedNames.add(names);
            }
            for (List list : duplicatedNames) {
                int counter = 0;
                boolean originalNameUsed = false;
                ei = list.size();
                for (i = 0; i < ei; ++i) {
                    originalName = (String)list.get(i);
                    if (currentCountry == country && currentPortfolio.equals(originalName)) {
                        originalNameUsed = true;
                        continue;
                    }
                    newName = originalName;
                    if (originalNameUsed || i < ei - 1) {
                        newName = originalName + counter++;
                        while (lowerCaseNames.contains(newName.toLowerCase())) {
                            newName = originalName + counter++;
                        }
                        lowerCaseNames.add(newName.toLowerCase());
                    } else {
                        originalNameUsed = true;
                    }
                    originalDirectory = org.yccheok.jstock.portfolio.Utils.getPortfolioDirectory(country, originalName);
                    newDirectory = org.yccheok.jstock.portfolio.Utils.getPortfolioDirectory(country, newName);
                    if (originalDirectory.equalsIgnoreCase(newDirectory)) continue;
                    new File(originalDirectory).renameTo(new File(newDirectory));
                }
            }
        }
    }

    private boolean saveWatchlistAndPortfolioInfos() {
        if (!Utils.createCompleteDirectoryHierarchyIfDoesNotExist(Utils.getUserDataDirectory() + "android")) {
            return false;
        }
        List<WatchlistInfo> watchlistInfos = org.yccheok.jstock.watchlist.Utils.getWatchlistInfos();
        List<PortfolioInfo> portfolioInfos = org.yccheok.jstock.portfolio.Utils.getPortfolioInfos();
        File watchlistInfosFile = new File(Utils.getUserDataDirectory() + "android" + File.separator + "watchlistinfos.csv");
        File portfolioInfosFile = new File(Utils.getUserDataDirectory() + "android" + File.separator + "portfolioinfos.csv");
        boolean result0 = Statements.newInstanceFromWatchlistInfos(watchlistInfos).saveAsCSVFile(watchlistInfosFile);
        boolean result1 = Statements.newInstanceFromPortfolioInfos(portfolioInfos).saveAsCSVFile(portfolioInfosFile);
        return result0 && result1;
    }

    public void reloadAfterDownloadFromCloud() {
        this.statusBar.setCountryIcon(this.jStockOptions.getCountry().getIcon(), this.jStockOptions.getCountry().toString());
        this.portfolioManagementJPanel.initPortfolio();
        this.indicatorScannerJPanel.stop();
        this.indicatorScannerJPanel.clear();
        this.initDatabase(true);
        this.initAjaxProvider();
        this.initMarketThread();
        this.initMarketJPanel();
        this.initStockHistoryMonitor();
        this.initOthersStockHistoryMonitor();
        this.initCurrencyExchangeMonitor();
        this.initRealTimeStockMonitor();
        this.initWatchlist();
        this.initAlertStateManager();
        this.initDynamicCharts();
        this.initDynamicChartVisibility();
        Enumeration<AbstractButton> e = this.buttonGroup2.getElements();
        while (e.hasMoreElements()) {
            AbstractButton button = e.nextElement();
            JRadioButtonMenuItem m = (JRadioButtonMenuItem)button;
            if (!m.getText().equals(this.jStockOptions.getCountry().toHumanReadableString())) continue;
            m.setSelected(true);
            break;
        }
        if (null != this.indicatorPanel) {
            this.indicatorPanel.initIndicatorProjectManager();
            this.indicatorPanel.initModuleProjectManager();
        }
        this.initGUIOptions();
        this.indicatorScannerJPanel.initGUIOptions();
    }

    private void changeCountry(Country country) {
        if (country == null) {
            return;
        }
        if (this.jStockOptions.getCountry() == country) {
            return;
        }
        if (this.needToSaveUserDefinedDatabase) {
            this.saveUserDefinedDatabaseAsCSV(country, this.stockInfoDatabase);
        }
        this.saveGUIOptions();
        this.saveWatchlist();
        this.portfolioManagementJPanel.savePortfolio();
        if (country == Country.Spain) {
            JOptionPane.showMessageDialog(null, MessagesBundle.getString("info_message_spain_not_supported"), MessagesBundle.getString("info_title_spain_not_supported"), 1);
        }
        this.jStockOptions.setCountry(country);
        this.statusBar.setCountryIcon(country.getIcon(), country.toString());
        this.portfolioManagementJPanel.initPortfolio();
        this.indicatorScannerJPanel.stop();
        this.indicatorScannerJPanel.clear();
        this.initDatabase(true);
        this.initAjaxProvider();
        this.initMarketThread();
        this.initMarketJPanel();
        this.initStockHistoryMonitor();
        this.initOthersStockHistoryMonitor();
        this.initCurrencyExchangeMonitor();
        this.initRealTimeStockMonitor();
        this.initWatchlist();
        this.initAlertStateManager();
        this.initDynamicCharts();
        Enumeration<AbstractButton> e = this.buttonGroup2.getElements();
        while (e.hasMoreElements()) {
            AbstractButton button = e.nextElement();
            JRadioButtonMenuItem m = (JRadioButtonMenuItem)button;
            if (country == Country.UnitedState && m.getText().equals(country.toString() + "s")) {
                m.setSelected(true);
                break;
            }
            if (!m.getText().equals(country.toString())) continue;
            m.setSelected(true);
            break;
        }
    }

    private MouseAdapter getMyJXStatusBarExchangeRateLabelMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    OptionsJDialog optionsJDialog = new OptionsJDialog((Frame)MainFrame.this, true);
                    optionsJDialog.setLocationRelativeTo(MainFrame.this);
                    optionsJDialog.set(MainFrame.this.jStockOptions);
                    optionsJDialog.select(GUIBundle.getString("OptionsJPanel_Wealth"));
                    optionsJDialog.setVisible(true);
                }
            }
        };
    }

    private MouseAdapter getMyJXStatusBarCountryLabelMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CountryJDialog countryJDialog = new CountryJDialog((Frame)MainFrame.this, true);
                    countryJDialog.setLocationRelativeTo(MainFrame.this);
                    countryJDialog.setCountry(MainFrame.this.jStockOptions.getCountry());
                    countryJDialog.setVisible(true);
                    Country country = countryJDialog.getCountry();
                    MainFrame.this.changeCountry(country);
                }
            }
        };
    }

    private MouseAdapter getMyJXStatusBarImageLabelMouseAdapter() {
        return new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DatabaseTask task = MainFrame.this.databaseTask;
                    if (task != null) {
                        if (task.isDone()) {
                            boolean success = false;
                            if (!task.isCancelled()) {
                                try {
                                    success = (Boolean)task.get();
                                }
                                catch (InterruptedException ex) {
                                    log.error(null, (Throwable)ex);
                                }
                                catch (ExecutionException ex) {
                                    log.error(null, (Throwable)ex);
                                }
                                catch (CancellationException ex) {
                                    log.error(null, (Throwable)ex);
                                }
                            }
                            if (!success) {
                                MainFrame.this.initDatabase(true);
                            } else {
                                int result = JOptionPane.showConfirmDialog(MainFrame.this, MessagesBundle.getString("question_message_perform_server_reconnecting"), MessagesBundle.getString("question_title_perform_server_reconnecting"), 0, 3);
                                if (result == 0) {
                                    MainFrame.this.initDatabase(false);
                                }
                            }
                        } else {
                            int result = JOptionPane.showConfirmDialog(MainFrame.this, MessagesBundle.getString("question_message_cancel_server_reconnecting"), MessagesBundle.getString("question_title_cancel_server_reconnecting"), 0, 3);
                            if (result == 0) {
                                Object object = MainFrame.this.databaseTaskMonitor;
                                synchronized (object) {
                                    MainFrame.this.databaseTask.cancel(true);
                                    MainFrame.this.databaseTask = null;
                                }
                                MainFrame.this.setStatusBar(false, GUIBundle.getString("MainFrame_NetworkError"));
                                MainFrame.this.statusBar.setImageIcon(MainFrame.this.getImageIcon("/images/16x16/network-error.png"), ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_DoubleClickedToTryAgain"));
                            }
                        }
                    } else {
                        MainFrame.this.initDatabase(true);
                    }
                }
            }
        };
    }

    public StockInfoDatabase getStockInfoDatabase() {
        return this.stockInfoDatabase;
    }

    public StockNameDatabase getStockNameDatabase() {
        return this.stockNameDatabase;
    }

    public List<StockServerFactory> getStockServerFactories() {
        return Factories.INSTANCE.getStockServerFactories(this.jStockOptions.getCountry());
    }

    public List<Stock> getStocks() {
        StockTableModel tableModel = (StockTableModel)this.jTable1.getModel();
        return tableModel.getStocks();
    }

    public void addStockToTable(final Stock stock, final StockAlert alert) {
        final JTable _jTable1 = this.jTable1;
        if (EventQueue.isDispatchThread()) {
            StockTableModel tableModel = (StockTableModel)_jTable1.getModel();
            tableModel.addStock(stock, alert);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StockTableModel tableModel = (StockTableModel)_jTable1.getModel();
                    tableModel.addStock(stock, alert);
                }
            });
        }
    }

    public void addStockToTable(final Stock stock) {
        final JTable _jTable1 = this.jTable1;
        if (EventQueue.isDispatchThread()) {
            StockTableModel tableModel = (StockTableModel)_jTable1.getModel();
            tableModel.addStock(stock);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StockTableModel tableModel = (StockTableModel)_jTable1.getModel();
                    tableModel.addStock(stock);
                }
            });
        }
    }

    private boolean isStockBeingSelected(Stock stock) {
        int[] rows = this.jTable1.getSelectedRows();
        if (rows.length == 1) {
            int row = rows[0];
            StockTableModel tableModel = (StockTableModel)this.jTable1.getModel();
            int modelIndex = this.jTable1.convertRowIndexToModel(row);
            if (stock.code.equals(tableModel.getStock((int)modelIndex).code)) {
                return true;
            }
        }
        return false;
    }

    private Stock getSelectedStock() {
        int[] rows = this.jTable1.getSelectedRows();
        if (rows.length == 1) {
            int row = rows[0];
            StockTableModel tableModel = (StockTableModel)this.jTable1.getModel();
            int modelIndex = this.jTable1.convertRowIndexToModel(row);
            return tableModel.getStock(modelIndex);
        }
        return null;
    }

    private void updateStockToTable(Stock stock) {
        StockTableModel tableModel = (StockTableModel)this.jTable1.getModel();
        tableModel.updateStock(stock);
    }

    private void update(final Indicator indicator, Boolean result) {
        Runnable r;
        boolean flag = result;
        if (!flag) {
            return;
        }
        StockTableModel stockTableModel = (StockTableModel)this.jTable1.getModel();
        final Stock stock = indicator.getStock();
        final Double price = ((OperatorIndicator)indicator).getName().equalsIgnoreCase("fallbelow") ? stockTableModel.getFallBelow(stock) : stockTableModel.getRiseAbove(stock);
        final double lastPrice = stock.getLastPrice();
        if (lastPrice <= 0.0) {
            return;
        }
        if (this.jStockOptions.isPopupMessage()) {
            r = new Runnable(){

                @Override
                public void run() {
                    String template;
                    String message = "";
                    if (((OperatorIndicator)indicator).getName().equalsIgnoreCase("fallbelow")) {
                        template = GUIBundle.getString("MainFrame_FallBelow_template");
                        message = MessageFormat.format(template, stock.symbol, lastPrice, price);
                    } else {
                        template = GUIBundle.getString("MainFrame_RiseAbove_template");
                        message = MessageFormat.format(template, stock.symbol, lastPrice, price);
                    }
                    if (MainFrame.this.jStockOptions.isPopupMessage()) {
                        MainFrame.this.displayPopupMessage(stock.symbol.toString(), message);
                        if (MainFrame.this.jStockOptions.isSoundEnabled()) {
                            Utils.playAlertSound();
                        }
                        try {
                            Thread.sleep(MainFrame.this.jStockOptions.getAlertSpeed() * 1000);
                        }
                        catch (InterruptedException exp) {
                            log.error(null, (Throwable)exp);
                        }
                    }
                }
            };
            try {
                this.systemTrayAlertPool.submit(r);
            }
            catch (RejectedExecutionException exp) {
                log.error(null, (Throwable)exp);
            }
        }
        if (!this.jStockOptions.isPopupMessage() && this.jStockOptions.isSoundEnabled()) {
            r = new Runnable(){

                @Override
                public void run() {
                    if (MainFrame.this.jStockOptions.isSoundEnabled()) {
                        Utils.playAlertSound();
                        try {
                            Thread.sleep(MainFrame.this.jStockOptions.getAlertSpeed() * 1000);
                        }
                        catch (InterruptedException exp) {
                            log.error(null, (Throwable)exp);
                        }
                    }
                }
            };
            try {
                this.systemTrayAlertPool.submit(r);
            }
            catch (RejectedExecutionException exp) {
                log.error(null, (Throwable)exp);
            }
        }
        if (this.jStockOptions.isSendEmail()) {
            r = new Runnable(){

                @Override
                public void run() {
                    String template;
                    String title = "";
                    if (((OperatorIndicator)indicator).getName().equalsIgnoreCase("fallbelow")) {
                        template = GUIBundle.getString("MainFrame_FallBelow_template");
                        title = MessageFormat.format(template, stock.symbol, lastPrice, price);
                    } else {
                        template = GUIBundle.getString("MainFrame_RiseAbove_template");
                        title = MessageFormat.format(template, stock.symbol, lastPrice, price);
                    }
                    String message = title + "\n(JStock)";
                    try {
                        String email = Utils.decrypt(MainFrame.this.jStockOptions.getEmail());
                        String CCEmail = Utils.decrypt(MainFrame.this.jStockOptions.getCCEmail());
                        GoogleMail.Send(email, Utils.decrypt(MainFrame.this.jStockOptions.getEmailPassword()), email + "@gmail.com", CCEmail, title, message);
                    }
                    catch (AddressException exp) {
                        log.error(null, (Throwable)exp);
                    }
                    catch (MessagingException exp) {
                        log.error(null, (Throwable)exp);
                    }
                }
            };
            try {
                this.emailAlertPool.submit(r);
            }
            catch (RejectedExecutionException exp) {
                log.error(null, (Throwable)exp);
            }
        }
        if (this.jStockOptions.isSMSEnabled()) {
            r = new Runnable(){

                @Override
                public void run() {
                    boolean status;
                    String template;
                    String message = "";
                    if (((OperatorIndicator)indicator).getName().equalsIgnoreCase("fallbelow")) {
                        template = GUIBundle.getString("MainFrame_FallBelow_template");
                        message = MessageFormat.format(template, stock.symbol, lastPrice, price);
                    } else {
                        template = GUIBundle.getString("MainFrame_RiseAbove_template");
                        message = MessageFormat.format(template, stock.symbol, lastPrice, price);
                    }
                    String username = Utils.decrypt(MainFrame.this.jStockOptions.getGoogleCalendarUsername());
                    if (SMSLimiter.INSTANCE.isSMSAllowed() && (status = GoogleCalendar.SMS(username, Utils.decrypt(MainFrame.this.jStockOptions.getGoogleCalendarPassword()), message))) {
                        SMSLimiter.INSTANCE.inc();
                    }
                }
            };
            try {
                this.smsAlertPool.submit(r);
            }
            catch (RejectedExecutionException exp) {
                log.error(null, (Throwable)exp);
            }
        }
    }

    private void highlightStock(int modelRow) {
        if (modelRow < 0) {
            return;
        }
        int row = this.jTable1.convertRowIndexToView(modelRow);
        this.jTable1.getSelectionModel().setSelectionInterval(row, row);
        JTableUtilities.scrollToVisible(this.jTable1, row, 0);
    }

    public boolean addUserDefinedStockInfo(StockInfo stockInfo) {
        StockInfoDatabase stock_info_database = this.stockInfoDatabase;
        if (stock_info_database == null) {
            return false;
        }
        boolean result = stock_info_database.addUserDefinedStockInfo(stockInfo);
        if (result) {
            this.needToSaveUserDefinedDatabase = true;
        }
        return result;
    }

    private Observer<AutoCompleteJComboBox, MatchType> getMatchObserver() {
        return new Observer<AutoCompleteJComboBox, MatchType>(){

            @Override
            public void update(AutoCompleteJComboBox subject, MatchType matchType) {
                assert (matchType != null);
                Code code = matchType.getCode();
                Symbol symbol = Symbol.newInstance(matchType.n);
                StockInfo stockInfo = StockInfo.newInstance(code, symbol);
                MainFrame.this.addStockInfoFromAutoCompleteJComboBox(stockInfo);
                MainFrame.this.addUserDefinedStockInfo(stockInfo);
            }
        };
    }

    private Observer<AutoCompleteJComboBox, ResultType> getResultObserver() {
        return new Observer<AutoCompleteJComboBox, ResultType>(){

            @Override
            public void update(AutoCompleteJComboBox subject, ResultType resultType) {
                assert (resultType != null);
                Code code = Code.newInstance(resultType.symbol);
                Symbol symbol = Symbol.newInstance(resultType.name);
                StockInfo stockInfo = StockInfo.newInstance(code, symbol);
                MainFrame.this.addStockInfoFromAutoCompleteJComboBox(stockInfo);
                MainFrame.this.addUserDefinedStockInfo(stockInfo);
            }
        };
    }

    private Observer<AutoCompleteJComboBox, StockInfo> getStockInfoObserver() {
        return new Observer<AutoCompleteJComboBox, StockInfo>(){

            @Override
            public void update(AutoCompleteJComboBox subject, StockInfo stockInfo) {
                assert (stockInfo != null);
                MainFrame.this.addStockInfoFromAutoCompleteJComboBox(stockInfo);
            }
        };
    }

    private void addStockInfoFromAutoCompleteJComboBox(StockInfo stockInfo) {
        StockTableModel tableModel = (StockTableModel)this.jTable1.getModel();
        Stock emptyStock = Utils.getEmptyStock(stockInfo);
        this.addStockToTable(emptyStock);
        int row = tableModel.findRow(emptyStock);
        this.realTimeStockMonitor.addStockCode(stockInfo.code);
        this.realTimeStockMonitor.startNewThreadsIfNecessary();
        this.realTimeStockMonitor.refresh();
        this.highlightStock(row);
    }

    private Observer<Indicator, Boolean> getAlertStateManagerObserver() {
        return new Observer<Indicator, Boolean>(){

            @Override
            public void update(Indicator subject, Boolean arg) {
                MainFrame.this.update(subject, arg);
            }
        };
    }

    private Observer<RealTimeStockMonitor, List<Stock>> getRealTimeStockMonitorObserver() {
        return new Observer<RealTimeStockMonitor, List<Stock>>(){

            @Override
            public void update(RealTimeStockMonitor monitor, List<Stock> stocks) {
                MainFrame.this.update(monitor, stocks);
            }
        };
    }

    private Observer<StockHistoryMonitor, StockHistoryMonitor.StockHistoryRunnable> getStockHistoryMonitorObserver() {
        return new Observer<StockHistoryMonitor, StockHistoryMonitor.StockHistoryRunnable>(){

            @Override
            public void update(StockHistoryMonitor monitor, StockHistoryMonitor.StockHistoryRunnable runnable) {
                MainFrame.this.update(monitor, runnable);
            }
        };
    }

    public void displayHistoryChart(Stock stock) {
        StockHistoryServer stockHistoryServer = this.stockHistoryMonitor.getStockHistoryServer(stock.code);
        if (stockHistoryServer == null) {
            if (this.stockCodeHistoryGUI.add(stock.code) && this.stockHistoryMonitor.addStockCode(stock.code)) {
                String template = GUIBundle.getString("MainFrame_LookingForHistory_template");
                String message = MessageFormat.format(template, stock.symbol, this.stockCodeHistoryGUI.size());
                this.setStatusBar(true, message);
            }
        } else {
            ChartJDialog chartJDialog = new ChartJDialog((Frame)this, stock.symbol + " (" + stock.code + ")", false, stockHistoryServer);
            chartJDialog.setVisible(true);
        }
    }

    private JPopupMenu getMyJTablePopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        final TableModel tableModel = this.jTable1.getModel();
        JMenuItem menuItem = new JMenuItem(ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_History..."), this.getImageIcon("/images/16x16/strokedocker.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int[] rows = MainFrame.this.jTable1.getSelectedRows();
                StockTableModel tableModel = (StockTableModel)MainFrame.this.jTable1.getModel();
                for (int row : rows) {
                    int modelIndex = MainFrame.this.jTable1.getRowSorter().convertRowIndexToModel(row);
                    Stock stock = tableModel.getStock(modelIndex);
                    MainFrame.this.displayHistoryChart(stock);
                }
            }
        });
        popup.add(menuItem);
        popup.addSeparator();
        if (this.jTable1.getSelectedRowCount() == 1) {
            menuItem = new JMenuItem(ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_Buy..."), this.getImageIcon("/images/16x16/inbox.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int row = MainFrame.this.jTable1.getSelectedRow();
                    int modelIndex = MainFrame.this.jTable1.getRowSorter().convertRowIndexToModel(row);
                    Stock stock = ((StockTableModel)tableModel).getStock(modelIndex);
                    MainFrame.this.portfolioManagementJPanel.showNewBuyTransactionJDialog(stock, stock.getLastPrice(), false);
                }
            });
            popup.add(menuItem);
            popup.addSeparator();
        }
        menuItem = new JMenuItem(ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_Delete"), this.getImageIcon("/images/16x16/editdelete.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.deteleSelectedTableRow();
            }
        });
        popup.add(menuItem);
        return popup;
    }

    private static boolean saveStockNameDatabaseAsCSV(Country country, StockNameDatabase stockNameDatabase) {
        File stockNameDatabaseCSVFile = new File(Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "database" + File.separator + "stock-name-database.csv");
        Statements statements = Statements.newInstanceFromStockNameDatabase(stockNameDatabase);
        boolean result = statements.saveAsCSVFile(stockNameDatabaseCSVFile);
        return result;
    }

    private static boolean saveStockInfoDatabaseAsCSV(Country country, StockInfoDatabase stockInfoDatabase) {
        File stockInfoDatabaseCSVFile = org.yccheok.jstock.engine.Utils.getStockInfoDatabaseFile(country);
        Statements statements = Statements.newInstanceFromStockInfoDatabase(stockInfoDatabase);
        boolean result = statements.saveAsCSVFile(stockInfoDatabaseCSVFile);
        return result;
    }

    private boolean saveUserDefinedDatabaseAsCSV(Country country, StockInfoDatabase stockInfoDatabase) {
        List<Pair<Code, Symbol>> pairs = MainFrame.getUserDefinedPair(stockInfoDatabase);
        File userDefinedDatabaseCSVFile = new File(Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "database" + File.separator + "user-defined-database.csv");
        if (pairs.isEmpty() && userDefinedDatabaseCSVFile.delete()) {
            return true;
        }
        Statements statements = Statements.newInstanceFromUserDefinedDatabase(pairs);
        boolean result = statements.saveAsCSVFile(userDefinedDatabaseCSVFile);
        this.needToSaveUserDefinedDatabase = false;
        return result;
    }

    private List<Pair<Code, Symbol>> loadUserDefinedDatabaseFromCSV(Country country) {
        File userDefinedDatabaseCSVFile = new File(Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "database" + File.separator + "user-defined-database.csv");
        Statements statements = Statements.newInstanceFromCSVFile(userDefinedDatabaseCSVFile);
        if (statements.getType() != Statement.Type.UserDefinedDatabase) {
            return new ArrayList<Pair<Code, Symbol>>();
        }
        ArrayList<Pair<Code, Symbol>> pairs = new ArrayList<Pair<Code, Symbol>>();
        int ei = statements.size();
        for (int i = 0; i < ei; ++i) {
            Statement statement = statements.get(i);
            Atom atom0 = statement.getAtom(0);
            Atom atom1 = statement.getAtom(1);
            Code code = Code.newInstance(atom0.getValue().toString());
            Symbol symbol = Symbol.newInstance(atom1.getValue().toString());
            pairs.add(new Pair<Code, Symbol>(code, symbol));
        }
        return pairs;
    }

    private StockNameDatabase loadStockNameDatabaseFromCSV(Country country) {
        File stockNameDatabaseCSVFile = new File(Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "database" + File.separator + "stock-name-database.csv");
        Statements statements = Statements.newInstanceFromCSVFile(stockNameDatabaseCSVFile);
        if (statements.getType() != Statement.Type.StockNameDatabase) {
            return null;
        }
        ArrayList<Stock> stocks = new ArrayList<Stock>();
        int ei = statements.size();
        for (int i = 0; i < ei; ++i) {
            Statement statement = statements.get(i);
            Atom atom0 = statement.getAtom(0);
            Atom atom1 = statement.getAtom(1);
            Code code = Code.newInstance(atom0.getValue().toString());
            String name = atom1.getValue().toString();
            Stock stock = new Stock.Builder(code, Symbol.newInstance(code.toString())).name(name).build();
            stocks.add(stock);
        }
        return new StockNameDatabase(stocks);
    }

    private StockInfoDatabase loadStockInfoDatabaseFromCSV(Country country) {
        File stockInfoDatabaseCSVFile = org.yccheok.jstock.engine.Utils.getStockInfoDatabaseFile(country);
        Statements statements = Statements.newInstanceFromCSVFile(stockInfoDatabaseCSVFile);
        if (statements.getType() != Statement.Type.StockInfoDatabase) {
            return null;
        }
        ArrayList<Stock> stocks = new ArrayList<Stock>();
        int ei = statements.size();
        for (int i = 0; i < ei; ++i) {
            Statement statement = statements.get(i);
            Atom atom0 = statement.getAtom(0);
            Atom atom1 = statement.getAtom(1);
            Atom atom2 = statement.getAtom(2);
            Atom atom3 = statement.getAtom(3);
            Code code = Code.newInstance(atom0.getValue().toString());
            Symbol symbol = Symbol.newInstance(atom1.getValue().toString());
            Stock.Industry industry = Stock.Industry.Unknown;
            Stock.Board board = Stock.Board.Unknown;
            try {
                industry = Stock.Industry.valueOf(atom2.getValue().toString());
            }
            catch (Exception exp) {
                log.error(null, (Throwable)exp);
            }
            try {
                board = Stock.Board.valueOf(atom3.getValue().toString());
            }
            catch (Exception exp) {
                log.error(null, (Throwable)exp);
            }
            Stock stock = new Stock.Builder(code, symbol).board(board).industry(industry).build();
            stocks.add(stock);
        }
        return new StockInfoDatabase(stocks);
    }

    private void initMyJXStatusBarExchangeRateLabelMouseAdapter() {
        MouseAdapter mouseAdapter = this.getMyJXStatusBarExchangeRateLabelMouseAdapter();
        this.statusBar.addExchangeRateLabelMouseListener(mouseAdapter);
    }

    private void initMyJXStatusBarCountryLabelMouseAdapter() {
        MouseAdapter mouseAdapter = this.getMyJXStatusBarCountryLabelMouseAdapter();
        this.statusBar.addCountryLabelMouseListener(mouseAdapter);
    }

    private void initMyJXStatusBarImageLabelMouseAdapter() {
        MouseAdapter mouseAdapter = this.getMyJXStatusBarImageLabelMouseAdapter();
        this.statusBar.addImageLabelMouseListener(mouseAdapter);
    }

    public void initCurrencyExchangeMonitor() {
        List<StockServerFactory> stockServerFactories = this.getStockServerFactories();
        this.portfolioManagementJPanel.initCurrencyExchangeMonitor(stockServerFactories);
    }

    private void initRealTimeStockMonitor() {
        final RealTimeStockMonitor oldRealTimeStockMonitor = this.realTimeStockMonitor;
        if (oldRealTimeStockMonitor != null) {
            this.zombiePool.execute(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)("Prepare to shut down " + oldRealTimeStockMonitor + "..."));
                    oldRealTimeStockMonitor.clearStockCodes();
                    oldRealTimeStockMonitor.dettachAll();
                    oldRealTimeStockMonitor.stop();
                    log.info((Object)("Shut down " + oldRealTimeStockMonitor + " peacefully."));
                }
            });
        }
        this.realTimeStockMonitor = new RealTimeStockMonitor(4, 20, this.jStockOptions.getScanningSpeed());
        List<StockServerFactory> stockServerFactories = this.getStockServerFactories();
        this.realTimeStockMonitor.setStockServerFactories(stockServerFactories);
        this.realTimeStockMonitor.attach(this.realTimeStockMonitorObserver);
        this.indicatorScannerJPanel.initRealTimeStockMonitor(stockServerFactories);
        this.portfolioManagementJPanel.initRealTimeStockMonitor(stockServerFactories);
    }

    private void initBrokingFirmLogos() {
        int size = this.jStockOptions.getBrokingFirmSize();
        for (int i = 0; i < size; ++i) {
            try {
                BufferedImage bufferedImage = ImageIO.read(new File(Utils.getUserDataDirectory() + "logos" + File.separator + i + ".png"));
                this.jStockOptions.getBrokingFirm(i).setLogo(bufferedImage);
                continue;
            }
            catch (IOException exp) {
                log.error(null, (Throwable)exp);
            }
        }
    }

    private void initGUIOptions() {
        File f = new File(Utils.getUserDataDirectory() + "config" + File.separator + "mainframe.xml");
        GUIOptions guiOptions = Utils.fromXML(GUIOptions.class, f);
        if (guiOptions == null) {
            JTableUtilities.removeTableColumn(this.jTable1, GUIBundle.getString("MainFrame_Open"));
            return;
        }
        if (guiOptions.getJTableOptionsSize() <= 0) {
            JTableUtilities.removeTableColumn(this.jTable1, GUIBundle.getString("MainFrame_Open"));
            return;
        }
        JTableUtilities.setJTableOptions(this.jTable1, guiOptions.getJTableOptions(0));
    }

    private void saveGUIOptions() {
        this._saveGUIOptions();
        this.indicatorScannerJPanel.saveGUIOptions();
        this.portfolioManagementJPanel.saveGUIOptions();
    }

    private boolean _saveGUIOptions() {
        if (!Utils.createCompleteDirectoryHierarchyIfDoesNotExist(Utils.getUserDataDirectory() + "config")) {
            return false;
        }
        GUIOptions.JTableOptions jTableOptions = new GUIOptions.JTableOptions();
        int count = this.jTable1.getColumnCount();
        for (int i = 0; i < count; ++i) {
            String name = this.jTable1.getColumnName(i);
            TableColumn column = this.jTable1.getColumnModel().getColumn(i);
            jTableOptions.addColumnOption(GUIOptions.JTableOptions.ColumnOption.newInstance(name, column.getWidth()));
        }
        GUIOptions guiOptions = new GUIOptions();
        guiOptions.addJTableOptions(jTableOptions);
        File f = new File(Utils.getUserDataDirectory() + "config" + File.separator + "mainframe.xml");
        return Utils.toXML((Object)guiOptions, f);
    }

    private void initChartJDialogOptions() {
        File f = new File(Utils.getUserDataDirectory() + "config" + File.separator + "chartjdialogoptions.xml");
        ChartJDialogOptions tmp = Utils.fromXML(ChartJDialogOptions.class, f);
        if (tmp == null) {
            this.chartJDialogOptions = new ChartJDialogOptions();
        } else {
            this.chartJDialogOptions = tmp;
            log.info((Object)("chartJDialogOptions loaded from " + f.toString() + " successfully."));
        }
    }

    private void initJStockOptions(JStockOptions jStockOptions) {
        this.jStockOptions = jStockOptions;
        if (this.jStockOptions.getScanningSpeed() == 0) {
            this.jStockOptions.setScanningSpeed(5000);
        }
        String proxyHost = this.jStockOptions.getProxyServer();
        int proxyPort = this.jStockOptions.getProxyPort();
        if (proxyHost.length() > 0 && org.yccheok.jstock.engine.Utils.isValidPortNumber(proxyPort)) {
            System.getProperties().put("http.proxyHost", proxyHost);
            System.getProperties().put("http.proxyPort", "" + proxyPort);
        } else {
            System.getProperties().remove("http.proxyHost");
            System.getProperties().remove("http.proxyPort");
        }
        for (Country country : Country.values()) {
            Class c = this.jStockOptions.getPrimaryStockServerFactoryClass(country);
            if (c == null) continue;
            Factories.INSTANCE.updatePrimaryStockServerFactory(country, c);
        }
    }

    public void updatePrimaryStockServerFactory(Country country, Class<? extends StockServerFactory> c) {
        if (c == this.jStockOptions.getPrimaryStockServerFactoryClass(country)) {
            return;
        }
        this.jStockOptions.addPrimaryStockServerFactoryClass(country, c);
        Factories.INSTANCE.updatePrimaryStockServerFactory(country, c);
        this.realTimeStockMonitor.setStockServerFactories(this.getStockServerFactories());
        this.stockHistoryMonitor.setStockServerFactories(this.getStockServerFactories());
        this.indicatorScannerJPanel.updatePrimaryStockServerFactory(Collections.unmodifiableList(this.getStockServerFactories()));
        this.portfolioManagementJPanel.updatePrimaryStockServerFactory(Collections.unmodifiableList(this.getStockServerFactories()));
        this.indicatorPanel.updatePrimaryStockServerFactory(Collections.unmodifiableList(this.getStockServerFactories()));
    }

    private void initWatchlist() {
        this.timestamp = 0L;
        this.initCSVWatchlist();
    }

    private boolean initCSVWatchlist() {
        List<String> availableWatchlistNames = org.yccheok.jstock.watchlist.Utils.getWatchlistNames();
        if (availableWatchlistNames.size() <= 0) {
            org.yccheok.jstock.watchlist.Utils.createEmptyWatchlist(org.yccheok.jstock.watchlist.Utils.getDefaultWatchlistName());
            availableWatchlistNames = org.yccheok.jstock.watchlist.Utils.getWatchlistNames();
        }
        assert (!availableWatchlistNames.isEmpty());
        if (!availableWatchlistNames.contains(this.jStockOptions.getWatchlistName())) {
            this.jStockOptions.setWatchlistName(availableWatchlistNames.get(0));
        }
        this.clearAllStocks();
        File realTimeStockFile = org.yccheok.jstock.watchlist.Utils.getWatchlistFile(org.yccheok.jstock.watchlist.Utils.getWatchlistDirectory());
        return this.openAsCSVFile(realTimeStockFile);
    }

    public static boolean saveCSVWatchlist(String directory, CSVWatchlist csvWatchlist) {
        assert (directory.endsWith(File.separator));
        if (!Utils.createCompleteDirectoryHierarchyIfDoesNotExist(directory)) {
            return false;
        }
        return MainFrame.saveAsCSVFile(csvWatchlist, org.yccheok.jstock.watchlist.Utils.getWatchlistFile(directory), true);
    }

    private boolean saveCSVWathclist() {
        String directory = org.yccheok.jstock.watchlist.Utils.getWatchlistDirectory();
        TableModel tableModel = this.jTable1.getModel();
        CSVWatchlist csvWatchlist = CSVWatchlist.newInstance(tableModel);
        return MainFrame.saveCSVWatchlist(directory, csvWatchlist);
    }

    private boolean saveWatchlist() {
        return this.saveCSVWathclist();
    }

    private boolean saveBrokingFirmLogos() {
        if (!Utils.createCompleteDirectoryHierarchyIfDoesNotExist(Utils.getUserDataDirectory() + "logos")) {
            return false;
        }
        if (!Utils.deleteDir(Utils.getUserDataDirectory() + "logos", false)) {
            return false;
        }
        int size = this.jStockOptions.getBrokingFirmSize();
        for (int i = 0; i < size; ++i) {
            Image image = this.jStockOptions.getBrokingFirm(i).getLogo();
            if (image == null) continue;
            File f = new File(Utils.getUserDataDirectory() + "logos" + File.separator + i + ".png");
            try {
                ImageIO.write((RenderedImage)Utils.toBufferedImage(image), "png", f);
                continue;
            }
            catch (IOException exp) {
                log.error(null, (Throwable)exp);
            }
        }
        return true;
    }

    private boolean saveDatabase() {
        Country country = this.jStockOptions.getCountry();
        if (!Utils.createCompleteDirectoryHierarchyIfDoesNotExist(Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "database")) {
            return false;
        }
        StockInfoDatabase stock_info_database = this.stockInfoDatabase;
        StockNameDatabase name_database = this.stockNameDatabase;
        boolean b0 = true;
        if (name_database != null) {
            Statements statements = Statements.newInstanceFromStockNameDatabase(name_database);
            File stockNameDatabaseCSVFile = new File(Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "database" + File.separator + "stock-name-database.csv");
            b0 = statements.saveAsCSVFile(stockNameDatabaseCSVFile);
        }
        if (stock_info_database == null) {
            return false;
        }
        if (stock_info_database.isEmpty()) {
            log.info((Object)"Database was corrupted.");
            return false;
        }
        boolean b1 = this.saveUserDefinedDatabaseAsCSV(country, stock_info_database);
        boolean b2 = true;
        File f = org.yccheok.jstock.engine.Utils.getStockInfoDatabaseFile(country);
        if (!f.exists()) {
            b2 = MainFrame.saveStockInfoDatabaseAsCSV(country, stock_info_database);
        }
        return b0 && b1 && b2;
    }

    private static List<Pair<Code, Symbol>> getUserDefinedPair(StockInfoDatabase stockInfoDatabase) {
        ArrayList<Pair<Code, Symbol>> pairs = new ArrayList<Pair<Code, Symbol>>();
        List<StockInfo> stockInfos = stockInfoDatabase.getUserDefinedStockInfos();
        for (StockInfo stockInfo : stockInfos) {
            pairs.add(new Pair<Code, Symbol>(stockInfo.code, stockInfo.symbol));
        }
        return pairs;
    }

    private boolean saveChartJDialogOptions() {
        if (!Utils.createCompleteDirectoryHierarchyIfDoesNotExist(Utils.getUserDataDirectory() + "config")) {
            return false;
        }
        File f = new File(Utils.getUserDataDirectory() + "config" + File.separator + "chartjdialogoptions.xml");
        return Utils.toXML((Object)this.chartJDialogOptions, f);
    }

    private boolean saveJStockOptions() {
        if (!Utils.createCompleteDirectoryHierarchyIfDoesNotExist(Utils.getUserDataDirectory() + "config")) {
            return false;
        }
        File f = new File(Utils.getUserDataDirectory() + "config" + File.separator + "options.xml");
        return Utils.toXML((Object)this.jStockOptions, f);
    }

    private void removeOldHistoryData(Country country) {
        Utils.deleteAllOldFiles(new File(Utils.getHistoryDirectory(country)), 1);
    }

    private void initAlertStateManager() {
        this.alertStateManager.clearState();
        this.alertStateManager.attach(this.alertStateManagerObserver);
    }

    private void initOthersStockHistoryMonitor() {
        List<StockServerFactory> stockServerFactories = this.getStockServerFactories();
        this.indicatorPanel.initStockHistoryMonitor(Collections.unmodifiableList(stockServerFactories));
        this.indicatorScannerJPanel.initStockHistoryMonitor(Collections.unmodifiableList(stockServerFactories));
    }

    private void initStockHistoryMonitor() {
        final StockHistoryMonitor oldStockHistoryMonitor = this.stockHistoryMonitor;
        if (oldStockHistoryMonitor != null) {
            this.zombiePool.execute(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)("Prepare to shut down " + oldStockHistoryMonitor + "..."));
                    oldStockHistoryMonitor.clearStockCodes();
                    oldStockHistoryMonitor.dettachAll();
                    oldStockHistoryMonitor.stop();
                    log.info((Object)("Shut down " + oldStockHistoryMonitor + " peacefully."));
                }
            });
        }
        this.stockHistoryMonitor = new StockHistoryMonitor(4);
        List<StockServerFactory> stockServerFactories = this.getStockServerFactories();
        this.stockHistoryMonitor.setStockServerFactories(stockServerFactories);
        this.stockHistoryMonitor.attach(this.stockHistoryMonitorObserver);
        Country country = this.jStockOptions.getCountry();
        this.removeOldHistoryData(country);
        StockHistorySerializer stockHistorySerializer = new StockHistorySerializer(Utils.getHistoryDirectory());
        this.stockHistoryMonitor.setStockHistorySerializer(stockHistorySerializer);
        this.stockHistoryMonitor.setDuration(Duration.getTodayDurationByYears(this.jStockOptions.getHistoryDuration()));
    }

    private void initKLSEInfoStockServerFactoryThread() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String remove = Utils.getUUIDValue(org.yccheok.jstock.network.Utils.getURL(Utils.Type.OPTIONS), "remove_klse_info_stock_server_factory");
                if (remove != null && remove.equals("1")) {
                    Factories.INSTANCE.removeKLSEInfoStockServerFactory();
                }
            }
        };
        this.klseInfoStockServerFactoryThread = new Thread(runnable);
        this.klseInfoStockServerFactoryThread.start();
    }

    public void initLatestNewsTask() {
        if (this.jStockOptions.isAutoUpdateNewsEnabled()) {
            if (this.latestNewsTask == null) {
                this.latestNewsTask = new LatestNewsTask();
                this.latestNewsTask.execute();
            }
        } else {
            final LatestNewsTask oldLatestNewsTask = this.latestNewsTask;
            if (oldLatestNewsTask != null) {
                this.zombiePool.execute(new Runnable(){

                    @Override
                    public void run() {
                        log.info((Object)("Prepare to shut down " + oldLatestNewsTask + "..."));
                        oldLatestNewsTask.cancel(true);
                        log.info((Object)("Shut down " + oldLatestNewsTask + " peacefully."));
                    }
                });
                this.latestNewsTask = null;
            }
        }
    }

    private void initMarketThread() {
        final Thread oldMarketThread = this.marketThread;
        if (oldMarketThread != null) {
            this.zombiePool.execute(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)("Prepare to shut down market thread " + oldMarketThread + "..."));
                    oldMarketThread.interrupt();
                    try {
                        oldMarketThread.join();
                    }
                    catch (InterruptedException ex) {
                        log.error(null, (Throwable)ex);
                    }
                    log.info((Object)("Shut down market thread " + oldMarketThread + " peacefully."));
                }
            });
        }
        this.marketThread = new Thread(new MarketRunnable());
        this.marketThread.start();
    }

    private void initAjaxProvider() {
        Country country = this.jStockOptions.getCountry();
        AutoCompleteJComboBox autoCompleteJComboBox = (AutoCompleteJComboBox)this.jComboBox1;
        if (country == Country.India) {
            autoCompleteJComboBox.setAjaxProvider(AjaxServiceProvider.Google, Arrays.asList("NSE", "BOM"));
            autoCompleteJComboBox.setGreedyEnabled(true, Arrays.asList("N", "B"));
        } else {
            autoCompleteJComboBox.setAjaxProvider(AjaxServiceProvider.Yahoo, Collections.<String>emptyList());
            autoCompleteJComboBox.setGreedyEnabled(false, Collections.<String>emptyList());
        }
        this.indicatorPanel.initAjaxProvider();
    }

    private void initStockInfoDatabaseMeta() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Country country;
                Map<Country, Long> localStockInfoDatabaseMeta = Utils.loadStockInfoDatabaseMeta(Utils.getStockInfoDatabaseMetaFile());
                String location = org.yccheok.jstock.network.Utils.getURL(Utils.Type.STOCK_INFO_DATABASE_META);
                String json = Utils.downloadAsString(location);
                Map<Country, Long> latestStockInfoDatabaseMeta = Utils.loadStockInfoDatabaseMeta(json);
                EnumMap<Country, Long> successStockInfoDatabaseMeta = new EnumMap<Country, Long>(Country.class);
                boolean needToInitDatabase = false;
                for (Map.Entry<Country, Long> entry : latestStockInfoDatabaseMeta.entrySet()) {
                    List<Stock> stocks;
                    String stocksCSVFileLocation;
                    File file;
                    Long local;
                    if (Thread.currentThread().isInterrupted() || MainFrame.this.stockInfoDatabaseMetaPool == null) break;
                    country = entry.getKey();
                    Long latest = entry.getValue();
                    if (latest.equals(local = localStockInfoDatabaseMeta.get((Object)country)) || (file = Utils.downloadAsTempFile(stocksCSVFileLocation = org.yccheok.jstock.engine.Utils.getStocksCSVFileLocation(country))) == null || (stocks = org.yccheok.jstock.engine.Utils.getStocksFromCSVFile(file)).isEmpty()) continue;
                    Pair<StockInfoDatabase, StockNameDatabase> stockDatabase = org.yccheok.jstock.engine.Utils.toStockDatabase(stocks, country);
                    MainFrame.saveStockInfoDatabaseAsCSV(country, (StockInfoDatabase)stockDatabase.first);
                    if (stockDatabase.second != null) {
                        MainFrame.saveStockNameDatabaseAsCSV(country, (StockNameDatabase)stockDatabase.second);
                    }
                    successStockInfoDatabaseMeta.put(country, latest);
                    if (country != MainFrame.this.jStockOptions.getCountry()) continue;
                    needToInitDatabase = true;
                }
                if (successStockInfoDatabaseMeta.isEmpty()) {
                    return;
                }
                for (Map.Entry<Country, Long> entry : localStockInfoDatabaseMeta.entrySet()) {
                    country = entry.getKey();
                    Long old = entry.getValue();
                    if (successStockInfoDatabaseMeta.containsKey((Object)country)) continue;
                    successStockInfoDatabaseMeta.put(country, old);
                }
                Utils.saveStockInfoDatabaseMeta(Utils.getStockInfoDatabaseMetaFile(), successStockInfoDatabaseMeta);
                if (needToInitDatabase) {
                    MainFrame.this.initDatabase(true);
                }
            }
        };
        this.stockInfoDatabaseMetaPool.execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDatabase(boolean readFromDisk) {
        this.setStatusBar(true, GUIBundle.getString("MainFrame_ConnectingToStockServerToRetrieveStockInformation..."));
        this.statusBar.setImageIcon(this.getImageIcon("/images/16x16/network-connecting.png"), ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_Connecting..."));
        Object object = this.databaseTaskMonitor;
        synchronized (object) {
            if (this.databaseTask != null) {
                this.databaseTask.cancel(true);
                this.stockInfoDatabase = null;
                this.stockNameDatabase = null;
                ((AutoCompleteJComboBox)this.jComboBox1).setStockInfoDatabase(null);
                this.indicatorPanel.setStockInfoDatabase(null);
            }
            this.databaseTask = new DatabaseTask(readFromDisk);
            this.databaseTask.execute();
        }
        System.gc();
    }

    private void update(RealTimeStockMonitor monitor, final List<Stock> stocks) {
        boolean isSymbolImmutable = org.yccheok.jstock.engine.Utils.isSymbolImmutable();
        int size = stocks.size();
        for (int i = 0; i < size; ++i) {
            Stock stock;
            Stock new_stock = stock = stocks.get(i);
            if (!isSymbolImmutable && !new_stock.symbol.toString().isEmpty()) continue;
            StockInfoDatabase stock_info_database = this.stockInfoDatabase;
            if (stock_info_database != null) {
                Symbol symbol = stock_info_database.codeToSymbol(stock.code);
                if (symbol != null) {
                    new_stock = new_stock.deriveStock(symbol);
                } else {
                    log.error((Object)("Wrong stock code " + stock.code + " given by stock server."));
                }
            } else {
                StockTableModel tableModel = (StockTableModel)this.jTable1.getModel();
                int row = tableModel.findRow(stock);
                if (row >= 0) {
                    Symbol symbol = tableModel.getStock((int)row).symbol;
                    new_stock = new_stock.deriveStock(symbol);
                }
            }
            if (stock == new_stock) continue;
            stocks.set(i, new_stock);
        }
        this.timestamp = System.currentTimeMillis();
        ((StockTableModel)this.jTable1.getModel()).setTimestamp(this.timestamp);
        MainFrame.getInstance().updateStatusBarWithLastUpdateDateMessageIfPossible();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Stock stock : stocks) {
                    MainFrame.this.updateStockToTable(stock);
                    if (!MainFrame.this.isStockBeingSelected(stock)) continue;
                    MainFrame.this.updateDynamicChart(stock);
                }
            }
        });
        for (Stock stock : stocks) {
            Code code = stock.code;
            DynamicChart dynamicChart = this.dynamicCharts.get(code);
            if (dynamicChart == null) {
                if (this.dynamicCharts.size() <= 10) {
                    dynamicChart = new DynamicChart();
                    this.dynamicCharts.put(code, dynamicChart);
                } else if (this.isStockBeingSelected(stock)) {
                    Set<Code> codes = this.dynamicCharts.keySet();
                    for (Code c : codes) {
                        this.dynamicCharts.remove(c);
                        if (this.dynamicCharts.size() > 10) continue;
                        break;
                    }
                    dynamicChart = new DynamicChart();
                    this.dynamicCharts.put(code, dynamicChart);
                }
            }
            if (dynamicChart == null) continue;
            if (this.isStockBeingSelected(stock)) {
                dynamicChart.addPriceObservation(stock.getTimestamp(), stock.getLastPrice());
                final Stock s = stock;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.this.updateDynamicChart(s);
                    }
                });
                continue;
            }
            dynamicChart.addPriceObservation(stock.getTimestamp(), stock.getLastPrice());
        }
        if (!(this.jStockOptions.isSMSEnabled() || this.jStockOptions.isPopupMessage() || this.jStockOptions.isSoundEnabled() || this.jStockOptions.isSendEmail())) {
            return;
        }
        StockTableModel stockTableModel = (StockTableModel)this.jTable1.getModel();
        for (Stock stock : stocks) {
            Double fallBelow = stockTableModel.getFallBelow(stock);
            if (fallBelow != null) {
                Indicator indicator = Utils.getLastPriceFallBelowIndicator(fallBelow);
                indicator.setStock(stock);
                this.alertStateManager.alert(indicator);
            } else {
                this.alertStateManager.clearState(FALL_BELOW_INDICATOR, stock);
            }
            Double riseAbove = stockTableModel.getRiseAbove(stock);
            if (riseAbove != null) {
                Indicator indicator = Utils.getLastPriceRiseAboveIndicator(riseAbove);
                indicator.setStock(stock);
                this.alertStateManager.alert(indicator);
                continue;
            }
            this.alertStateManager.clearState(RISE_ABOVE_INDICATOR, stock);
        }
    }

    public void updateStatusBarWithLastUpdateDateMessageIfPossible() {
        if (this.refreshPriceInProgress) {
            this.setStatusBar(false, this.getBestStatusBarMessage());
            this.refreshPriceInProgress = false;
            return;
        }
        if (this.isStatusBarBusy) {
            return;
        }
        if (this.getSelectedComponent() != this.jPanel8 && this.getSelectedComponent() != this.portfolioManagementJPanel) {
            return;
        }
        this.setStatusBar(false, this.getBestStatusBarMessage());
    }

    public String getBestStatusBarMessage() {
        long _timestamp;
        String currentName;
        if (this.getSelectedComponent() == this.jPanel8) {
            currentName = this.getJStockOptions().getWatchlistName();
            _timestamp = this.timestamp;
        } else if (this.getSelectedComponent() == this.portfolioManagementJPanel) {
            currentName = this.getJStockOptions().getPortfolioName();
            _timestamp = this.portfolioManagementJPanel.getTimestamp();
        } else {
            return GUIBundle.getString("MainFrame_Connected");
        }
        if (_timestamp == 0L) {
            return MessageFormat.format(GUIBundle.getString("MainFrame_Connected_template"), currentName);
        }
        Date date = new Date(_timestamp);
        String time = Utils.isToday(_timestamp) ? Utils.getTodayLastUpdateTimeFormat().format(date) : Utils.getOtherDayLastUpdateTimeFormat().format(date);
        return MessageFormat.format(GUIBundle.getString("MainFrame_LastUpdate_template"), currentName, time);
    }

    private void update(final List<Market> markets) {
        assert (!markets.isEmpty());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.marketJPanel.update(markets);
            }
        });
    }

    public void update(StockHistoryMonitor monitor, final StockHistoryMonitor.StockHistoryRunnable runnable) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String template;
                Code code = runnable.getCode();
                Symbol symbol = null;
                StockInfoDatabase stock_info_database = MainFrame.this.stockInfoDatabase;
                if (stock_info_database != null) {
                    symbol = stock_info_database.codeToSymbol(code);
                }
                boolean shouldShowGUI = MainFrame.this.stockCodeHistoryGUI.remove(code);
                if (MainFrame.this.stockCodeHistoryGUI.isEmpty()) {
                    if (runnable.getStockHistoryServer() != null) {
                        template = GUIBundle.getString("MainFrame_HistorySuccess_template");
                        String message = MessageFormat.format(template, symbol != null ? symbol : code);
                        MainFrame.this.setStatusBar(false, message);
                    } else {
                        template = GUIBundle.getString("MainFrame_HistoryFailed_template");
                        String message = MessageFormat.format(template, symbol != null ? symbol : code);
                        MainFrame.this.setStatusBar(false, message);
                    }
                } else if (runnable.getStockHistoryServer() != null) {
                    template = GUIBundle.getString("MainFrame_HistorySuccessStillWaitingForHistoryTotal_template");
                    String message = MessageFormat.format(template, symbol != null ? symbol : code, MainFrame.this.stockCodeHistoryGUI.size());
                    MainFrame.this.setStatusBar(true, message);
                } else {
                    template = GUIBundle.getString("MainFrame_HistoryFailedStillWaitingForHistoryTotal_template");
                    String message = MessageFormat.format(template, symbol != null ? symbol : code, MainFrame.this.stockCodeHistoryGUI.size());
                    MainFrame.this.setStatusBar(true, message);
                }
                if (runnable.getStockHistoryServer() != null && shouldShowGUI) {
                    ChartJDialog chartJDialog = new ChartJDialog((Frame)MainFrame.this, (symbol != null ? symbol : code) + " (" + code + ")", false, runnable.getStockHistoryServer());
                    chartJDialog.setVisible(true);
                }
            }
        });
    }

    private ImageIcon getImageIcon(String imageIcon) {
        return new ImageIcon(this.getClass().getResource(imageIcon));
    }

    public void displayPopupMessage(final String caption, final String message) {
        if (this.trayIcon == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.trayIcon.displayMessage(caption, message, TrayIcon.MessageType.INFO);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.trayIcon.displayMessage(caption, message, TrayIcon.MessageType.INFO);
                }
            });
        }
    }

    public IndicatorProjectManager getAlertIndicatorProjectManager() {
        return this.indicatorPanel.getAlertIndicatorProjectManager();
    }

    public void updateScanningSpeed(int speed) {
        this.realTimeStockMonitor.setDelay(speed);
        this.indicatorScannerJPanel.updateScanningSpeed(speed);
    }

    public void updateHistoryDuration(Duration historyDuration) {
        Country[] countries;
        Duration oldDuration = this.stockHistoryMonitor.getDuration();
        if (oldDuration.isContains(historyDuration)) {
            this.stockHistoryMonitor.setDuration(historyDuration);
            return;
        }
        log.info((Object)("We are going to remove all history files, due to new duration " + historyDuration + " is not within old duration " + oldDuration));
        for (Country country : countries = Country.values()) {
            Utils.deleteDir(Utils.getHistoryDirectory(country), false);
        }
        this.initStockHistoryMonitor();
    }

    public void repaintTable() {
        Component c = this.getSelectedComponent();
        if (c instanceof IndicatorScannerJPanel) {
            this.indicatorScannerJPanel.repaintTable();
        } else if (!(c instanceof IndicatorPanel)) {
            this.jTable1.repaint();
        }
    }

    private void initMarketJPanel() {
        if (this.marketJPanel != null) {
            this.jPanel2.remove(this.marketJPanel);
        }
        this.marketJPanel = new MarketJPanel(this.jStockOptions.getCountry());
        this.jPanel2.add(this.marketJPanel);
        this.jPanel2.revalidate();
    }

    private void initPreloadDatabase(boolean overWrite) {
        Utils.extractZipFile("database" + File.separator + "database.zip", overWrite);
    }

    public Component getSelectedComponent() {
        return this.jTabbedPane1.getSelectedComponent();
    }

    private void initExtraDatas() {
        Utils.extractZipFile("extra" + File.separator + "extra.zip", false);
    }

    private ActionListener getTimerActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainFrame.this.jTabbedPane1.getIconAt(4) == MainFrame.this.smileIcon) {
                    MainFrame.this.jTabbedPane1.setIconAt(4, MainFrame.this.smileGrayIcon);
                } else {
                    MainFrame.this.jTabbedPane1.setIconAt(4, MainFrame.this.smileIcon);
                }
            }
        };
    }

    public void initDynamicChartVisibility() {
        this.jPanel10.setVisible(this.jStockOptions.isDynamicChartVisible());
    }

    private void initDynamicCharts() {
        this.dynamicCharts.clear();
    }

    private void initStatusBar() {
        String message = ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_ConnectingToStockServerToRetrieveStockInformation...");
        ImageIcon icon = this.getImageIcon("/images/16x16/network-connecting.png");
        String iconMessage = ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_Connecting...");
        this.statusBar.setMainMessage(message).setImageIcon(icon, iconMessage).setCountryIcon(this.jStockOptions.getCountry().getIcon(), this.jStockOptions.getCountry().toString());
    }

    private MouseAdapter getDynamicChartMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    Stock stock = MainFrame.this.getSelectedStock();
                    if (stock == null) {
                        return;
                    }
                    DynamicChart dynamicChart = (DynamicChart)MainFrame.this.dynamicCharts.get(stock.code);
                    if (dynamicChart == null) {
                        return;
                    }
                    Symbol symbol = null;
                    StockInfoDatabase stock_info_database = MainFrame.this.stockInfoDatabase;
                    if (stock_info_database != null) {
                        symbol = stock_info_database.codeToSymbol(stock.code);
                    }
                    String template = GUIBundle.getString("MainFrame_IntradayMovementTemplate");
                    String message = MessageFormat.format(template, symbol == null ? stock.symbol : symbol);
                    dynamicChart.showNewJDialog(MainFrame.this, message);
                }
            }
        };
    }

    private void refreshCurrencyExchangeMonitor() {
        this.portfolioManagementJPanel.refreshCurrencyExchangeMonitor();
    }

    public void refreshAllRealTimeStockMonitors() {
        RealTimeStockMonitor _realTimeStockMonitor = this.realTimeStockMonitor;
        if (_realTimeStockMonitor != null) {
            _realTimeStockMonitor.refresh();
        }
        this.indicatorScannerJPanel.refreshRealTimeStockMonitor();
        this.portfolioManagementJPanel.refreshRealTimeStockMonitor();
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
        log = LogFactory.getLog(MainFrame.class);
        EMPTY_DYNAMIC_CHART = new DynamicChart();
        FALL_BELOW_INDICATOR = Utils.getLastPriceFallBelowIndicator(0.0);
        RISE_ABOVE_INDICATOR = Utils.getLastPriceRiseAboveIndicator(0.0);
    }

    private class TableKeyEventListener
    extends KeyAdapter {
        private TableKeyEventListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            MainFrame.this.jTable1.getSelectionModel().clearSelection();
        }
    }

    private class LatestNewsTask
    extends SwingWorker<Void, String> {
        private static final int SHORT_DELAY = 20000;
        private volatile CountDownLatch doneSignal;

        private LatestNewsTask() {
        }

        @Override
        protected void done() {
        }

        @Override
        protected void process(List<String> messages) {
            boolean show = false;
            for (String message : messages) {
                AutoUpdateNewsJDialog dialog = new AutoUpdateNewsJDialog((Frame)MainFrame.this, true);
                dialog.setNews(message);
                dialog.setVisible(true);
                show = true;
            }
            if (show) {
                this.doneSignal.countDown();
            }
        }

        @Override
        protected Void doInBackground() {
            while (!this.isCancelled()) {
                String location;
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException ex) {
                    log.info(null, (Throwable)ex);
                    break;
                }
                Map<String, String> map = Utils.getUUIDValue(org.yccheok.jstock.network.Utils.getURL(Utils.Type.NEWS_INFORMATION_TXT));
                String newsID = MainFrame.this.getJStockOptions().getNewsID();
                if (newsID.equals(map.get("news_id")) || (location = map.get("news_url")) == null) break;
                this.doneSignal = new CountDownLatch(1);
                String respond = Utils.getResponseBodyAsStringBasedOnProxyAuthOption(location);
                if (respond == null || respond.indexOf(Utils.getJStockUUID()) < 0) break;
                this.publish(respond);
                try {
                    this.doneSignal.await();
                }
                catch (InterruptedException ex) {
                    log.info(null, (Throwable)ex);
                    break;
                }
                MainFrame.this.jStockOptions.setNewsID(map.get("news_id"));
            }
            return null;
        }
    }

    private static class ColumnHeaderToolTips
    extends MouseMotionAdapter {
        TableColumn curCol;
        Map<TableColumn, String> tips = new HashMap<TableColumn, String>();

        private ColumnHeaderToolTips() {
        }

        public void setToolTip(TableColumn col, String tooltip) {
            if (tooltip == null) {
                this.tips.remove(col);
            } else {
                this.tips.put(col, tooltip);
            }
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            TableColumn col = null;
            JTableHeader header = (JTableHeader)evt.getSource();
            JTable table = header.getTable();
            TableColumnModel colModel = table.getColumnModel();
            int vColIndex = colModel.getColumnIndexAtX(evt.getX());
            if (vColIndex >= 0) {
                col = colModel.getColumn(vColIndex);
            }
            if (col != this.curCol) {
                header.setToolTipText(this.tips.get(col));
                this.curCol = col;
            }
        }
    }

    private class TableRowPopupListener
    extends MouseAdapter {
        private TableRowPopupListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            int[] rows = MainFrame.this.jTable1.getSelectedRows();
            if (rows.length == 1) {
                int row = rows[0];
                StockTableModel tableModel = (StockTableModel)MainFrame.this.jTable1.getModel();
                int modelIndex = MainFrame.this.jTable1.convertRowIndexToModel(row);
                Stock stock = tableModel.getStock(modelIndex);
                MainFrame.this.updateDynamicChart(stock);
            } else {
                MainFrame.this.updateDynamicChart(null);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() && MainFrame.this.jTable1.getSelectedRowCount() > 0) {
                MainFrame.this.getMyJTablePopupMenu().show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class DatabaseTask
    extends SwingWorker<Boolean, Void> {
        private boolean readFromDisk = true;

        public DatabaseTask(boolean readFromDisk) {
            this.readFromDisk = readFromDisk;
        }

        @Override
        protected void done() {
            if (this.isCancelled()) {
                return;
            }
            boolean success = false;
            try {
                success = (Boolean)this.get();
            }
            catch (InterruptedException exp) {
                log.error(null, (Throwable)exp);
            }
            catch (ExecutionException exp) {
                log.error(null, (Throwable)exp);
            }
            catch (CancellationException ex) {
                log.error(null, (Throwable)ex);
            }
            if (success) {
                MainFrame.this.setStatusBar(false, MainFrame.this.getBestStatusBarMessage());
                MainFrame.this.statusBar.setImageIcon(MainFrame.this.getImageIcon("/images/16x16/network-transmit-receive.png"), ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_Connected"));
            } else {
                MainFrame.this.setStatusBar(false, GUIBundle.getString("MainFrame_NetworkError"));
                MainFrame.this.statusBar.setImageIcon(MainFrame.this.getImageIcon("/images/16x16/network-error.png"), ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("MainFrame_DoubleClickedToTryAgain"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean doInBackground() {
            String location;
            File file;
            Country country = MainFrame.this.jStockOptions.getCountry();
            Utils.createCompleteDirectoryHierarchyIfDoesNotExist(Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "database");
            if (this.readFromDisk) {
                StockInfoDatabase tmp_stock_info_database = MainFrame.this.loadStockInfoDatabaseFromCSV(country);
                if (tmp_stock_info_database == null) {
                    MainFrame.this.initPreloadDatabase(true);
                    tmp_stock_info_database = MainFrame.this.loadStockInfoDatabaseFromCSV(country);
                }
                StockNameDatabase tmp_name_database = org.yccheok.jstock.engine.Utils.isNameImmutable() ? MainFrame.this.loadStockNameDatabaseFromCSV(country) : null;
                if (this.isCancelled()) {
                    return false;
                }
                if (tmp_stock_info_database != null && !tmp_stock_info_database.isEmpty()) {
                    List pairs = MainFrame.this.loadUserDefinedDatabaseFromCSV(country);
                    boolean addUserDefinedStockInfoSuccessAtLeastOnce = false;
                    if (!pairs.isEmpty()) {
                        tmp_stock_info_database.removeAllUserDefinedStockInfos();
                        for (Pair pair : pairs) {
                            if (!tmp_stock_info_database.addUserDefinedStockInfo(StockInfo.newInstance((Code)pair.first, (Symbol)pair.second))) continue;
                            addUserDefinedStockInfoSuccessAtLeastOnce = true;
                        }
                    }
                    if (!addUserDefinedStockInfoSuccessAtLeastOnce) {
                        new File(Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "database" + File.separator + "user-defined-database.csv").delete();
                    }
                    Object i$ = MainFrame.this.databaseTaskMonitor;
                    synchronized (i$) {
                        if (this.isCancelled()) {
                            return false;
                        }
                        MainFrame.this.stockInfoDatabase = tmp_stock_info_database;
                        MainFrame.this.stockNameDatabase = tmp_name_database;
                        ((AutoCompleteJComboBox)MainFrame.this.jComboBox1).setStockInfoDatabase(MainFrame.this.stockInfoDatabase);
                        MainFrame.this.indicatorPanel.setStockInfoDatabase(MainFrame.this.stockInfoDatabase);
                        return true;
                    }
                }
            }
            if ((file = Utils.downloadAsTempFile(location = org.yccheok.jstock.engine.Utils.getStocksCSVFileLocation(country))) == null) {
                return false;
            }
            List<Stock> stocks = org.yccheok.jstock.engine.Utils.getStocksFromCSVFile(file);
            if (!stocks.isEmpty()) {
                List pairs;
                Pair<StockInfoDatabase, StockNameDatabase> stockDatabase = org.yccheok.jstock.engine.Utils.toStockDatabase(stocks, country);
                if (this.isCancelled()) {
                    return false;
                }
                MainFrame.saveStockInfoDatabaseAsCSV(country, (StockInfoDatabase)stockDatabase.first);
                if (stockDatabase.second != null) {
                    MainFrame.saveStockNameDatabaseAsCSV(country, (StockNameDatabase)stockDatabase.second);
                }
                if (!(pairs = MainFrame.this.loadUserDefinedDatabaseFromCSV(country)).isEmpty()) {
                    for (Pair pair : pairs) {
                        ((StockInfoDatabase)stockDatabase.first).addUserDefinedStockInfo(StockInfo.newInstance((Code)pair.first, (Symbol)pair.second));
                    }
                }
                Object object = MainFrame.this.databaseTaskMonitor;
                synchronized (object) {
                    if (this.isCancelled()) {
                        return false;
                    }
                    MainFrame.this.stockInfoDatabase = (StockInfoDatabase)stockDatabase.first;
                    MainFrame.this.stockNameDatabase = (StockNameDatabase)stockDatabase.second;
                    ((AutoCompleteJComboBox)MainFrame.this.jComboBox1).setStockInfoDatabase(MainFrame.this.stockInfoDatabase);
                    MainFrame.this.indicatorPanel.setStockInfoDatabase(MainFrame.this.stockInfoDatabase);
                    return true;
                }
            }
            return false;
        }
    }

    private class MarketRunnable
    implements Runnable {
        private static final long MIN_DELAY = 2000L;
        private static final long MIN_DELAY_COUNTER = 3L;
        private int minDelayCounter = 0;

        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            List<StockServerFactory> stockServerFactories = MainFrame.this.getStockServerFactories();
            List<Index> is = org.yccheok.jstock.engine.Utils.getStockIndices(MainFrame.this.jStockOptions.getCountry());
            int is_size = is.size();
            while (!currentThread.isInterrupted() && MainFrame.this.marketThread == currentThread) {
                int fail = is_size;
                for (StockServerFactory factory : stockServerFactories) {
                    MarketServer marketServer = factory.getMarketServer();
                    if (marketServer == null) continue;
                    List<Market> markets = marketServer.getMarkets(is);
                    if (MainFrame.this.marketThread != currentThread) break;
                    int market_size = markets.size();
                    if (market_size != is_size) continue;
                    fail -= market_size;
                    MainFrame.this.update(markets);
                    break;
                }
                try {
                    if (fail == 0) {
                        Thread.sleep(MainFrame.this.jStockOptions.getScanningSpeed());
                        continue;
                    }
                    if ((long)this.minDelayCounter < 3L) {
                        ++this.minDelayCounter;
                        Thread.sleep(2000L);
                        continue;
                    }
                    Thread.sleep(MainFrame.this.jStockOptions.getScanningSpeed());
                }
                catch (InterruptedException exp) {
                    log.error(null, (Throwable)exp);
                    break;
                }
            }
        }
    }

    class ChangeLookAndFeelAction
    extends AbstractAction {
        MainFrame mainFrame;
        String lafClassName;

        protected ChangeLookAndFeelAction(MainFrame mainFrame2, String lafClassName) {
            super("ChangeTheme");
            this.mainFrame = mainFrame2;
            this.lafClassName = lafClassName;
        }

        public String getLafClassName() {
            return this.lafClassName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.mainFrame.setLookAndFeel(this.lafClassName);
        }
    }

    private static class MainFrameHolder {
        private static final MainFrame INSTANCE = new MainFrame();

        private MainFrameHolder() {
        }
    }

    public static final class CSVWatchlist {
        public final TableModel tableModel;

        private CSVWatchlist(TableModel tableModel) {
            if (tableModel == null) {
                throw new IllegalArgumentException();
            }
            this.tableModel = tableModel;
        }

        public static CSVWatchlist newInstance(TableModel tableModel) {
            return new CSVWatchlist(tableModel);
        }
    }
}

