/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.portfolio.BrokingFirm;

public class NewBrokingFirmJDialog
extends JDialog {
    private static final Log log = LogFactory.getLog(NewBrokingFirmJDialog.class);
    private Image logo = null;
    private BrokingFirm brokingFirm = null;
    private JButton jButton1;
    private JButton jButton2;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextField jTextField1;

    public NewBrokingFirmJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private boolean isValidInput() {
        if (this.jTextField1.getText().length() <= 0) {
            this.jTextField1.requestFocus();
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.jButton2 = new JButton();
        this.jButton1 = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel1 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("New Broking Firm");
        this.setResizable(false);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/apply.png")));
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.jButton2.setText(bundle.getString("NewBrokingFirmJDialog_OK"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewBrokingFirmJDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton2);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/button_cancel.png")));
        this.jButton1.setText(bundle.getString("NewBrokingFirmJDialog_Cancel"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewBrokingFirmJDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton1);
        this.getContentPane().add((Component)this.jPanel3, "South");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("NewBrokingFirmJDialog_BrokingFirm")));
        this.jLabel3.setText(bundle.getString("NewBrokingFirmJDialog_Logo"));
        this.jLabel1.setText(bundle.getString("NewBrokingFirmJDialog_Name"));
        this.jCheckBox1.setText(bundle.getString("NewBrokingFirmJDialog_UseLogo"));
        this.jCheckBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                NewBrokingFirmJDialog.this.jCheckBox1ItemStateChanged(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setLayout(new BorderLayout());
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setHorizontalTextPosition(0);
        this.jLabel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NewBrokingFirmJDialog.this.jLabel2MouseClicked(evt);
            }
        });
        this.jPanel1.add((Component)this.jLabel2, "Center");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox1).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, 140, Short.MAX_VALUE).addComponent(this.jTextField1, -1, 140, Short.MAX_VALUE)))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField1, -2, -1, -2)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(36, 36, 36).addComponent(this.jLabel3)).addGroup(jPanel2Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -1, 111, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox1).addContainerGap()));
        this.getContentPane().add((Component)this.jPanel2, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 219) / 2, (screenSize.height - 272) / 2, 219, 272);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (!this.isValidInput()) {
            return;
        }
        this.brokingFirm = new BrokingFirm(this.jTextField1.getText());
        if (this.jCheckBox1.isSelected()) {
            this.brokingFirm.setLogo(this.logo);
        } else {
            this.brokingFirm.setLogo(null);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.brokingFirm = null;
        this.setVisible(false);
        this.dispose();
    }

    public BrokingFirm getBrokingFirm() {
        return this.brokingFirm;
    }

    private static boolean fileNameEndWithImageExtension(String filename) {
        return filename.endsWith(".jpg") || filename.endsWith(".jpeg") || filename.endsWith(".gif") || filename.endsWith(".png") || filename.endsWith(".bmp");
    }

    private void letUserSelectAnImage() {
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.addChoosableFileFilter(new MyFilter());
        int returnVal = fc.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        if (NewBrokingFirmJDialog.fileNameEndWithImageExtension(file.getName())) {
            this.loadImage(file);
        }
    }

    private void jLabel2MouseClicked(MouseEvent evt) {
        this.letUserSelectAnImage();
    }

    private void jCheckBox1ItemStateChanged(ItemEvent evt) {
        JCheckBox me = (JCheckBox)evt.getSource();
        if (me.isSelected() && this.logo == null) {
            this.letUserSelectAnImage();
            if (this.logo == null) {
                this.jCheckBox1.setSelected(false);
            }
        }
    }

    private void loadImage(File file) {
        ImageIcon imageIcon = new ImageIcon(file.getAbsolutePath());
        if (imageIcon.getIconWidth() <= 0 || imageIcon.getIconHeight() <= 0) {
            return;
        }
        this.setLogo(imageIcon.getImage());
    }

    public void setBrokingFirm(BrokingFirm brokingFirm) {
        this.brokingFirm = brokingFirm;
        this.jTextField1.setText(brokingFirm.getName());
        this.setLogo(brokingFirm.getLogo());
    }

    public void setLogo(final Image logo) {
        if (logo == null) {
            this.logo = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewBrokingFirmJDialog.this.jLabel2.setIcon(null);
                    NewBrokingFirmJDialog.this.jCheckBox1.setSelected(false);
                }
            });
            return;
        }
        this.logo = logo;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImageIcon scaledImageIcon = new ImageIcon(Utils.getScaledImage(logo, NewBrokingFirmJDialog.this.jLabel2.getWidth() - 2, NewBrokingFirmJDialog.this.jLabel2.getHeight() - 2));
                NewBrokingFirmJDialog.this.jLabel2.setIcon(scaledImageIcon);
                NewBrokingFirmJDialog.this.jCheckBox1.setSelected(true);
            }
        });
    }

    private static class MyFilter
    extends FileFilter {
        private MyFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String filename = file.getName();
            return NewBrokingFirmJDialog.fileNameEndWithImageExtension(filename);
        }

        @Override
        public String getDescription() {
            return "Image file";
        }
    }
}

