/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXHeader;
import org.yccheok.jstock.engine.Duration;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.JStockOptionsObserver;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.internationalization.GUIBundle;

public class OptionsSpeedJPanel
extends JPanel
implements JStockOptionsObserver {
    private static final Log log = LogFactory.getLog(OptionsSpeedJPanel.class);
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JComboBox jComboBox3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JXHeader jXHeader1;

    public OptionsSpeedJPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jXHeader1 = new JXHeader();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBox3 = new JComboBox();
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jComboBox2 = new JComboBox();
        this.jLabel3 = new JLabel();
        this.setLayout(new BorderLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.jXHeader1.setDescription(bundle.getString("OptionsSpeedJPanel_Description"));
        this.jXHeader1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/32x32/clock.png")));
        this.jXHeader1.setTitle(bundle.getString("OptionsSpeedJPanel_ScanningSpeed"));
        this.add((Component)this.jXHeader1, "North");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("OptionsSpeedJPanel_RealtimeData")));
        this.jLabel1.setText(bundle.getString("OptionsSpeedJPanel_StockScanningSpeed"));
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"2", "5", "10", "20", "30", "40", "50", "60"}));
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont((float)this.jLabel2.getFont().getSize() - 1.0f));
        this.jLabel2.setText(bundle.getString("OptionsSpeedJPanel_SmallerMeansFaster"));
        this.jComboBox3.setModel(this.getComboBoxModel());
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, 64, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox3, -2, 94, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addContainerGap(27, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jComboBox3, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jLabel1)).addContainerGap(16, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(bundle.getString("OptionsSpeedJPanel_HistoryData")));
        this.jLabel4.setFont(this.jLabel4.getFont().deriveFont((float)this.jLabel4.getFont().getSize() - 1.0f));
        this.jLabel4.setText(bundle.getString("OptionsSpeedJPanel_SmallerMeansFaster"));
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "5", "10", "15", "20"}));
        this.jLabel3.setText(bundle.getString("OptionsSpeedJPanel_HistoryDuration"));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox2, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addContainerGap(116, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jComboBox2, -2, -1, -2).addComponent(this.jLabel4)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel3, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.add((Component)this.jPanel1, "Center");
    }

    @Override
    public void set(JStockOptions jStockOptions) {
        int maxSpeed = 60;
        if (jStockOptions.getScanningSpeed() <= 60000) {
            this.jComboBox1.setSelectedItem("" + jStockOptions.getScanningSpeed() / 1000);
            this.jComboBox3.setSelectedIndex(0);
        } else if (jStockOptions.getScanningSpeed() <= 3600000) {
            this.jComboBox1.setSelectedItem("" + jStockOptions.getScanningSpeed() / 60000);
            this.jComboBox3.setSelectedIndex(1);
        } else {
            assert (jStockOptions.getScanningSpeed() <= 216000000);
            this.jComboBox1.setSelectedItem("" + jStockOptions.getScanningSpeed() / 3600000);
            this.jComboBox3.setSelectedIndex(2);
        }
        this.jComboBox2.setSelectedItem("" + jStockOptions.getHistoryDuration());
    }

    @Override
    public boolean apply(JStockOptions jStockOptions) {
        int speed = 1;
        int historyDuration = 1;
        try {
            speed = Integer.parseInt(this.jComboBox1.getSelectedItem().toString());
        }
        catch (NumberFormatException exp) {
            log.error(null, (Throwable)exp);
        }
        try {
            historyDuration = Integer.parseInt(this.jComboBox2.getSelectedItem().toString());
        }
        catch (NumberFormatException exp) {
            log.error(null, (Throwable)exp);
        }
        if (this.jComboBox3.getSelectedIndex() == 0) {
            jStockOptions.setScanningSpeed(speed * 1000);
        } else if (this.jComboBox3.getSelectedIndex() == 1) {
            jStockOptions.setScanningSpeed(speed * 1000 * 60);
        } else {
            jStockOptions.setScanningSpeed(speed * 1000 * 60 * 60);
        }
        jStockOptions.setHistoryDuration(historyDuration);
        MainFrame m = MainFrame.getInstance();
        if (m != null) {
            m.updateScanningSpeed(jStockOptions.getScanningSpeed());
            m.updateHistoryDuration(Duration.getTodayDurationByYears(historyDuration));
        }
        return true;
    }

    private ComboBoxModel getComboBoxModel() {
        return new DefaultComboBoxModel<String>(new String[]{GUIBundle.getString("OptionsSpeedJPanel_Seconds"), GUIBundle.getString("OptionsSpeedJPanel_Minutes"), GUIBundle.getString("OptionsSpeedJPanel_Hours")});
    }
}

