/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;

public class POIUtils {
    private static final Map<Object, Method> parameterTypeMap;
    private static final Log log;

    private POIUtils() {
    }

    public static void invokeSetCellValue(HSSFCell cell, Object value) {
        Method method = POIUtils.findMethodToInvoke(value);
        if (method == null) {
            Double doubleLong;
            Double doubleInteger;
            Method method2;
            if (value.getClass().equals(Integer.class) && (method2 = POIUtils.findMethodToInvoke(doubleInteger = new Double(((Integer)value).doubleValue()))) != null) {
                try {
                    method2.invoke((Object)cell, doubleInteger);
                }
                catch (Exception e) {
                    log.error(null, (Throwable)e);
                }
                return;
            }
            if (value.getClass().equals(Long.class) && (method2 = POIUtils.findMethodToInvoke(doubleLong = new Double(((Long)value).doubleValue()))) != null) {
                try {
                    method2.invoke((Object)cell, doubleLong);
                }
                catch (Exception e) {
                    log.error(null, (Throwable)e);
                }
                return;
            }
            String string = value.toString();
            Method method3 = POIUtils.findMethodToInvoke(string);
            if (method3 == null) {
                throw new RuntimeException("Nothing found for " + value.getClass());
            }
            try {
                method3.invoke((Object)cell, string);
            }
            catch (Exception e) {
                log.error(null, (Throwable)e);
            }
            return;
        }
        try {
            method.invoke((Object)cell, value);
        }
        catch (Exception e) {
            log.error(null, (Throwable)e);
        }
    }

    private static Method findMethodToInvoke(Object value) {
        Method method = parameterTypeMap.get(value.getClass());
        if (method != null) {
            return method;
        }
        for (Class<?> x = value.getClass().getSuperclass(); x != null && x != Object.class; x = x.getSuperclass()) {
            method = parameterTypeMap.get(x);
            if (method == null) continue;
            return method;
        }
        for (Class<?> i : value.getClass().getInterfaces()) {
            method = parameterTypeMap.get(i);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private static void handlePrimitive(Method method, Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            parameterTypeMap.put(Boolean.class, method);
        } else if (clazz == Character.TYPE) {
            parameterTypeMap.put(Character.class, method);
        } else if (clazz == Byte.TYPE) {
            parameterTypeMap.put(Byte.class, method);
        } else if (clazz == Short.TYPE) {
            parameterTypeMap.put(Short.class, method);
        } else if (clazz == Integer.TYPE) {
            parameterTypeMap.put(Integer.class, method);
        } else if (clazz == Long.TYPE) {
            parameterTypeMap.put(Long.class, method);
        } else if (clazz == Float.TYPE) {
            parameterTypeMap.put(Float.class, method);
        } else if (clazz == Double.TYPE) {
            parameterTypeMap.put(Double.class, method);
        }
    }

    static {
        Method[] methods;
        parameterTypeMap = new HashMap<Object, Method>();
        log = LogFactory.getLog(POIUtils.class);
        for (Method method : methods = HSSFCell.class.getMethods()) {
            Class<?>[] clazzes;
            if (!method.getName().equals("setCellValue") || (clazzes = method.getParameterTypes()).length != 1) continue;
            if (clazzes[0].isPrimitive()) {
                POIUtils.handlePrimitive(method, clazzes[0]);
                continue;
            }
            parameterTypeMap.put(clazzes[0], method);
        }
    }
}

