/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.portfolio;

import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.file.CSVHelper;
import org.yccheok.jstock.file.GUIBundleWrapper;
import org.yccheok.jstock.gui.portfolio.CommentableContainer;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.portfolio.Commentable;
import org.yccheok.jstock.portfolio.Dividend;
import org.yccheok.jstock.portfolio.DividendSummary;

public class DividendSummaryTableModel
extends AbstractTableModel
implements CommentableContainer,
CSVHelper {
    private static final String[] columnNames;
    private static final String[] languageIndependentColumnNames;
    private static final Class[] columnClasses;
    private final DividendSummary dividendSummary;

    public DividendSummaryTableModel(DividendSummary dividendSummary) {
        this.dividendSummary = dividendSummary;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Dividend dividend = (Dividend)this.dividendSummary.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return dividend.date.getCalendar().getTime();
            }
            case 1: {
                return dividend.stockInfo;
            }
            case 2: {
                return dividend.amount;
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.dividendSummary.size();
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    public Class getColumnClass(int c) {
        return columnClasses[c];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 0: {
                Dividend newDividend = ((Dividend)this.dividendSummary.get(row)).setDate(new SimpleDate((Date)value));
                this.dividendSummary.remove(row);
                this.dividendSummary.add(row, newDividend);
                this.fireTableCellUpdated(row, col);
                break;
            }
            case 1: {
                Dividend newDividend = ((Dividend)this.dividendSummary.get(row)).setStockInfo((StockInfo)value);
                this.dividendSummary.remove(row);
                this.dividendSummary.add(row, newDividend);
                this.fireTableCellUpdated(row, col);
                break;
            }
            case 2: {
                Dividend newDividend = ((Dividend)this.dividendSummary.get(row)).setAmount((Double)value);
                this.dividendSummary.remove(row);
                this.dividendSummary.add(row, newDividend);
                this.fireTableCellUpdated(row, col);
                break;
            }
        }
    }

    public void removeRow(int index) {
        this.dividendSummary.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public int add(Dividend dividend) {
        this.dividendSummary.add(dividend);
        int index = this.dividendSummary.size() - 1;
        this.fireTableRowsInserted(index, index);
        return index;
    }

    public int addNewDividend() {
        return this.add(new Dividend(StockInfo.newInstance(Code.newInstance(""), Symbol.newInstance("")), 0.0, new SimpleDate()));
    }

    public Dividend getDividend(int index) {
        return (Dividend)this.dividendSummary.get(index);
    }

    @Override
    public Commentable getCommentable(int index) {
        return (Commentable)this.dividendSummary.get(index);
    }

    @Override
    public String getLanguageIndependentColumnName(int columnIndex) {
        return languageIndependentColumnNames[columnIndex];
    }

    static {
        columnClasses = new Class[]{Date.class, StockInfo.class, Double.class};
        String[] tmp = new String[]{GUIBundle.getString("PortfolioManagementJPanel_Date"), GUIBundle.getString("PortfolioManagementJPanel_Stock"), GUIBundle.getString("PortfolioManagementJPanel_Dividend")};
        GUIBundleWrapper guiBundleWrapper = GUIBundleWrapper.newInstance(GUIBundleWrapper.Language.INDEPENDENT);
        String[] tmp2 = new String[]{guiBundleWrapper.getString("PortfolioManagementJPanel_Date"), guiBundleWrapper.getString("PortfolioManagementJPanel_Stock"), guiBundleWrapper.getString("PortfolioManagementJPanel_Dividend")};
        columnNames = tmp;
        languageIndependentColumnNames = tmp2;
    }
}

