/*
 * Decompiled with CFR 0.152.
 */
package com.tictactec.ta.lib.test;

import com.tictactec.ta.lib.Core;
import com.tictactec.ta.lib.MAType;
import com.tictactec.ta.lib.MInteger;
import com.tictactec.ta.lib.RetCode;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class CoreTest
extends TestCase {
    private double[] input;
    private int[] inputInt;
    private double[] output;
    private int[] outputInt;
    private MInteger outBegIdx;
    private MInteger outNbElement;
    private RetCode retCode;
    private Core lib = new Core();
    private int lookback;
    public static double[] close = new double[]{91.5, 94.815, 94.375, 95.095, 93.78, 94.625, 92.53, 92.75, 90.315, 92.47, 96.125, 97.25, 98.5, 89.875, 91.0, 92.815, 89.155, 89.345, 91.625, 89.875, 88.375, 87.625, 84.78, 83.0, 83.5, 81.375, 84.44, 89.25, 86.375, 86.25, 85.25, 87.125, 85.815, 88.97, 88.47, 86.875, 86.815, 84.875, 84.19, 83.875, 83.375, 85.5, 89.19, 89.44, 91.095, 90.75, 91.44, 89.0, 91.0, 90.5, 89.03, 88.815, 84.28, 83.5, 82.69, 84.75, 85.655, 86.19, 88.94, 89.28, 88.625, 88.5, 91.97, 91.5, 93.25, 93.5, 93.155, 91.72, 90.0, 89.69, 88.875, 85.19, 83.375, 84.875, 85.94, 97.25, 99.875, 104.94, 106.0, 102.5, 102.405, 104.595, 106.125, 106.0, 106.065, 104.625, 108.625, 109.315, 110.5, 112.75, 123.0, 119.625, 118.75, 119.25, 117.94, 116.44, 115.19, 111.875, 110.595, 118.125, 116.0, 116.0, 112.0, 113.75, 112.94, 116.0, 120.5, 116.62, 117.0, 115.25, 114.31, 115.5, 115.87, 120.69, 120.19, 120.75, 124.75, 123.37, 122.94, 122.56, 123.12, 122.56, 124.62, 129.25, 131.0, 132.25, 131.0, 132.81, 134.0, 137.38, 137.81, 137.88, 137.25, 136.31, 136.25, 134.63, 128.25, 129.0, 123.87, 124.81, 123.0, 126.25, 128.38, 125.37, 125.69, 122.25, 119.37, 118.5, 123.19, 123.5, 122.19, 119.31, 123.31, 121.12, 123.37, 127.37, 128.5, 123.87, 122.94, 121.75, 124.44, 122.0, 122.37, 122.94, 124.0, 123.19, 124.56, 127.25, 125.87, 128.86, 132.0, 130.75, 134.75, 135.0, 132.38, 133.31, 131.94, 130.0, 125.37, 130.13, 127.12, 125.19, 122.0, 125.0, 123.0, 123.5, 120.06, 121.0, 117.75, 119.87, 122.0, 119.19, 116.37, 113.5, 114.25, 110.0, 105.06, 107.0, 107.87, 107.0, 107.12, 107.0, 91.0, 93.94, 93.87, 95.5, 93.0, 94.94, 98.25, 96.75, 94.81, 94.37, 91.56, 90.25, 93.94, 93.62, 97.0, 95.0, 95.87, 94.06, 94.62, 93.75, 98.0, 103.94, 107.87, 106.06, 104.5, 105.0, 104.19, 103.06, 103.42, 105.27, 111.87, 116.0, 116.62, 118.28, 113.37, 109.0, 109.7, 109.25, 107.0, 109.19, 110.0, 109.2, 110.12, 108.0, 108.62, 109.75, 109.81, 109.0, 108.75, 107.87};
    public static final double FLT_EPSILON = 1.192092896E-7;
    public static final double TA_REAL_MIN = -3.0E37;

    public void test_MACD() {
        double[] macd = new double[close.length];
        double[] signal = new double[close.length];
        double[] hist = new double[close.length];
        this.lookback = this.lib.macdLookback(15, 26, 9);
        this.retCode = this.lib.macd(0, close.length - 1, close, 15, 26, 9, this.outBegIdx, this.outNbElement, macd, signal, hist);
        double[] ema15 = new double[close.length];
        this.lookback = this.lib.emaLookback(15);
        this.retCode = this.lib.ema(0, close.length - 1, close, 15, this.outBegIdx, this.outNbElement, ema15);
        double[] ema26 = new double[close.length];
        this.lookback = this.lib.emaLookback(26);
        this.retCode = this.lib.ema(0, close.length - 1, close, 26, this.outBegIdx, this.outNbElement, ema26);
    }

    public CoreTest(String testName) {
        super(testName);
        this.input = new double[200];
        this.inputInt = new int[200];
        this.output = new double[200];
        this.outputInt = new int[200];
        this.outBegIdx = new MInteger();
        this.outNbElement = new MInteger();
    }

    protected void setUp() {
        int i = 0;
        while (i < this.input.length) {
            this.input[i] = i;
            this.inputInt[i] = i;
            ++i;
        }
        i = 0;
        while (i < this.output.length) {
            this.output[i] = -999999.0;
            this.outputInt[i] = -999999;
            ++i;
        }
        this.outBegIdx.value = -1;
        this.outNbElement.value = -1;
        this.retCode = RetCode.InternalError;
        this.lookback = -1;
    }

    protected void tearDown() {
        CoreTest.assertEquals((String)this.retCode.toString(), (String)RetCode.Success.toString());
        CoreTest.assertEquals((int)this.lookback, (int)this.outBegIdx.value);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(CoreTest.class);
        return suite;
    }

    public void testMFI() {
        this.lookback = this.lib.mfiLookback(2);
        this.retCode = this.lib.mfi(0, this.input.length - 1, this.input, this.input, this.input, this.input, 2, this.outBegIdx, this.outNbElement, this.output);
    }

    public void testHT() {
        this.lookback = this.lib.htTrendModeLookback();
        this.retCode = this.lib.htTrendMode(0, this.input.length - 1, this.input, this.outBegIdx, this.outNbElement, this.outputInt);
    }

    public void testMA_MAMA() {
        this.lookback = this.lib.movingAverageLookback(10, MAType.Mama);
        this.retCode = this.lib.movingAverage(0, this.input.length - 1, this.input, 10, MAType.Mama, this.outBegIdx, this.outNbElement, this.output);
    }

    public void testMA_SMA() {
        this.lookback = this.lib.movingAverageLookback(10, MAType.Sma);
        this.retCode = this.lib.movingAverage(0, this.input.length - 1, this.input, 10, MAType.Sma, this.outBegIdx, this.outNbElement, this.output);
        CoreTest.assertEquals((int)this.outBegIdx.value, (int)9);
    }

    public void testCMO() {
        this.lookback = this.lib.cmoLookback(10);
        this.retCode = this.lib.cmo(0, this.input.length - 1, this.input, 10, this.outBegIdx, this.outNbElement, this.output);
        CoreTest.assertEquals((Object)100.0, (Object)this.output[0]);
    }

    public void testSimpleCall() {
        this.input[0] = 2.0;
        this.input[1] = 1.2;
        this.input[2] = 1.5;
        this.retCode = this.lib.max(0, 2, this.input, 2, this.outBegIdx, this.outNbElement, this.output);
        CoreTest.assertEquals((Object)((Object)this.retCode), (Object)((Object)RetCode.Success));
        CoreTest.assertEquals((int)this.outBegIdx.value, (int)1);
        CoreTest.assertEquals((int)this.outNbElement.value, (int)2);
        CoreTest.assertEquals((Object)this.output[0], (Object)2.0);
        CoreTest.assertEquals((Object)this.output[1], (Object)1.5);
        this.lookback = this.lib.maxLookback(2);
    }

    public void testCMO2() {
        double[] inputRandFltEpsilon = new double[100];
        int i = 0;
        while (i < inputRandFltEpsilon.length) {
            double data;
            int sign = (int)Math.random() % 2;
            inputRandFltEpsilon[i] = data = (sign != 0 ? 1.0 : -1.0) * 1.192092896E-7;
            ++i;
        }
        int optInTimePeriod = Integer.MIN_VALUE;
        double[] output = new double[100];
        Arrays.fill(output, -3.0E37);
        MInteger outBegIdx = new MInteger();
        MInteger outNbElement = new MInteger();
        int lookback = this.lib.cmoLookback(optInTimePeriod);
        this.retCode = this.lib.cmo(0, inputRandFltEpsilon.length - 1, inputRandFltEpsilon, optInTimePeriod, outBegIdx, outNbElement, output);
        CoreTest.assertEquals((int)lookback, (int)outBegIdx.value);
        CoreTest.assertEquals((Object)output[0], (Object)0.0);
        CoreTest.assertEquals((Object)output[1], (Object)0.0);
        CoreTest.assertEquals((Object)output[85], (Object)0.0);
        CoreTest.assertEquals((Object)output[86], (Object)-3.0E37);
    }
}

