/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.Frame;
import java.io.File;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractSaveBeforeAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;

public class LoadRecentAction
extends AbstractSaveBeforeAction {
    public static final String ID = "file.loadRecent";
    private File file;

    public LoadRecentAction(Application app, File file) {
        super(app);
        this.file = file;
        this.putValue("Name", file.getName());
    }

    @Override
    public void doIt(final View view) {
        Application app = this.getApplication();
        app.setEnabled(true);
        int multipleOpenId = 1;
        for (View aView : app.views()) {
            if (aView == view || aView.getFile() == null || !aView.getFile().equals(this.file)) continue;
            multipleOpenId = Math.max(multipleOpenId, aView.getMultipleOpenId() + 1);
        }
        view.setMultipleOpenId(multipleOpenId);
        view.execute(new Worker(){

            @Override
            public Object construct() {
                try {
                    view.read(LoadRecentAction.this.file);
                    return null;
                }
                catch (Throwable e) {
                    return e;
                }
            }

            @Override
            public void finished(Object value) {
                LoadRecentAction.this.fileOpened(view, LoadRecentAction.this.file, value);
            }
        });
    }

    protected void fileOpened(View view, File file, Object value) {
        Application app = this.getApplication();
        if (value == null) {
            view.setFile(file);
            view.setEnabled(true);
            Frame w = (Frame)SwingUtilities.getWindowAncestor(view.getComponent());
            if (w != null) {
                w.setExtendedState(w.getExtendedState() & 0xFFFFFFFE);
                w.toFront();
            }
            view.getComponent().requestFocus();
            if (app != null) {
                app.setEnabled(true);
            }
        } else {
            if (value instanceof Throwable) {
                ((Throwable)value).printStackTrace();
            }
            JSheet.showMessageSheet(view.getComponent(), "<html>" + UIManager.getString("OptionPane.css") + "<b>Couldn't open the file \"" + file + "\".</b><br>" + value, 0, new SheetListener(){

                @Override
                public void optionSelected(SheetEvent evt) {
                }
            });
        }
    }
}

