/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.teddy.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.text.Element;
import javax.swing.text.ParagraphView;
import org.jhotdraw.samples.teddy.text.NumberedViewFactory;

public class NumberedParagraphView
extends ParagraphView {
    public static short NUMBERS_WIDTH = (short)30;
    private static Font numberFont = new Font("Dialog", 0, 10);
    private NumberedViewFactory viewFactory;

    public NumberedParagraphView(Element e, NumberedViewFactory viewFactory) {
        super(e);
        this.viewFactory = viewFactory;
    }

    @Override
    protected short getLeftInset() {
        short left = super.getLeftInset();
        return this.viewFactory.isLineNumbersVisible() ? (short)(left + NUMBERS_WIDTH) : left;
    }

    @Override
    public void paintChild(Graphics g, Rectangle r, int n) {
        super.paintChild(g, r, n);
        if (this.viewFactory.isLineNumbersVisible() && n == 0) {
            g.setColor(Color.gray);
            int lineAscent = g.getFontMetrics().getAscent();
            g.setFont(numberFont);
            int numberAscent = g.getFontMetrics().getAscent();
            int lineNumber = this.getDocument().getDefaultRootElement().getElementIndex(this.getStartOffset());
            int numberX = r.x - this.getLeftInset();
            int numberY = r.y + lineAscent;
            g.drawString(Integer.toString(lineNumber + 1), numberX, numberY);
        }
    }
}

