/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.media.mediarss;

import java.text.ParseException;

public class NormalPlayTime {
    public static final NormalPlayTime NOW = new NormalPlayTime(true, -1L);
    private boolean isNow;
    private long ms;

    public NormalPlayTime(long ms) {
        this(false, ms);
    }

    private NormalPlayTime(boolean now, long ms) {
        this.isNow = now;
        this.ms = ms;
    }

    public boolean isNow() {
        return this.isNow;
    }

    public long getTimeOffsetMs() {
        return this.ms;
    }

    public static NormalPlayTime parse(String stringRep) throws ParseException {
        if (stringRep == null) {
            return null;
        }
        if ("now".equals(stringRep)) {
            return NOW;
        }
        NPTParser parser = new NPTParser(stringRep);
        return new NormalPlayTime(parser.parse());
    }

    public String toString() {
        return this.getNptSecondsRepresentation();
    }

    public String getNptSecondsRepresentation() {
        if (this.isNow) {
            return "now";
        }
        long seconds = this.ms / 1000L;
        long fraction = this.ms % 1000L;
        if (fraction == 0L) {
            return Long.toString(seconds);
        }
        return String.format("%1$d.%2$03d", seconds, fraction);
    }

    public String getNptHhmmssRepresentation() {
        if (this.isNow) {
            return "now";
        }
        long fraction = this.ms % 1000L;
        long totalseconds = this.ms / 1000L;
        long seconds = totalseconds % 60L;
        long totalminutes = totalseconds / 60L;
        long minutes = totalminutes % 60L;
        long hours = totalminutes / 60L;
        if (fraction > 0L) {
            return String.format("%1$02d:%2$02d:%3$02d.%4$03d", hours, minutes, seconds, fraction);
        }
        return String.format("%1$02d:%2$02d:%3$02d", hours, minutes, seconds);
    }

    private static class NPTParser {
        private final String text;
        private final int length;
        private int currentIndex;
        private char current;
        private static final char EOF = '\u0000';

        public NPTParser(String text) {
            this.text = text;
            this.length = text.length();
            this.currentIndex = -1;
            this.next();
        }

        private long parse() throws ParseException {
            long ms;
            int first = this.parseNumber();
            if (this.current == ':') {
                int hours = first;
                this.next();
                long minutes = this.parseNumber();
                this.assertCurrentIs(':');
                this.next();
                long seconds = this.parseNumber();
                ms = (((long)hours * 60L + minutes) * 60L + seconds) * 1000L;
            } else {
                ms = (long)first * 1000L;
            }
            if (this.current == '.') {
                this.next();
                int exp = 100;
                int i = 0;
                while (i <= 3 && this.isDigit()) {
                    ms += (long)(exp * this.digitValue());
                    this.next();
                    ++i;
                    exp /= 10;
                }
                this.parseNumber();
            }
            this.assertCurrentIs('\u0000');
            return ms;
        }

        private int parseNumber() {
            int retval = 0;
            while (this.isDigit()) {
                retval *= 10;
                retval += this.digitValue();
                this.next();
            }
            return retval;
        }

        private int digitValue() {
            return this.current - 48;
        }

        private boolean isDigit() {
            return this.current >= '0' && this.current <= '9';
        }

        private void assertCurrentIs(char c) throws ParseException {
            if (c != this.current) {
                throw new ParseException("Unexpected character", this.currentIndex);
            }
        }

        private void next() {
            ++this.currentIndex;
            this.current = this.currentIndex >= this.length ? (char)'\u0000' : this.text.charAt(this.currentIndex);
        }
    }
}

