/*
 * Decompiled with CFR 0.152.
 */
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;

public final class Beep
extends Thread {
    float sampleRate = 32000.0f;
    int freqHz;
    int durationMsec;
    double level;

    public Beep(int n, int n2, double d) {
        this.freqHz = n;
        this.durationMsec = n2;
        this.level = d * 32767.0;
        this.start();
    }

    private double envelope(double d, double d2, double d3, double d4) {
        return (d2 - d3) * (-d + d3) / ((d2 - d3 + d4) * (-d + d3 + d4));
    }

    @Override
    public void run() {
        try {
            int n = (int)(2.0f * this.sampleRate * (float)this.durationMsec / 1000.0f);
            byte[] byArray = new byte[n];
            double d = Math.PI * 2 * (double)this.freqHz / (double)this.sampleRate;
            double d2 = 0.0;
            int n2 = 0;
            while (n2 < n) {
                int n3 = (int)(Math.sin(d2) * this.level * this.envelope(0.0, n, n2, 1000.0));
                byArray[n2++] = (byte)(n3 % 256);
                byArray[n2++] = (byte)(n3 / 256);
                d2 += d;
            }
            AudioFormat audioFormat = new AudioFormat(this.sampleRate, 16, 1, true, false);
            SourceDataLine sourceDataLine = AudioSystem.getSourceDataLine(audioFormat);
            sourceDataLine.open(audioFormat);
            sourceDataLine.start();
            sourceDataLine.write(byArray, 0, byArray.length);
            sourceDataLine.drain();
            sourceDataLine.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void beep(double d) {
        new Beep(1000, 100, d);
    }

    public static void beep() {
        new Beep(1000, 100, 0.5);
    }

    public static void main(String[] stringArray) {
        Beep.beep(0.5);
    }
}

