/*
 * Decompiled with CFR 0.152.
 */
import java.util.GregorianCalendar;
import java.util.Vector;

public final class DateRangeCalculator {
    private GregorianCalendar startDate;
    private GregorianCalendar endDate;
    PLCash parent;
    public static String[] periodList = new String[]{"Custom Dates", "All Dates", "Current Month", "Current Quarter", "Current Year", "Month to date", "Quarter to date", "Year to date", "Earliest date to date", "Last Month", "Last Quarter", "Last Year", "Last 12 Months"};
    public static String[] intervalList = new String[]{"Single", "One Day", "One Week", "Two Week", "Half Month", "Month", "Quarter", "Half Year", "Year"};

    public DateRangeCalculator(PLCash pLCash) {
        this.parent = pLCash;
    }

    public GregorianCalendar getStartDate() {
        return this.startDate;
    }

    public GregorianCalendar getEndDate() {
        return this.endDate;
    }

    public boolean computeDates(int n, ReportDesignData reportDesignData) {
        this.startDate = new GregorianCalendar();
        this.endDate = new GregorianCalendar();
        boolean bl = true;
        switch (n) {
            case 0: {
                this.startDate.setTimeInMillis(reportDesignData.db_startDate);
                this.endDate.setTimeInMillis(reportDesignData.db_endDate);
                break;
            }
            case 1: {
                this.startDate = new GregorianCalendar(1900, 0, 1);
                this.endDate = new GregorianCalendar(2100, 0, 1);
                break;
            }
            case 2: {
                this.startDate = new GregorianCalendar(this.startDate.get(1), this.startDate.get(2), this.startDate.getActualMinimum(5));
                this.endDate = new GregorianCalendar(this.endDate.get(1), this.endDate.get(2), this.endDate.getActualMaximum(5));
                break;
            }
            case 3: {
                int n2 = this.startDate.get(2);
                n2 -= n2 % 3;
                this.startDate = new GregorianCalendar(this.startDate.get(1), n2, 1);
                this.endDate = new GregorianCalendar(this.endDate.get(1), n2, 1);
                this.endDate.add(2, 2);
                this.endDate = new GregorianCalendar(this.endDate.get(1), this.endDate.get(2), this.endDate.getActualMaximum(5));
                break;
            }
            case 4: {
                this.startDate = new GregorianCalendar(this.startDate.get(1), 0, 1);
                this.endDate = new GregorianCalendar(this.endDate.get(1), 11, 31);
                break;
            }
            case 5: {
                this.startDate = new GregorianCalendar(this.startDate.get(1), this.startDate.get(2), 1);
                break;
            }
            case 6: {
                int n3 = this.startDate.get(2);
                n3 -= n3 % 3;
                this.startDate = new GregorianCalendar(this.startDate.get(1), n3, 1);
                break;
            }
            case 7: {
                this.startDate = new GregorianCalendar(this.startDate.get(1), 0, 1);
                break;
            }
            case 8: {
                this.startDate = new GregorianCalendar(1900, 0, 1);
                break;
            }
            case 9: {
                this.startDate.add(2, -1);
                this.startDate = new GregorianCalendar(this.startDate.get(1), this.startDate.get(2), 1);
                this.endDate = new GregorianCalendar(this.startDate.get(1), this.startDate.get(2), this.startDate.getActualMaximum(5));
                break;
            }
            case 10: {
                this.startDate.add(2, -3);
                int n4 = this.startDate.get(2);
                n4 -= n4 % 3;
                this.startDate = new GregorianCalendar(this.startDate.get(1), n4, 1);
                this.endDate.add(2, -3);
                this.endDate = new GregorianCalendar(this.endDate.get(1), n4, 1);
                this.endDate.add(2, 2);
                this.endDate = new GregorianCalendar(this.endDate.get(1), this.endDate.get(2), this.endDate.getActualMaximum(5));
                break;
            }
            case 11: {
                this.startDate.add(1, -1);
                this.startDate = new GregorianCalendar(this.startDate.get(1), 0, 1);
                this.endDate.add(1, -1);
                this.endDate = new GregorianCalendar(this.endDate.get(1), 11, 31);
                break;
            }
            case 12: {
                this.startDate.add(2, -12);
                this.startDate = new GregorianCalendar(this.startDate.get(1), this.startDate.get(2), 1);
                this.endDate = new GregorianCalendar(this.endDate.get(1), this.endDate.get(2), this.endDate.getActualMaximum(5));
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public String getDisplayDateString(GregorianCalendar gregorianCalendar) {
        return this.parent.commonCode.displayDateForTime(gregorianCalendar.getTimeInMillis());
    }

    public static long baseTimeForTime(int n, long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(l);
        switch (n) {
            case 0: {
                return gregorianCalendar.getTimeInMillis();
            }
            case 1: {
                return gregorianCalendar.getTimeInMillis();
            }
            case 2: {
                int n2 = gregorianCalendar.get(7);
                n2 = (n2 - 1) % 7;
                gregorianCalendar.add(7, -n2);
                return gregorianCalendar.getTimeInMillis();
            }
            case 3: {
                int n3 = gregorianCalendar.get(7);
                n3 = (n3 - 1) % 14;
                gregorianCalendar.add(7, -n3);
                return gregorianCalendar.getTimeInMillis();
            }
            case 4: {
                int n4 = gregorianCalendar.get(5);
                n4 = (n4 - 1) % 15;
                gregorianCalendar.add(5, -n4);
                return gregorianCalendar.getTimeInMillis();
            }
            case 5: {
                GregorianCalendar gregorianCalendar2 = new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2), 1);
                return gregorianCalendar2.getTimeInMillis();
            }
            case 6: {
                int n5 = gregorianCalendar.get(2);
                n5 -= n5 % 3;
                GregorianCalendar gregorianCalendar3 = new GregorianCalendar(gregorianCalendar.get(1), n5, 1);
                return gregorianCalendar3.getTimeInMillis();
            }
            case 7: {
                int n6 = gregorianCalendar.get(2);
                n6 -= n6 % 6;
                GregorianCalendar gregorianCalendar4 = new GregorianCalendar(gregorianCalendar.get(1), n6, 1);
                return gregorianCalendar4.getTimeInMillis();
            }
            case 8: {
                GregorianCalendar gregorianCalendar5 = new GregorianCalendar(gregorianCalendar.get(1), 0, 1);
                return gregorianCalendar5.getTimeInMillis();
            }
        }
        return 0L;
    }

    public static long nextPeriodTime(int n, long l, long l2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(l);
        switch (n) {
            case 0: {
                gregorianCalendar.setTimeInMillis(l2);
                gregorianCalendar.add(6, 1);
                return gregorianCalendar.getTimeInMillis();
            }
            case 1: {
                gregorianCalendar.add(7, 1);
                return gregorianCalendar.getTimeInMillis();
            }
            case 2: {
                gregorianCalendar.add(7, 7);
                return gregorianCalendar.getTimeInMillis();
            }
            case 3: {
                gregorianCalendar.add(7, 14);
                return gregorianCalendar.getTimeInMillis();
            }
            case 4: {
                int n2 = gregorianCalendar.get(5);
                if (n2 == 1) {
                    gregorianCalendar.add(5, 15);
                } else {
                    gregorianCalendar.add(2, 1);
                    gregorianCalendar = new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2), 1);
                }
                return gregorianCalendar.getTimeInMillis();
            }
            case 5: {
                gregorianCalendar.add(2, 1);
                return gregorianCalendar.getTimeInMillis();
            }
            case 6: {
                gregorianCalendar.add(2, 3);
                return gregorianCalendar.getTimeInMillis();
            }
            case 7: {
                gregorianCalendar.add(2, 6);
                return gregorianCalendar.getTimeInMillis();
            }
            case 8: {
                gregorianCalendar.add(1, 1);
                return gregorianCalendar.getTimeInMillis();
            }
        }
        return 0L;
    }

    public static long addDay(long l, int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(l);
        gregorianCalendar.add(5, n);
        return gregorianCalendar.getTimeInMillis();
    }

    public static Long[] computeBinDates(int n, long l, long l2) {
        Vector<Long> vector = new Vector<Long>();
        long l3 = DateRangeCalculator.baseTimeForTime(n, l);
        while (l3 <= l2) {
            vector.add(new Long(l3));
            if (n == 0) break;
            l3 = DateRangeCalculator.nextPeriodTime(n, l3, l2);
        }
        return vector.toArray(new Long[vector.size()]);
    }
}

