/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public abstract class EditorPane
extends JPanel {
    PLCash parent;
    JPanel splitsPanel;
    JButton commitButton;
    JButton cancelButton;
    Account account;
    int index;
    String address = "";
    boolean dataChanged = false;
    boolean hasSplits = false;
    boolean suppressChange = false;
    Transaction orig_t;
    Transaction edit_t;

    public EditorPane() {
        this.initComponents();
    }

    protected abstract void commit(int var1);

    public abstract void loadForm(Account var1, int var2);

    protected abstract void setChanged(boolean var1);

    protected JTextField getTextField(JComboBox jComboBox) {
        return (JTextField)jComboBox.getEditor().getEditorComponent();
    }

    protected void handlePayeeField(JTextField jTextField, KeyEvent keyEvent) {
        String string;
        String string2 = jTextField.getText();
        int n = jTextField.getCaretPosition();
        String string3 = string = string2.substring(0, n);
        char c = keyEvent.getKeyChar();
        if (!Character.isISOControl(c)) {
            string = string + c;
            keyEvent.consume();
        }
        if (c == '\b') {
            int n2 = string.length();
            if (--n2 < 0) {
                n2 = 0;
            }
            string = string.substring(0, n2);
            keyEvent.consume();
        }
        n = string.length();
        String string4 = string.toLowerCase();
        String string5 = null;
        if (string.length() > 0) {
            string5 = this.parent.memHandler.nearestMatchLCString(string4);
        }
        if (string5 != null && string5.toLowerCase().indexOf(string4) != 0) {
            string5 = null;
        }
        if (string5 == null) {
            string5 = string;
        }
        jTextField.setText(string5);
        if (n >= string5.length()) {
            n = string5.length();
        }
        jTextField.setCaretPosition(n);
    }

    protected void handleNumberEntry(InputMethodEvent inputMethodEvent, boolean bl) {
        JTextField jTextField = (JTextField)inputMethodEvent.getSource();
        String string = this.parent.commonCode.formatCurrency(jTextField.getText(), bl);
        if (string != null) {
            jTextField.setText(string);
        }
    }

    protected void handleNumberEntry(ActionEvent actionEvent, boolean bl) {
        JTextField jTextField = (JTextField)actionEvent.getSource();
        String string = this.parent.commonCode.formatCurrency(jTextField.getText(), bl);
        if (string != null) {
            jTextField.setText(string);
        }
    }

    protected void closeEditingWindow(Account account) {
        this.parent.closeEditWindow();
        if (account.accountDisplay != null) {
            account.accountDisplay.tableFocus();
        }
    }

    public SplitsHandler getSplitPane() {
        return (SplitsHandler)this.splitsPanel;
    }

    protected void deleteTransaction() {
        this.account.accountDisplay.deleteTransactions();
        this.parent.playSound();
    }

    public boolean checkChanged() {
        boolean bl = false;
        if (this.dataChanged) {
            Object[] objectArray = new String[]{"Save", "Discard", "Cancel"};
            int n = JOptionPane.showOptionDialog(this.parent, "You have made changes to the present transaction.", "Transaction Changed", -1, 2, null, objectArray, objectArray[0]);
            if (n == 0) {
                this.commit(0);
            }
            if (n != 2) {
                this.dataChanged = false;
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    protected void changeTransaction(int n, boolean bl) {
        int n2;
        if (!this.checkChanged()) {
            return;
        }
        int n3 = n2 = bl ? n : this.index + n;
        if (n2 < 0 || n2 > this.account.size()) {
            this.parent.beep();
        } else {
            this.loadForm(this.account, n2);
        }
    }

    protected void toBegin() {
        this.changeTransaction(0, true);
    }

    protected void toEnd() {
        this.changeTransaction(this.account.size() - 1, true);
    }

    protected void newTransaction() {
        this.changeTransaction(this.account.size(), true);
    }

    protected void watchForLF(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n' && this.parent.programValues.db_EnterMode) {
            this.commit(1);
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Add/Edit Account"));
    }
}

