/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JFrame;
import javax.swing.JTextField;

public final class FloatingWindow
extends JFrame {
    JTextField label;
    Font df;
    Rectangle pref;
    FontMetrics fm;
    int charHeight;
    Insets insets;

    public FloatingWindow(Font font) {
        this.setUndecorated(true);
        this.label = new JTextField();
        this.label.setEditable(false);
        this.df = font;
        this.label.setFont(this.df);
        this.insets = new Insets(2, 2, 2, 2);
        this.fm = this.label.getFontMetrics(this.df);
        this.charHeight = this.fm.getAscent() + this.fm.getDescent() + this.fm.getLeading();
        this.charHeight += this.insets.top + this.insets.bottom;
        this.pref = new Rectangle(0, 0, 4, 4);
        this.getContentPane().add(this.label);
        MyLineBorder myLineBorder = new MyLineBorder(Color.black, 1, this.insets);
        this.label.setBorder(myLineBorder);
        this.getContentPane().setBackground(Color.white);
        this.setBackground(Color.white);
        this.label.setBackground(new Color(204, 204, 255));
    }

    public void setMessage(String string) {
        int n = this.fm.stringWidth(string) + this.insets.left + this.insets.right;
        Rectangle rectangle = new Rectangle(0, 0, n, this.charHeight);
        this.pref.add(rectangle);
        this.label.setPreferredSize(new Dimension(this.pref.width, this.pref.height));
        this.label.setText(string);
        this.pack();
    }

    public void showAt(Point point) {
        this.setLocation(point);
        this.setVisible(true);
        this.toFront();
    }

    public void hideWindow() {
        this.setVisible(false);
    }
}

