/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Stack;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public final class HelpBrowser
extends JPanel {
    PLCash parent;
    Stack outStack;
    Stack backStack;
    int scrollValue = 0;
    boolean needScroll = false;
    String currentFile = "";
    private JComboBox addressComboBox;
    private JPanel topPanel;
    private JEditorPane browserWindow;
    private JButton backButton;
    private JScrollPane scrollPane;
    private JButton forwardButton;
    private JMenuItem closeMenuItem;
    private JPopupMenu popupMenu;

    public HelpBrowser(PLCash pLCash) {
        this.parent = pLCash;
        this.outStack = new Stack();
        this.backStack = new Stack();
        this.initComponents();
        this.browserWindow.addHyperlinkListener(new LinkFollower(this, this.parent));
        this.browserWindow.setEditable(false);
        this.checkButtons();
    }

    public void setPage(String string) {
        try {
            this.wrapPCB(this.addressComboBox).addItemToList(string);
            if (this.currentFile.equals(string)) {
                this.browserWindow.getDocument().putProperty("stream", null);
            }
            this.currentFile = string;
            this.browserWindow.setPage(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.checkButtons();
    }

    public void toPage(String string) {
        if (!this.backStack.empty()) {
            this.backStack.pop();
        }
        this.pushStack(this.outStack);
        this.setPage(string);
    }

    private PriorityComboBox wrapPCB(Object object) {
        return (PriorityComboBox)object;
    }

    private void updateAddress() {
        Object object;
        if (!this.wrapPCB((Object)this.addressComboBox).busy && (object = this.addressComboBox.getSelectedItem()) != null) {
            this.toPage(object.toString());
        }
    }

    private void pushStack(Stack stack) {
        BrowserItem browserItem = new BrowserItem(this.currentFile, this.scrollPane.getVerticalScrollBar().getValue());
        stack.push(browserItem);
    }

    private void popStack(Stack stack) {
        if (!stack.empty()) {
            BrowserItem browserItem = (BrowserItem)stack.pop();
            this.setPage(browserItem.path);
            this.scrollValue = browserItem.scrollPos;
            this.needScroll = true;
            this.repaint();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void goBack() {
        if (!this.outStack.empty()) {
            this.pushStack(this.backStack);
            this.popStack(this.outStack);
        }
    }

    private void goForward() {
        if (!this.backStack.empty()) {
            this.pushStack(this.outStack);
            this.popStack(this.backStack);
        }
    }

    private void checkButtons() {
        this.backButton.setEnabled(this.outStack.size() > 0);
        this.forwardButton.setEnabled(this.backStack.size() > 0);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.needScroll) {
            this.needScroll = false;
            this.scrollPane.getVerticalScrollBar().setValue(this.scrollValue);
        }
    }

    private boolean handleMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            return true;
        }
        return false;
    }

    private void closeThisWindow() {
        this.parent.displayHandler.closeTab(this);
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.closeMenuItem = new JMenuItem();
        this.topPanel = new JPanel();
        this.backButton = new MyJButton();
        this.forwardButton = new MyJButton();
        this.addressComboBox = new PriorityComboBox();
        this.scrollPane = new JScrollPane();
        this.browserWindow = new JEditorPane();
        this.closeMenuItem.setText("Close");
        this.closeMenuItem.setToolTipText("Close this window");
        this.closeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpBrowser.this.closeMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.closeMenuItem);
        this.setLayout(new BorderLayout());
        this.topPanel.setLayout(new GridBagLayout());
        this.backButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Left.png")));
        this.backButton.setToolTipText("Go back one page");
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpBrowser.this.backButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.topPanel.add((Component)this.backButton, gridBagConstraints);
        this.forwardButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Right.png")));
        this.forwardButton.setToolTipText("Go forward one page");
        this.forwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpBrowser.this.forwardButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.topPanel.add((Component)this.forwardButton, gridBagConstraints);
        this.addressComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpBrowser.this.addressComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.topPanel.add((Component)this.addressComboBox, gridBagConstraints);
        this.add((Component)this.topPanel, "North");
        this.browserWindow.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                HelpBrowser.this.browserWindowMousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                HelpBrowser.this.browserWindowMouseReleased(mouseEvent);
            }
        });
        this.scrollPane.setViewportView(this.browserWindow);
        this.add((Component)this.scrollPane, "Center");
    }

    private void closeMenuItemActionPerformed(ActionEvent actionEvent) {
        this.closeThisWindow();
    }

    private void browserWindowMouseReleased(MouseEvent mouseEvent) {
        this.handleMenu(mouseEvent);
    }

    private void browserWindowMousePressed(MouseEvent mouseEvent) {
        this.handleMenu(mouseEvent);
    }

    private void addressComboBoxActionPerformed(ActionEvent actionEvent) {
        this.updateAddress();
    }

    private void forwardButtonActionPerformed(ActionEvent actionEvent) {
        this.goForward();
    }

    private void backButtonActionPerformed(ActionEvent actionEvent) {
        this.goBack();
    }
}

