/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.framework.Application;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.net.URI;
import javax.swing.JOptionPane;

public abstract class Browser {
    private Browser() {
    }

    public static void show(URI uri, Component parent, String errorDialogTitle) {
        try {
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException e) {
            Browser.error(uri, parent, errorDialogTitle);
        }
        catch (UnsupportedOperationException e) {
            Browser.error(uri, parent, errorDialogTitle);
        }
    }

    private static void error(URI uri, Component parent, String errorDialogTitle) {
        String url = uri.toString();
        String message = Formatter.format(Application.getString("Browser.unsupported.message", parent.getLocale()), url);
        StringSelection stringSelection = new StringSelection(url);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
        if (errorDialogTitle == null) {
            errorDialogTitle = "";
        }
        JOptionPane.showMessageDialog(Utils.getOwnerWindow(parent), message, errorDialogTitle, 2);
    }
}

