/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.UIManager;

public abstract class FontUtils {
    private static final String DEFAULT_FONT_PROPERTY_NAME = "defaultFont";

    private FontUtils() {
    }

    public static List<Font> getAvailableTextFonts(Locale locale) {
        Font[] allfonts;
        ArrayList<Font> result = new ArrayList<Font>();
        for (Font font : allfonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            if (font.canDisplayUpTo(font.getFontName(locale)) != -1) continue;
            result.add(font);
        }
        return result;
    }

    public static boolean isDefaultFontSupportedByLookAndFeel(String lookAndFeelName) {
        return "Nimbus".equals(lookAndFeelName);
    }

    public static Font getDefaultFont() {
        return FontUtils.isDefaultFontSupportedByLookAndFeel(UIManager.getLookAndFeel().getName()) ? UIManager.getDefaults().getFont(DEFAULT_FONT_PROPERTY_NAME) : null;
    }

    public static void setDefaultFont(Font font) {
        if (FontUtils.isDefaultFontSupportedByLookAndFeel(UIManager.getLookAndFeel().getName())) {
            UIManager.getLookAndFeelDefaults().put(DEFAULT_FONT_PROPERTY_NAME, font);
        }
    }
}

