/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public abstract class Utils {
    private static final String LOCATION_Y_PROPERTY = "y";
    private static final String LOCATION_X_PROPERTY = "x";
    private static final String SIZE_X_PROPERTY = "size.x";
    private static final String SIZE_Y_PROPERTY = "size.y";

    private Utils() {
    }

    public static Window getOwnerWindow(Component component) {
        while (component != null && !(component instanceof Window)) {
            if (component instanceof JPopupMenu) {
                component = ((JPopupMenu)component).getInvoker();
                continue;
            }
            component = component.getParent();
        }
        return (Window)component;
    }

    @Deprecated
    public static void centerWindow(Window window, Window reference) {
        window.setLocationRelativeTo(reference);
    }

    public static void packColumns(JTable table, int margin) {
        for (int i = 0; i < table.getColumnCount(); ++i) {
            Utils.packColumn(table, i, margin);
        }
    }

    public static int packColumn(JTable table, int colIndex, int margin) {
        TableColumnModel colModel = table.getColumnModel();
        int viewIndex = table.convertColumnIndexToView(colIndex);
        if (viewIndex < 0) {
            return -1;
        }
        TableColumn col = colModel.getColumn(viewIndex);
        int width = 0;
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
        width = comp.getPreferredSize().width;
        for (int r = 0; r < table.getRowCount(); ++r) {
            renderer = table.getCellRenderer(r, colIndex);
            comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, colIndex), false, false, r, colIndex);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        col.setPreferredWidth(width += 2 * margin);
        return width;
    }

    public static Icon createIcon(URL path, int size) {
        ImageIcon imageIcon = new ImageIcon(path);
        int currentSize = imageIcon.getIconHeight();
        if (size != currentSize) {
            Image img = imageIcon.getImage();
            imageIcon = new ImageIcon(img.getScaledInstance(size, size, 4));
        }
        return imageIcon;
    }

    public static Icon createIcon(URL path, float sizeRatio) {
        ImageIcon imageIcon = new ImageIcon(path);
        if (sizeRatio != 1.0f) {
            Image img = imageIcon.getImage();
            imageIcon = new ImageIcon(img.getScaledInstance((int)((float)imageIcon.getIconWidth() * sizeRatio), (int)((float)imageIcon.getIconHeight() * sizeRatio), 4));
        }
        return imageIcon;
    }

    public static MouseListener getToolTipAdapter(final int initialDelay, final int dismissDelay, final int reshowDelay) {
        return new MouseAdapter(){
            private int originalDismissDelay;
            private int originalInitialDelay;
            private int originalReshowDelay;
            private boolean originalEnabled;

            @Override
            public void mouseEntered(MouseEvent e) {
                ToolTipManager ttm = ToolTipManager.sharedInstance();
                this.originalInitialDelay = ttm.getInitialDelay();
                this.originalDismissDelay = ttm.getDismissDelay();
                this.originalReshowDelay = ttm.getReshowDelay();
                this.originalEnabled = ttm.isEnabled();
                if (dismissDelay > 0) {
                    ttm.setDismissDelay(dismissDelay);
                } else if (dismissDelay == 0) {
                    ttm.setEnabled(false);
                }
                if (initialDelay >= 0) {
                    ttm.setInitialDelay(initialDelay);
                }
                if (reshowDelay >= 0) {
                    ttm.setReshowDelay(reshowDelay);
                }
                super.mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ToolTipManager ttm = ToolTipManager.sharedInstance();
                ttm.setInitialDelay(this.originalInitialDelay);
                ttm.setDismissDelay(this.originalDismissDelay);
                ttm.setReshowDelay(this.originalReshowDelay);
                ttm.setEnabled(this.originalEnabled);
                super.mouseExited(e);
            }
        };
    }

    public static String getLFClassFromName(String lookAndFeelName) {
        UIManager.LookAndFeelInfo[] installedLookAndFeels = UIManager.getInstalledLookAndFeels();
        String lookAndFeelClass = null;
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : installedLookAndFeels) {
            if (!lookAndFeelInfo.getName().equals(lookAndFeelName)) continue;
            lookAndFeelClass = lookAndFeelInfo.getClassName();
            break;
        }
        return lookAndFeelClass;
    }

    public static void saveState(Frame frame, Preferences prefs) {
        prefs.put(LOCATION_X_PROPERTY, Integer.toString(frame.getLocation().x));
        prefs.put(LOCATION_Y_PROPERTY, Integer.toString(frame.getLocation().y));
        Dimension size = frame.getSize();
        int h = (frame.getExtendedState() & 4) == 0 ? size.height : -1;
        int w = (frame.getExtendedState() & 2) == 0 ? size.width : -1;
        prefs.put(SIZE_X_PROPERTY, Integer.toString(w));
        prefs.put(SIZE_Y_PROPERTY, Integer.toString(h));
    }

    public static void restoreState(Frame frame, Preferences prefs) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension = new Dimension(prefs.getInt(SIZE_X_PROPERTY, 0), prefs.getInt(SIZE_Y_PROPERTY, 0));
        int extendedState = 0;
        if (dimension.width != 0 && dimension.height != 0) {
            if (dimension.height < 0) {
                extendedState |= 4;
                dimension.height = frame.getSize().height;
            }
            if (dimension.width < 0) {
                extendedState |= 2;
                dimension.width = frame.getSize().width;
            }
            frame.setSize(dimension);
            frame.setExtendedState(extendedState);
        }
        Point location = new Point(prefs.getInt(LOCATION_X_PROPERTY, 0), prefs.getInt(LOCATION_Y_PROPERTY, 0));
        if (location.x + frame.getWidth() > screenSize.width) {
            location.x = screenSize.width - frame.getWidth();
        }
        if (location.y + frame.getHeight() > screenSize.height) {
            location.y = screenSize.height - frame.getHeight();
        }
        frame.setLocation(location);
    }
}

