/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.dialog;

import com.fathzer.soft.ajlib.swing.framework.Application;
import com.fathzer.soft.ajlib.utilities.FileUtils;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class FileChooser
extends JFileChooser {
    private static final long serialVersionUID = 1L;
    private JTextField fileNameField = null;
    private File selectedFile = null;
    private Component fileNameLabel;
    private boolean selectionTestEnabled = true;

    public FileChooser() {
        this((String)null);
    }

    public FileChooser(String path) {
        super(path);
        Field field2;
        try {
            field2 = this.getUI().getClass().getDeclaredField("fileNameTextField");
            try {
                field2.setAccessible(true);
                this.fileNameField = (JTextField)field2.get(this.getUI());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (NoSuchFieldException field2) {
            // empty catch block
        }
        try {
            field2 = this.getUI().getClass().getDeclaredField("fileNameLabel");
            try {
                field2.setAccessible(true);
                this.fileNameLabel = (JLabel)field2.get(this.getUI());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (NoSuchFieldException field3) {
            // empty catch block
        }
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                File old = FileChooser.this.getSelectedFile();
                File superSelected = FileChooser.super.getSelectedFile();
                String name = FileChooser.this.fileNameField != null ? FileChooser.this.fileNameField.getText() : (superSelected == null ? "" : superSelected.getName());
                File selectedFile = FileChooser.this.buildSelectedFile(name);
                if (!NullUtils.areEquals(old, selectedFile)) {
                    int pos = FileChooser.this.fileNameField != null ? FileChooser.this.fileNameField.getCaretPosition() : 0;
                    FileChooser.this.firePropertyChange("SelectedFileChangedProperty", old, selectedFile);
                    if (FileChooser.this.fileNameField != null) {
                        if (pos > FileChooser.this.fileNameField.getText().length()) {
                            pos = FileChooser.this.fileNameField.getText().length();
                        }
                        FileChooser.this.fileNameField.setCaretPosition(pos);
                    }
                }
            }
        };
        if (this.fileNameField != null) {
            new MyDocument(this.fileNameField);
            this.addPropertyChangeListener("text", listener);
        }
        this.addPropertyChangeListener("directoryChanged", listener);
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if ("SelectedFileChangedProperty".equals(propertyName)) {
            this.selectedFile = (File)newValue;
        }
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public boolean isGetSelectedFileFixed() {
        return this.fileNameField != null;
    }

    @Override
    public File getSelectedFile() {
        if (!this.isGetSelectedFileFixed()) {
            if (this.getUI() instanceof BasicFileChooserUI) {
                String name = ((BasicFileChooserUI)this.getUI()).getFileName();
                this.selectedFile = this.buildSelectedFile(name);
            } else {
                System.err.println("Warning, unable to get the current file name. UI is instance of " + this.ui.getClass());
                this.selectedFile = super.getSelectedFile();
            }
        }
        return this.selectedFile;
    }

    @Override
    public void approveSelection() {
        File file;
        if (this.selectionTestEnabled && (file = this.getSelectedFile()) != null) {
            String error;
            if (this.getDialogType() == 1) {
                try {
                    boolean cancel;
                    File canonical = FileUtils.getCanonical(file);
                    if (canonical.exists() && (cancel = FileChooser.showSaveDisplayQuestion(this))) {
                        return;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if ((error = this.getDisabledCause()) != null) {
                JOptionPane.showMessageDialog(this, error, this.get("Generic.error"), 0);
                return;
            }
        }
        super.approveSelection();
    }

    public void setSelectionTestEnabled(boolean enabled) {
        this.selectionTestEnabled = enabled;
    }

    public String getDisabledCause() {
        File file = this.getSelectedFile();
        if (file == null) {
            return null;
        }
        try {
            if (this.getDialogType() == 0) {
                if (!file.exists()) {
                    return this.get("openDialog.fileDoesntExist");
                }
                File canonical = FileUtils.getCanonical(file);
                if (!canonical.exists()) {
                    return this.get("openDialog.targetDoesntExist");
                }
                if (!FileUtils.isReadable(file)) {
                    return this.get("openDialog.fileNotReadable");
                }
            } else {
                File canonical = FileUtils.getCanonical(file);
                if (!FileUtils.isWritable(canonical)) {
                    return this.get("saveDialog.fileNotWritable");
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private String get(String key) {
        return Application.LOCALIZATION.getString(key, this.getLocale());
    }

    public static boolean showSaveDisplayQuestion(Component parent) {
        String message = Application.LOCALIZATION.getString("saveDialog.FileExist.message", parent.getLocale());
        return JOptionPane.showOptionDialog(parent, message, Application.LOCALIZATION.getString("saveDialog.FileExist.title", parent.getLocale()), 0, 2, null, null, null) == 1;
    }

    @Override
    public void setDialogType(int dialogType) {
        if (this.fileNameField != null && this.fileNameLabel != null) {
            boolean visible = dialogType != 0;
            this.fileNameField.setVisible(visible);
            this.fileNameLabel.setVisible(visible);
        }
        super.setDialogType(dialogType);
    }

    @Override
    public void setSelectedFile(File file) {
        if (file == null && this.selectedFile != null) {
            File parent = this.selectedFile.getParentFile();
            super.setSelectedFile(new File(""));
            super.setCurrentDirectory(parent);
            this.selectedFile = null;
        } else {
            super.setSelectedFile(file);
        }
    }

    private File buildSelectedFile(String name) {
        return (name = new File(name).getName()).length() == 0 ? null : new File(FileChooser.super.getCurrentDirectory(), name);
    }

    private class MyDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        private static final String TEXT_PROPERTY = "text";
        private boolean ignoreEvents = false;
        private JTextField field;

        private MyDocument(JTextField field) {
            this.field = field;
            field.setDocument(this);
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            String oldValue = this.field.getText();
            this.ignoreEvents = true;
            super.replace(offset, length, text, attrs);
            this.ignoreEvents = false;
            String newValue = this.field.getText();
            if (!oldValue.equals(newValue)) {
                FileChooser.this.firePropertyChange(TEXT_PROPERTY, oldValue, newValue);
            }
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            String oldValue = this.field.getText();
            super.remove(offs, len);
            String newValue = this.field.getText();
            if (!this.ignoreEvents && !oldValue.equals(newValue)) {
                FileChooser.this.firePropertyChange(TEXT_PROPERTY, oldValue, newValue);
            }
        }
    }
}

