/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.widget;

import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.widget.ComboBox;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public abstract class AbstractSelector<T, V>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel jLabel;
    private ComboBox combo;
    private JButton newButton;
    private T lastSelected;
    private V parameters;

    public AbstractSelector(V parameters) {
        this.parameters = parameters;
        this.initialize();
        this.internalPopulate();
        this.lastSelected = this.get();
    }

    private void internalPopulate() {
        this.getCombo().setActionEnabled(false);
        this.getCombo().removeAllItems();
        this.populateCombo();
        this.getCombo().setActionEnabled(true);
    }

    protected Icon getNewButtonIcon() {
        return null;
    }

    public V getParameters() {
        return this.parameters;
    }

    public void setParameters(V parameters) {
        this.parameters = parameters;
        this.refresh();
    }

    protected abstract void populateCombo();

    public void refresh() {
        T old = this.get();
        boolean oldEnabled = this.getCombo().isActionEnabled();
        this.getCombo().setActionEnabled(false);
        this.getCombo().removeAllItems();
        this.populateCombo();
        this.getCombo().setActionEnabled(oldEnabled);
        this.setSelectionAfterRefresh(old);
    }

    protected void setSelectionAfterRefresh(T old) {
        if (this.getCombo().contains(old)) {
            this.getCombo().setSelectedItem(old);
        }
    }

    private void initialize() {
        String label = this.getLabel();
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.getJLabel(), "West");
        this.add(this.getCombo());
        this.add((Component)this.getNewButton(), "East");
        Dimension dimension = this.getCombo().getPreferredSize();
        this.getNewButton().setPreferredSize(new Dimension(dimension.height, dimension.height));
        if (label != null) {
            this.getJLabel().setText(this.getLabel());
        }
        if (this.getComboTip() != null) {
            this.getCombo().setToolTipText(this.getComboTip());
        }
        if (this.getNewButtonTip() != null) {
            this.getNewButton().setToolTipText(this.getNewButtonTip());
        }
    }

    public JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
        }
        return this.jLabel;
    }

    public JButton getNewButton() {
        if (this.newButton == null) {
            this.newButton = new JButton();
            this.newButton.setHorizontalAlignment(2);
            Icon icon = this.getNewButtonIcon();
            this.newButton = new JButton(icon);
            this.newButton.setFocusable(false);
            this.newButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object c = AbstractSelector.this.createNew();
                    if (c != null) {
                        AbstractSelector.this.internalPopulate();
                        AbstractSelector.this.getCombo().setSelectedItem(c);
                        Utils.getOwnerWindow(AbstractSelector.this).pack();
                    }
                }
            });
            this.newButton.setVisible(this.isNewButtonVisible());
        }
        return this.newButton;
    }

    protected boolean isNewButtonVisible() {
        return true;
    }

    public ComboBox getCombo() {
        if (this.combo == null) {
            this.combo = new ComboBox();
            this.combo.setRenderer(new Renderer());
            this.combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object old = AbstractSelector.this.lastSelected;
                    AbstractSelector.this.lastSelected = AbstractSelector.this.get();
                    if (!NullUtils.areEquals(old, AbstractSelector.this.lastSelected)) {
                        AbstractSelector.this.firePropertyChange(AbstractSelector.this.getPropertyName(), old, AbstractSelector.this.lastSelected);
                    }
                }
            });
        }
        return this.combo;
    }

    protected Component getCustomizedRenderer(Component renderer, T value, int index, boolean isSelected, boolean cellHasFocus) {
        return renderer;
    }

    protected Object getDefaultRenderedValue(T value) {
        return value;
    }

    protected abstract T createNew();

    protected String getLabel() {
        return null;
    }

    protected String getComboTip() {
        return null;
    }

    protected String getNewButtonTip() {
        return null;
    }

    protected abstract String getPropertyName();

    public T get() {
        return (T)this.getCombo().getSelectedItem();
    }

    public void set(T value) {
        T oldValue = this.get();
        if (!NullUtils.areEquals(value, oldValue)) {
            this.getCombo().setSelectedItem(value);
        }
    }

    @Override
    public void setToolTipText(String tip) {
        this.getCombo().setToolTipText(tip);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getJLabel().setEnabled(enabled);
        this.getNewButton().setEnabled(enabled);
        this.getCombo().setEnabled(enabled);
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object v = value;
            Component renderer = super.getListCellRendererComponent((JList<?>)list, AbstractSelector.this.getDefaultRenderedValue(v), index, isSelected, cellHasFocus);
            return AbstractSelector.this.getCustomizedRenderer(renderer, v, index, isSelected, cellHasFocus);
        }
    }
}

