/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.widget;

import com.fathzer.soft.ajlib.swing.Browser;
import com.fathzer.soft.ajlib.swing.framework.Application;
import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HTMLPane
extends JScrollPane {
    public static final String CONTENT_CHANGED_PROPERTY = "CHANGED";
    private static final String HTML_START_TAG = "<html>";
    private static final String HTML_END_TAG = "</html>";
    private JTextPane textPane;
    private String contentType;
    private DocumentListener docListener;

    public HTMLPane() {
        this.setHorizontalScrollBarPolicy(31);
        this.contentType = null;
        this.getTextPane().getDocument().addDocumentListener(this.getDocumentListener());
        this.setViewportView(this.getTextPane());
    }

    public HTMLPane(URL url) throws IOException {
        this();
        this.setContent(url);
    }

    public HTMLPane(String text) {
        this();
        this.setContent(text);
    }

    public void setContent(String text) {
        String type;
        if (this.contentType == null) {
            boolean html;
            String trimmed = text.trim();
            boolean bl = html = trimmed.length() >= HTML_START_TAG.length() + HTML_END_TAG.length();
            if (html) {
                html = HTML_START_TAG.equalsIgnoreCase(trimmed.substring(0, HTML_START_TAG.length()));
            }
            if (html) {
                html = HTML_END_TAG.equalsIgnoreCase(trimmed.substring(trimmed.length() - HTML_END_TAG.length()));
            }
            type = html ? "text/html" : "text/plain";
        } else {
            type = this.contentType;
        }
        this.getTextPane().setContentType(type);
        try {
            this.getTextPane().read(new StringReader(text), (Object)type);
            this.getTextPane().getDocument().addDocumentListener(this.getDocumentListener());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setContent(URL url) throws IOException {
        if (url != null) {
            this.getTextPane().setPage(url);
            this.textPane.getDocument().addDocumentListener(this.getDocumentListener());
        }
    }

    public JTextPane getTextPane() {
        if (this.textPane == null) {
            this.textPane = new JTextPane();
            this.textPane.setEditable(false);
            this.textPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        URL url = e.getURL();
                        if (url == null) {
                            throw new IllegalArgumentException(e.getDescription() + " leads to a null url");
                        }
                        try {
                            Browser.show(url.toURI(), HTMLPane.this, Application.getString("Generic.error", HTMLPane.this.getLocale()));
                        }
                        catch (URISyntaxException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                }
            });
            this.textPane.getDocument().addDocumentListener(this.getDocumentListener());
        }
        return this.textPane;
    }

    private DocumentListener getDocumentListener() {
        if (this.docListener == null) {
            this.docListener = new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    HTMLPane.this.firePropertyChange(HTMLPane.CONTENT_CHANGED_PROPERTY, null, null);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    HTMLPane.this.firePropertyChange(HTMLPane.CONTENT_CHANGED_PROPERTY, null, null);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    HTMLPane.this.firePropertyChange(HTMLPane.CONTENT_CHANGED_PROPERTY, null, null);
                }
            };
        }
        return this.docListener;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        if (contentType != null) {
            this.getTextPane().setContentType(contentType);
        }
    }
}

