/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.utilities;

import java.text.Normalizer;
import java.util.regex.Pattern;

public class TextMatcher {
    private Kind kind;
    private String filter;
    private boolean caseSensitive;
    private boolean diacriticalSensitive;
    private Object internalFilter;

    public TextMatcher(Kind kind, String filter, boolean caseSensitive, boolean diacriticalSensitive) {
        if (kind == null) {
            throw new IllegalArgumentException();
        }
        this.kind = kind;
        this.filter = filter;
        this.caseSensitive = caseSensitive;
        this.diacriticalSensitive = diacriticalSensitive;
        if (!diacriticalSensitive) {
            filter = TextMatcher.removeDiacriticals(filter);
        }
        this.internalFilter = kind == Kind.REGULAR ? (caseSensitive ? Pattern.compile(filter) : Pattern.compile(filter, 66)) : (kind == Kind.EQUALS || kind == Kind.CONTAINS && caseSensitive ? filter : filter.toUpperCase());
    }

    public static String removeDiacriticals(String string) {
        return Normalizer.normalize(string, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isDiacriticalSensitive() {
        return this.diacriticalSensitive;
    }

    public boolean matches(String text) {
        if (text == null) {
            return false;
        }
        if (!this.diacriticalSensitive) {
            text = TextMatcher.removeDiacriticals(text);
        }
        if (this.kind == Kind.REGULAR) {
            return ((Pattern)this.internalFilter).matcher(text).matches();
        }
        if (this.kind == Kind.EQUALS) {
            return this.caseSensitive ? text.equals(this.internalFilter) : text.equalsIgnoreCase((String)this.internalFilter);
        }
        if (this.kind == Kind.CONTAINS) {
            if (this.caseSensitive) {
                return text.contains((CharSequence)this.internalFilter);
            }
            return text.toUpperCase().contains((CharSequence)this.internalFilter);
        }
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return this.filter.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TextMatcher) {
            TextMatcher other = (TextMatcher)obj;
            return this.kind.equals((Object)other.kind) && this.filter.equals(other.filter) && this.caseSensitive == other.caseSensitive && this.diacriticalSensitive == other.diacriticalSensitive;
        }
        return false;
    }

    public static enum Kind {
        REGULAR,
        EQUALS,
        CONTAINS;

    }
}

