/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.jclop.dropbox.swing;

import com.dropbox.core.BadRequestException;
import com.dropbox.core.DbxAuthFinish;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxWebAuth;
import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.Browser;
import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.dialog.AbstractDialog;
import com.fathzer.soft.jclop.dropbox.DbxConnectionData;
import com.fathzer.soft.jclop.dropbox.swing.ConnectionButtonsPanel;
import com.fathzer.soft.jclop.dropbox.swing.ConnectionPanel;
import com.fathzer.soft.jclop.dropbox.swing.MessagePack;
import com.fathzer.soft.jclop.swing.AbstractURIChooserPanel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionDialog
extends AbstractDialog<DbxConnectionData, DbxAuthFinish> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionDialog.class);
    private boolean connectionHasStarted = false;
    private DbxAuthFinish pair;
    private DbxWebAuth webAuth;
    private ConnectionButtonsPanel cButtons;

    public ConnectionDialog(Window owner, DbxConnectionData appInfo, Locale locale) {
        super(owner, MessagePack.getString("com.fathzer.soft.jclop.dropbox.ConnectionDialog.title", locale), appInfo);
        this.setLocale(locale);
    }

    @Override
    protected JPanel createCenterPane() {
        return new ConnectionPanel(this.getOkButton().getText(), ((DbxConnectionData)this.data).getAppName(), this.getLocale());
    }

    @Override
    protected DbxAuthFinish buildResult() {
        return this.pair;
    }

    @Override
    protected void confirm() {
        try {
            String code = this.getConnectionButtonsPanel().getCodeField().getText();
            this.pair = this.webAuth.finishFromCode(code);
        }
        catch (BadRequestException e) {
            AbstractURIChooserPanel.showError(this, MessagePack.getString("com.fathzer.soft.jclop.dropbox.ConnectionDialog.accessNotGranted", this.getLocale()), this.getLocale());
            this.getConnectionButtonsPanel().getConnectButton().setEnabled(true);
            this.updateOkButtonEnabled();
            return;
        }
        catch (DbxException e) {
            LOGGER.warn("Error while linking with Dropbox account", e);
            AbstractURIChooserPanel.showError(this, MessagePack.getString("com.fathzer.soft.jclop.dropbox.ConnectionDialog.unexpectedError", this.getLocale()), this.getLocale());
        }
        super.confirm();
    }

    @Override
    protected String getOkDisabledCause() {
        if (!this.connectionHasStarted) {
            return Formatter.format(MessagePack.getString("com.fathzer.soft.jclop.dropbox.ConnectionDialog.error.processNotStarted", this.getLocale()), this.getConnectionButtonsPanel().getConnectButton().getText());
        }
        return null;
    }

    @Override
    protected JPanel createButtonsPane() {
        this.getConnectionButtonsPanel().addButtons(this.getOkButton(), this.getCancelButton());
        this.cButtons.getConnectButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Window window = Utils.getOwnerWindow(ConnectionDialog.this.cButtons);
                ConnectionDialog.this.webAuth = new DbxWebAuth(((DbxConnectionData)ConnectionDialog.this.data).getConfig(), ((DbxConnectionData)ConnectionDialog.this.data).getAppInfo());
                try {
                    DbxWebAuth.Request authRequest = DbxWebAuth.newRequestBuilder().build();
                    String authorizeUrl = ConnectionDialog.this.webAuth.authorize(authRequest);
                    Browser.show(new URI(authorizeUrl), window, MessagePack.getString("com.fathzer.soft.jclop.dropbox.ConnectionDialog.error.unableToLaunchBrowser.title", ConnectionDialog.this.getLocale()));
                    ConnectionDialog.this.connectionHasStarted = true;
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                ConnectionDialog.this.cButtons.getConnectButton().setEnabled(false);
                ConnectionDialog.this.updateOkButtonEnabled();
            }
        });
        return this.cButtons;
    }

    private ConnectionButtonsPanel getConnectionButtonsPanel() {
        if (this.cButtons == null) {
            this.cButtons = new ConnectionButtonsPanel(this.getLocale());
        }
        return this.cButtons;
    }
}

