/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.jclop.swing;

import com.fathzer.soft.ajlib.utilities.NullUtils;
import com.fathzer.soft.jclop.swing.URIChooser;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class MultipleURIChooserPanel
extends JTabbedPane {
    public static final String SELECTED_URI_PROPERTY = "selectedUri";
    public static final String URI_APPROVED_PROPERTY = "uriApproved";
    private URI selectedURI;
    private boolean isSave;
    private int lastSetup = -1;

    public MultipleURIChooserPanel(URIChooser[] choosers) {
        this.setTabPlacement(1);
        for (URIChooser uiChooser : choosers) {
            this.addTab(uiChooser.getTitle(), uiChooser.getIcon(), (Component)((Object)uiChooser), null);
            ((Component)((Object)uiChooser)).addPropertyChangeListener(SELECTED_URI_PROPERTY, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    URI old = MultipleURIChooserPanel.this.selectedURI;
                    MultipleURIChooserPanel.this.selectedURI = (URI)evt.getNewValue();
                    if (!NullUtils.areEquals(old, MultipleURIChooserPanel.this.selectedURI)) {
                        MultipleURIChooserPanel.this.firePropertyChange(MultipleURIChooserPanel.SELECTED_URI_PROPERTY, old, MultipleURIChooserPanel.this.selectedURI);
                    }
                }
            });
            ((Component)((Object)uiChooser)).addPropertyChangeListener(URI_APPROVED_PROPERTY, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    MultipleURIChooserPanel.this.firePropertyChange(MultipleURIChooserPanel.URI_APPROVED_PROPERTY, evt.getOldValue(), evt.getNewValue());
                }
            });
        }
        this.setSaveType(false);
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                URI old = MultipleURIChooserPanel.this.selectedURI;
                boolean hasSelectedTab = MultipleURIChooserPanel.this.getSelectedComponent() != null;
                MultipleURIChooserPanel.this.selectedURI = hasSelectedTab ? ((URIChooser)((Object)MultipleURIChooserPanel.this.getSelectedComponent())).getSelectedURI() : null;
                if (!NullUtils.areEquals(old, MultipleURIChooserPanel.this.selectedURI)) {
                    MultipleURIChooserPanel.this.firePropertyChange(MultipleURIChooserPanel.SELECTED_URI_PROPERTY, old, MultipleURIChooserPanel.this.selectedURI);
                }
                if (hasSelectedTab && MultipleURIChooserPanel.this.isShowing()) {
                    MultipleURIChooserPanel.this.setUp(MultipleURIChooserPanel.this.getSelectedIndex());
                }
            }
        };
        this.addChangeListener(listener);
    }

    void setUp(int index) {
        if (this.lastSetup != index) {
            this.lastSetup = index;
            ((URIChooser)((Object)this.getComponent(index))).setUp();
        }
    }

    public void setSaveType(boolean save) {
        this.isSave = save;
        for (int i = 0; i < this.getTabCount(); ++i) {
            URIChooser tab = (URIChooser)((Object)this.getComponentAt(i));
            this.setToolTipTextAt(i, tab.getTooltip(save));
            tab.setSaveType(save);
        }
    }

    public boolean isSaveType() {
        return this.isSave;
    }

    public URI getSelectedURI() {
        return this.selectedURI;
    }

    public void setSelectedURI(URI uri) {
        if (uri != null) {
            String scheme = uri.getScheme();
            for (int i = 0; i < this.getComponentCount(); ++i) {
                URIChooser panel = (URIChooser)((Object)this.getComponent(i));
                if (!panel.getScheme().equals(scheme)) continue;
                this.setSelectedIndex(i);
                panel.setSelectedURI(uri);
                break;
            }
        } else {
            ((URIChooser)((Object)this.getSelectedComponent())).setSelectedURI(null);
        }
    }
}

