/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.jclop.swing;

import com.fathzer.soft.ajlib.swing.dialog.AbstractDialog;
import com.fathzer.soft.ajlib.swing.dialog.FileChooser;
import com.fathzer.soft.ajlib.swing.framework.Application;
import com.fathzer.soft.jclop.swing.MessagePack;
import com.fathzer.soft.jclop.swing.MultipleURIChooserPanel;
import com.fathzer.soft.jclop.swing.URIChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class URIChooserDialog
extends AbstractDialog<URIChooser[], URI> {
    private MultipleURIChooserPanel multiplePanel;
    private boolean saveDialog = false;
    private boolean confirmIfExisting = true;
    private ConfirmButtonUpdater updater = null;

    public URIChooserDialog(Window owner, String title, URIChooser[] choosers) {
        super(owner, title, choosers);
        this.setSaveDialog(false);
    }

    private URIChooser getSelectedPanel() {
        if (this.multiplePanel == null) {
            return ((URIChooser[])this.data)[0];
        }
        return (URIChooser)((Object)this.multiplePanel.getSelectedComponent());
    }

    @Override
    protected JPanel createCenterPane() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                URIChooserDialog.this.getSelectedPanel().setUp();
            }
        });
        PropertyChangeListener selectListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (URIChooserDialog.this.updater == null || !URIChooserDialog.this.updater.update(URIChooserDialog.this.getOkButton(), URIChooserDialog.this.getSelectedURI(), URIChooserDialog.this.getSelectedPanel().isSelectedExist())) {
                    URIChooserDialog.this.setOkButtonTitle();
                }
                URIChooserDialog.this.updateOkButtonEnabled();
            }
        };
        PropertyChangeListener confirmListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (((Boolean)evt.getNewValue()).booleanValue()) {
                    URIChooserDialog.this.confirm();
                }
            }
        };
        JPanel result = new JPanel(new BorderLayout());
        this.multiplePanel = ((URIChooser[])this.data).length == 1 ? null : new MultipleURIChooserPanel((URIChooser[])this.data);
        MultipleURIChooserPanel cp = this.multiplePanel == null ? (Component)((Object)((URIChooser[])this.data)[0]) : this.multiplePanel;
        result.add((Component)cp, "Center");
        ((Component)cp).addPropertyChangeListener("selectedUri", selectListener);
        ((Component)cp).addPropertyChangeListener("uriApproved", confirmListener);
        return result;
    }

    @Override
    protected URI buildResult() {
        return this.getSelectedURI();
    }

    @Override
    protected String getOkDisabledCause() {
        if (this.getSelectedPanel().updateSelectedURI() && this.getSelectedURI() == null) {
            return MessagePack.DEFAULT.getString("com.fathzer.soft.jclop.URIChooserDialog.noFileSelected", this.getLocale());
        }
        return this.getSelectedPanel().getDisabledCause();
    }

    @Override
    protected void confirm() {
        boolean exists;
        URI selectedURI = this.getSelectedURI();
        boolean bl = exists = this.confirmIfExisting && selectedURI != null && this.saveDialog && this.getSelectedPanel().isSelectedExist();
        if (exists && FileChooser.showSaveDisplayQuestion(this)) {
            return;
        }
        String error = this.getSelectedPanel().getDisabledCause();
        if (error != null) {
            JOptionPane.showMessageDialog(this, error, Application.getString("Generic.error", this.getLocale()), 0);
            return;
        }
        super.confirm();
    }

    private URI getSelectedURI() {
        URIChooser panel = this.getSelectedPanel();
        return panel != null ? panel.getSelectedURI() : null;
    }

    public void setSaveDialog(boolean save) {
        if (save != this.saveDialog) {
            this.saveDialog = save;
            if (this.updater == null || this.updater.update(this.getOkButton(), this.getSelectedURI(), this.getSelectedPanel().isSelectedExist())) {
                this.setOkButtonTitle();
            }
            for (URIChooser panel : (URIChooser[])this.data) {
                panel.setSaveType(save);
            }
        }
    }

    private void setOkButtonTitle() {
        String title = this.saveDialog ? MessagePack.DEFAULT.getString("com.fathzer.soft.jclop.URIChooserDialog.saveButton.title", this.getLocale()) : MessagePack.DEFAULT.getString("com.fathzer.soft.jclop.URIChooserDialog.openButton.title", this.getLocale());
        this.getOkButton().setText(title);
    }

    public URI showDialog() {
        this.setVisible(true);
        return (URI)this.getResult();
    }

    public void setSelectedURI(URI uri) {
        URIChooser panel = null;
        if (uri != null) {
            String scheme = uri.getScheme();
            for (URIChooser aPanel : (URIChooser[])this.data) {
                if (!aPanel.getScheme().equals(scheme)) continue;
                panel = aPanel;
            }
            if (panel == null) {
                throw new IllegalArgumentException();
            }
        } else {
            panel = ((URIChooser[])this.data)[0];
        }
        panel.setSelectedURI(uri);
        if (this.multiplePanel != null && uri != null) {
            this.multiplePanel.setSelectedComponent((Component)((Object)panel));
        }
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this.data != null) {
            for (URIChooser chooser : (URIChooser[])this.data) {
                ((Component)((Object)chooser)).setLocale(locale);
            }
        }
    }

    public void setConfirmIfExisting(boolean confirm) {
        this.confirmIfExisting = confirm;
    }

    public void setConfirmButtonUpdater(ConfirmButtonUpdater updater) {
        this.updater = updater;
    }

    public boolean hasScheme(String scheme) {
        for (URIChooser aPanel : (URIChooser[])this.data) {
            if (!aPanel.getScheme().equals(scheme)) continue;
            return true;
        }
        return false;
    }

    public static interface ConfirmButtonUpdater {
        public boolean update(JButton var1, URI var2, boolean var3);
    }
}

